/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/php/lang/inspections/attributes/MissingArrayElementInsertionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "key", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "repositionCaret", "added", "Lcom/intellij/psi/PsiElement;", "getAnchorElement", "expression", "Lcom/jetbrains/php/lang/psi/elements/ArrayCreationExpression;", "ensureComma", "lastHashElement", "Lcom/jetbrains/php/lang/psi/elements/ArrayHashElement;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpMissingArrayKeyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpMissingArrayKeyInspection.kt\ncom/jetbrains/php/lang/inspections/attributes/MissingArrayElementInsertionQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class MissingArrayElementInsertionQuickFix
implements LocalQuickFix {
    @NotNull
    private final String key;

    public MissingArrayElementInsertionQuickFix(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.key};
        String string = PhpBundle.message("intention.family.name.add.missing.array.key", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            ArrayCreationExpression arrayCreationExpression = psiElement instanceof ArrayCreationExpression ? (ArrayCreationExpression)psiElement : null;
            if (arrayCreationExpression == null) break block3;
            ArrayCreationExpression expression = arrayCreationExpression;
            boolean bl = false;
            ArrayCreationExpressionImpl arrayCreationExpressionImpl = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), ArrayCreationExpressionImpl.class, "['" + this.key + "' => ]");
            Intrinsics.checkNotNullExpressionValue((Object)((Object)arrayCreationExpressionImpl), (String)"createPhpPsiFromText(...)");
            ArrayCreationExpressionImpl container = arrayCreationExpressionImpl;
            ArrayHashElement arrayHashElement = PhpPsiUtil.getChildOfClass((PsiElement)container, ArrayHashElement.class);
            if (arrayHashElement != null) {
                ArrayHashElement newHashElement = arrayHashElement;
                boolean bl2 = false;
                PsiElement psiElement2 = this.getAnchorElement(expression);
                if (psiElement2 != null) {
                    PsiElement anchor = psiElement2;
                    boolean bl3 = false;
                    PsiElement psiElement3 = expression.addAfter((PsiElement)newHashElement, anchor);
                    if (psiElement3 != null) {
                        PsiElement added = psiElement3;
                        boolean bl4 = false;
                        this.repositionCaret(project, added);
                    }
                }
            }
        }
    }

    private final void repositionCaret(Project project, PsiElement added) {
        block0: {
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) break block0;
            Editor editor2 = editor;
            boolean bl = false;
            int caretOffset = added.getTextRange().getEndOffset();
            editor2.getCaretModel().moveToOffset(caretOffset);
        }
    }

    private final PsiElement getAnchorElement(ArrayCreationExpression expression) {
        ArrayHashElement arrayHashElement;
        block3: {
            block2: {
                Iterable iterable = expression.getHashElements();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHashElements(...)");
                arrayHashElement = (ArrayHashElement)CollectionsKt.lastOrNull((Iterable)iterable);
                if (arrayHashElement == null) break block2;
                ArrayHashElement it = arrayHashElement;
                boolean bl = false;
                PsiElement psiElement = this.ensureComma(expression, it);
                arrayHashElement = psiElement;
                if (psiElement != null) break block3;
            }
            arrayHashElement = expression.isShortSyntax() ? expression.getFirstChild() : expression.getFirstChild().getNextSibling();
        }
        return arrayHashElement;
    }

    private final PsiElement ensureComma(ArrayCreationExpression expression, ArrayHashElement lastHashElement) {
        PsiElement psiElement;
        Object object = lastHashElement.getNextSibling();
        boolean bl = object != null && (object = object.getText()) != null ? StringsKt.endsWith$default((String)object, (String)",", (boolean)false, (int)2, null) : false;
        if (bl) {
            PsiElement psiElement2 = lastHashElement.getNextSibling();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getNextSibling(...)");
        } else {
            PsiElement psiElement3 = expression.addAfter(PhpPsiElementFactory.createComma(lastHashElement.getProject()), (PsiElement)lastHashElement);
            psiElement = psiElement3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"addAfter(...)");
        }
        return psiElement;
    }
}

