/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpNeverTypedNoReturnProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCustomFunctionPredicateIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionAlwaysThrowsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNonVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNonVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodVoidReturnTypeIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.mockery.PhpMockeryTypeInferenceUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpVoidFunctionResultUsedInspection
extends PhpInspection {
    public static final String DESCRIPTION = "inspection.invalid.function.result.used.problem";
    public static final String METHOD = "inspection.invalid.function.result.used.problem.method";
    public static final String FUNCTION = "inspection.invalid.function.result.used.problem.function";
    public static final String VOID_NEVER = "inspection.void.never.function.result.used.problem.type";
    public static final String VOID = "inspection.void.function.result.used.problem.type";
    public static final String NEVER = "inspection.never.function.result.used.problem.type";
    public static final String PHP_SPEC_SUBJECT = "\\PhpSpec\\Wrapper\\Subject";
    public static final String METHOD_PROPHECY = "\\Prophecy\\Prophecy\\MethodProphecy";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpVoidFunctionResultUsedInspection.analyzeCall(reference, holder, PhpVoidFunctionResultUsedInspection.FUNCTION);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if (PhpPsiUtil.isOfType(reference.getParent(), (IElementType)PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                PhpVoidFunctionResultUsedInspection.analyzeCall((FunctionReference)reference, holder, PhpVoidFunctionResultUsedInspection.METHOD);
            }
        };
    }

    private static void analyzeCall(@NotNull FunctionReference reference, @NotNull ProblemsHolder holder, @Nls @NotNull String kind) {
        String name;
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(3);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(name = reference.getName()))) {
            PsiElement parent = reference.getParent();
            if (parent instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)parent;
                PsiElement rightOperand = binaryExpression.getRightOperand();
                if (rightOperand == reference && PhpLangUtil.isShortCircuitOperator(binaryExpression.getOperationType()) && PhpCodeInsightUtil.isResultUsed(parent)) {
                    PhpVoidFunctionResultUsedInspection.registerProblem(reference, holder, kind, name);
                }
            } else if (parent instanceof PhpMatchArm) {
                PhpExpression matchBody = ((PhpMatchArm)parent).getBodyExpression();
                if (parent instanceof PhpDefaultMatchArm && PhpCustomFunctionPredicateIndex.matchesHierarchyAware(reference, PhpFunctionAlwaysThrowsIndex.class)) {
                    return;
                }
                if (reference != matchBody || PhpCodeInsightUtil.isResultUsed(parent.getParent())) {
                    PhpVoidFunctionResultUsedInspection.registerProblem(reference, holder, kind, name);
                }
            } else if (PhpCodeInsightUtil.isResultUsed((PsiElement)reference)) {
                if (parent instanceof FunctionImpl && FunctionImpl.isShortArrowFunction((Function)parent) && FunctionImpl.getShortArrowFunctionArgument((Function)parent) == reference) {
                    return;
                }
                PhpVoidFunctionResultUsedInspection.registerProblem(reference, holder, kind, name);
            }
        }
    }

    private static void registerProblem(@NotNull FunctionReference reference, @NotNull ProblemsHolder holder, @Nls @NotNull String kind, @NotNull String name) {
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(6);
        }
        if (name == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(7);
        }
        if (!PhpVoidFunctionResultUsedInspection.voidTypedFunctionWithNameExists(reference) && !PhpNeverTypedNoReturnProvider.neverTypedFunctionWithNameExists(reference) && PhpVoidFunctionResultUsedInspection.nonVoidTypedFunctionWithNameExists(reference) && PhpNeverTypedNoReturnProvider.nonNeverTypedFunctionWithNameExists(reference)) {
            return;
        }
        Collection functions = reference.multiResolveStrict(Function.class);
        if (functions.isEmpty()) {
            return;
        }
        boolean voidExists = false;
        boolean neverExists = false;
        boolean inapplicableTypeExists = false;
        for (Function function : functions) {
            PhpType type = function.getGlobalType();
            if (PhpType.VOID.equals((Object)type)) {
                voidExists = true;
                continue;
            }
            if (PhpType.NEVER.equals((Object)type)) {
                neverExists = true;
                continue;
            }
            inapplicableTypeExists = true;
            break;
        }
        if (inapplicableTypeExists || PhpVoidFunctionResultUsedInspection.isMockeryMockCall(reference)) {
            return;
        }
        String typeKey = voidExists && neverExists ? VOID_NEVER : (neverExists ? NEVER : VOID);
        holder.registerProblem((PsiElement)reference, PhpBundle.message(DESCRIPTION, PhpBundle.message(typeKey, new Object[0]), PhpBundle.message(kind, new Object[0]), name), new LocalQuickFix[0]);
    }

    private static boolean voidTypedFunctionWithNameExists(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(8);
        }
        return PhpNeverTypedNoReturnProvider.functionWithNameExistsInStubIndex(reference, PhpMethodVoidReturnTypeIndex.KEY, PhpFunctionVoidReturnTypeIndex.KEY);
    }

    private static boolean nonVoidTypedFunctionWithNameExists(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(9);
        }
        return PhpNeverTypedNoReturnProvider.functionWithNameExistsInStubIndex(reference, PhpMethodNonVoidReturnTypeIndex.KEY, PhpFunctionNonVoidReturnTypeIndex.KEY);
    }

    private static boolean isMockeryMockCall(FunctionReference reference) {
        return reference instanceof MethodReference && ContainerUtil.exists((Iterable)PhpType.global((PsiElement[])new PsiElement[]{reference}).getTypes(), t -> PhpVoidFunctionResultUsedInspection.isMockeryExpectationInterface(reference.getProject(), t) || PhpVoidFunctionResultUsedInspection.isMockMethodCall(t));
    }

    private static boolean isMockeryExpectationInterface(@NotNull Project project, String type) {
        if (project == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(10);
        }
        return PhpMockeryTypeInferenceUtil.isMockeryNamespace(type) && PhpMockeryTypeInferenceUtil.MOCKERY_EXPECTATION_INTERFACE.isConvertibleFromGlobal(project, PhpType.from((String[])new String[]{type}));
    }

    private static boolean isMockMethodCall(String type) {
        return type.endsWith(PHP_SPEC_SUBJECT) || type.endsWith(METHOD_PROPHECY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpVoidFunctionResultUsedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeCall";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "voidTypedFunctionWithNameExists";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "nonVoidTypedFunctionWithNameExists";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isMockeryExpectationInterface";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

