/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRemoveParameterWithPropagationQuickFix;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPropertyOnlyWrittenInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDataProviderInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveParametersQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUnusedMethodParametersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnusedParameterInspection
extends PhpInspection {
    public static final PhpRemoveParametersQuickFix REMOVE_PARAMETER = new PhpRemoveParametersQuickFix();
    private static final Int2ObjectMap<ParameterNotUsedReason> EMPTY_MAP = new Int2ObjectOpenHashMap();
    private static final LocalQuickFix REMOVE_PARAMETER_WITH_PROPAGATION = new PhpRemoveParameterWithPropagationQuickFix();
    private final PhpRemoveAllUnusedParametersQuickFix REMOVE_ALL_UNUSED_PARAMETERS = new PhpRemoveAllUnusedParametersQuickFix();
    public static final String ALL_PARAMETER_ACCESS_FUNCTION = "func_get_args";
    public static final String PARAMETER_ACCESS_FUNCTION = "func_get_arg";
    public static final String PARAMETER_COUNT_ACCESS_FUNCTION = "func_num_args";
    public boolean DONT_REPORT_EMPTY_BODY = true;
    public boolean DONT_REPORT_OVERRIDE = true;
    public boolean DONT_REPORT_ABSTRACT_CLASS = false;
    public boolean DONT_REPORT_ANONYMOUS = false;
    public boolean DONT_REPORT_PARAMETERS_COUNT_ACCESS = false;
    public boolean DONT_REPORT_PROPERTY_HOOK_TYPE = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PhpPropertyHook hook;
                PhpClass containingClass = method.getContainingClass();
                if (containingClass == null || containingClass.isInterface()) {
                    return;
                }
                if (method instanceof PhpPropertyHook && (hook = (PhpPropertyHook)method).getHookType() == PhpPropertyHook.PhpPropertyHookType.SET) {
                    Parameter parameter = hook.getParameter(0);
                    if (parameter == null) {
                        return;
                    }
                    if (parameter.getName().equalsIgnoreCase("value")) {
                        PhpType parameterType = parameter.getGlobalType();
                        Field field = hook.getContainingField();
                        if (field == null) {
                            return;
                        }
                        PhpType fieldType = field.getDeclaredType().global(hook.getProject());
                        if (fieldType.equals((Object)parameterType) && !PhpUnusedParameterInspection.this.isDontReportPropertyHookType()) {
                            PhpUnusedParameterInspection.reportProblem(holder, parameter, REMOVE_PARAMETER, ParameterNotUsedReason.PROPERTY_HOOK_PARAMETER_TYPE_IS_EQUAL_TO_PROPERTY_TYPE);
                            return;
                        }
                    }
                }
                if (PhpUnusedParameterInspection.this.isDontReportAbstractClass() && containingClass.isAbstract()) {
                    return;
                }
                CharSequence methodName = method.getNameCS();
                if (StringUtil.isEmpty((CharSequence)methodName) || PhpLangUtil.isMagicMethod(methodName) && !PhpLangUtil.isNewStyleConstructor(methodName)) {
                    return;
                }
                if (method.isAbstract()) {
                    return;
                }
                Parameter[] parameters = method.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                Int2ObjectMap<ParameterNotUsedReason> unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)method);
                if (unused.isEmpty()) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportEmptyBody() && PhpCodeInsightUtil.isEmptyBody((Function)method)) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportOverride()) {
                    Ref isOverride = new Ref((Object)false);
                    PhpClassHierarchyUtils.processSuperMethods((Method)method, (member, subClass, baseClass) -> {
                        if (member != method && (member.getMethodType(false) != Method.MethodType.CONSTRUCTOR || member.isAbstract())) {
                            isOverride.set((Object)true);
                            return false;
                        }
                        return true;
                    });
                    if (((Boolean)isOverride.get()).booleanValue()) {
                        return;
                    }
                }
                PhpUnusedParameterInspection.removeUsedParametersInHierarchy(unused, method);
                PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix = this.removeAllQuickFix(unused.size());
                IntIterator iterator = unused.keySet().iterator();
                while (iterator.hasNext()) {
                    int index = iterator.nextInt();
                    PhpUnusedParameterInspection.reportProblem(holder, parameters[index], removeAllQuickFix, (ParameterNotUsedReason)((Object)unused.get(index)));
                }
            }

            public void visitPhpFunction(Function function) {
                if (PhpPropertyOnlyWrittenInspection.isEntryPoint((PsiElement)function)) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportAnonymous() && function.isClosure()) {
                    return;
                }
                Parameter[] parameters = function.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                Int2ObjectMap<ParameterNotUsedReason> unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)function);
                if (unused.isEmpty()) {
                    return;
                }
                if (PhpUnusedParameterInspection.this.isDontReportEmptyBody() && PhpCodeInsightUtil.isEmptyBody(function)) {
                    return;
                }
                int minIndexToReport = function.isClosure() ? PhpUnusedParameterInspection.getLastUsedParameterIndex(parameters, unused) : -1;
                PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix = this.removeAllQuickFix(unused.size());
                IntIterator iterator = unused.keySet().iterator();
                while (iterator.hasNext()) {
                    int index = iterator.nextInt();
                    if (index <= minIndexToReport) continue;
                    PhpUnusedParameterInspection.reportProblem(holder, parameters[index], removeAllQuickFix, (ParameterNotUsedReason)((Object)unused.get(index)));
                }
            }

            private PhpRemoveAllUnusedParametersQuickFix removeAllQuickFix(int unusedCasesSize) {
                return unusedCasesSize > 1 ? PhpUnusedParameterInspection.this.REMOVE_ALL_UNUSED_PARAMETERS : null;
            }
        };
    }

    private static int getLastUsedParameterIndex(Parameter[] parameters, Int2ObjectMap<ParameterNotUsedReason> unused) {
        return IntStream.range(0, parameters.length).filter(i -> !unused.containsKey(i)).max().orElse(-1);
    }

    private static void removeUsedParametersInHierarchy(final Int2ObjectMap<ParameterNotUsedReason> unusedLocal, Method method) {
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<Method>(){

            public boolean process(Method member, PhpClass subClass, PhpClass baseClass) {
                Collection<String> unusedParameters = PhpUnusedMethodParametersIndex.getUnusedParametersNames(member.getProject(), member);
                Parameter[] parameters = member.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (unusedParameters.contains(parameters[i].getName())) continue;
                    unusedLocal.remove(i);
                }
                return !unusedLocal.isEmpty();
            }
        });
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @NotNull Parameter parameter, @Nullable LocalQuickFix quickFix, ParameterNotUsedReason unusedCase) {
        PhpRemoveParametersQuickFix removeParameterQuickFix;
        if (holder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(1);
        }
        if (parameter == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(2);
        }
        PsiElement namePsi = parameter.getNameIdentifier();
        assert (namePsi != null);
        String description = PhpBundle.message("inspection.unused.parameter.problem", parameter.getName(), PhpUnusedParameterInspection.getDescriptionByNumber(unusedCase));
        Function function = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Function.class);
        PhpRemoveParametersQuickFix phpRemoveParametersQuickFix = removeParameterQuickFix = holder.isOnTheFly() && function instanceof Method && ((Method)function).getAccess().isPrivate() ? REMOVE_PARAMETER_WITH_PROPAGATION : REMOVE_PARAMETER;
        if (quickFix == null) {
            holder.registerProblem(namePsi, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{removeParameterQuickFix});
        } else {
            holder.registerProblem(namePsi, description, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{removeParameterQuickFix, quickFix});
        }
    }

    public Int2ObjectMap<ParameterNotUsedReason> getUnusedParameters(Parameter @NotNull [] parameters, @NotNull PhpScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(4);
        }
        HashSet<Integer> indirectParameterAccess = new HashSet<Integer>();
        if (scopeHolder instanceof Method) {
            indirectParameterAccess.addAll(PhpUnusedParameterInspection.usedParameterIndexesByDataProvider((Method)scopeHolder));
        }
        return PhpUnusedParameterInspection.getUnusedParameters(parameters, scopeHolder, this.isDontReportParametersCountAccess(), indirectParameterAccess);
    }

    @NotNull
    public static Int2ObjectMap<ParameterNotUsedReason> getUnusedParameters(Parameter @NotNull [] parameters, @NotNull PhpScopeHolder scopeHolder, boolean dontReportParametersCountAccess) {
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(6);
        }
        return PhpUnusedParameterInspection.getUnusedParameters(parameters, scopeHolder, dontReportParametersCountAccess, new HashSet<Integer>());
    }

    @NotNull
    public static Int2ObjectMap<ParameterNotUsedReason> getUnusedParameters(Parameter @NotNull [] parameters, @NotNull PhpScopeHolder scopeHolder, boolean dontReportParametersCountAccess, Set<Integer> indirectParameterAccess) {
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(8);
        }
        if (PhpUnusedParameterInspection.collectIndirectAccess(scopeHolder, indirectParameterAccess, dontReportParametersCountAccess)) {
            Int2ObjectMap<ParameterNotUsedReason> int2ObjectMap = EMPTY_MAP;
            if (int2ObjectMap == null) {
                PhpUnusedParameterInspection.$$$reportNull$$$0(9);
            }
            return int2ObjectMap;
        }
        Int2ObjectOpenHashMap unusedIndexesDescriptions = new Int2ObjectOpenHashMap();
        int parametersLength = parameters.length;
        block0: for (int i = 0; i < parametersLength; ++i) {
            Parameter parameter;
            String parameterName;
            if (indirectParameterAccess.contains(i) || StringUtil.isEmpty((String)(parameterName = (parameter = parameters[i]).getName()))) continue;
            PhpAccessVariableInstruction[] followingAccesses = PhpControlFlowUtil.getFollowingVariableAccessInstructions((PhpInstruction)scopeHolder.getControlFlow().getEntryPoint(), parameterName, true);
            if (followingAccesses.length == 0) {
                if (parameter.isPassByRef()) {
                    unusedIndexesDescriptions.put(i, (Object)ParameterNotUsedReason.REFERENCE_NOT_USED);
                    continue;
                }
                unusedIndexesDescriptions.put(i, (Object)ParameterNotUsedReason.NOT_USED);
                continue;
            }
            if (parameter.isPassByRef()) {
                for (PhpAccessVariableInstruction followingAccess : followingAccesses) {
                    if (!followingAccess.getAccess().isWriteRef()) continue block0;
                }
                unusedIndexesDescriptions.put(i, (Object)ParameterNotUsedReason.REFERENCE_OVERWRITTEN_IMMEDIATELY);
                continue;
            }
            for (PhpAccessVariableInstruction followingAccess : followingAccesses) {
                PhpAccessInstruction.Access access = followingAccess.getAccess();
                if (!access.isWrite() || access instanceof PhpAccessInstruction.ReadOrReadRefAccess || access.isRead()) continue block0;
            }
            unusedIndexesDescriptions.put(i, (Object)ParameterNotUsedReason.OVERWRITTEN_IMMEDIATELY);
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = unusedIndexesDescriptions;
        if (int2ObjectOpenHashMap == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(10);
        }
        return int2ObjectOpenHashMap;
    }

    private static Collection<Integer> usedParameterIndexesByDataProvider(@NotNull Method method) {
        PhpClass containingClass;
        if (method == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(11);
        }
        if (PhpUnitDataProviderInspectionBase.getDataProvidersTags(method).length > 0 && (containingClass = method.getContainingClass()) != null && PhpUnitUtil.isTestMethod(containingClass, method)) {
            return IntStream.range(0, method.getParameters().length - 1).boxed().collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static boolean collectIndirectAccess(@NotNull PhpScopeHolder scopeHolder, final @NotNull Set<Integer> accessedParameters, final boolean reportParametersCountAccess) {
        if (scopeHolder == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(12);
        }
        if (accessedParameters == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(13);
        }
        final Ref hasAccessToAllParameters = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)scopeHolder.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction instruction) {
                if (instruction instanceof PhpCallInstruction) {
                    Integer index;
                    PsiElement indexElement;
                    ParameterList parameterList;
                    FunctionReference functionReference = ((PhpCallInstruction)instruction).getFunctionReference();
                    CharSequence functionName = functionReference.getNameCS();
                    if (PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.ALL_PARAMETER_ACCESS_FUNCTION) || reportParametersCountAccess && PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.PARAMETER_COUNT_ACCESS_FUNCTION)) {
                        hasAccessToAllParameters.set((Object)true);
                    } else if (PhpLangUtil.equalsFunctionNames(functionName, PhpUnusedParameterInspection.PARAMETER_ACCESS_FUNCTION) && (parameterList = functionReference.getParameterList()) != null && (indexElement = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpElementTypes.NUMBER)) != null && (index = PhpCodeInsightUtil.toInt(indexElement)) != null) {
                        accessedParameters.add(index);
                    }
                }
                return (Boolean)hasAccessToAllParameters.get() == false;
            }
        });
        return (Boolean)hasAccessToAllParameters.get();
    }

    @NotNull
    private static String getDescriptionByNumber(ParameterNotUsedReason num) {
        String string = PhpBundle.message(switch (num) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterNotUsedReason.NOT_USED -> "inspection.unused.parameter.problem.case1";
            case ParameterNotUsedReason.OVERWRITTEN_IMMEDIATELY -> "inspection.unused.parameter.problem.case2";
            case ParameterNotUsedReason.REFERENCE_NOT_USED -> "inspection.unused.parameter.problem.case3";
            case ParameterNotUsedReason.REFERENCE_OVERWRITTEN_IMMEDIATELY -> "inspection.unused.parameter.problem.case4";
            case ParameterNotUsedReason.PROPERTY_HOOK_PARAMETER_TYPE_IS_EQUAL_TO_PROPERTY_TYPE -> "inspection.unused.parameter.problem.case5";
        }, new Object[0]);
        if (string == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean isDontReportEmptyBody() {
        return this.DONT_REPORT_EMPTY_BODY;
    }

    public boolean isDontReportAbstractClass() {
        return this.DONT_REPORT_ABSTRACT_CLASS;
    }

    public boolean isDontReportOverride() {
        return this.DONT_REPORT_OVERRIDE;
    }

    public boolean isDontReportAnonymous() {
        return this.DONT_REPORT_ANONYMOUS;
    }

    public boolean isDontReportParametersCountAccess() {
        return this.DONT_REPORT_PARAMETERS_COUNT_ACCESS;
    }

    public boolean isDontReportPropertyHookType() {
        return this.DONT_REPORT_PROPERTY_HOOK_TYPE;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DONT_REPORT_EMPTY_BODY", (String)PhpBundle.message("inspection.unused.parameter.option.description.empty.body", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_OVERRIDE", (String)PhpBundle.message("inspection.unused.parameter.option.description.empty.override", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_ABSTRACT_CLASS", (String)PhpBundle.message("inspection.unused.parameter.option.description.empty.abstract", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_ANONYMOUS", (String)PhpBundle.message("inspection.unused.parameter.option.description.empty.anonymous", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_PARAMETERS_COUNT_ACCESS", (String)PhpBundle.message("inspection.unused.parameter.option.description.parameter.count", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"DONT_REPORT_PROPERTY_HOOK_TYPE", (String)PhpBundle.message("inspection.unused.parameter.option.description.property.hook.param.type", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUnusedParameterInspection.$$$reportNull$$$0(15);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionByNumber";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedParameters";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "usedParameterIndexesByDataProvider";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectIndirectAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class PhpRemoveAllUnusedParametersQuickFix
    extends PhpRemoveParametersQuickFix {
        private PhpRemoveAllUnusedParametersQuickFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = PhpBundle.message("php.remove.all.unused.parameters.quick.fix.text", new Object[0]);
            if (string == null) {
                PhpRemoveAllUnusedParametersQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected Collection<Parameter> getParametersToDelete(@NotNull Parameter parameter) {
            Function function;
            if (parameter == null) {
                PhpRemoveAllUnusedParametersQuickFix.$$$reportNull$$$0(1);
            }
            if ((function = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Function.class)) == null) {
                return null;
            }
            Parameter[] parameters = function.getParameters();
            if (parameters.length == 0) {
                return null;
            }
            Int2ObjectMap<ParameterNotUsedReason> unused = PhpUnusedParameterInspection.this.getUnusedParameters(parameters, (PhpScopeHolder)function);
            if (unused.isEmpty()) {
                return null;
            }
            return PhpRemoveAllUnusedParametersQuickFix.getParams(parameters, unused.keySet().toIntArray());
        }

        private static Set<Parameter> getParams(Parameter[] parameters, int[] keys) {
            HashSet<Parameter> result = new HashSet<Parameter>(keys.length);
            for (int key : keys) {
                result.add(parameters[key]);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection$PhpRemoveAllUnusedParametersQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedParameterInspection$PhpRemoveAllUnusedParametersQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getParametersToDelete";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static enum ParameterNotUsedReason {
        NOT_USED,
        OVERWRITTEN_IMMEDIATELY,
        REFERENCE_NOT_USED,
        REFERENCE_OVERWRITTEN_IMMEDIATELY,
        PROPERTY_HOOK_PARAMETER_TYPE_IS_EQUAL_TO_PROPERTY_TYPE;

    }
}

