/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddFieldDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportFunctionQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpParameterInfo;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedFunctionInspection
extends PhpInspection {
    public static final String FUNCTION_EXISTS = "function_exists";
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("function_exists");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpUndefinedFunctionInspection.processPhpFunctionReference((PhpReference)reference, holder);
            }

            public void visitPhpCallableFunction(PhpCallableFunction reference) {
                PhpUndefinedFunctionInspection.processPhpFunctionReference((PhpReference)reference, holder);
            }
        };
    }

    private static void processPhpFunctionReference(@NotNull PhpReference reference, @NotNull ProblemsHolder holder) {
        String name;
        if (reference == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUndefinedFunctionInspection.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)(name = reference.getName()))) {
            return;
        }
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null) {
            return;
        }
        ResolveResult[] results = ((PsiPolyVariantReference)reference.getReference()).multiResolve(false);
        if (results.length == 0) {
            Ref canBeDefined = Ref.create((Object)false);
            Ref canBeUndefined = Ref.create((Object)false);
            PhpDFAUtil.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, reference.getFQN(), DF_ANALYZER);
            if (!((Boolean)canBeDefined.get()).booleanValue()) {
                holder.registerProblem(nameNode.getPsi(), PhpUndefinedFunctionInspection.getPROBLEM_1(), PhpUndefinedFunctionInspection.getFixes(nameNode, reference));
            } else if (((Boolean)canBeUndefined.get()).booleanValue()) {
                holder.registerProblem(nameNode.getPsi(), PhpUndefinedFunctionInspection.getPROBLEM_2(), new LocalQuickFix[0]);
            }
        }
    }

    private static LocalQuickFix[] getFixes(ASTNode nameNode, PhpReference reference) {
        LocalQuickFix[] localQuickFixArray;
        if (PhpImportFunctionQuickFix.INSTANCE.isApplicable(nameNode.getPsi())) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = PhpImportFunctionQuickFix.INSTANCE;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] baseFixes = localQuickFixArray;
        Object[] fixes = PhpRenameWrongReferenceQuickFix.appendQuickFix(reference, baseFixes);
        PhpClass clazz = PhpPsiUtil.getParentOfClass((PsiElement)reference, PhpClass.class);
        if (!PhpCodeInsightUtil.hasQualifier((PhpReferenceBase)reference)) {
            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)PhpAddFunctionDeclarationQuickFix.INSTANCE);
            if (clazz != null && !clazz.isAnonymous() && reference instanceof FunctionReference) {
                boolean isStaticContext = PhpAddMethodFromFunctionCallQuickFix.isStaticContext((PsiElement)reference);
                Collection methods = clazz.findMethodsByName((CharSequence)reference.getName());
                if (methods.isEmpty() || ContainerUtil.and((Iterable)methods, m -> m.getAccess().isPrivate())) {
                    return (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)PhpAddMethodFromFunctionCallQuickFix.INSTANCE);
                }
                if (methods.stream().anyMatch(m -> !m.getAccess().isPrivate() && (m.isStatic() || !isStaticContext))) {
                    return (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)PhpAddMethodFromFunctionCallQuickFix.METHOD_CALL_INSTANCE);
                }
            }
        }
        return fixes;
    }

    @Nullable
    public static Boolean isDfaReachable(PhpReference reference) {
        return PhpDFAUtil.isDfaReachable(reference, DF_ANALYZER);
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.undefined.function.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.undefined.function.problem2", new Object[0]);
    }

    @Nullable
    public static PhpInstruction getInstruction(PhpReference reference) {
        if (reference instanceof FunctionReference) {
            return PhpControlFlowUtil.getCallInstruction((FunctionReference)reference);
        }
        if (reference instanceof PhpCallableFunction) {
            return PhpControlFlowUtil.getFirstClassCallableInstruction((PhpCallableFunction)reference);
        }
        return PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processPhpFunctionReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAddFunctionDeclarationQuickFix
    implements LocalQuickFix {
        private static final PhpAddFunctionDeclarationQuickFix INSTANCE = new PhpAddFunctionDeclarationQuickFix();

        private PhpAddFunctionDeclarationQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.undefined.function.add.function", new Object[0]);
            if (string == null) {
                PhpAddFunctionDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddFunctionDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddFunctionDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PhpReference reference = PhpPsiUtil.getParentOfClass(nameIdentifier, PhpReference.class);
            assert (reference != null);
            Collection<PhpParameterInfo> infos = PhpAddMethodDeclarationQuickFix.getParametersInfos((PhpExpression)reference);
            String paramListText = PhpAddMethodDeclarationQuickFix.makeParameterList(project, infos, (PsiElement)reference, false, true);
            Function definition = PhpPsiElementFactory.createFunction(project, "function " + nameIdentifier.getText() + paramListText + "{}");
            PsiElement insertedFunction = PhpExtractMethodHandler.insertDefinition(PhpAddFunctionDeclarationQuickFix.getNearestNonClassScopeHolder((PsiElement)reference), (PsiElement)reference, definition);
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)nameIdentifier)) {
                Function function = (Function)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedFunction);
                PhpAddFieldDeclarationQuickFix.runTemplate((PsiElement)function, PhpAddMethodDeclarationQuickFix.createTemplate(function, (PsiElement)function, infos), (TemplateEditingListener)new TemplateEditingAdapter(){

                    public void templateFinished(@NotNull Template template, boolean brokenOff) {
                        if (template == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!brokenOff) {
                            PhpCodeEditUtil.setupMethodBody(project);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection$PhpAddFunctionDeclarationQuickFix$1", "templateFinished"));
                    }
                });
            }
        }

        private static PhpScopeHolder getNearestNonClassScopeHolder(PsiElement element) {
            return (PhpScopeHolder)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpScopeHolder && (!(e instanceof Function) || !((Function)e).isClosure()) && !(e instanceof Method) && !(e instanceof PhpClass)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection$PhpAddFunctionDeclarationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection$PhpAddFunctionDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpAddMethodFromFunctionCallQuickFix
    extends PhpAddMethodDeclarationQuickFix
    implements PriorityAction {
        public static final PhpAddMethodFromFunctionCallQuickFix INSTANCE = new PhpAddMethodFromFunctionCallQuickFix(true);
        public static final PhpAddMethodFromFunctionCallQuickFix METHOD_CALL_INSTANCE = new PhpAddMethodFromFunctionCallQuickFix(false);
        private final boolean myAddMethodDeclaration;

        private PhpAddMethodFromFunctionCallQuickFix(boolean addMethodDeclaration) {
            this.myAddMethodDeclaration = addMethodDeclaration;
        }

        @Override
        @NotNull
        public String getName() {
            String string = !this.myAddMethodDeclaration ? PhpBundle.message("intention.replace.with.method.call", new Object[0]) : super.getName();
            if (string == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(2);
            }
            FunctionReference reference = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), FunctionReference.class);
            assert (reference != null);
            if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)reference.getContainingFile())) {
                return;
            }
            IntentionPreviewUtils.write(() -> {
                String methodCallText = PhpAddMethodFromFunctionCallQuickFix.getCallPrefix(reference) + reference.getText();
                MethodReference methodReference = PhpPsiElementFactory.createMethodReference(project, methodCallText);
                reference.replace((PsiElement)methodReference);
                if (this.myAddMethodDeclaration && !IntentionPreviewUtils.isPreviewElement((PsiElement)reference)) {
                    super.applyFix(project, descriptor);
                }
            });
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(4);
            }
            FunctionReference reference = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), FunctionReference.class);
            assert (reference != null);
            String methodCallText = PhpAddMethodFromFunctionCallQuickFix.getCallPrefix(reference) + reference.getText();
            MethodReference methodReference = PhpPsiElementFactory.createMethodReference(project, methodCallText);
            reference.replace((PsiElement)methodReference);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.TOP;
            if (priority == null) {
                PhpAddMethodFromFunctionCallQuickFix.$$$reportNull$$$0(6);
            }
            return priority;
        }

        private static String getCallPrefix(FunctionReference reference) {
            if (PhpAddMethodFromFunctionCallQuickFix.isStaticContext((PsiElement)reference)) {
                return "self::";
            }
            PhpClass clazz = PhpPsiUtil.getParentOfClass((PsiElement)reference, PhpClass.class);
            assert (clazz != null);
            Collection methods = clazz.findMethodsByName((CharSequence)reference.getName());
            return !methods.isEmpty() && ContainerUtil.and((Iterable)methods, Method::isStatic) ? "self::" : "$this->";
        }

        private static boolean isStaticContext(PsiElement element) {
            Method method = PhpPsiUtil.getParentOfClass(element, Method.class);
            return method != null && method.isStatic();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection$PhpAddMethodFromFunctionCallQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedFunctionInspection$PhpAddMethodFromFunctionCallQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

