/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTemplateTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassConstantType;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpLanguageFeatureUsageVisitor
extends PhpElementVisitor {
    private final boolean myGlobal;

    public PhpLanguageFeatureUsageVisitor(boolean global) {
        this.myGlobal = global;
    }

    public void visitPhpFieldReference(FieldReference reference) {
        ASTNode nameNode;
        super.visitPhpFieldReference(reference);
        this.checkStaticReferenceAccess((MemberReference)reference);
        this.checkNullsafeDereferencing((MemberReference)reference);
        if (FieldReferenceImpl.isClassNameLiteral((MemberReference)reference) && (nameNode = reference.getNameNode()) != null) {
            this.checkFeature(PhpLanguageFeature.CLASS_NAME_LITERAL_ON_OBJECT, nameNode.getPsi());
        }
        super.visitPhpFieldReference(reference);
    }

    public void visitPhpMethod(Method method) {
        Object modifierList;
        PhpModifier modifier;
        super.visitPhpMethod(method);
        PhpClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isTrait() && (modifier = method.getModifier()).isAbstract() && modifier.isPrivate() && (modifierList = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF)) != null) {
            this.checkFeature(PhpLanguageFeature.ABSTRACT_PRIVATE_TRAIT_METHODS, (PsiElement)modifierList);
        }
    }

    public void visitPhpParameter(Parameter parameter) {
        PsiElement defaultValue;
        PsiElement quest;
        super.visitPhpParameter(parameter);
        if (parameter.isVariadic()) {
            this.checkFeature(PhpLanguageFeature.VARIADIC_FUNCTIONS, (PsiElement)parameter);
        }
        if (parameter.isPromotedField()) {
            Object setOperationModifier;
            PsiElement elementToRegisterProblem;
            PsiElement readonlyModifier;
            PsiElement finalKeyword;
            if (((Field)parameter).isFinal() && (finalKeyword = PhpPsiUtil.getChildOfType((PsiElement)parameter, PhpTokenTypes.kwFINAL)) != null) {
                this.checkFeature(PhpLanguageFeature.FINAL_PROPERTY_PROMOTION, finalKeyword);
            }
            if ((readonlyModifier = PhpLanguageFeatureUsageVisitor.getReadonlyModifier((PsiElement)parameter)) != null) {
                this.checkFeature(PhpLanguageFeature.READONLY_PROPERTIES, readonlyModifier);
            } else {
                this.checkFeature(PhpLanguageFeature.PROPERTY_PROMOTION, (PsiElement)parameter);
            }
            List hooks = ((Field)parameter).getPropertyHooksList();
            PhpPropertyHook hook = hooks.stream().findFirst().orElse(null);
            if (hook != null && (elementToRegisterProblem = hook.getNameIdentifier()) != null) {
                this.checkFeature(PhpLanguageFeature.PROPERTY_HOOKS, elementToRegisterProblem);
            }
            if ((setOperationModifier = PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)parameter)) != null) {
                this.checkFeature(PhpLanguageFeature.ASYMMETRIC_VISIBILITY, (PsiElement)setOperationModifier);
            }
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)parameter, Function.class) instanceof PhpDocMethod) {
            return;
        }
        String type = parameter.getDeclaredType().toString();
        this.checkScalarTypeHint(parameter, type);
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getChildByCondition((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        Collection<Object> classReferences = typeDeclaration != null ? typeDeclaration.getClassReferences() : Collections.emptyList();
        for (ClassReference classReference : classReferences) {
            if ("object".equalsIgnoreCase(type)) {
                this.checkFeature(PhpLanguageFeature.OBJECT_TYPE_HINT, (PsiElement)classReference);
            }
            this.checkPhp7TypeHints(type, (PsiElement)classReference);
        }
        if (typeDeclaration != null && PhpPsiUtil.isOfType(quest = typeDeclaration.getFirstChild(), PhpTokenTypes.opQUEST)) {
            Object t = PhpPsiUtil.getNextSiblingByCondition(quest, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
            if (t != null) {
                TextRange range = TextRange.create((int)quest.getStartOffsetInParent(), (int)(t.getStartOffsetInParent() + t.getTextLength()));
                this.checkFeature(PhpLanguageFeature.NULLABLES, (PsiElement)typeDeclaration, range);
            } else {
                this.checkFeature(PhpLanguageFeature.NULLABLES, quest);
            }
        }
        if ((defaultValue = parameter.getDefaultValue()) instanceof NewExpression) {
            this.checkFeature(PhpLanguageFeature.NEW_IN_INIT, defaultValue);
        }
    }

    protected void checkScalarTypeHint(Parameter parameter, String type) {
        if (!type.equalsIgnoreCase("array") && !type.equalsIgnoreCase("callable") && !type.equalsIgnoreCase("null") && PhpType.isPrimitiveType((String)type)) {
            this.checkFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS, parameter.getFirstChild());
        }
    }

    public void visitPhpReturnType(PhpReturnType returnType) {
        super.visitPhpReturnType(returnType);
        if (returnType.isNullable()) {
            this.checkFeature(PhpLanguageFeature.NULLABLES, (PsiElement)returnType);
        } else {
            ClassReference reference = (ClassReference)ContainerUtil.getOnlyItem((Collection)returnType.getClassReferences());
            if (reference != null) {
                if ("void".equalsIgnoreCase(returnType.getDeclaredType().toString())) {
                    this.checkFeature(PhpLanguageFeature.RETURN_VOID, (PsiElement)returnType);
                } else if ("never".equalsIgnoreCase(returnType.getDeclaredType().toString())) {
                    this.checkFeature(PhpLanguageFeature.RETURN_NEVER, (PsiElement)returnType);
                } else {
                    this.checkFeature(PhpLanguageFeature.RETURN_TYPES, (PsiElement)returnType);
                }
            }
            boolean classContext = PhpPsiUtil.getParentOfClass((PsiElement)returnType, PhpClass.class) != null;
            for (ClassReference r : returnType.getClassReferences()) {
                this.checkPhp7TypeHints(r.getNameCS(), (PsiElement)r);
                if (!classContext || !PhpAnnotatorVisitor.isStaticKeywordClassReference(r)) continue;
                this.checkFeature(PhpLanguageFeature.STATIC_RETURN_TYPE_HINT, (PsiElement)r);
            }
        }
    }

    private static boolean isInsideStringLiteral(ArrayAccessExpression expression) {
        return expression.getParent() instanceof Variable && expression.getParent().getParent() instanceof StringLiteralExpression;
    }

    protected boolean isString(PhpType type) {
        return type.equals((Object)PhpType.STRING);
    }

    protected void checkPhp7TypeHints(CharSequence name, @NotNull PsiElement psi) {
        if (psi == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(0);
        }
    }

    public void visitPhpField(Field field) {
        PhpClass containingClass;
        PhpModifierList modifierList;
        PsiElement elementToRegisterProblem;
        super.visitPhpField(field);
        List hooks = field.getPropertyHooksList();
        PhpPropertyHook hook = hooks.stream().findFirst().orElse(null);
        if (hook != null && (elementToRegisterProblem = hook.getNameIdentifier()) != null) {
            this.checkFeature(PhpLanguageFeature.PROPERTY_HOOKS, elementToRegisterProblem);
        }
        ASTNode node = field.getNameNode();
        if (field.isConstant() && node != null && PhpTokenTypes.tsKEYWORDS.contains(node.getElementType())) {
            this.checkFeature(PhpLanguageFeature.KEYWORD_NAMES, node.getPsi());
        }
        if ((modifierList = (PhpModifierList)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)field, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF)) != null) {
            PsiElement setOperationModifier;
            PsiElement readonlyModifier = PhpLanguageFeatureUsageVisitor.getReadonlyModifier((PsiElement)modifierList);
            if (readonlyModifier != null) {
                this.checkFeature(PhpLanguageFeature.READONLY_PROPERTIES, readonlyModifier);
            }
            if (field.isConstant()) {
                ASTNode finalModifier = modifierList.getNode().findChildByType(PhpTokenTypes.kwFINAL);
                if (finalModifier != null) {
                    this.checkFeature(PhpLanguageFeature.FINAL_CLASS_CONSTANTS, finalModifier.getPsi());
                } else {
                    this.checkFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY, (PsiElement)modifierList);
                }
            }
            if ((setOperationModifier = PhpModifierListImpl.getSetOperationModifierPsiElement((PsiElement)modifierList)) != null) {
                this.checkFeature(PhpLanguageFeature.ASYMMETRIC_VISIBILITY, setOperationModifier);
            }
        }
        if (field.isConstant() && (containingClass = field.getContainingClass()) != null && containingClass.isTrait()) {
            this.checkFeature(PhpLanguageFeature.CONSTANTS_IN_TRAITS, (PsiElement)field);
        }
    }

    public void visitPhpClassFieldsList(PhpClassFieldsList classFieldsList) {
        super.visitPhpClassFieldsList(classFieldsList);
    }

    @Nullable
    private static PsiElement getReadonlyModifier(@NotNull PsiElement element) {
        ASTNode readonlyKw;
        if (element == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(1);
        }
        return (readonlyKw = element.getNode().findChildByType(PhpTokenTypes.IDENTIFIER)) != null && "readonly".equalsIgnoreCase(readonlyKw.getText()) ? readonlyKw.getPsi() : null;
    }

    public void visitPhpFunction(Function function) {
        super.visitPhpFunction(function);
        ASTNode node = function.getNameNode();
        if (node != null && PhpTokenTypes.tsKEYWORDS.contains(node.getElementType())) {
            this.checkFeature(PhpLanguageFeature.KEYWORD_NAMES, node.getPsi());
        }
        if (function.isClosure()) {
            ASTNode fnKeyword = function.getNode().findChildByType(PhpTokenTypes.kwFN);
            if (fnKeyword != null) {
                this.checkFeature(PhpLanguageFeature.ARROW_FUNCTION_SYNTAX, fnKeyword.getPsi());
            }
            this.checkTrailingCommaInClosureUseList(function);
        }
    }

    private void checkTrailingCommaInClosureUseList(Function function) {
        PhpUseList useList = (PhpUseList)PsiTreeUtil.getChildOfType((PsiElement)function, PhpUseList.class);
        if (useList == null) {
            return;
        }
        PsiElement trailingComma = PhpUseListImpl.getTrailingComma(useList);
        if (trailingComma != null) {
            this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_CLOSURE_USE_LIST, trailingComma);
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        super.visitPhpArrayCreationExpression(expression);
        if (expression.isShortSyntax()) {
            this.checkFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX, (PsiElement)expression);
        }
        for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES)) {
            if (child instanceof ArrayHashElement) {
                PhpPsiElement value;
                PhpPsiElement key = ((ArrayHashElement)child).getKey();
                if (key != null) {
                    this.checkSpreadOperatorInArrayAllowance(key.getParent());
                }
                if ((value = ((ArrayHashElement)child).getValue()) == null) continue;
                this.checkSpreadOperatorInArrayAllowance(value.getParent());
                continue;
            }
            this.checkSpreadOperatorInArrayAllowance((PsiElement)child);
        }
    }

    private void checkSpreadOperatorInArrayAllowance(PsiElement value) {
        if (ArrayCreationExpressionImpl.isUnpackedArrayArgument(value)) {
            this.checkFeature(PhpLanguageFeature.SPREAD_OPERATOR_IN_ARRAY, value);
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        ArrayIndex index;
        PhpPsiElement indexValue;
        super.visitPhpArrayAccessExpression(expression);
        PhpPsiElement value = expression.getValue();
        if (value instanceof FunctionReference) {
            PsiElement target = PhpPsiUtil.findNextSiblingOfAnyType((PsiElement)value, PhpTokenTypes.chLBRACE, PhpTokenTypes.chLBRACKET);
            this.checkFeature(PhpLanguageFeature.ARRAY_DEREFERENCING, (PsiElement)(target != null ? target : expression));
        }
        PhpPsiElement phpPsiElement = indexValue = (index = expression.getIndex()) != null ? index.getValue() : null;
        if (indexValue instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)indexValue).getOperation(), PhpTokenTypes.opMINUS) && (PhpPsiUtil.isOfType(indexValue.getLastChild(), PhpTokenTypes.tsINTEGERS) && PhpLanguageFeatureUsageVisitor.isInsideStringLiteral(expression) || PhpPsiUtil.isOfType((PsiElement)((UnaryExpression)indexValue).getValue(), PhpElementTypes.NUMBER) && this.isString(new PhpType().add((PsiElement)value)))) {
            this.checkFeature(PhpLanguageFeature.NEGATIVE_NUMERIC_INDICES, (PsiElement)index);
        }
    }

    public void visitPhpBreak(PhpBreak breakStatement) {
        super.visitPhpBreak(breakStatement);
        this.checkBreakContinueArgument(breakStatement.getArgument(), PhpLanguageFeature.VAR_BREAK_ARGUMENT, PhpLanguageFeature.VAR_BREAK_ZERO_ARGUMENT);
    }

    public void visitPhpFinally(Finally element) {
        super.visitPhpFinally(element);
        this.checkFeature(PhpLanguageFeature.FINALLY, (PsiElement)element);
    }

    public void visitPhpClassConstantReference(ClassConstantReference expression) {
        super.visitPhpClassConstantReference(expression);
        PsiElement child = expression.getLastChild();
        if (PhpPsiUtil.isOfType(child, PhpTokenTypes.kwCLASS)) {
            this.checkFeature(PhpLanguageFeature.CLASS_NAME_CONST, child);
        }
        if (PhpPsiUtil.isOfType(child, PhpTokenTypes.chRBRACE)) {
            this.checkFeature(PhpLanguageFeature.DYNAMIC_CLASS_CONSTANT, (PsiElement)expression);
        }
    }

    public void visitPhpEmpty(PhpEmpty expression) {
        super.visitPhpEmpty(expression);
        PhpPsiElement child = expression.getFirstPsiChild();
        if (!(child == null || child instanceof Variable || child instanceof FieldReference || child instanceof ArrayAccessExpression)) {
            this.checkFeature(PhpLanguageFeature.EMPTY_ANY_EXPRESSION, (PsiElement)child);
        }
    }

    public void visitPhpArrayIndex(ArrayIndex expression) {
        super.visitPhpArrayIndex(expression);
        PhpPsiElement prev = expression.getPrevPsiSibling();
        if (prev instanceof ArrayCreationExpression || prev instanceof StringLiteralExpression) {
            this.checkFeature(PhpLanguageFeature.IMMEDIATE_DEREFERENCING, expression.getParent());
        }
    }

    public void visitPhpYield(PhpYield element) {
        super.visitPhpYield(element);
        this.checkFeature(PhpLanguageFeature.GENERATORS, (PsiElement)element);
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        super.visitPhpContinue(continueStatement);
        this.checkBreakContinueArgument(continueStatement.getArgument(), PhpLanguageFeature.VAR_CONTINUE_ARGUMENT, PhpLanguageFeature.VAR_CONTINUE_ZERO_ARGUMENT);
    }

    private void checkBreakContinueArgument(@Nullable PsiElement argument, @NotNull PhpLanguageFeature argumentFeature, @NotNull PhpLanguageFeature zeroArgumentFeature) {
        if (argumentFeature == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(2);
        }
        if (zeroArgumentFeature == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(3);
        }
        if (argument != null) {
            Object element = argument instanceof ParenthesizedExpression ? ((ParenthesizedExpression)argument).extract() : argument;
            if (!PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
                this.checkFeature(argumentFeature, argument);
            } else {
                Integer depth = PhpCodeInsightUtil.toInt(element);
                if (depth == null || depth <= 0) {
                    this.checkFeature(zeroArgumentFeature, argument);
                }
            }
        }
    }

    public void visitPhpClass(PhpClass clazz) {
        super.visitPhpClass(clazz);
        if (clazz.isTrait()) {
            this.checkFeature(PhpLanguageFeature.TRAITS, clazz.getFirstChild());
        } else if (clazz.isEnum()) {
            this.checkFeature(PhpLanguageFeature.ENUM_CLASSES, clazz.getFirstChild());
        }
        if (clazz.isAnonymous()) {
            this.checkFeature(PhpLanguageFeature.ANONYMOUS_CLASSES, clazz.getFirstChild());
        }
        if (clazz.isReadonly()) {
            PsiElement readonlyModifier = PhpLanguageFeatureUsageVisitor.getReadonlyModifier((PsiElement)clazz);
            if (clazz.isAnonymous()) {
                this.checkFeature(PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES, readonlyModifier);
            } else {
                this.checkFeature(PhpLanguageFeature.READONLY_CLASSES, readonlyModifier);
            }
        }
    }

    public void visitPhpVariable(Variable variable) {
        Function f;
        super.visitPhpVariable(variable);
        if (PhpLangUtil.equalsVariableNames("this", variable.getName()) && !variable.isDeclaration() && (f = PhpPsiUtil.getParentOfClass((PsiElement)variable, Function.class)) != null && f.isClosure()) {
            this.checkFeature(PhpLanguageFeature.THIS_IN_CLOSURE, (PsiElement)variable);
        }
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        super.visitPhpNamespace(namespace);
        ASTNode node = namespace.getNameNode();
        if (node != null) {
            PhpLexer lexer = new PhpLexer(false);
            this.checkKeywordInFQN(lexer, node.getPsi());
        }
    }

    public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
        super.visitPhpNamespaceReference(reference);
        PhpLexer lexer = new PhpLexer(false);
        this.checkKeywordsInNamespaceReference(reference, lexer);
    }

    public void visitPhpClassReference(ClassReference classReference) {
        Function f;
        String name;
        ASTNode node;
        super.visitPhpClassReference(classReference);
        PhpNamespaceReference namespaceReference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)PhpNamespaceReference.class::isInstance));
        PhpLexer lexer = new PhpLexer(false);
        if (namespaceReference != null) {
            this.checkKeywordsInNamespaceReference(namespaceReference, lexer);
        }
        if ((node = classReference.getNameNode()) != null) {
            this.checkKeywordInFQN(lexer, node.getPsi());
        }
        if ((name = classReference.getName()) != null && (name.equals("self") || name.equals("static") || name.equals("parent")) && (f = PhpPsiUtil.getParentOfClass((PsiElement)classReference, Function.class)) != null && f.isClosure()) {
            if (name.equals("self")) {
                this.checkFeature(PhpLanguageFeature.SELF_IN_CLOSURE, (PsiElement)classReference);
            }
            if (name.equals("static")) {
                this.checkFeature(PhpLanguageFeature.STATIC_IN_CLOSURE, (PsiElement)classReference);
            }
            if (name.equals("parent")) {
                this.checkFeature(PhpLanguageFeature.PARENT_IN_CLOSURE, (PsiElement)classReference);
            }
        }
    }

    private void checkKeywordsInNamespaceReference(PhpNamespaceReference namespaceReference, PhpLexer lexer) {
        for (PsiElement child = namespaceReference.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.checkKeywordInFQN(lexer, child);
        }
    }

    private void checkKeywordInFQN(PhpLexer lexer, @Nullable PsiElement child) {
        if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER)) {
            String text = child.getText();
            lexer.start((CharSequence)text, 0, text.length(), 2);
            IElementType type = lexer.getTokenType();
            if (type != PhpTokenTypes.IDENTIFIER) {
                this.checkKeywordInFQN(child, type);
            }
        }
    }

    public void visitPhpNewExpression(NewExpression expression) {
        super.visitPhpNewExpression(expression);
        this.checkCallParameterList((ParameterListOwner)expression);
        PsiElement parent = expression.getParent();
        if (parent instanceof ParenthesizedExpression) {
            if ((parent = parent.getParent()) instanceof FieldReference || parent instanceof MethodReference) {
                this.checkFeature(PhpLanguageFeature.CLASS_MEMBER_ACCESS_ON_INSTANTIATION, expression.getParent());
            }
        } else {
            boolean isAnonymousClassOrNoConstructorArgumentsParentheses;
            boolean bl = isAnonymousClassOrNoConstructorArgumentsParentheses = expression.getClassReference() == null || expression.getParameterList() != null;
            if (isAnonymousClassOrNoConstructorArgumentsParentheses && (parent instanceof FieldReference || parent instanceof FunctionReference || parent instanceof ArrayAccessExpression)) {
                this.checkFeature(PhpLanguageFeature.NEW_WITHOUT_PARENTHESES, parent);
            }
        }
    }

    public void visitPhpMethodReference(MethodReference reference) {
        PhpPsiElement ref;
        PhpPsiElement child;
        super.visitPhpMethodReference(reference);
        this.checkStaticReferenceAccess((MemberReference)reference);
        this.checkCallParameterList((ParameterListOwner)reference);
        this.checkNullsafeDereferencing((MemberReference)reference);
        if (reference.isStatic() && (child = reference.getFirstPsiChild()) != null && (ref = child.getNextPsiSibling()) instanceof StringLiteralExpression && ref.getTextLength() > 0) {
            this.checkFeature(PhpLanguageFeature.LITERAL_IN_STATIC_CALL, (PsiElement)ref);
        }
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        super.visitPhpFunctionCall(reference);
        PhpPsiElement child = reference.getFirstPsiChild();
        if (child instanceof ParenthesizedExpression) {
            this.checkFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, (PsiElement)child);
        }
        this.checkCallParameterList((ParameterListOwner)reference);
    }

    public void visitPhpCallableFunction(PhpCallableFunction reference) {
        PsiElement variadicElement = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.opVARIADIC);
        if (variadicElement != null) {
            this.checkFeature(PhpLanguageFeature.FIRST_CLASS_CALLABLE, variadicElement);
        }
    }

    public void visitPhpCallableMethod(PhpCallableMethod reference) {
        this.visitPhpCallableFunction((PhpCallableFunction)reference);
    }

    private void checkCallParameterList(@NotNull ParameterListOwner parameterListOwner) {
        ParameterList parameterList;
        if (parameterListOwner == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(4);
        }
        if ((parameterList = parameterListOwner.getParameterList()) != null) {
            PsiElement unpacking;
            PsiElement bitOperator = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpTokenTypes.opBIT_AND);
            if (bitOperator != null) {
                this.checkFeature(PhpLanguageFeature.CALL_TIME_PASS_BY_REFERENCE, bitOperator);
            }
            if ((unpacking = PhpPsiUtil.getChildOfType((PsiElement)parameterList, PhpTokenTypes.opVARIADIC)) != null) {
                this.checkFeature(PhpLanguageFeature.ARGUMENT_UNPACKING, unpacking);
            }
            if (PhpPsiUtil.isOfType(parameterList.getLastChild(), PhpTokenTypes.opCOMMA)) {
                this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, parameterList.getLastChild());
            }
        }
    }

    public void visitPhpParameterList(ParameterList list) {
        super.visitPhpParameterList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PhpDocMethod) {
            return;
        }
        if (parent instanceof Function && PhpPsiUtil.isOfType(list.getLastChild(), PhpTokenTypes.opCOMMA)) {
            this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_PARAMETER_LIST, list.getLastChild());
        }
        if (parent instanceof ParameterListOwner) {
            for (ParameterListImpl.PhpNamedArgumentPart part : ((ParameterListImpl)list).getNamedArgumentsParts()) {
                this.checkFeature(PhpLanguageFeature.NAMED_ARGUMENTS, (PsiElement)list, part.getRangeInParent());
            }
        }
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        PsiElement prevSibling;
        super.visitPhpIsset(issetExpression);
        ASTNode lastChildNode = issetExpression.getNode().getLastChildNode();
        if (PhpPsiUtil.isOfType(lastChildNode, PhpTokenTypes.chRPAREN) && PhpPsiUtil.isOfType(prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(lastChildNode.getPsi(), true), PhpTokenTypes.opCOMMA)) {
            this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, prevSibling);
        }
        for (PsiElement param : issetExpression.getChildren()) {
            PsiElement child;
            PsiElement[] children;
            if (!(param instanceof ArrayAccessExpression) || (children = param.getChildren()).length <= 0 || !((child = children[0]) instanceof ConstantReference) && !(child instanceof ClassConstantReference)) continue;
            this.checkFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, param);
        }
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        PsiElement prevPrevSibling;
        PsiElement prevSibling;
        super.visitPhpUnset(unsetStatement);
        ASTNode lastChildNode = unsetStatement.getNode().getLastChildNode();
        if (PhpPsiUtil.isOfType(lastChildNode, PhpTokenTypes.opSEMICOLON) && PhpPsiUtil.isOfType(prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(lastChildNode.getPsi(), true), PhpTokenTypes.chRPAREN) && PhpPsiUtil.isOfType(prevPrevSibling = prevSibling.getPrevSibling(), PhpTokenTypes.opCOMMA)) {
            this.checkFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL, prevPrevSibling);
        }
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        PsiElement operand;
        super.visitPhpBinaryExpression(expression);
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opEXP)) {
            this.checkFeature(PhpLanguageFeature.EXPONENTIATION, operation);
        }
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opSPACESHIP)) {
            this.checkFeature(PhpLanguageFeature.SPACESHIP_OPERATOR, operation);
        }
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCOALESCE)) {
            this.checkFeature(PhpLanguageFeature.COALESCE_OPERATOR, operation);
        }
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.kwINSTANCEOF) && PhpLangUtil.isScalar(operand = expression.getLeftOperand())) {
            this.checkFeature(PhpLanguageFeature.LITERAL_IN_INSTANCEOF, operand);
        }
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opPIPE)) {
            this.checkFeature(PhpLanguageFeature.PIPE_OPERATOR, operation);
        }
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        super.visitPhpSelfAssignmentExpression(expression);
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opEXP_ASGN)) {
            this.checkFeature(PhpLanguageFeature.EXPONENTIATION, operation);
        }
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCOALESCE_ASGN)) {
            this.checkFeature(PhpLanguageFeature.COALESCE_ASSIGN, operation);
        }
    }

    public void visitPhpForeach(ForeachStatement expression) {
        super.visitPhpForeach(expression);
        PsiElement list = PhpPsiUtil.getChildOfType((PsiElement)expression, PhpTokenTypes.kwLIST);
        if (list != null) {
            this.checkFeature(PhpLanguageFeature.FOREACH_LIST, list);
        }
        List variables = expression.getVariables();
        PsiElement openBracket = PhpLanguageFeatureUsageVisitor.findFirstOpenBracket(variables);
        PsiElement closeBracket = PhpLanguageFeatureUsageVisitor.findLastClosetBracket(variables);
        if (PhpPsiUtil.isOfType(openBracket, PhpTokenTypes.chLBRACKET) && PhpPsiUtil.isOfType(closeBracket, PhpTokenTypes.chRBRACKET)) {
            this.checkFeature(PhpLanguageFeature.LIST_ASSIGN, (PsiElement)expression, TextRange.create((int)openBracket.getTextRangeInParent().getStartOffset(), (int)closeBracket.getTextRangeInParent().getEndOffset()));
        }
    }

    @Nullable
    private static PsiElement findFirstOpenBracket(List<Variable> variables) {
        PsiElement p;
        PsiElement openBracket = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)ContainerUtil.getFirstItem(variables), true);
        if (PhpPsiUtil.isOfType(openBracket, PhpTokenTypes.opHASH_ARRAY)) {
            openBracket = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(openBracket, true);
            openBracket = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(openBracket, true);
        }
        while (PhpPsiUtil.isOfType(p = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(openBracket, true), PhpTokenTypes.chLBRACKET)) {
            openBracket = p;
        }
        return openBracket;
    }

    @Nullable
    private static PsiElement findLastClosetBracket(List<Variable> variables) {
        PsiElement p;
        PsiElement closeBracket = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)ContainerUtil.getLastItem(variables), true);
        while (PhpPsiUtil.isOfType(p = PhpPsiUtil.getNextSiblingIgnoreWhitespace(closeBracket, true), PhpTokenTypes.chLBRACKET)) {
            closeBracket = p;
        }
        return closeBracket;
    }

    public void visitPhpExpression(PhpExpression expression) {
        super.visitPhpExpression(expression);
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER)) {
            String text = expression.getText();
            if (text.startsWith("0b")) {
                this.checkFeature(PhpLanguageFeature.BINARY_LITERAL, (PsiElement)expression);
            }
            if (StringUtil.startsWithIgnoreCase((String)text, (String)"0o")) {
                this.checkFeature(PhpLanguageFeature.EXPLICIT_OCTAL_LITERAL, (PsiElement)expression);
            }
            if (text.contains("_")) {
                this.checkFeature(PhpLanguageFeature.NUMERIC_LITERALS_SEPARATORS, (PsiElement)expression);
            }
        }
    }

    public void visitPhpUseList(PhpUseList expression) {
        super.visitPhpUseList(expression);
        ASTNode node = expression.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCONST, PhpTokenTypes.kwFUNCTION}));
        if (node != null) {
            this.checkFeature(PhpLanguageFeature.USE_FUNCTION_AND_CONST, node.getPsi());
        }
        if (PhpPsiUtil.getChildByCondition((PsiElement)expression, PhpUseImpl.USE_BRACES_CONDITION) != null) {
            this.checkFeature(PhpLanguageFeature.GROUPED_USE, (PsiElement)expression);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression expr) {
        super.visitPhpMultiassignmentExpression(expr);
        PhpPsiElement child = expr.getFirstPsiChild();
        if (PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
            this.checkFeature(PhpLanguageFeature.LIST_ASSIGN, (PsiElement)child);
        }
    }

    public void visitPhpUse(PhpUse expression) {
        super.visitPhpUse(expression);
        if (PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpClass.class) != null) {
            this.checkFeature(PhpLanguageFeature.TRAITS, expression.getParent().getFirstChild());
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        super.visitPhpStringLiteralExpression(expression);
        if (expression.isHeredoc() && PhpPsiUtil.isOfType(expression.getLastChild(), PhpTokenTypes.HEREDOC_END)) {
            ASTNode at1;
            if (expression.getLastChild().getText().startsWith("\n ") || expression.getLastChild().getText().startsWith("\n\t")) {
                this.checkFeature(PhpLanguageFeature.FLEXIBLE_HEREDOCS, expression.getLastChild());
            }
            int offset = expression.getTextOffset() + expression.getTextLength();
            FileASTNode node = expression.getContainingFile().getNode();
            ASTNode at0 = node.findLeafElementAt(offset);
            if (!(at0 != null && at0.getChars().charAt(0) == '\n' || (at1 = node.findLeafElementAt(offset + 1)) != null && at1.getChars().charAt(0) == '\n')) {
                this.checkFeature(PhpLanguageFeature.FLEXIBLE_HEREDOCS, expression.getLastChild());
            }
        }
    }

    public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
        super.visitPhpTypeDeclaration(typeDeclaration);
        Collection classReferences = typeDeclaration.getClassReferences();
        this.checkStandaloneNullFalse(classReferences);
        if (classReferences.size() > 1) {
            PsiElement classReferenceGroup;
            this.checkFeature(PhpLanguageFeature.UNION_TYPES, (PsiElement)typeDeclaration);
            if (typeDeclaration.isIntersection()) {
                this.checkFeature(PhpLanguageFeature.INTERSECTION_TYPES, (PsiElement)typeDeclaration);
            }
            if ((classReferenceGroup = PhpPsiUtil.getChildOfType((PsiElement)typeDeclaration, PhpElementTypes.CLASS_REFERENCES_GROUP)) != null) {
                this.checkFeature(PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE, classReferenceGroup);
            }
        } else if (typeDeclaration instanceof PhpFieldType && !(typeDeclaration instanceof PhpClassConstantType)) {
            if (classReferences.size() == 1) {
                this.checkFeature(PhpLanguageFeature.TYPED_PROPERTIES, (PsiElement)typeDeclaration);
            }
            for (ClassReference reference : classReferences) {
                if (!PhpLangUtil.equalsClassNames(reference.getNameCS(), "true")) continue;
                this.checkPhp7TypeHints(reference.getNameCS(), (PsiElement)reference);
            }
        }
    }

    public void visitPhpClassConstantTypeDeclaration(PhpClassConstantType classConstantTypeDeclaration) {
        if (!(classConstantTypeDeclaration.getNextSibling() instanceof PsiErrorElement)) {
            ClassConstImpl classConst = (ClassConstImpl)((Object)ObjectUtils.tryCast((Object)classConstantTypeDeclaration.getNextPsiSibling(), ClassConstImpl.class));
            if (classConst == null || PsiTreeUtil.findChildOfType((PsiElement)classConst, PsiErrorElement.class) != null) {
                return;
            }
            PsiElement defaultValue = classConst.getDefaultValue();
            if (defaultValue != null) {
                this.checkFeature(PhpLanguageFeature.TYPED_CLASS_CONSTANTS, (PsiElement)classConstantTypeDeclaration);
            }
        }
    }

    private void checkStandaloneNullFalse(Collection<ClassReference> classReferences) {
        ClassReference referenceToCheck;
        String name;
        List notNullReferences;
        if (!classReferences.isEmpty() && (notNullReferences = ContainerUtil.filter(classReferences, c -> !c.textMatches((CharSequence)"null"))).size() <= 1 && (PhpLangUtil.equalsClassNames(name = (referenceToCheck = (ClassReference)ContainerUtil.getFirstItem((Collection)notNullReferences, (Object)((ClassReference)ContainerUtil.getFirstItem(classReferences)))).getName(), "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
            this.checkFeature(PhpLanguageFeature.STANDALONE_NULL_FALSE, (PsiElement)referenceToCheck);
        }
    }

    public void visitPhpStatement(Statement statement) {
        PsiElement strictTypesDirective;
        super.visitPhpStatement(statement);
        if (statement instanceof Declare && (strictTypesDirective = DeclareImpl.getStrictTypesDirective((Declare)((Declare)statement))) != null) {
            this.checkFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS, PhpBundle.message("strict.type.declaration.is.available.in.php.7.only", new Object[0]), strictTypesDirective);
        }
    }

    public void visitPhpCatch(Catch phpCatch) {
        super.visitPhpCatch(phpCatch);
        Collection types = phpCatch.getExceptionTypes();
        if (types.size() > 1) {
            ClassReference first = (ClassReference)ContainerUtil.getFirstItem((Collection)types);
            ClassReference last = (ClassReference)ContainerUtil.getLastItem((List)((List)types));
            TextRange range = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
            this.checkFeature(PhpLanguageFeature.CATCH_MULTIPLE, (PsiElement)phpCatch, range);
        }
        this.checkNonCapturingCatches(phpCatch);
    }

    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        super.visitPhpThrowExpression(throwExpression);
        if (!(throwExpression.getParent() instanceof Statement)) {
            this.checkFeature(PhpLanguageFeature.THROW_EXPRESSION, (PsiElement)throwExpression);
        }
    }

    private void checkNonCapturingCatches(Catch phpCatch) {
        if (phpCatch.getExceptionTypes().isEmpty() || phpCatch.getException() != null) {
            return;
        }
        PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)phpCatch, PhpTokenTypes.chLPAREN);
        PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)phpCatch, PhpTokenTypes.chRPAREN);
        if (lParen == null || rParen == null) {
            return;
        }
        TextRange range = TextRange.create((int)lParen.getStartOffsetInParent(), (int)(rParen.getStartOffsetInParent() + 1));
        this.checkFeature(PhpLanguageFeature.NON_CAPTURING_CATCHES, (PsiElement)phpCatch, range);
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        super.visitPhpMatchExpression(matchExpression);
        this.checkFeature(PhpLanguageFeature.MATCH_EXPRESSION, matchExpression.getFirstChild());
    }

    public void visitPhpAttributesList(PhpAttributesList attributesList) {
        super.visitPhpAttributesList(attributesList);
        this.checkFeature(PhpLanguageFeature.ATTRIBUTES, (PsiElement)attributesList);
        if (PhpPsiUtil.isOfType(attributesList.getParent(), PhpElementTypes.CONSTANTS)) {
            this.checkFeature(PhpLanguageFeature.ATTRIBUTES_ON_CONSTANTS, (PsiElement)attributesList);
        }
    }

    public void visitPhpAttribute(PhpAttribute attribute) {
        for (PsiElement parameter : attribute.getParameters()) {
            if (!(parameter instanceof NewExpression)) continue;
            this.checkFeature(PhpLanguageFeature.NEW_IN_INIT, parameter);
        }
    }

    public void visitPhpConstant(Constant constant) {
        PsiElement value = constant.getValue();
        if (value instanceof NewExpression) {
            this.checkFeature(PhpLanguageFeature.NEW_IN_INIT, value);
        }
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        for (AssignmentExpression declaration : staticStatement.getDeclarations()) {
            PhpPsiElement value = declaration.getValue();
            if (this.myGlobal && value != null && !PhpCodeValidationUtil.isAllowedAsStaticValue((PsiElement)value)) {
                this.checkFeature(PhpLanguageFeature.ARBITRARY_STATIC_VARIABLE_INITIALIZERS, (PsiElement)value);
                continue;
            }
            if (!(value instanceof NewExpression)) continue;
            this.checkFeature(PhpLanguageFeature.NEW_IN_INIT, (PsiElement)value);
        }
    }

    public void visitPhpDocTag(PhpDocTag tag) {
        if (tag instanceof PhpDocTemplateTag) {
            this.checkFeature(PhpLanguageFeature.DOC_TEMPLATE_TAG, (PsiElement)tag);
        }
    }

    protected void checkKeywordInFQN(PsiElement child, IElementType type) {
        this.checkFeature(PhpLanguageFeature.NAMESPACED_NAME_AS_SINGLE_TOKEN, child);
    }

    private void checkNullsafeDereferencing(MemberReference reference) {
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference.getClassReference(), true);
        if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.opQUEST)) {
            this.checkFeature(PhpLanguageFeature.NULLSAFE_DEREFERENCING, sibling);
        }
    }

    private void checkStaticReferenceAccess(MemberReference reference) {
        PsiElement parent = reference.getParent();
        if (parent instanceof MemberReference && ((MemberReference)parent).getReferenceType().isStatic()) {
            this.checkFeature(PhpLanguageFeature.UNIFORM_VARIABLE_SYNTAX, parent);
        }
    }

    protected void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull PsiElement psiElement) {
        if (languageFeature == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(5);
        }
        if (psiElement == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(6);
        }
        this.checkFeature(languageFeature, languageFeature.getNotSupportedErrorMessage(), psiElement);
    }

    private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull @Nls String errorMessage, @NotNull PsiElement psiElement) {
        if (languageFeature == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(7);
        }
        if (errorMessage == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(9);
        }
        this.checkFeature(languageFeature, errorMessage, psiElement, null);
    }

    private void checkFeature(@NotNull PhpLanguageFeature languageFeature, @NotNull PsiElement psiElement, @Nullable TextRange rangeInElement) {
        if (languageFeature == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(10);
        }
        if (psiElement == null) {
            PhpLanguageFeatureUsageVisitor.$$$reportNull$$$0(11);
        }
        this.checkFeature(languageFeature, languageFeature.getNotSupportedErrorMessage(), psiElement, rangeInElement);
    }

    protected abstract void checkFeature(@NotNull PhpLanguageFeature var1, @NotNull String var2, @NotNull PsiElement var3, @Nullable TextRange var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentFeature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zeroArgumentFeature";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterListOwner";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeature";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpLanguageFeatureUsageVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPhp7TypeHints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReadonlyModifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBreakContinueArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallParameterList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFeature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

