/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpHookedPropertyCantBeAccessedByRefInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedSetIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePublicIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePublicSetIntention;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J2\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J$\u0010\u0013\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J2\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0019H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "setterHasReturnStatement", "setter", "Lcom/jetbrains/php/lang/psi/elements/Method;", "isReferencedOnlyFromGetterAndSetter", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "getter", "isPotentiallyFutureVirtualProperty", "Lcom/intellij/openapi/util/Ref;", "getterAndSetterHaveDefaultBodies", "fieldName", "", "methodHasDefaultBody", "method", "getFieldReference", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lcom/jetbrains/php/lang/psi/elements/FieldReference;", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\ncom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n1869#2,2:448\n*S KotlinDebug\n*F\n+ 1 PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\ncom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection\n*L\n136#1:448,2\n*E\n"})
public final class PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpField(Field field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.checkField(field);
            }

            public void visitPhpParameter(Parameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                if (!(parameter instanceof Field)) {
                    return;
                }
                this.checkField((Field)parameter);
            }

            private final void checkField(Field field) {
                Parameter param;
                Object[] setter;
                Method getter;
                PhpPropertyHook setHook;
                PhpPropertyHook getHook;
                block18: {
                    block17: {
                        block16: {
                            if (field.isReadonly() || field.isConstant() || field.getModifier().isStatic() || field.isAbstract()) {
                                return;
                            }
                            getHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook(field);
                            setHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getSetHook(field);
                            if (getHook != null && setHook != null) {
                                return;
                            }
                            PhpAccessorsGenerator generator = new PhpAccessorsGenerator(field);
                            Object[] objectArray = generator.findGetters();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findGetters(...)");
                            Object[] getters = objectArray;
                            Object[] objectArray2 = generator.findSetters();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"findSetters(...)");
                            Object[] setters = objectArray2;
                            if (getters.length > 1 || setters.length > 1) {
                                return;
                            }
                            getter = (Method)ArraysKt.firstOrNull((Object[])getters);
                            setter = (Object[])ArraysKt.firstOrNull((Object[])setters);
                            if (getter == null && setter == null) {
                                return;
                            }
                            if (getHook != null && setter == null || setHook != null && getter == null) {
                                return;
                            }
                            if (getter == null) break block16;
                            Parameter[] parameterArray = getter.getParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
                            if (!(((Object[])parameterArray).length == 0)) break block17;
                        }
                        if (setter == null || setter.getParameters().length <= 1) break block18;
                    }
                    return;
                }
                Object[] objectArray = setter;
                Parameter parameter = param = setter != null && (objectArray = objectArray.getParameters()) != null ? (Parameter)ArraysKt.firstOrNull((Object[])objectArray) : null;
                if ((parameter != null ? parameter.getDefaultValue() : null) != null) {
                    return;
                }
                if (param != null && !PhpAnnotatorVisitor.areParameterHookTypeAndFieldTypeCompatible(field.getDeclaredType(), param.getDeclaredType(), field.getProject())) {
                    return;
                }
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                boolean hasDefaultBodies = PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.access$getterAndSetterHaveDefaultBodies(this.this$0, getter, (Method)setter, string);
                Ref isPotentiallyVirtualProperty = new Ref((Object)true);
                if (hasDefaultBodies || field.getModifier().isPrivate() && !PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.access$setterHasReturnStatement(this.this$0, (Method)setter) && PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.access$isReferencedOnlyFromGetterAndSetter(this.this$0, field, getter, (Method)setter, isPotentiallyVirtualProperty) && (!((Boolean)isPotentiallyVirtualProperty.get()).booleanValue() || field.getDefaultValue() == null)) {
                    String message = null;
                    String qfText = null;
                    if (getter != null && getHook == null && setter != null && setHook == null) {
                        Object[] objectArray3 = new Object[]{"Getter and setter", "get and set hooks"};
                        String string2 = PhpBundle.message("inspection.message.getter.setter.can.be.replaced.property.hooks", objectArray3);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        message = string2;
                        objectArray3 = new Object[]{"getter and setter", "get and set hooks"};
                        String string3 = PhpBundle.message("quick.fix.replace.getter.setter.with.hooks", objectArray3);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                        qfText = string3;
                    } else if (getter != null && getHook == null) {
                        Object[] objectArray4 = new Object[]{"Getter", "get hook"};
                        String string4 = PhpBundle.message("inspection.message.getter.setter.can.be.replaced.property.hooks", objectArray4);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                        message = string4;
                        objectArray4 = new Object[]{"getter", "get hook"};
                        String string5 = PhpBundle.message("quick.fix.replace.getter.setter.with.hooks", objectArray4);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                        qfText = string5;
                    } else {
                        Object[] objectArray5 = new Object[]{"Setter", "set hook"};
                        String string6 = PhpBundle.message("inspection.message.getter.setter.can.be.replaced.property.hooks", objectArray5);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                        message = string6;
                        objectArray5 = new Object[]{"setter", "set hook"};
                        String string7 = PhpBundle.message("quick.fix.replace.getter.setter.with.hooks", objectArray5);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                        qfText = string7;
                    }
                    if (field.getNameIdentifier() == null) {
                        return;
                    }
                    PsiElement psiElement = field.getNameIdentifier();
                    Intrinsics.checkNotNull((Object)psiElement);
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix((PsiElement)field, qfText)};
                    this.$holder.registerProblem(psiElement, message, localQuickFixArray);
                }
            }
        };
    }

    private final boolean setterHasReturnStatement(Method setter) {
        if (setter == null) {
            return false;
        }
        Ref hasReturn = new Ref((Object)false);
        PhpControlFlowUtil.processFlow(setter.getControlFlow(), new PhpInstructionProcessor((Ref<Boolean>)hasReturn){
            final /* synthetic */ Ref<Boolean> $hasReturn;
            {
                this.$hasReturn = $hasReturn;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                this.$hasReturn.set((Object)true);
                return false;
            }
        });
        Object object = hasReturn.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final boolean isReferencedOnlyFromGetterAndSetter(Field field, Method getter, Method setter, Ref<Boolean> isPotentiallyFutureVirtualProperty) {
        PhpClass phpClass = field.getContainingClass();
        if (phpClass == null) {
            return true;
        }
        PhpClass clazz = phpClass;
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)clazz), true);
        Ref referencedOnlyFromGetterAndSetter = new Ref((Object)true);
        Iterable $this$forEach$iv = ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).asIterable();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            Method containingMethod = (Method)PhpPsiUtil.getParentByCondition(it.getElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (containingMethod == null || !Intrinsics.areEqual((Object)containingMethod, (Object)getter) && !Intrinsics.areEqual((Object)containingMethod, (Object)setter) && !(containingMethod instanceof PhpPropertyHook)) {
                referencedOnlyFromGetterAndSetter.set((Object)false);
                continue;
            }
            if (!Intrinsics.areEqual((Object)containingMethod, (Object)getter) && !Intrinsics.areEqual((Object)containingMethod, (Object)setter)) continue;
            isPotentiallyFutureVirtualProperty.set((Object)false);
        }
        Object object = referencedOnlyFromGetterAndSetter.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final boolean getterAndSetterHaveDefaultBodies(Method getter, Method setter, String fieldName) {
        return this.methodHasDefaultBody(getter, fieldName, (Function1<? super PsiElement, ? extends FieldReference>)((Function1)PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection::getterAndSetterHaveDefaultBodies$lambda$1)) && this.methodHasDefaultBody(setter, fieldName, (Function1<? super PsiElement, ? extends FieldReference>)((Function1)PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection::getterAndSetterHaveDefaultBodies$lambda$2));
    }

    private final boolean methodHasDefaultBody(Method method, String fieldName, Function1<? super PsiElement, ? extends FieldReference> getFieldReference) {
        if (method == null) {
            return true;
        }
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            return false;
        }
        GroupStatement groupStatement2 = groupStatement;
        if (groupStatement2.getStatements().length != 1) {
            return false;
        }
        PsiElement[] psiElementArray = groupStatement2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStatements(...)");
        FieldReference reference = (FieldReference)getFieldReference.invoke(ArraysKt.firstOrNull((Object[])psiElementArray));
        if (reference == null) {
            return false;
        }
        PhpExpression phpExpression = reference.getClassReference();
        Variable variable = phpExpression instanceof Variable ? (Variable)phpExpression : null;
        if (variable == null) {
            return false;
        }
        Variable classRef = variable;
        String string = reference.getName();
        if (string == null) {
            return false;
        }
        String field = string;
        return Intrinsics.areEqual((Object)classRef.getName(), (Object)"this") && Intrinsics.areEqual((Object)field, (Object)fieldName);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    private static final FieldReference getterAndSetterHaveDefaultBodies$lambda$1(PsiElement it) {
        PhpReturn phpReturn = it instanceof PhpReturn ? (PhpReturn)it : null;
        PsiElement psiElement = phpReturn != null ? phpReturn.getArgument() : null;
        return psiElement instanceof FieldReference ? (FieldReference)psiElement : null;
    }

    private static final FieldReference getterAndSetterHaveDefaultBodies$lambda$2(PsiElement it) {
        AssignmentExpression assignmentExpression = PhpPsiUtil.getChildOfClass(it, AssignmentExpression.class);
        PhpPsiElement phpPsiElement = assignmentExpression != null ? assignmentExpression.getVariable() : null;
        return phpPsiElement instanceof FieldReference ? (FieldReference)phpPsiElement : null;
    }

    public static final /* synthetic */ boolean access$getterAndSetterHaveDefaultBodies(PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection $this, Method getter, Method setter, String fieldName) {
        return $this.getterAndSetterHaveDefaultBodies(getter, setter, fieldName);
    }

    public static final /* synthetic */ boolean access$setterHasReturnStatement(PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection $this, Method setter) {
        return $this.setterHasReturnStatement(setter);
    }

    public static final /* synthetic */ boolean access$isReferencedOnlyFromGetterAndSetter(PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection $this, Field field, Method getter, Method setter, Ref isPotentiallyFutureVirtualProperty) {
        return $this.isReferencedOnlyFromGetterAndSetter(field, getter, setter, (Ref<Boolean>)isPotentiallyFutureVirtualProperty);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0016J\r\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0015H\u0016J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020#H\u0002J2\u0010)\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010 \u001a\u0004\u0018\u00010\u00192\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J@\u0010+\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010 \u001a\u0004\u0018\u00010\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J(\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0002J&\u00105\u001a\u00020/2\b\u0010'\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00102\u001a\u00020/J\u001a\u00106\u001a\u00020\t2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010$\u001a\u00020%H\u0002J$\u00109\u001a\u0004\u0018\u0001082\b\u0010'\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010:\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection$PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "text", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "replaceGetterUsagesWithFieldRead", "fieldName", "getter", "Lcom/jetbrains/php/lang/psi/elements/Method;", "usages", "", "Lcom/intellij/psi/PsiReference;", "startInWriteAction", "", "replaceSetterUsagesWithFieldWrite", "setter", "abstractPropertyHooksFromParent", "", "Lcom/jetbrains/php/lang/psi/elements/PhpPropertyHook$PhpPropertyHookType;", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "replaceParentAbstractMethodsWithAbstractHook", "method", "hookType", "addPropertyHooks", "abstractHookTypes", "changeFieldVisibility", "getterUsages", "setterUsages", "getMinimumVisibilityBasedOnUsage", "Lcom/jetbrains/php/lang/psi/elements/PhpModifier$Access;", "usage", "methodVisibility", "fieldVisibility", "containingClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "getMinimumVisibility", "replaceParameterInSetHook", "setHook", "Lcom/jetbrains/php/lang/psi/elements/PhpPropertyHook;", "createHookFromMethod", "hookKw", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\ncom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection$PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n1869#2,2:448\n1869#2,2:450\n1869#2,2:452\n1869#2,2:454\n1869#2,2:456\n774#2:459\n865#2,2:460\n1563#2:462\n1634#2,3:463\n1563#2:466\n1634#2,3:467\n1#3:458\n*S KotlinDebug\n*F\n+ 1 PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection.kt\ncom/jetbrains/php/lang/inspections/PhpGetterAndSetterCanBeReplacedWithPropertyHooksInspection$PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix\n*L\n199#1:448,2\n213#1:450,2\n398#1:452,2\n412#1:454,2\n414#1:456,2\n227#1:459\n227#1:460,2\n227#1:462\n227#1:463,3\n242#1:466\n242#1:467,3\n*E\n"})
    private static final class PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @NotNull
        private final String text;

        public PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix(@NotNull PsiElement element, @NlsSafe @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(element);
            this.text = text;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof Field)) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                return;
            }
            PhpAccessorsGenerator generator = new PhpAccessorsGenerator((Field)startElement);
            Method[] methodArray = generator.findGetters();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"findGetters(...)");
            Method getter = (Method)ArraysKt.firstOrNull((Object[])methodArray);
            Method[] methodArray2 = generator.findSetters();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"findSetters(...)");
            Method setter = (Method)ArraysKt.firstOrNull((Object[])methodArray2);
            Set<PhpPropertyHook.PhpPropertyHookType> abstractHookTypes = this.abstractPropertyHooksFromParent((Field)startElement);
            WriteAction.run(() -> PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix.invoke$lambda$2(getter, setter, this, startElement));
            this.addPropertyHooks((Field)startElement, getter, setter, abstractHookTypes);
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        @NotNull
        public String getFamilyName() {
            return this.text;
        }

        private final void replaceGetterUsagesWithFieldRead(String fieldName, Method getter, List<? extends PsiReference> usages) {
            if (getter == null) {
                return;
            }
            Iterable $this$forEach$iv = usages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FieldReference newReference;
                PhpExpression classRef;
                PsiReference it = (PsiReference)element$iv;
                boolean bl = false;
                if (!(it.getElement() instanceof MethodReference)) continue;
                PsiElement psiElement = it.getElement();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.MethodReference");
                if (((MethodReference)psiElement).getClassReference() == null) continue;
                Project project = getter.getProject();
                String string = classRef.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] cArray = new char[]{'$'};
                Intrinsics.checkNotNullExpressionValue((Object)PhpPsiElementFactory.createFieldReference(project, StringsKt.trim((String)string, (char[])cArray), fieldName, true), (String)"createFieldReference(...)");
                it.getElement().replace((PsiElement)newReference);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private final void replaceSetterUsagesWithFieldWrite(String fieldName, Method setter, List<? extends PsiReference> usages) {
            if (setter == null) {
                return;
            }
            Iterable $this$forEach$iv = usages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AssignmentExpression assignment;
                FieldReference newReference;
                PhpExpression classRef;
                ParameterList parameterList;
                PsiReference it = (PsiReference)element$iv;
                boolean bl = false;
                if (!(it.getElement() instanceof MethodReference)) continue;
                PsiElement psiElement = it.getElement();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.MethodReference");
                if (((MethodReference)psiElement).getClassReference() == null || (parameterList = PhpPsiUtil.getChildOfClass(it.getElement(), ParameterList.class)) == null || (parameterList = parameterList.getParameter(0)) == null) continue;
                ParameterList parameter = parameterList;
                Project project = setter.getProject();
                String string = classRef.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] cArray = new char[]{'$'};
                Intrinsics.checkNotNullExpressionValue((Object)PhpPsiElementFactory.createFieldReference(project, StringsKt.trim((String)string, (char[])cArray), fieldName, true), (String)"createFieldReference(...)");
                String assignmentText = newReference.getText() + " = " + parameter.getText();
                Intrinsics.checkNotNullExpressionValue((Object)PhpPsiElementFactory.createPhpPsiFromText(setter.getProject(), AssignmentExpression.class, assignmentText), (String)"createPhpPsiFromText(...)");
                it.getElement().replace((PsiElement)assignment);
            }
        }

        private final Set<PhpPropertyHook.PhpPropertyHookType> abstractPropertyHooksFromParent(Field field) {
            Set abstractHookTypes = new LinkedHashSet();
            PhpClassHierarchyUtils.processSuperFields((Field)field, (arg_0, arg_1, arg_2) -> PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix.abstractPropertyHooksFromParent$lambda$7(abstractHookTypes, arg_0, arg_1, arg_2));
            return abstractHookTypes;
        }

        private final void replaceParentAbstractMethodsWithAbstractHook(Field field, Method method, PhpPropertyHook.PhpPropertyHookType hookType) {
            PhpClassHierarchyUtils.processSuperMethods((Method)method, (arg_0, arg_1, arg_2) -> PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix.replaceParentAbstractMethodsWithAbstractHook$lambda$12(field, hookType, arg_0, arg_1, arg_2));
        }

        private final void addPropertyHooks(Field field, Method getter, Method setter, Set<PhpPropertyHook.PhpPropertyHookType> abstractHookTypes) {
            Object object;
            Object getterUsages2;
            block7: {
                block6: {
                    Project project;
                    block5: {
                        Object object2;
                        block4: {
                            Project project2 = field.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                            project = project2;
                            object2 = getter;
                            if (object2 == null) break block4;
                            Method it = object2;
                            boolean bl = false;
                            Project project3 = getter.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                            String string = PhpBundle.message("php.property.hooks.search.setter.getter.usages", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            List list = (List)TasksKt.runWithModalProgressBlocking((Project)project3, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends PsiReference>>, Object>(getter, project, null){
                                int label;
                                final /* synthetic */ Method $getter;
                                final /* synthetic */ Project $project;
                                {
                                    this.$getter = $getter;
                                    this.$project = $project;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)this.$getter, (SearchScope)GlobalSearchScope.allScope((Project)this.$project), true);
                                            return CollectionsKt.toList((Iterable)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).asIterable());
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends PsiReference>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }));
                            object2 = list;
                            if (list != null) break block5;
                        }
                        object2 = getterUsages2 = CollectionsKt.emptyList();
                    }
                    if ((object = setter) == null) break block6;
                    Method it = object;
                    boolean bl = false;
                    Project project4 = setter.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                    String string = PhpBundle.message("php.property.hooks.search.setter.getter.usages", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    List list = (List)TasksKt.runWithModalProgressBlocking((Project)project4, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends PsiReference>>, Object>(setter, project, null){
                        int label;
                        final /* synthetic */ Method $setter;
                        final /* synthetic */ Project $project;
                        {
                            this.$setter = $setter;
                            this.$project = $project;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)this.$setter, (SearchScope)GlobalSearchScope.allScope((Project)this.$project), true);
                                    return CollectionsKt.toList((Iterable)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).asIterable());
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends PsiReference>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    object = list;
                    if (list != null) break block7;
                }
                object = CollectionsKt.emptyList();
            }
            Object setterUsages2 = object;
            this.changeFieldVisibility(field, getter, setter, (List<? extends PsiReference>)getterUsages2, (List<? extends PsiReference>)setterUsages2);
            WriteAction.run(() -> PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix.addPropertyHooks$lambda$16(field, this, getter, abstractHookTypes, setter, (List)getterUsages2, (List)setterUsages2));
        }

        private final void changeFieldVisibility(Field field, Method getter, Method setter, List<? extends PsiReference> getterUsages2, List<? extends PsiReference> setterUsages2) {
            PhpModifier.Access access = field.getModifier().getSetAccess();
            if (access == null) {
                PhpModifier.Access access2 = field.getModifier().getAccess();
                access = access2;
                Intrinsics.checkNotNullExpressionValue((Object)access2, (String)"getAccess(...)");
            }
            PhpModifier.Access minimumSetVisibility = this.getMinimumVisibility(setter, setterUsages2, access);
            PhpModifier.Access access3 = field.getModifier().getAccess();
            Intrinsics.checkNotNullExpressionValue((Object)access3, (String)"getAccess(...)");
            PhpModifier.Access minimumVisibility = this.getMinimumVisibility(getter, getterUsages2, access3);
            if (minimumSetVisibility.isWeakerThan(minimumVisibility)) {
                minimumVisibility = minimumSetVisibility;
            }
            if (field.getModifier().getSetAccess() != null && field.getModifier().getSetAccess() != minimumSetVisibility) {
                switch (WhenMappings.$EnumSwitchMapping$0[minimumSetVisibility.ordinal()]) {
                    case 1: {
                        if (field instanceof PhpPromotedFieldParameterImpl) {
                            new PhpMakePublicSetIntention().changeAccess(((PhpPromotedFieldParameterImpl)field).getProject(), (PhpPromotedFieldParameterImpl)field);
                            break;
                        }
                        new PhpMakePublicSetIntention().changeAccess(field);
                        break;
                    }
                    case 2: {
                        if (field instanceof PhpPromotedFieldParameterImpl) {
                            new PhpMakeProtectedSetIntention().changeAccess(((PhpPromotedFieldParameterImpl)field).getProject(), (PhpPromotedFieldParameterImpl)field);
                            break;
                        }
                        new PhpMakeProtectedSetIntention().changeAccess(field);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (field.getModifier().getAccess() != minimumVisibility) {
                switch (WhenMappings.$EnumSwitchMapping$0[minimumVisibility.ordinal()]) {
                    case 1: {
                        if (field instanceof PhpPromotedFieldParameterImpl) {
                            new PhpMakePublicIntention().changeAccess(((PhpPromotedFieldParameterImpl)field).getProject(), (PhpPromotedFieldParameterImpl)field);
                            break;
                        }
                        new PhpMakePublicIntention().changeAccess(field);
                        break;
                    }
                    case 2: {
                        if (field instanceof PhpPromotedFieldParameterImpl) {
                            new PhpMakeProtectedIntention().changeAccess(((PhpPromotedFieldParameterImpl)field).getProject(), (PhpPromotedFieldParameterImpl)field);
                            break;
                        }
                        new PhpMakeProtectedIntention().changeAccess(field);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }

        private final PhpModifier.Access getMinimumVisibilityBasedOnUsage(PsiReference usage, PhpModifier.Access methodVisibility, PhpModifier.Access fieldVisibility, PhpClass containingClass) {
            if (fieldVisibility == PhpModifier.Access.PUBLIC) {
                return fieldVisibility;
            }
            PhpClass parentUsageClass = (PhpClass)PhpPsiUtil.getParentByCondition(usage.getElement(), false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpFile.INSTANCEOF);
            if (Intrinsics.areEqual((Object)parentUsageClass, (Object)containingClass)) {
                return fieldVisibility;
            }
            if (parentUsageClass != null) {
                PhpClass[] phpClassArray = parentUsageClass.getSupers();
                Intrinsics.checkNotNullExpressionValue((Object)phpClassArray, (String)"getSupers(...)");
                if (ArraysKt.contains((Object[])phpClassArray, (Object)containingClass)) {
                    return PhpModifier.Access.PROTECTED;
                }
            }
            return methodVisibility;
        }

        @NotNull
        public final PhpModifier.Access getMinimumVisibility(@Nullable Method method, @NotNull List<? extends PsiReference> usages, @NotNull PhpModifier.Access fieldVisibility) {
            Method method2;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter(usages, (String)"usages");
                    Intrinsics.checkNotNullParameter((Object)fieldVisibility, (String)"fieldVisibility");
                    method2 = method;
                    if (method2 == null) break block3;
                    Method it = method2;
                    boolean bl = false;
                    PhpModifier.Access prev = null;
                    prev = fieldVisibility;
                    Iterable $this$forEach$iv = usages;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiReference it2 = (PsiReference)element$iv;
                        boolean bl2 = false;
                        PhpModifier.Access access = method.getAccess();
                        Intrinsics.checkNotNullExpressionValue((Object)access, (String)"getAccess(...)");
                        PhpClass phpClass = method.getContainingClass();
                        Intrinsics.checkNotNull((Object)phpClass);
                        PhpModifier.Access visibility = this.getMinimumVisibilityBasedOnUsage(it2, access, fieldVisibility, phpClass);
                        if (!visibility.isWeakerThan(prev)) continue;
                        prev = visibility;
                    }
                    PhpModifier.Access access = prev;
                    method2 = access;
                    if (access != null) break block4;
                }
                method2 = fieldVisibility;
            }
            return method2;
        }

        private final void replaceParameterInSetHook(PhpPropertyHook setHook, Field field) {
            PsiReference it;
            if (setHook == null) {
                return;
            }
            Parameter[] parameterArray = setHook.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
            Parameter parameter = (Parameter)ArraysKt.firstOrNull((Object[])parameterArray);
            if (parameter == null) {
                return;
            }
            Parameter singleParameter = parameter;
            List usages = new ArrayList();
            ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)singleParameter, (SearchScope)new LocalSearchScope((PsiElement)setHook), true);
            Iterable $this$forEach$iv = ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).asIterable();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiReference)element$iv;
                boolean bl = false;
                PsiElement psiElement = it.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                usages.add(psiElement);
            }
            $this$forEach$iv = usages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Variable newVar;
                it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof Variable)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)PhpPsiElementFactory.createVariable(setHook.getProject(), "value", true), (String)"createVariable(...)");
                it.replace((PsiElement)newVar);
            }
            if (Intrinsics.areEqual((Object)singleParameter.getDeclaredType(), (Object)field.getDeclaredType()) && setHook.getParameterList() != null) {
                ParameterList parameterList = setHook.getParameterList();
                Intrinsics.checkNotNull((Object)parameterList);
                $this$forEach$iv = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)parameterList, (Condition<? super PsiElement>)((Condition)PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix::replaceParameterInSetHook$lambda$21));
                if ($this$forEach$iv != null) {
                    $this$forEach$iv.delete();
                }
                if (($this$forEach$iv = PhpPsiUtil.getNextSiblingByCondition((PsiElement)setHook.getParameterList(), (Condition<? super PsiElement>)((Condition)PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix::replaceParameterInSetHook$lambda$22))) != null) {
                    $this$forEach$iv.delete();
                }
                ParameterList parameterList2 = setHook.getParameterList();
                Intrinsics.checkNotNull((Object)parameterList2);
                parameterList2.delete();
            } else {
                String string = singleParameter.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = singleParameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String newText = StringsKt.replace$default((String)string, (String)string2, (String)"value", (boolean)false, (int)4, null);
                Parameter parameter2 = PhpPsiElementFactory.createComplexParameter(field.getProject(), newText);
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"createComplexParameter(...)");
                Parameter parameter3 = parameter2;
                singleParameter.replace((PsiElement)parameter3);
            }
        }

        private final PhpPropertyHook createHookFromMethod(Method method, Field field, String hookKw) {
            PhpPropertyHook hook;
            Object parameter;
            GroupStatement groupStatement;
            block7: {
                Object object;
                block6: {
                    if (method == null) {
                        return null;
                    }
                    GroupStatement groupStatement2 = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                    if (groupStatement2 == null) {
                        return null;
                    }
                    groupStatement = groupStatement2;
                    Parameter[] parameterArray = method.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
                    object = (Parameter)ArraysKt.firstOrNull((Object[])parameterArray);
                    if (object == null) break block6;
                    Parameter it = object;
                    boolean bl = false;
                    String string = "(" + it.getText() + ")";
                    object = string;
                    if (string != null) break block7;
                }
                object = parameter = "";
            }
            if ((hook = PhpPsiElementFactory.createPropertyHook(field.getProject(), field.getName(), hookKw + (String)parameter + groupStatement.getText())).getHookType() == PhpPropertyHook.PhpPropertyHookType.SET) {
                this.replaceParameterInSetHook(hook, field);
            }
            return hook;
        }

        private static final void invoke$lambda$2(Method $getter, Method $setter, PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix this$0, PsiElement $startElement) {
            block1: {
                Method it;
                Method method = $getter;
                if (method != null) {
                    it = method;
                    boolean bl = false;
                    this$0.replaceParentAbstractMethodsWithAbstractHook((Field)$startElement, it, PhpPropertyHook.PhpPropertyHookType.GET);
                }
                Method method2 = $setter;
                if (method2 == null) break block1;
                it = method2;
                boolean bl = false;
                this$0.replaceParentAbstractMethodsWithAbstractHook((Field)$startElement, it, PhpPropertyHook.PhpPropertyHookType.SET);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean abstractPropertyHooksFromParent$lambda$7(Set $abstractHookTypes, Field superField, PhpClass subClass, PhpClass baseClass) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PhpPropertyHook it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List list = superField.getPropertyHooksList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyHooksList(...)");
            Iterable iterable = list;
            Set set = $abstractHookTypes;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PhpPropertyHook)element$iv$iv;
                boolean bl = false;
                if (!it.isAbstract()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PhpPropertyHook)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getHookType());
            }
            set.addAll((List)destination$iv$iv);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean replaceParentAbstractMethodsWithAbstractHook$lambda$12(Field $field, PhpPropertyHook.PhpPropertyHookType $hookType, Method superMethod, PhpClass subClass, PhpClass baseClass) {
            if (!superMethod.isAbstract()) {
                return true;
            }
            PhpDocComment phpDocComment = superMethod.getDocComment();
            if (phpDocComment != null) {
                phpDocComment.delete();
            }
            Field field = baseClass.findOwnFieldByName((CharSequence)$field.getName(), false);
            if (field != null) {
                Field superField = field;
                boolean bl = false;
                PsiElement hookContainer = FieldImpl.getPropertyHooksContainer(superField);
                if (hookContainer != null) {
                    void $this$mapTo$iv$iv;
                    List list = superField.getPropertyHooksList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPropertyHooksList(...)");
                    List hooks = list;
                    Iterable $this$map$iv = hooks;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        PhpPropertyHook phpPropertyHook = (PhpPropertyHook)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.getHookType());
                    }
                    if (((List)destination$iv$iv).contains($hookType)) {
                        return true;
                    }
                    PhpPropertyHook hook = PhpPsiElementFactory.createPropertyHook($field.getProject(), $field.getName(), $hookType.keyWord + ";");
                    hookContainer.addAfter((PsiElement)hook, hookContainer.getFirstChild());
                } else {
                    hookContainer = PhpPsiElementFactory.createPropertyHooks($field.getProject(), $hookType.keyWord + ";");
                    superField.addAfter(hookContainer, superField.getLastChild());
                    PsiElement psiElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)superField, true);
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl3 = false;
                        if (PhpPsiUtil.isOfType(it, PhpTokenTypes.opSEMICOLON)) {
                            it.delete();
                        }
                    }
                }
                superMethod.delete();
                return true;
            }
            PhpModifier.Abstractness abstractness = baseClass.isInterface() ? PhpModifier.Abstractness.IMPLEMENTED : PhpModifier.Abstractness.ABSTRACT;
            PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)PhpModifier.Access.PUBLIC, (PhpModifier.Access)$field.getModifier().getSetAccess(), (PhpModifier.Abstractness)abstractness, (PhpModifier.State)$field.getModifier().getState());
            Intrinsics.checkNotNullExpressionValue((Object)phpModifier, (String)"instance(...)");
            PhpModifier modifier = phpModifier;
            PhpPsiElement phpPsiElement = PhpPsiElementFactory.createClassField($field.getProject(), modifier, $field.getName(), null, $field.getDeclaredType().toString());
            Intrinsics.checkNotNullExpressionValue((Object)phpPsiElement, (String)"createClassField(...)");
            PhpPsiElement fieldList = phpPsiElement;
            PsiElement hooksContainer = PhpPsiElementFactory.createPropertyHooks($field.getProject(), $hookType.keyWord + ";");
            PsiElement psiElement = fieldList.getLastChild();
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                if (PhpPsiUtil.isOfType(fieldList.getLastChild(), PhpTokenTypes.opSEMICOLON)) {
                    it.delete();
                }
            }
            fieldList.addAfter(hooksContainer, fieldList.getLastChild());
            superMethod.replace((PsiElement)fieldList);
            return true;
        }

        private static final boolean addPropertyHooks$lambda$16$lambda$15(PsiElement e) {
            return PhpPsiUtil.isOfType(e, PhpTokenTypes.opSEMICOLON);
        }

        private static final void addPropertyHooks$lambda$16(Field $field, PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix this$0, Method $getter, Set $abstractHookTypes, Method $setter, List $getterUsages, List $setterUsages) {
            block20: {
                PhpPropertyHook setHook;
                PsiElement hooksContainer = FieldImpl.getPropertyHooksContainer($field);
                PhpPropertyHook existingGetHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook($field);
                PhpPropertyHook existingSetHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getSetHook($field);
                if (existingGetHook == null && existingSetHook == null) {
                    Method method;
                    Method method2;
                    Object object;
                    PhpPropertyHook setHook2;
                    PhpPropertyHook getHook = this$0.createHookFromMethod($getter, $field, "get");
                    if (getHook == null && $abstractHookTypes.contains(PhpPropertyHook.PhpPropertyHookType.GET)) {
                        getHook = PhpPsiElementFactory.createPropertyHook($field.getProject(), PhpPropertyHook.PhpPropertyHookType.GET, $field.getName());
                    }
                    if ((setHook2 = this$0.createHookFromMethod($setter, $field, "set")) == null && $abstractHookTypes.contains(PhpPropertyHook.PhpPropertyHookType.SET)) {
                        setHook2 = PhpPsiElementFactory.createPropertyHook($field.getProject(), PhpPropertyHook.PhpPropertyHookType.SET, $field.getName());
                    }
                    if (getHook == null && setHook2 == null) {
                        return;
                    }
                    Project project = $field.getProject();
                    Object object2 = getHook;
                    if (object2 == null || (object2 = object2.getText()) == null) {
                        object2 = "";
                    }
                    if ((object = setHook2) == null || (object = object.getText()) == null) {
                        object = "";
                    }
                    PsiElement hooks = PhpPsiElementFactory.createPropertyHooks(project, (String)object2 + " " + (String)object);
                    PsiElement psiElement = hooksContainer != null ? hooksContainer.replace(hooks) : $field.addAfter(hooks, $field.getLastChild());
                    if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
                        String string = $field.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this$0.replaceGetterUsagesWithFieldRead(string, $getter, $getterUsages);
                        String string2 = $field.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        this$0.replaceSetterUsagesWithFieldWrite(string2, $setter, $setterUsages);
                    }
                    if ((method2 = $getter) != null && (method2 = method2.getDocComment()) != null) {
                        method2.delete();
                    }
                    Method method3 = $getter;
                    if (method3 != null) {
                        method3.delete();
                    }
                    if ((method = $setter) != null && (method = method.getDocComment()) != null) {
                        method.delete();
                    }
                    Method method4 = $setter;
                    if (method4 != null) {
                        method4.delete();
                    }
                } else if (existingGetHook == null) {
                    PhpPropertyHook getHook = this$0.createHookFromMethod($getter, $field, "get");
                    if (getHook != null) {
                        PsiElement psiElement = hooksContainer;
                        Intrinsics.checkNotNull((Object)psiElement);
                        psiElement.addBefore((PsiElement)getHook, (PsiElement)existingSetHook);
                        String string = $field.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this$0.replaceGetterUsagesWithFieldRead(string, $getter, $getterUsages);
                        Method method = $getter;
                        if (method != null && (method = method.getDocComment()) != null) {
                            method.delete();
                        }
                        Method method5 = $getter;
                        if (method5 != null) {
                            method5.delete();
                        }
                    }
                } else if (existingSetHook == null && (setHook = this$0.createHookFromMethod($setter, $field, "set")) != null) {
                    PsiElement psiElement = hooksContainer;
                    Intrinsics.checkNotNull((Object)psiElement);
                    psiElement.addAfter((PsiElement)setHook, (PsiElement)existingGetHook);
                    String string = $field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this$0.replaceSetterUsagesWithFieldWrite(string, $setter, $setterUsages);
                    Method method = $setter;
                    if (method != null && (method = method.getDocComment()) != null) {
                        method.delete();
                    }
                    Method method6 = $setter;
                    if (method6 != null) {
                        method6.delete();
                    }
                }
                Object t = PhpPsiUtil.getNextSiblingByCondition((PsiElement)$field, (Condition<? super PsiElement>)((Condition)PhpReplaceGetterAndSetterWithGetAndSetHookQuickFix::addPropertyHooks$lambda$16$lambda$15));
                if (t == null) break block20;
                t.delete();
            }
        }

        private static final boolean replaceParameterInSetHook$lambda$21(PsiElement e) {
            return PhpPsiUtil.isOfType(e, PhpTokenTypes.chLPAREN);
        }

        private static final boolean replaceParameterInSetHook$lambda$22(PsiElement e) {
            return PhpPsiUtil.isOfType(e, PhpTokenTypes.chRPAREN);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PhpModifier.Access.values().length];
                try {
                    nArray[PhpModifier.Access.PUBLIC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PhpModifier.Access.PROTECTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

