/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFqnInspectionBase
extends PhpInspection {
    public boolean ENABLE_IN_FILE_SCOPE = true;
    public boolean IGNORE_GLOBAL_NAMESPACE = false;

    protected static boolean isGlobalNamespaceFqn(@Nullable String fqn) {
        return fqn != null && PhpLangUtil.isFqn(fqn) && PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(fqn));
    }

    protected LocalQuickFix[] getQuickFixes(@NotNull PhpReferenceBase reference, LocalQuickFix fix) {
        if (reference == null) {
            PhpFqnInspectionBase.$$$reportNull$$$0(0);
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add(fix);
        if (PhpFqnInspectionBase.isGlobalNamespaceFqn(reference.getFQN())) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "IGNORE_GLOBAL_NAMESPACE", PhpBundle.message("quickfix.disable.inspection.for.global.namespace", new Object[0]), true)));
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)reference, false, PhpDocType.class) != null) {
            fixes.add(PhpEnableFqcnInPhpDocQuickFix.INSTANCE);
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    protected abstract Key<? extends PhpFqnInspectionBase> getShortNameKey();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase", "getQuickFixes"));
    }

    private static class PhpEnableFqcnInPhpDocQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        static final LocalQuickFix INSTANCE = new PhpEnableFqcnInPhpDocQuickFix();

        private PhpEnableFqcnInPhpDocQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.force.fqcn.for.references.in.phpdoc", new Object[0]);
            if (string == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(2);
            }
            final PsiFile file = descriptor.getPsiElement().getContainingFile();
            PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(project, file, true);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file.getVirtualFile()}){

                public void undo() {
                    PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(project, file, false);
                }

                public void redo() {
                    PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(project, file, true);
                }

                public boolean isGlobal() {
                    return true;
                }
            });
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(4);
            }
            HtmlChunk label = HtmlChunk.text((String)PhpBundle.message("checkbox.use.fully.qualified.class.names", new Object[0]));
            HtmlChunk.Element checkbox = HtmlChunk.tag((String)"input").attr("type", "checkbox").attr("readonly", "true").attr("checked", "true");
            HtmlChunk.Element info = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.tag((String)"td").child((HtmlChunk)checkbox), HtmlChunk.tag((String)"td").child(label)}));
            return new IntentionPreviewInfo.Html(new HtmlBuilder().append(PhpBundle.message("set.the.following.option", new Object[0])).br().br().append((HtmlChunk)info).toFragment());
        }

        private static void setPhpDocFQCN(@NotNull Project project, @NotNull PsiFile file, boolean value) {
            if (project == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(5);
            }
            if (file == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(6);
            }
            ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN = value;
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableFqcnInPhpDocQuickFix";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableFqcnInPhpDocQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setPhpDocFQCN";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

