/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRedundantAssignmentToPromotedFieldInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PhpFieldCanBePromotedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFieldCanBePromotedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                if (method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                PhpClass clazz = method.getContainingClass();
                if (clazz == null) {
                    return;
                }
                Collection<Field> fields = PhpFieldCanBePromotedInspection.getOwnFields(clazz);
                Map possiblePromotedFieldsParameters = ((StreamEx)StreamEx.of((Object[])method.getParameters()).filter(Predicate.not(Parameter::isPromotedField))).mapToEntry(Function.identity(), p -> PhpFieldCanBePromotedInspection.findMatchingField(fields, p)).nonNullValues().toMap();
                if (possiblePromotedFieldsParameters.isEmpty()) {
                    return;
                }
                HashMap instructionsToCheck = new HashMap();
                PhpRedundantAssignmentToPromotedFieldInspection.processAssignmentsDuplicatingPromotedField(method, possiblePromotedFieldsParameters.keySet(), (instruction, assignment) -> {
                    PsiElement parent = assignment.getParent();
                    if (parent instanceof Statement && parent.getChildren().length == 1) {
                        instructionsToCheck.put(instruction, assignment);
                    }
                });
                for (final PhpAccessFieldByVariableInstruction instructionToCheck : instructionsToCheck.keySet()) {
                    Field field;
                    AssignmentExpression assignment2;
                    Parameter parameter;
                    final Ref alwaysReachable = new Ref((Object)true);
                    PhpControlFlowUtil.processSuccessors((PhpInstruction)method.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

                        public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                            if (instructionToCheck == instruction) {
                                return false;
                            }
                            return super.processAccessFieldByVariableInstruction(instruction);
                        }

                        public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                            alwaysReachable.set((Object)false);
                            return false;
                        }
                    });
                    if (!((Boolean)alwaysReachable.get()).booleanValue() || (parameter = PhpFieldCanBePromotedInspection.getAssignedParameter(assignment2 = (AssignmentExpression)instructionsToCheck.get(instructionToCheck))) == null || (field = (Field)possiblePromotedFieldsParameters.get(parameter)) == null) continue;
                    PhpClassFieldsList list = field.getParentList();
                    PhpConvertToPromotedFieldQuickFix fix = list != null && list.getFields().size() == 1 && field.getDocComment() != null ? new PhpConvertToPromotedFieldAndRemoveDocCommentQuickFix(parameter, assignment2) : new PhpConvertToPromotedFieldQuickFix(parameter, assignment2);
                    holder.registerProblem(assignment2.getParent(), PhpBundle.message("inspection.message.field.assignment.can.be.converted.to.promoted.field", new Object[0]), new LocalQuickFix[]{fix});
                    holder.registerProblem((PsiElement)parameter, PhpBundle.message("inspection.message.field.assignment.can.be.converted.to.promoted.field", new Object[0]), new LocalQuickFix[]{fix});
                    holder.registerProblem((PsiElement)field, PhpBundle.message("inspection.message.field.assignment.can.be.converted.to.promoted.field", new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
    }

    @NotNull
    private static @Unmodifiable Collection<Field> getOwnFields(PhpClass clazz) {
        List list = ContainerUtil.filter((Object[])clazz.getOwnFields(), FieldImpl.class::isInstance);
        if (list == null) {
            PhpFieldCanBePromotedInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static Field findMatchingField(Collection<Field> fields, Parameter p) {
        Field field = (Field)ContainerUtil.find(fields, f -> PhpLangUtil.equalsFieldNames(p.getName(), f.getName()));
        if (field == null || field.getModifier().isStatic() || field instanceof PhpClassImpl.MyRenamableFakePsiElement) {
            return null;
        }
        PhpType parameterDeclaredType = p.getDeclaredType();
        PsiElement parameterDefaultValue = p.getDefaultValue();
        if (PhpLangUtil.isNull(parameterDefaultValue)) {
            parameterDeclaredType = PhpType.from((PhpType[])new PhpType[]{parameterDeclaredType}).add(PhpType.NULL);
        }
        if (!field.getDeclaredType().equals((Object)parameterDeclaredType)) {
            return null;
        }
        PsiElement fieldDefaultValue = field.getDefaultValue();
        if (parameterDefaultValue != null) {
            if (fieldDefaultValue == null || PhpPsiUtil.areElementsEquivalent(parameterDefaultValue, fieldDefaultValue)) {
                return field;
            }
        } else {
            Parameter nextParameter = (Parameter)PhpPsiUtil.getNextSiblingByCondition((PsiElement)p, (Condition<? super PsiElement>)Parameter.INSTANCEOF);
            if (fieldDefaultValue == null || nextParameter == null || nextParameter.isOptional() || nextParameter.isVariadic()) {
                return field;
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Nullable
    private static Parameter getAssignedParameter(AssignmentExpression assignment) {
        Variable value = (Variable)assignment.getValue();
        if (value == null) {
            return null;
        }
        return (Parameter)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((Collection)value.resolveLocal()), Parameter.class);
    }

    @Nullable
    public static PsiElement getVisibilityModifier(PsiElement element) {
        if (element instanceof PhpModifierList) {
            PhpModifierList modifierList = (PhpModifierList)element;
            List<PsiElement> tokens = PhpPsiUtil.getChildrenOfType((PsiElement)modifierList, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
            return (PsiElement)ContainerUtil.find(tokens, it -> !PhpModifierListImpl.isSetOperationModifier(it));
        }
        if (element instanceof Field) {
            Field field = (Field)element;
            PhpClassFieldsList classField = PhpPsiUtil.getParentOfClass((PsiElement)field, PhpClassFieldsList.class);
            if (classField == null) {
                return null;
            }
            PhpModifierList modifierList = classField.getModifierList();
            if (modifierList == null) {
                return null;
            }
            return PhpFieldCanBePromotedInspection.getVisibilityModifier((PsiElement)modifierList);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFieldCanBePromotedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFieldCanBePromotedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class PhpConvertToPromotedFieldAndRemoveDocCommentQuickFix
    extends PhpConvertToPromotedFieldQuickFix {
        private PhpConvertToPromotedFieldAndRemoveDocCommentQuickFix(Parameter parameter, AssignmentExpression assignment) {
            super(parameter, assignment);
        }

        @Override
        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.convert.to.promoted.field.remove.doc.comment", new Object[0]);
            if (string == null) {
                PhpConvertToPromotedFieldAndRemoveDocCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpFieldCanBePromotedInspection$PhpConvertToPromotedFieldAndRemoveDocCommentQuickFix", "getFamilyName"));
        }
    }

    private static class PhpConvertToPromotedFieldQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpConvertToPromotedFieldQuickFix(Parameter parameter, AssignmentExpression assignment) {
            super((PsiElement)parameter, (PsiElement)assignment);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.convert.to.promoted.field", new Object[0]);
            if (string == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement parameterElement, @NotNull PsiElement assignmentElement) {
            if (project == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(3);
            }
            if (parameterElement == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(4);
            }
            if (assignmentElement == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(5);
            }
            AssignmentExpression assignment = (AssignmentExpression)assignmentElement;
            Parameter parameter = (Parameter)parameterElement;
            if (parameter.isPromotedField()) {
                return;
            }
            Method method = PhpPsiUtil.getParentOfClass((PsiElement)assignment, Method.class);
            if (method == null) {
                return;
            }
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            Field field = PhpFieldCanBePromotedInspection.findMatchingField(PhpFieldCanBePromotedInspection.getOwnFields(containingClass), parameter);
            if (field != null) {
                PsiElement fieldDefaultValue = field.getDefaultValue();
                if (fieldDefaultValue != null && parameter.getDefaultValue() == null) {
                    PhpConvertToPromotedFieldQuickFix.insertDefaultValue(parameter, fieldDefaultValue);
                }
                if (PhpLangUtil.isNull(parameter.getDefaultValue())) {
                    parameter.updateType(PhpType.from((PhpType[])new PhpType[]{parameter.getDeclaredType().add(PhpType.NULL)}));
                }
                boolean hasVisibilityModifier = PhpFieldCanBePromotedInspection.getVisibilityModifier((PsiElement)field) != null;
                PhpConvertToPromotedFieldQuickFix.insertVisibilityModifier(parameter, field.getModifier(), field.isReadonly(), hasVisibilityModifier);
                PhpConvertToPromotedFieldQuickFix.insertPropertyHooks(project, parameter, field);
                this.addNotPresentAttributes(project, parameter, field);
                PhpMoveClassMemberBase.removeFieldWithPhpDoc(field);
            } else {
                PhpConvertToPromotedFieldQuickFix.insertVisibilityModifier(parameter, PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC, false, true);
            }
            assignment.getParent().delete();
        }

        private static boolean hasVisibilityModifier(Field field) {
            return PhpFieldCanBePromotedInspection.getVisibilityModifier((PsiElement)field) != null;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void addNotPresentAttributes(@NotNull Project project, Parameter parameter, Field field) {
            if (project == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(6);
            }
            @NotNull Collection parameterAttributes = parameter.getAttributes();
            for (PhpAttribute attribute : field.getAttributes()) {
                if (ContainerUtil.exists((Iterable)parameterAttributes, attr -> PhpPsiUtil.areElementsEquivalent((PsiElement)attribute, (PsiElement)attr))) continue;
                parameter.addBefore((PsiElement)PhpPsiElementFactory.createAttributesList(project, attribute.getText()), parameter.getFirstChild());
            }
        }

        private static void insertPropertyHooks(@NotNull Project project, Parameter parameter, Field field) {
            if (project == null) {
                PhpConvertToPromotedFieldQuickFix.$$$reportNull$$$0(7);
            }
            if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project)) {
                return;
            }
            PsiElement hooksContainer = FieldImpl.getPropertyHooksContainer(field);
            if (hooksContainer == null) {
                return;
            }
            parameter.addAfter(hooksContainer, parameter.getLastChild());
        }

        private static void insertVisibilityModifier(Parameter parameter, PhpModifier modifier, boolean isReadonly, boolean hasVisibilityModifier) {
            PsiElement visibilityModifier;
            Object insertBefore = parameter.getNameIdentifier();
            assert (insertBefore != null);
            Object typeDeclaration = PhpPsiUtil.getPrevSiblingByCondition(insertBefore, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
            if (typeDeclaration != null) {
                insertBefore = typeDeclaration;
            }
            PhpModifierList modifierList = PhpPsiElementFactory.createModifierList(parameter.getProject(), modifier);
            if (isReadonly) {
                PsiElement readonly = PhpPsiElementFactory.createFromText(parameter.getProject(), PhpTokenTypes.IDENTIFIER, "readonly");
                modifierList.add(readonly);
            }
            if (!hasVisibilityModifier && (visibilityModifier = PhpFieldCanBePromotedInspection.getVisibilityModifier((PsiElement)modifierList)) != null) {
                visibilityModifier.delete();
            }
            parameter.addBefore((PsiElement)modifierList, insertBefore);
        }

        private static void insertDefaultValue(Parameter parameter, PsiElement value) {
            PsiElement eq = parameter.add(PhpPsiElementFactory.createFromText(parameter.getProject(), PhpTokenTypes.opASGN, "$a = 2;"));
            parameter.addAfter(value, eq);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFieldCanBePromotedInspection$PhpConvertToPromotedFieldQuickFix";
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignmentElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFieldCanBePromotedInspection$PhpConvertToPromotedFieldQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addNotPresentAttributes";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "insertPropertyHooks";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

