/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFunctionInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.psi.PhpDeprecationProvider;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpElementIsNotAvailableInCurrentPhpVersionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            private final boolean syncWithComposer;
            {
                this.syncWithComposer = ComposerDataService.getInstance(holder.getProject()).syncLanguageLevel();
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.check((PhpReference)reference, () -> PhpUndefinedMethodInspection.findDfaReachability((PhpReference)reference, reference.getClassReference()) == PhpUndefinedMethodInspection.Reachability.DEFINED);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.check((PhpReference)reference, () -> PhpUndefinedFunctionInspection.isDfaReachable((PhpReference)reference));
            }

            public void visitPhpClassReference(ClassReference reference) {
                Supplier<Boolean> dfaReachableSupplier = PhpElementIsNotAvailableInCurrentPhpVersionInspection.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedClassInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                Supplier<Boolean> dfaReachableSupplier = PhpElementIsNotAvailableInCurrentPhpVersionInspection.createDfaReachabilitySupplier(reference);
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                Supplier<Boolean> dfaReachableSupplier = PhpElementIsNotAvailableInCurrentPhpVersionInspection.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedFieldInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.check((PhpReference)reference, () -> PhpUndefinedConstantInspection.isDfaReachable(reference));
            }

            private void check(PhpReference reference, Supplier<@Nullable Boolean> dfaReachableSupplier) {
                Collection<? extends PsiElement> elements = PhpDeprecationInspection.multiResolve(reference);
                if (elements.isEmpty()) {
                    return;
                }
                if (ContainerUtil.all(elements, element -> PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableBySinceTag((PsiElement)reference, element))) {
                    if (dfaReachableSupplier.get() == Boolean.TRUE) {
                        return;
                    }
                    PhpLanguageLevel version = PhpElementIsNotAvailableInCurrentPhpVersionInspection.versions(elements, "@since").max(Comparator.naturalOrder()).orElse(PhpLanguageLevel.DEFAULT);
                    LocalQuickFix fix = PhpLanguageLevelInspection.getSwitchLanguageLevelQuickFix(holder.getProject(), version, this.syncWithComposer, isOnTheFly);
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("php.element.is.available.starting.with.php.version", reference.getName(), version.getPresentableName()), new LocalQuickFix[]{fix});
                    return;
                }
                if (ContainerUtil.all(elements, PhpElementIsNotAvailableInCurrentPhpVersionInspection::notAvailableByRemovedTag)) {
                    if (dfaReachableSupplier.get() == Boolean.TRUE) {
                        return;
                    }
                    PhpLanguageLevel removedVersion = PhpElementIsNotAvailableInCurrentPhpVersionInspection.versions(elements, "@removed").min(Comparator.naturalOrder()).orElse(PhpLanguageLevel.DEFAULT);
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("php.element.was.removed.in.php.version", reference.getName(), removedVersion.getPresentableName()), new LocalQuickFix[0]);
                }
            }
        };
    }

    @NotNull
    public static @NotNull Supplier<@NotNull Boolean> createDfaReachabilitySupplier(ClassConstantReference reference) {
        Supplier<Boolean> supplier = PhpElementIsNotAvailableInCurrentPhpVersionInspection.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> {
            PhpExpression classReference = reference.getClassReference();
            if (classReference instanceof ClassReference) {
                PhpUndefinedClassConstantInspection.performDfaReachability((MemberReference)reference, (PhpReference)classReference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }
        });
        if (supplier == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(1);
        }
        return supplier;
    }

    private static Supplier<@NotNull Boolean> createDfaReachableSupplier(BiConsumer<Ref<Boolean>, Ref<Boolean>> consumer) {
        return () -> {
            Ref canBeUndefined = new Ref((Object)Boolean.FALSE);
            Ref canBeDefined = new Ref((Object)Boolean.FALSE);
            consumer.accept(canBeDefined, canBeUndefined);
            return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
        };
    }

    public static boolean notAvailableByRemovedTag(PsiElement element) {
        if (element instanceof PhpNamedElement) {
            String removedVersion = PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)element, "@removed");
            return PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion((PhpNamedElement)element, removedVersion);
        }
        return false;
    }

    private static boolean notAvailableBySinceTag(@Nullable PsiElement context, PsiElement element) {
        if (element instanceof PhpNamedElement) {
            String version = PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)element, "@since");
            return version != null && !PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion(context, (PhpNamedElement)element, version);
        }
        return true;
    }

    public static boolean notAvailableBySinceTag(PsiElement element) {
        return PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableBySinceTag(null, element);
    }

    private static @NotNull Stream<@Nullable PhpLanguageLevel> versions(Collection<? extends PsiElement> elements, String tag) {
        Stream<PhpLanguageLevel> stream = elements.stream().map(e -> PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)e, tag)).filter(Objects::nonNull).map(versionString -> (PhpLanguageLevel)ObjectUtils.notNull((Object)PhpLanguageLevel.parse((String)versionString), (Object)PhpLanguageLevel.DEFAULT));
        if (stream == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(2);
        }
        return stream;
    }

    public static boolean isAvailableInCurrentPhpVersion(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(3);
        }
        return PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion(null, element, PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion(element, "@since")) && !PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion(element);
    }

    private static boolean isRemovedInCurrentPhpVersion(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(4);
        }
        return PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion(element, PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion(element, "@removed"));
    }

    public static boolean isRemovedInCurrentPhpVersion(@NotNull PhpNamedElement element, String removedVersion) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(5);
        }
        if (removedVersion == null) {
            return false;
        }
        List providers = PhpDeprecationProvider.getProvidersForElement((PhpNamedElement)element);
        return !providers.isEmpty() && providers.stream().allMatch(provider -> provider.isDeprecated(element, removedVersion));
    }

    private static boolean isAvailableInCurrentPhpVersion(@Nullable PsiElement context, @NotNull PhpNamedElement element, @Nullable String version) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(6);
        }
        if (version == null) {
            return true;
        }
        return !ContainerUtil.exists((Iterable)PhpDeprecationProvider.getProvidersForElement((PhpNamedElement)element), provider -> provider.isNotAvailable(context, element, version));
    }

    private static String getVersion(PhpNamedElement element, String tagName) {
        PhpDocTag sinceTag;
        if (element instanceof PhpClassAlias) {
            return null;
        }
        PhpDocComment comment = element.getDocComment();
        PhpDocTag phpDocTag = sinceTag = comment != null ? (PhpDocTag)ArrayUtil.getFirstElement((Object[])comment.getTagElementsByName(tagName)) : null;
        if (sinceTag == null) {
            return null;
        }
        return PhpNamedElementImpl.getVersionString(sinceTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpElementIsNotAvailableInCurrentPhpVersionInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpElementIsNotAvailableInCurrentPhpVersionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDfaReachabilitySupplier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "versions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableInCurrentPhpVersion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRemovedInCurrentPhpVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

