/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpDeprecationQuickFixesProvider;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDeprecationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkFunctionCall((FunctionReference)reference, PhpBundle.message("method.ref.is.deprecated", new Object[0]));
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkFunctionCall(reference, PhpBundle.message("function.ref.is.deprecated", new Object[0]));
            }

            public void visitPhpCallableFunction(PhpCallableFunction reference) {
                PhpDeprecationInspection.checkResolvedElements((PsiElement)reference, PhpBundle.message("function.ref.is.deprecated", new Object[0]), holder, PhpDeprecationInspection.multiResolve((PhpReference)reference));
            }

            public void visitPhpCallableMethod(PhpCallableMethod reference) {
                PhpDeprecationInspection.checkResolvedElements((PsiElement)reference, PhpBundle.message("method.ref.is.deprecated", new Object[0]), holder, PhpDeprecationInspection.multiResolve((PhpReference)reference));
            }

            public void checkFunctionCall(@NotNull FunctionReference reference, @Nls String message) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection<? extends PsiElement> elements = PhpDeprecationInspection.multiResolve((PhpReference)reference);
                PhpDeprecationInspection.checkResolvedElements((PsiElement)reference, message, holder, elements);
                this.checkDeprecatedParameters(reference, elements);
            }

            public void checkDeprecatedParameters(@NotNull FunctionReference reference, Collection<? extends PsiElement> elements) {
                List<PsiElement> arguments;
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((arguments = Arrays.asList(reference.getParameters())).isEmpty()) {
                    return;
                }
                Function function = (Function)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(elements), Function.class);
                if (function == null) {
                    return;
                }
                List<Parameter> parameters = Arrays.asList(function.getParameters());
                if (!ContainerUtil.exists(parameters, PhpDeprecationInspection::isDeprecatedDeclaration)) {
                    return;
                }
                for (int i = 0; i < arguments.size(); ++i) {
                    Parameter parameter = PhpDeprecationInspection.resolveParameter(arguments, parameters, i);
                    if (parameter == null) continue;
                    PhpDeprecationInspection.checkResolvedElements(arguments.get(i), PhpBundle.message("parameter.is.deprecated", parameter.getName()), holder, Collections.singleton(parameter));
                }
            }

            public void visitPhpClassReference(ClassReference reference) {
                PhpDeprecationInspection.check((PhpReference)reference, PhpBundle.message("class.ref.is.deprecated", new Object[0]), holder);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                PhpDeprecationInspection.check((PhpReference)reference, PhpBundle.message("constant.ref.is.deprecated", new Object[0]), holder);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                PhpDeprecationInspection.check((PhpReference)reference, PhpBundle.message("field.ref.is.deprecated", new Object[0]), holder);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                PhpDeprecationInspection.check((PhpReference)reference, PhpBundle.message("constant.ref.is.deprecated1", new Object[0]), holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "reference";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkFunctionCall";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkDeprecatedParameters";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static int resolveParameterIndex(List<PsiElement> arguments, List<Parameter> parameters, int i) {
        return PhpWorkaroundUtil.resolveMappedParameterIndex(PhpAnnotatorVisitor.getNameOfMappedParam(arguments, parameters, i), parameters);
    }

    @Nullable
    public static Parameter resolveParameter(List<PsiElement> arguments, List<Parameter> parameters, int i) {
        if (parameters.isEmpty()) {
            return null;
        }
        int index = PhpDeprecationInspection.resolveParameterIndex(arguments, parameters, i);
        return index >= 0 && index < parameters.size() ? parameters.get(index) : null;
    }

    private static void check(PhpReference reference, @Nls String desc, ProblemsHolder holder) {
        PhpDeprecationInspection.checkResolvedElements((PsiElement)reference, desc, holder, PhpDeprecationInspection.multiResolve(reference));
    }

    private static void checkResolvedElements(PsiElement reference, @Nls String desc, ProblemsHolder holder, Collection<? extends PsiElement> resolvedElements) {
        if (resolvedElements.isEmpty()) {
            return;
        }
        if (ContainerUtil.all(resolvedElements, PhpDeprecationInspection::isDeprecatedDeclaration)) {
            Optional reasonFromInfo = StreamEx.of(resolvedElements).select(PhpDeprecationAttributeOwner.class).map(PhpDeprecationAttributeOwner::getDeprecationInfo).nonNull().map(PhpDeprecationAttributeOwner.PhpDeprecationInfo::getReason).nonNull().findFirst();
            List fixes = resolvedElements.stream().flatMap(e -> PhpDeprecationInspection.getFixes(reference, (PhpNamedElement)e).stream()).toList();
            if (reference instanceof PhpReference) {
                holder.registerProblem(((PhpReference)reference).getElement(), reasonFromInfo.orElse(desc), ProblemHighlightType.LIKE_DEPRECATED, ((PhpReference)reference).getRangeInElement(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            } else {
                holder.registerProblem(reference, reasonFromInfo.orElse(desc), ProblemHighlightType.LIKE_DEPRECATED, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static boolean isDeprecatedDeclaration(PsiElement element) {
        return element instanceof PhpNamedElement && ((PhpNamedElement)element).isDeprecated() && PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion((PhpNamedElement)element);
    }

    @NotNull
    public static Collection<? extends PsiElement> multiResolve(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(1);
        }
        if (reference instanceof ClassReference && reference.getParent() instanceof NewExpression) {
            Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal(reference, reference.getName(), reference.getNamespaceName(), true);
            if (collection == null) {
                PhpDeprecationInspection.$$$reportNull$$$0(2);
            }
            return collection;
        }
        List list = ContainerUtil.map((Object[])reference.multiResolve(false), ResolveResult::getElement);
        if (list == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static Collection<LocalQuickFix> getFixes(@NotNull PsiElement deprecatedReference, @NotNull PhpNamedElement deprecatedElement) {
        if (deprecatedReference == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(4);
        }
        if (deprecatedElement == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(5);
        }
        Collection collection = PhpDeprecationQuickFixesProvider.EP_NAME.getExtensionList().stream().flatMap(extension -> extension.createFixes(deprecatedReference, deprecatedElement).stream()).collect(Collectors.toList());
        if (collection == null) {
            PhpDeprecationInspection.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

