/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpDeprecatedTriggerErrorInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "analyzeErrorLevelArg", "element", "Lcom/intellij/psi/PsiElement;", "isUserError", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpDeprecatedTriggerErrorInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpDeprecatedTriggerErrorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Object object = reference;
                if (object == null || (object = object.getName()) == null) {
                    return;
                }
                Object name = object;
                if (!Intrinsics.areEqual((Object)name, (Object)"trigger_error")) {
                    return;
                }
                Collection collection = reference.multiResolveStrict(Function.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"multiResolveStrict(...)");
                Function function = (Function)CollectionsKt.firstOrNull((Iterable)collection);
                if (function == null) {
                    return;
                }
                Function function2 = function;
                if (!Intrinsics.areEqual((Object)function2.getFQN(), (Object)"\\trigger_error")) {
                    return;
                }
                PsiElement psiElement = reference.getParameter("error_level", 1);
                if (psiElement == null) {
                    return;
                }
                PsiElement param = psiElement;
                if (PhpDeprecatedTriggerErrorInspection.access$analyzeErrorLevelArg(this.this$0, param)) {
                    this.$holder.registerProblem(param, PhpBundle.message("inspection.php.arg.trigger.error.is.deprecated", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private final boolean analyzeErrorLevelArg(PsiElement element) {
        if (!(element instanceof Variable)) {
            return this.isUserError(element);
        }
        Ref isUserError = new Ref((Object)false);
        PhpAccessVariableInstruction phpAccessVariableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)element, PhpAccessVariableInstruction.class);
        if (phpAccessVariableInstruction == null) {
            return false;
        }
        PhpAccessVariableInstruction instruction = phpAccessVariableInstruction;
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(this, (Ref<Boolean>)isUserError){
            final /* synthetic */ PhpDeprecatedTriggerErrorInspection this$0;
            final /* synthetic */ Ref<Boolean> $isUserError;
            {
                this.this$0 = $receiver;
                this.$isUserError = $isUserError;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (!instruction.getAccess().isWrite()) {
                    return true;
                }
                AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                if (assignmentExpression == null) {
                    return true;
                }
                AssignmentExpression assignment = assignmentExpression;
                if (PhpDeprecatedTriggerErrorInspection.access$isUserError(this.this$0, (PsiElement)assignment.getValue())) {
                    this.$isUserError.set((Object)true);
                }
                return false;
            }
        });
        Object object = isUserError.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final boolean isUserError(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (PhpType.isPrimitiveType((String)element.getText())) {
            return false;
        }
        if (element instanceof Constant) {
            if (Intrinsics.areEqual((Object)((Constant)element).getFQN(), (Object)"\\E_USER_ERROR")) {
                return true;
            }
            return this.isUserError(((Constant)element).getValue());
        }
        if (element instanceof ConstantReference) {
            PsiElement psiElement = ((ConstantReference)element).resolve();
            if (psiElement == null) {
                return false;
            }
            PsiElement resolved = psiElement;
            return this.isUserError(resolved);
        }
        if (element instanceof ClassConstantReference) {
            PsiElement psiElement = ((ClassConstantReference)element).resolve();
            if (psiElement == null) {
                return false;
            }
            PsiElement resolved = psiElement;
            return this.isUserError(resolved);
        }
        if (element instanceof Field && ((Field)element).isConstant()) {
            return this.isUserError(((Field)element).getDefaultValue());
        }
        if (element instanceof PhpExpression) {
            return Intrinsics.areEqual((Object)((PhpExpression)element).getText(), (Object)"256");
        }
        return false;
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    public static final /* synthetic */ boolean access$analyzeErrorLevelArg(PhpDeprecatedTriggerErrorInspection $this, PsiElement element) {
        return $this.analyzeErrorLevelArg(element);
    }

    public static final /* synthetic */ boolean access$isUserError(PhpDeprecatedTriggerErrorInspection $this, PsiElement element) {
        return $this.isUserError(element);
    }
}

