/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClosureCanBeConvertedToShortArrowFunctionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClosureCanBeConvertedToShortArrowFunctionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpField(Field field) {
                field.getPropertyHooksList().forEach(propertyHook -> {
                    if (propertyHook.isShort()) {
                        return;
                    }
                    GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)propertyHook, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                    if (body == null) {
                        return;
                    }
                    PsiElement onlyStatement = body.getOnlyStatement();
                    if (onlyStatement == null) {
                        return;
                    }
                    if (propertyHook.getHookType() == PhpPropertyHook.PhpPropertyHookType.GET && !(onlyStatement instanceof PhpReturn)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)propertyHook, PhpBundle.message("inspection.property.hook.can.be.can.be.shortened", new Object[0]), new LocalQuickFix[]{PhpShortenPropertyHookQuickFix.INSTANCE});
                });
            }

            public void visitPhpFunction(Function closure) {
                if (!PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(closure.getProject())) {
                    return;
                }
                if (!closure.isClosure() || FunctionImpl.isShortArrowFunction(closure)) {
                    return;
                }
                GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                if (body == null) {
                    return;
                }
                if (!(body.getOnlyStatement() instanceof PhpReturn)) {
                    return;
                }
                if (PhpClosureCanBeConvertedToShortArrowFunctionInspection.useByReferenceExists(closure)) {
                    return;
                }
                holder.registerProblem((PsiElement)closure, PhpBundle.message("inspection.closure.can.be.converted.to.arrow.function", new Object[0]), new LocalQuickFix[]{PhpConvertClosureToArrowFunctionQuickFix.INSTANCE});
            }
        };
    }

    private static boolean useByReferenceExists(Function closure) {
        PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
        if (useList == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])useList.getChildren(), r -> PhpPsiUtil.isOfType(r.getPrevSibling(), PhpTokenTypes.opBIT_AND));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection", "buildVisitor"));
    }

    private static class PhpConvertClosureToArrowFunctionQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpConvertClosureToArrowFunctionQuickFix INSTANCE = new PhpConvertClosureToArrowFunctionQuickFix();

        private PhpConvertClosureToArrowFunctionQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("convert.closure.to.arrow.function", new Object[0]);
            if (string == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)ObjectUtils.tryCast((Object)element, Function.class)) == null) {
                return;
            }
            GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (body == null) {
                return;
            }
            PsiElement returnArgument = PhpConvertClosureToArrowFunctionQuickFix.copyReturnArgumentWithoutSemicolon(body);
            if (returnArgument == null) {
                return;
            }
            PhpConvertClosureToArrowFunctionQuickFix.doReplace(project, function, body, returnArgument);
        }

        private static void doReplace(@NotNull Project project, Function function, GroupStatement body, PsiElement returnArgument) {
            ASTNode functionKeyword;
            if (project == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(4);
            }
            if ((functionKeyword = function.getNode().findChildByType(PhpTokenTypes.kwFUNCTION)) == null) {
                return;
            }
            PhpConvertClosureToArrowFunctionQuickFix.restoreComments(function, body);
            functionKeyword.getPsi().replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwFN, "fn()"));
            PsiElement arrow = body.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opHASH_ARRAY, "fn() => 1"));
            arrow.getParent().addAfter(returnArgument, arrow);
            Object useList = PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                useList.delete();
            }
        }

        @Nullable
        protected static PsiElement copyReturnArgumentWithoutSemicolon(@NotNull GroupStatement body) {
            PhpReturn onlyReturn;
            if (body == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(5);
            }
            if ((onlyReturn = (PhpReturn)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])body.getStatements()), PhpReturn.class)) == null) {
                return null;
            }
            PsiElement returnArgument = onlyReturn.getArgument();
            return returnArgument != null ? returnArgument.copy() : null;
        }

        private static void restoreComments(Function function, GroupStatement body) {
            PsiElement parent = function.getParent();
            SyntaxTraverser.psiTraverser((PsiElement)body).filter(PsiComment.class).forEach(comment -> parent.addBefore(comment.copy(), (PsiElement)function));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpConvertClosureToArrowFunctionQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpConvertClosureToArrowFunctionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doReplace";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "copyReturnArgumentWithoutSemicolon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpShortenPropertyHookQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpShortenPropertyHookQuickFix INSTANCE = new PhpShortenPropertyHookQuickFix();

        private PhpShortenPropertyHookQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("shorten.property.hook", new Object[0]);
            if (string == null) {
                PhpShortenPropertyHookQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpPropertyHook propertyHook;
            if (project == null) {
                PhpShortenPropertyHookQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpShortenPropertyHookQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpShortenPropertyHookQuickFix.$$$reportNull$$$0(3);
            }
            if ((propertyHook = (PhpPropertyHook)ObjectUtils.tryCast((Object)element, PhpPropertyHook.class)) == null) {
                return;
            }
            GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)propertyHook, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (body == null) {
                return;
            }
            PsiElement onlyStatementArgument = PhpShortenPropertyHookQuickFix.getOnlyStatementArgument(body, propertyHook.getHookType());
            if (onlyStatementArgument == null) {
                return;
            }
            PsiElement newElement = body.replace(onlyStatementArgument);
            PsiElement arrow = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opHASH_ARRAY, "=>");
            propertyHook.addBefore(arrow, newElement);
            PsiElement semicolon = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opSEMICOLON, ";");
            propertyHook.addAfter(semicolon, newElement);
        }

        @Nullable
        private static PsiElement getOnlyStatementArgument(@NotNull GroupStatement body, PhpPropertyHook.PhpPropertyHookType hookType) {
            if (body == null) {
                PhpShortenPropertyHookQuickFix.$$$reportNull$$$0(4);
            }
            if (hookType == PhpPropertyHook.PhpPropertyHookType.GET) {
                return PhpConvertClosureToArrowFunctionQuickFix.copyReturnArgumentWithoutSemicolon(body);
            }
            if (hookType == PhpPropertyHook.PhpPropertyHookType.SET) {
                PsiElement onlyStatement = body.getOnlyStatement();
                if (onlyStatement == null) {
                    return null;
                }
                return PhpPsiUtil.getChildByCondition(onlyStatement, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpShortenPropertyHookQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpShortenPropertyHookQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOnlyStatementArgument";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

