/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpClassImplementsSolelyTraversableInspection
extends PhpInspection {
    private static final String ITERATOR_AGGREGATE = "\\IteratorAggregate";
    private static final String ITERATOR = "\\Iterator";
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpReplaceWithInterfaceQuickFix("\\Iterator"), new PhpReplaceWithInterfaceQuickFix("\\IteratorAggregate")};
    private static final String TRAVERSABLE = "\\Traversable";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassImplementsSolelyTraversableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isInterface()) {
                    return;
                }
                List elements = clazz.getImplementsList().getReferenceElements();
                ClassReference traversable = PhpClassImplementsSolelyTraversableInspection.findByFqn(elements, PhpClassImplementsSolelyTraversableInspection.TRAVERSABLE);
                if (traversable == null) {
                    return;
                }
                if ((PhpClassImplementsSolelyTraversableInspection.findByFqn(elements, PhpClassImplementsSolelyTraversableInspection.ITERATOR) != null || PhpClassImplementsSolelyTraversableInspection.findByFqn(elements, PhpClassImplementsSolelyTraversableInspection.ITERATOR_AGGREGATE) != null) && PhpProjectConfigurationFacade.getInstance(clazz.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP740)) {
                    return;
                }
                holder.registerProblem((PsiElement)traversable, PhpBundle.message("class.implements.solely.traversable", clazz.getName()), FIXES);
            }
        };
    }

    private static ClassReference findByFqn(List<ClassReference> elements, String fqn) {
        return (ClassReference)ContainerUtil.find(elements, a -> PhpLangUtil.equalsClassNames(a.getFQN(), fqn));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpClassImplementsSolelyTraversableInspection", "buildVisitor"));
    }

    private static final class PhpReplaceWithInterfaceQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myInterfaceFqn;

        private PhpReplaceWithInterfaceQuickFix(String interfaceFqn) {
            this.myInterfaceFqn = interfaceFqn;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with.interface.quick.fix.family.name", PhpLangUtil.toShortName(this.myInterfaceFqn));
            if (string == null) {
                PhpReplaceWithInterfaceQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpPsiElement scope;
            if (project == null) {
                PhpReplaceWithInterfaceQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithInterfaceQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithInterfaceQuickFix.$$$reportNull$$$0(3);
            }
            String name = (scope = PhpCodeInsightUtil.findScopeForUseOperator(element)) != null ? PhpCodeInsightUtil.createQualifiedName(scope, this.myInterfaceFqn) : this.myInterfaceFqn;
            element.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, name));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpClassImplementsSolelyTraversableInspection$PhpReplaceWithInterfaceQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpClassImplementsSolelyTraversableInspection$PhpReplaceWithInterfaceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

