/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpVariableDocDeclarationInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableDocDeclaredTypeAnalyzerProcessor;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpConcatenationWithEmptyStringCanBeInlinedInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpDangerousArrayInitializationInspection;
import com.jetbrains.php.lang.inspections.type.PhpCastIsUnnecessaryInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpApplyingEmptyIndexOperatorOnStringInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                if (expression.getParent() instanceof ArrayAccessExpression) {
                    return;
                }
                if (expression.getIndex() != null && expression.getIndex().getValue() != null) {
                    return;
                }
                if (!expression.isWriteAccess()) {
                    return;
                }
                if (!PhpApplyingEmptyIndexOperatorOnStringInspection.isRealValueTypeEqualsString(expression)) {
                    return;
                }
                ArrayList<PsiUpdateModCommandQuickFix> quickFixes = new ArrayList<PsiUpdateModCommandQuickFix>();
                if (RemoveEmptyIndexOperatorQuickFix.isAvailable(expression)) {
                    quickFixes.add(RemoveEmptyIndexOperatorQuickFix.INSTANCE);
                }
                if (PhpApplyingEmptyIndexOperatorOnStringInspection.isPossibleToReplaceWithConcatenation(expression)) {
                    quickFixes.add(ReplaceWithConcatenationQuickFix.INSTANCE);
                }
                holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.php.empty.index.operator.not.supported.for.strings", new Object[0]), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        };
    }

    public static boolean isRealValueTypeEqualsString(@NotNull ArrayAccessExpression expression) {
        PhpTypedElement typedValue;
        if (expression == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(1);
        }
        if ((typedValue = PhpApplyingEmptyIndexOperatorOnStringInspection.getTypedValue(expression)) == null) {
            return false;
        }
        if (!PhpType.intersectsGlobal((Project)expression.getProject(), (PhpType)PhpType.STRING, (PhpType)typedValue.getType())) {
            return false;
        }
        PhpType realType = PhpApplyingEmptyIndexOperatorOnStringInspection.getRealType(typedValue);
        if (!realType.filterUnknown().isEmpty() && !realType.filterUnknown().equals((Object)PhpType.STRING)) {
            return false;
        }
        PhpType type = realType.global(expression.getProject());
        return PhpType.STRING.equals((Object)type);
    }

    private static boolean isPossibleToReplaceWithConcatenation(@NotNull ArrayAccessExpression expression) {
        AssignmentExpression assignmentExpression;
        if (expression == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(2);
        }
        if ((assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)expression, AssignmentExpression.class)) == null) {
            return false;
        }
        SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)ObjectUtils.tryCast((Object)assignmentExpression, SelfAssignmentExpression.class);
        return selfAssignmentExpression == null || !PhpPsiUtil.isOfType(selfAssignmentExpression.getOperation(), PhpTokenTypes.opCONCAT_ASGN);
    }

    @Nullable
    static PhpTypedElement getTypedValue(@NotNull ArrayAccessExpression arrayAccessExpression) {
        PhpPsiElement value;
        if (arrayAccessExpression == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(3);
        }
        if ((value = arrayAccessExpression.getValue()) instanceof ArrayAccessExpression) {
            return PhpApplyingEmptyIndexOperatorOnStringInspection.getTypedValue((ArrayAccessExpression)value);
        }
        return (PhpTypedElement)ObjectUtils.tryCast((Object)value, PhpTypedElement.class);
    }

    @NotNull
    private static PhpType getRealType(@NotNull PhpTypedElement element) {
        if (element == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(4);
        }
        if (PhpCastIsUnnecessaryInspection.parameterWithoutRealType((PsiElement)element)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        if (element instanceof FieldReference) {
            PhpType phpType = PhpApplyingEmptyIndexOperatorOnStringInspection.getFieldDeclaredType((FieldReference)element);
            if (phpType == null) {
                PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        PhpType phpType = PhpTypeInfo.getTypeFromAST((PsiElement)element, new PhpTypeAnalyserVisitor(){

            @Override
            protected boolean extractTypeFromArrayAccessExpression(ArrayAccessExpression arrayAccessExpression) {
                return true;
            }

            @Override
            public void visitPhpVariable(Variable variable) {
                this.addInferredType(variable, new PhpVariableDocDeclaredTypeAnalyzerProcessor(variable){

                    @Override
                    public boolean processVariableDocDeclarationInstruction(PhpVariableDocDeclarationInstruction instruction) {
                        return true;
                    }
                });
            }
        });
        if (phpType == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    private static PhpType getFieldDeclaredType(@NotNull FieldReference fieldReference) {
        Field field;
        if (fieldReference == null) {
            PhpApplyingEmptyIndexOperatorOnStringInspection.$$$reportNull$$$0(8);
        }
        return (field = (Field)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class)) == null ? PhpType.EMPTY : field.getDeclaredType().global(fieldReference.getProject());
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP710;
    }

    public static boolean isEmptyStringExpression(@Nullable PsiElement element) {
        PhpPsiElement phpElement = (PhpPsiElement)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(element), PhpPsiElement.class);
        if (phpElement == null) {
            return false;
        }
        if (PhpConcatenationWithEmptyStringCanBeInlinedInspection.isEmptyStringLiteral((PsiElement)phpElement)) {
            return true;
        }
        ConcatenationExpression concatenation = (ConcatenationExpression)ObjectUtils.tryCast((Object)phpElement, ConcatenationExpression.class);
        if (concatenation != null) {
            return PhpApplyingEmptyIndexOperatorOnStringInspection.isEmptyStringExpression(concatenation.getLeftOperand()) && PhpApplyingEmptyIndexOperatorOnStringInspection.isEmptyStringExpression(concatenation.getRightOperand());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isRealValueTypeEqualsString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleToReplaceWithConcatenation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypedValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRealType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDeclaredType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class RemoveEmptyIndexOperatorQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final RemoveEmptyIndexOperatorQuickFix INSTANCE = new RemoveEmptyIndexOperatorQuickFix();

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.empty.index.operator", new Object[0]);
            if (string == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            ArrayAccessExpression arrayAccessExpression;
            if (project == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(3);
            }
            if ((arrayAccessExpression = (ArrayAccessExpression)ObjectUtils.tryCast((Object)element, ArrayAccessExpression.class)) == null) {
                return;
            }
            PhpTypedElement value = PhpApplyingEmptyIndexOperatorOnStringInspection.getTypedValue(arrayAccessExpression);
            if (value != null) {
                arrayAccessExpression.replace(value.copy());
            }
        }

        static boolean isAvailable(@NotNull ArrayAccessExpression expression) {
            if (expression == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(4);
            }
            if (!(expression.getParent() instanceof AssignmentExpression)) {
                return true;
            }
            Variable variable = (Variable)ObjectUtils.tryCast((Object)PhpApplyingEmptyIndexOperatorOnStringInspection.getTypedValue(expression), Variable.class);
            if (variable == null) {
                return false;
            }
            if (PhpDangerousArrayInitializationInspection.isRepeatable((PhpPsiElement)expression, PhpArrayAccessInstruction.class)) {
                return false;
            }
            return RemoveEmptyIndexOperatorQuickFix.hasEmptyStringValue(variable);
        }

        private static boolean hasEmptyStringValue(@NotNull Variable variable) {
            PhpAccessVariableInstruction originalInstruction;
            if (variable == null) {
                RemoveEmptyIndexOperatorQuickFix.$$$reportNull$$$0(5);
            }
            if ((originalInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) == null) {
                return false;
            }
            final Ref canBeEmpty = new Ref((Object)false);
            final Ref canBeNonEmpty = new Ref((Object)false);
            PhpControlFlowUtil.processPreviousVariableAccesses(originalInstruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (!instruction.getAccess().isWrite()) {
                        return true;
                    }
                    Variable v = (Variable)instruction.getAnchor();
                    AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)v, AssignmentExpression.class);
                    if (assignment == null || assignment.getVariable() != v) {
                        return true;
                    }
                    if (PhpApplyingEmptyIndexOperatorOnStringInspection.isEmptyStringExpression((PsiElement)assignment.getValue())) {
                        if (assignment instanceof SelfAssignmentExpression) {
                            return true;
                        }
                        canBeEmpty.set((Object)true);
                    } else {
                        canBeNonEmpty.set((Object)true);
                    }
                    return false;
                }
            });
            if (((Boolean)canBeNonEmpty.get()).booleanValue()) {
                return false;
            }
            if (((Boolean)canBeEmpty.get()).booleanValue()) {
                return true;
            }
            return !PhpDangerousArrayInitializationInspection.isParameter(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection$RemoveEmptyIndexOperatorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection$RemoveEmptyIndexOperatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasEmptyStringValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ReplaceWithConcatenationQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final ReplaceWithConcatenationQuickFix INSTANCE = new ReplaceWithConcatenationQuickFix();

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.concatenation", new Object[0]);
            if (string == null) {
                ReplaceWithConcatenationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            ArrayAccessExpression arrayAccessExpression;
            if (project == null) {
                ReplaceWithConcatenationQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithConcatenationQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithConcatenationQuickFix.$$$reportNull$$$0(3);
            }
            if ((arrayAccessExpression = (ArrayAccessExpression)ObjectUtils.tryCast((Object)element, ArrayAccessExpression.class)) == null) {
                return;
            }
            AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)arrayAccessExpression, AssignmentExpression.class);
            if (assignmentExpression == null || assignmentExpression.getValue() == null) {
                return;
            }
            SelfAssignmentExpression newExpression = PhpPsiElementFactory.createFirstFromText(project, SelfAssignmentExpression.class, String.format("$a .= %s", assignmentExpression.getValue().getText()));
            assert (newExpression != null && newExpression.getVariable() != null);
            PhpTypedElement value = PhpApplyingEmptyIndexOperatorOnStringInspection.getTypedValue(arrayAccessExpression);
            if (value == null) {
                return;
            }
            newExpression.getVariable().replace((PsiElement)value);
            assignmentExpression.replace((PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection$ReplaceWithConcatenationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpApplyingEmptyIndexOperatorOnStringInspection$ReplaceWithConcatenationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

