/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.findUsages.PhpFindMethodUsagesDialog;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesConfiguration;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesHandlerFactory;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesOptions;
import com.jetbrains.php.lang.psi.elements.Method;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFindUsagesHandler
extends FindUsagesHandler {
    private final PsiElement[] myElementsToSearch;
    private final PhpFindUsagesHandlerFactory myFactory;
    private final PsiElement[] mySecondaryElements;

    public PhpFindUsagesHandler(PsiElement element, PhpFindUsagesHandlerFactory factory) {
        this(element, PsiElement.EMPTY_ARRAY, factory);
    }

    public PhpFindUsagesHandler(PsiElement element, PsiElement @NotNull [] elementsToSearch, PsiElement @NotNull [] secondaryElements, PhpFindUsagesHandlerFactory factory) {
        if (elementsToSearch == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(0);
        }
        if (secondaryElements == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(1);
        }
        super(element);
        this.myElementsToSearch = elementsToSearch;
        this.mySecondaryElements = secondaryElements;
        this.myFactory = factory;
    }

    public PhpFindUsagesHandler(PsiElement element, PsiElement @NotNull [] elementsToSearch, PhpFindUsagesHandlerFactory factory) {
        if (elementsToSearch == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(2);
        }
        this(element, elementsToSearch, PsiElement.EMPTY_ARRAY, factory);
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions configOptions = PhpFindUsagesConfiguration.getInstance(this.getProject()).getFindUsagesOptions(dataContext);
        PsiElement element = this.getPsiElement();
        if (element instanceof Method) {
            PhpFindUsagesOptions methodOptions = this.myFactory.getFindMethodOptions();
            methodOptions.isSearchForTextOccurrences = configOptions.isSearchForTextOccurrences;
            PhpFindUsagesOptions phpFindUsagesOptions = methodOptions;
            if (phpFindUsagesOptions == null) {
                PhpFindUsagesHandler.$$$reportNull$$$0(3);
            }
            return phpFindUsagesOptions;
        }
        FindUsagesOptions findUsagesOptions = configOptions;
        if (findUsagesOptions == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(4);
        }
        return findUsagesOptions;
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiElement element = this.getPsiElement();
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        if (psiElementArray == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean processElementUsages(@NotNull PsiElement element, final @NotNull Processor<? super UsageInfo> processor2, @NotNull FindUsagesOptions options) {
        if (element == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(8);
        }
        if (options == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(9);
        }
        if (element instanceof Method) {
            ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference ref) {
                    TextRange rangeInElement = ref.getRangeInElement();
                    return processor2.process((Object)new UsageInfo(ref.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false));
                }
            };
            ReadActionProcessor<PsiElement> elementProcessor = new ReadActionProcessor<PsiElement>(){

                public boolean processInReadAction(PsiElement element) {
                    return processor2.process((Object)new UsageInfo(element, false));
                }
            };
            boolean isIncludeChildMethods = options instanceof PhpFindUsagesOptions && ((PhpFindUsagesOptions)options).isIncludeChildMethods;
            for (Method it : PhpFindUsagesHandler.checkImplementedMethods(element)) {
                ReferencesSearch.search((PsiElement)it, (SearchScope)options.searchScope, (boolean)false).forEach((Processor)refProcessor);
                if (!isIncludeChildMethods || it.equals(element)) continue;
                elementProcessor.process((Object)it);
            }
        }
        return super.processElementUsages(element, processor2, options);
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof Method) {
            return new PhpFindMethodUsagesDialog(element, this.getProject(), this.getFindUsagesOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        AbstractFindUsagesDialog abstractFindUsagesDialog = super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
        if (abstractFindUsagesDialog == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(10);
        }
        return abstractFindUsagesDialog;
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        if (this.mySecondaryElements == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(11);
        }
        return this.mySecondaryElements;
    }

    @NotNull
    private static Set<Method> checkImplementedMethods(@NotNull PsiElement element) {
        if (element == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(12);
        }
        Method method = (Method)element;
        HashSet<Method> implementedMethods = new HashSet<Method>();
        Project project = (Project)ReadAction.compute(() -> ((Method)method).getProject());
        DumbService dumbService = DumbService.getInstance((Project)project);
        dumbService.runReadActionInSmartMode(() -> PhpClassHierarchyUtils.processOverridingMethods((Method)method, (method1, subClass, baseClass) -> {
            implementedMethods.add((Method)method1);
            return true;
        }));
        implementedMethods.add(method);
        HashSet<Method> hashSet = implementedMethods;
        if (hashSet == null) {
            PhpFindUsagesHandler.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 10, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSearch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesDialog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImplementedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementedMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 10, 11, 13 -> new IllegalStateException(string);
        };
    }
}

