/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpConstructorReferenceSearcher;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

final class PhpAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    PhpAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement refElement;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(1);
        }
        if ((refElement = parameters.getElementToSearch()) instanceof PhpUse) {
            PhpUse use = (PhpUse)refElement;
            PhpAliasReferenceSearcher.searchUseAlias(parameters, use, (PsiElement)use, use.isOfConst());
        } else if (!(parameters instanceof PhpRenameSearchParameters) && (refElement instanceof PhpClass || refElement instanceof Function || refElement instanceof Constant || refElement instanceof PhpNamespace)) {
            PhpNamedElement namedElement = (PhpNamedElement)refElement;
            if (namedElement instanceof Method) {
                Method method = (Method)namedElement;
                PhpClass phpClass = method.getContainingClass();
                if (phpClass != null) {
                    if (PhpAliasReferenceSearcher.isConstructor(method)) {
                        for (PhpUse use : PhpAliasReferenceSearcher.findUses(parameters, phpClass.getName())) {
                            if (!PhpLangUtil.equalsIgnoreCase(phpClass.getFQN(), use.getFQN())) continue;
                            PhpAliasReferenceSearcher.searchUseAlias(parameters, use, (PsiElement)method, false);
                        }
                        return;
                    }
                } else {
                    return;
                }
            }
            String name = namedElement.getName();
            String fqn = namedElement.getFQN();
            Collection<PhpUse> uses = PhpAliasReferenceSearcher.findUses(parameters, name);
            for (PhpUse use : uses) {
                if (!PhpLangUtil.equalsIgnoreCase(fqn, use.getFQN())) continue;
                PhpAliasReferenceSearcher.searchUseAlias(parameters, use, (PsiElement)use, namedElement instanceof Constant);
            }
        }
    }

    @NotNull
    private static Collection<PhpUse> findUses(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull String name) {
        SearchScope scope;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (name == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(3);
        }
        if ((scope = parameters.getEffectiveSearchScope()) instanceof LocalSearchScope) {
            HashSet<PhpUse> uses = new HashSet<PhpUse>();
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element);
                if (scopeHolder == null) continue;
                for (PhpUseList useList : PhpCodeInsightUtil.collectImports(scopeHolder)) {
                    Collections.addAll(uses, useList.getDeclarations());
                }
                if (!(scopeHolder instanceof PhpFile)) continue;
                for (PhpNamespace namespace : PhpCodeInsightUtil.collectNamespaces((PsiFile)((PhpFile)scopeHolder))) {
                    for (PhpUseList useList : PhpCodeInsightUtil.collectImports((PhpPsiElement)namespace)) {
                        Collections.addAll(uses, useList.getDeclarations());
                    }
                }
            }
            HashSet<PhpUse> hashSet = uses;
            if (hashSet == null) {
                PhpAliasReferenceSearcher.$$$reportNull$$$0(4);
            }
            return hashSet;
        }
        Collection collection = PhpIndex.getInstance((Project)parameters.getProject()).getUseAliasesByReferenceName(name);
        if (collection == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private static void searchUseAlias(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull PhpUse use, @NotNull PsiElement target, boolean caseSensitive) {
        PhpPsiElement useScope;
        String aliasedName;
        if (parameters == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (use == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(7);
        }
        if (target == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(8);
        }
        if ((aliasedName = use.getAliasName()) != null && (useScope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)use)) != null) {
            SearchScope scope = PhpConstructorReferenceSearcher.getEffectiveSearchScope(parameters).intersectWith((SearchScope)new LocalSearchScope((PsiElement)useScope));
            MyRequestResultProcessor processor2 = new MyRequestResultProcessor((PsiElement)use, target);
            parameters.getOptimizer().searchWord(aliasedName, scope, (short)1, caseSensitive, target, (RequestResultProcessor)processor2);
        }
    }

    private static boolean isConstructor(@NotNull Method method) {
        PhpClass clazz;
        if (method == null) {
            PhpAliasReferenceSearcher.$$$reportNull$$$0(9);
        }
        if ((clazz = method.getContainingClass()) == null) {
            return false;
        }
        return "__construct".equals(method.getName()) || PhpLangUtil.equalsClassNames(method.getName(), clazz.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "use";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUses";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "searchUseAlias";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class MyRequestResultProcessor
    extends RequestResultProcessor {
        private final PsiElement myUseTarget;
        private final PsiElement myOriginalTarget;

        MyRequestResultProcessor(@NotNull PsiElement useTarget, @NotNull PsiElement originalTarget) {
            if (useTarget == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(0);
            }
            if (originalTarget == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(1);
            }
            super(new Object[]{useTarget});
            this.myUseTarget = useTarget;
            this.myOriginalTarget = originalTarget;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(3);
            }
            if (!this.myUseTarget.isValid() || !this.myOriginalTarget.isValid()) {
                return false;
            }
            for (PsiReference ref : PsiReferenceService.getService().getReferences(element, new PsiReferenceService.Hints(this.myUseTarget, Integer.valueOf(offsetInElement)))) {
                Method method;
                PsiElement psiElement;
                ProgressManager.checkCanceled();
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || this.myUseTarget != PhpTargetElementEvaluator.getElementByReference(ref) || !((psiElement = this.myOriginalTarget) instanceof Method && PhpAliasReferenceSearcher.isConstructor(method = (Method)psiElement) ? element.getParent() instanceof NewExpression && !consumer.process((Object)ref) : !consumer.process((Object)ref))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useTarget";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalTarget";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpAliasReferenceSearcher$MyRequestResultProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

