/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocStubElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocMethodStub;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocMethodImpl
extends PhpNamedElementImpl<PhpDocMethodStub>
implements PhpTokenTypes,
PhpDocMethod {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{IDENTIFIER}), tsKEYWORDS});
    private static final PhpExpressionCodeFragmentImpl.CodeFragmentEmptyScope EMPTY_SCOPE = new PhpExpressionCodeFragmentImpl.CodeFragmentEmptyScope("PhpDocMethod");

    public PhpDocMethodImpl(ASTNode node) {
        super(node);
    }

    public PhpDocMethodImpl(PhpDocMethodStub stub) {
        super(stub, PhpDocStubElementTypes.phpDocMethod);
    }

    public boolean isClosure() {
        return false;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpClass containingClass = this.getContainingClass();
        String string = containingClass != null ? containingClass.getFQN() + "." + this.getName() : "." + this.getName();
        if (string == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        PhpClass containingClass = this.getContainingClass();
        return containingClass != null ? containingClass.getNamespaceName() : "\\";
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    public Method.MethodType getMethodType(boolean allowAmbiguity) {
        return Method.MethodType.REGULAR_METHOD;
    }

    public boolean isStatic() {
        PhpDocMethodStub stub = (PhpDocMethodStub)this.getGreenStub();
        return stub != null ? stub.isStatic() : this.getParent().getText().contains(" static");
    }

    public boolean isFinal() {
        return false;
    }

    public boolean isAbstract() {
        PhpClass containingClass = this.getContainingClass();
        return containingClass != null && containingClass.isInterface();
    }

    public PhpModifier.Access getAccess() {
        return PhpModifier.Access.PUBLIC;
    }

    public PhpClass getContainingClass() {
        return PhpDocMethodImpl.getContainingClass(this);
    }

    @Nullable
    public PhpReturnType getTypeDeclaration() {
        return null;
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        List<PhpAttribute> list = Collections.emptyList();
        if (list == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    static PhpClass getContainingClass(@NotNull PhpNamedElement element) {
        PhpDocComment docComment;
        if (element == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(2);
        }
        if ((docComment = element.getDocComment()) != null) {
            StubElement parent;
            PhpDocCommentStub docCommentStub = (PhpDocCommentStub)docComment.getStub();
            if (docCommentStub != null && (parent = docCommentStub.getParentStub()) != null) {
                List children = parent.getChildrenStubs();
                int i = children.indexOf(docCommentStub);
                return i != -1 && i < children.size() - 1 ? (PhpClass)ObjectUtils.tryCast((Object)((StubElement)children.get(i + 1)).getPsi(), PhpClass.class) : null;
            }
            PhpPsiElement next = docComment.getNextPsiSibling();
            PsiElement parent2 = docComment.getParent();
            if (parent2 instanceof PhpNamespace && next instanceof GroupStatement) {
                next = next.getFirstPsiChild();
            }
            return next instanceof PhpClass ? (PhpClass)next : null;
        }
        return null;
    }

    public Parameter @NotNull [] getParameters() {
        Parameter[] params;
        PhpDocMethodStub stub = (PhpDocMethodStub)this.getGreenStub();
        if (stub != null) {
            return PhpDocMethodImpl.getStubParameters(stub);
        }
        ParameterList paramsList = this.getParameterList();
        if (paramsList != null && (params = (Parameter[])PsiTreeUtil.getChildrenOfType((PsiElement)paramsList, Parameter.class)) != null) {
            if (params == null) {
                PhpDocMethodImpl.$$$reportNull$$$0(3);
            }
            return params;
        }
        if (Parameter.EMPTY_ARRAY == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(4);
        }
        return Parameter.EMPTY_ARRAY;
    }

    private static Parameter @NotNull [] getStubParameters(PhpDocMethodStub stub) {
        Parameter[] parameterArray = (Parameter[])stub.getChildrenByType((IElementType)PhpStubElementTypes.NOT_PROMOTED_PARAMETER, Parameter.ARRAY_FACTORY);
        if (parameterArray == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(5);
        }
        return parameterArray;
    }

    private ParameterList getParameterList() {
        return (ParameterList)this.findChildByClass(ParameterList.class);
    }

    @Nullable
    public Parameter getParameter(int index) {
        if (index < 0) {
            return null;
        }
        PhpDocMethodStub stub = (PhpDocMethodStub)this.getGreenStub();
        if (stub != null) {
            Parameter[] parameters = PhpDocMethodImpl.getStubParameters(stub);
            return index < parameters.length ? parameters[index] : null;
        }
        return PhpPsiUtil.getNthChildOfClass((PsiElement)this.getParameterList(), index, Parameter.class);
    }

    public boolean hasRefParams() {
        return false;
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpModifier phpModifier = this.isStatic() ? PhpModifier.PUBLIC_IMPLEMENTED_STATIC : PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
        if (phpModifier == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(6);
        }
        return phpModifier;
    }

    @Override
    public ASTNode getNameNode() {
        PsiElement methodName = this.findChildByType(NN);
        return methodName != null ? methodName.getNode() : null;
    }

    @Override
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getParentOfClass((PsiElement)this, PhpDocComment.class);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor2) {
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpDocMethodStub stub = (PhpDocMethodStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                PhpDocMethodImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PhpTypedElement) {
            PhpType phpType = ((PhpTypedElement)parent).getType();
            if (phpType == null) {
                PhpDocMethodImpl.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpType phpType = this.getType();
        if (phpType == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Nullable
    public PhpReturnType getReturnType() {
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) {
        ASTNode nameNode;
        if (name == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(11);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            PhpDocMethod method = PhpPsiElementFactory.createFromText(this.getProject(), PhpDocMethod.class, "/** @method " + name + "()");
            assert (method != null) : name;
            nameNode.getTreeParent().replaceChild(nameNode, method.getNameNode());
        }
        return this;
    }

    public Collection<String> getDocExceptions() {
        return Collections.emptyList();
    }

    @NotNull
    public PhpScope getScope() {
        PhpExpressionCodeFragmentImpl.CodeFragmentEmptyScope codeFragmentEmptyScope = EMPTY_SCOPE;
        if (codeFragmentEmptyScope == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(12);
        }
        return codeFragmentEmptyScope;
    }

    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = EMPTY_SCOPE.getControlFlow();
        if (phpControlFlow == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(13);
        }
        return phpControlFlow;
    }

    @Override
    public Icon getIcon() {
        return MethodImpl.getIcon((Method)this);
    }

    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            PhpDocMethodImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocMethodImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 2: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocMethodImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 11 -> new IllegalArgumentException(string);
        };
    }
}

