/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.lang.documentation.QuickDocSyntaxHighlightingHandler;
import com.intellij.lang.documentation.QuickDocSyntaxHighlightingHandlerFactory;
import org.jetbrains.annotations.NotNull;

public class PhpQuickDocSyntaxHighlightingHandler
implements QuickDocSyntaxHighlightingHandler {
    private static final String OPEN_PHP_TAG = "<?php";
    private static final String SHORT_OPEN_TAG = "<?";
    private static final String ECHO_OPEN_TAG = "<?=";
    private boolean hasOpenTag;

    @NotNull
    public String preprocessCode(@NotNull String code) {
        if (code == null) {
            PhpQuickDocSyntaxHighlightingHandler.$$$reportNull$$$0(0);
        }
        this.hasOpenTag = code.startsWith(OPEN_PHP_TAG) || code.startsWith(SHORT_OPEN_TAG) || code.startsWith(ECHO_OPEN_TAG);
        Object object = this.hasOpenTag ? code : "<?php " + code;
        if (object == null) {
            PhpQuickDocSyntaxHighlightingHandler.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    public String postProcessHtml(@NotNull String html) {
        if (html == null) {
            PhpQuickDocSyntaxHighlightingHandler.$$$reportNull$$$0(2);
        }
        html = this.hasOpenTag ? html : html.replaceFirst("&lt;\\?php(&#32;| )", "").replaceFirst("<span style=[^>]*></span>", "");
        String string = html.replace("\\", "&#8726;").replace("&#32;", "&nbsp;");
        if (string == null) {
            PhpQuickDocSyntaxHighlightingHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpQuickDocSyntaxHighlightingHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpQuickDocSyntaxHighlightingHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessCode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessCode";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "postProcessHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    public static class Factory
    implements QuickDocSyntaxHighlightingHandlerFactory {
        @NotNull
        public QuickDocSyntaxHighlightingHandler createHandler() {
            return new PhpQuickDocSyntaxHighlightingHandler();
        }
    }
}

