/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocumentationProvider;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamespaceDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameter;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTemplateTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamedElementDocSource
extends PhpDefaultDocSource {
    protected PhpNamedElement myElement;

    public PhpNamedElementDocSource(PhpNamedElement element, boolean isGenerationForRenderedDoc) {
        super((PhpPsiElement)element, isGenerationForRenderedDoc);
        this.myElement = element;
        this.myDocComment = this.myElement.getDocComment();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getTitle() {
        String title = XmlStringUtil.escapeString((String)this.myElement.getText(), (boolean)false);
        StringBuilder buffer = new StringBuilder();
        PhpNamedElement phpNamedElement = this.myElement;
        if (phpNamedElement instanceof Field) {
            Field field = (Field)phpNamedElement;
            name = field.isConstant() ? field.getName() : "$" + field.getName();
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)name, (TextAttributesKey)PhpAnnotatorVisitor.getInstanceFieldHighlightingData(field));
            PhpNamedElementDocSource.appendDefaultValue(buffer, field.getDefaultValue());
        } else {
            name = this.myElement;
            if (name instanceof PhpEnumCase) {
                PhpEnumCase enumCase = (PhpEnumCase)name;
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)enumCase.getName(), (TextAttributesKey)PhpHighlightingData.INSTANCE_FIELD);
                PhpNamedElementDocSource.appendDefaultValue(buffer, (PsiElement)enumCase.getExpression());
            } else if (this.myElement instanceof Variable) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)title, (TextAttributesKey)PhpHighlightingData.VAR);
            } else {
                name = this.myElement;
                if (name instanceof Constant) {
                    Constant constant = (Constant)name;
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)constant.getName(), (TextAttributesKey)PhpHighlightingData.CONSTANT);
                    PhpNamedElementDocSource.appendDefaultValue(buffer, constant.getValue());
                } else if (this.myElement instanceof Parameter) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)("$" + this.myElement.getName()), (TextAttributesKey)PhpHighlightingData.PARAMETER);
                    PhpNamedElementDocSource.appendDefaultValue(buffer, ((Parameter)this.myElement).getDefaultValue());
                } else {
                    name = this.myElement;
                    if (name instanceof PhpDocTemplateParameter) {
                        PhpDocTemplateParameter parameter = (PhpDocTemplateParameter)name;
                        PsiElement parent = parameter.getParent();
                        if (parent instanceof PhpDocTemplateTag) {
                            PhpDocTemplateTag templateTag = (PhpDocTemplateTag)parent;
                            PhpDocType superType = templateTag.getSuperType();
                            String variantString = templateTag.isCovariant() ? "covariant " : (templateTag.isContravariant() ? "contravariant " : "");
                            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)("template " + variantString + "parameter"), (TextAttributesKey)PhpHighlightingData.KEYWORD);
                            buffer.append(" ");
                            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)title, (TextAttributesKey)PhpHighlightingData.CLASS);
                            if (superType != null) {
                                buffer.append(" ");
                                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)"of", (TextAttributesKey)PhpHighlightingData.KEYWORD);
                                buffer.append(" ");
                                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)superType.getText(), (TextAttributesKey)PhpHighlightingData.CLASS);
                            }
                        }
                    } else {
                        buffer.append(title);
                    }
                }
            }
        }
        String string = title == null ? "" : buffer.toString();
        if (string == null) {
            PhpNamedElementDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void appendDefaultValue(StringBuilder buffer, @Nullable PsiElement value) {
        String defaultValue = PhpDocUtil.getDefaultValue(value);
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            buffer.append(" = ").append(defaultValue);
        }
    }

    @Override
    @NotNull
    public String getDescription() {
        String[] description = new String[]{""};
        if (!DumbService.isDumb((Project)this.myElement.getProject())) {
            this.myElement.processDocs(comment -> {
                String superDesc = PhpDocUtil.getDescription(comment, this.myIsGenerationForRenderedDoc);
                if (!superDesc.isEmpty()) {
                    description[0] = PhpNamedElementDocSource.updateDescription(description[0], superDesc);
                    return StringUtil.containsIgnoreCase((String)superDesc, (String)"@inheritDoc");
                }
                return true;
            });
        } else if (this.myDocComment != null) {
            description[0] = PhpDocUtil.getDescription(this.myDocComment, this.myIsGenerationForRenderedDoc);
        }
        StringBuilder descBuilder = new StringBuilder();
        if (!this.myIsGenerationForRenderedDoc) {
            PhpNamedElementDocSource.appendTagDescriptions(this.myDocComment, "@var", descBuilder, false);
        }
        PhpNamedElementDocSource.appendTagDescriptions(this.myDocComment, "@xglobal", descBuilder, this.myIsGenerationForRenderedDoc);
        descBuilder.append(description[0]);
        String string = descBuilder.toString();
        if (string == null) {
            PhpNamedElementDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String updateDescription(String description, String superDescription) {
        if (description.isEmpty()) {
            return superDescription;
        }
        String wrappedInheritDoc = "<p>@inheritDoc</p>";
        String updatedDescription = StringUtil.containsIgnoreCase((String)description, (String)wrappedInheritDoc) ? StringUtil.replaceIgnoreCase((String)description, (String)wrappedInheritDoc, (String)superDescription) : StringUtil.replaceIgnoreCase((String)description, (String)"@inheritDoc", (String)superDescription);
        return updatedDescription.replaceAll("^(<p>)+", "<p>").replaceAll("(</p>)+$", "</p>");
    }

    public static void appendTagDescriptions(PhpDocComment comment, String tagName, StringBuilder descBuilder, boolean generationForRenderedDoc) {
        PhpDocTag[] tags;
        if (comment == null) {
            return;
        }
        for (PhpDocTag tag : tags = comment.getTagElementsByName(tagName)) {
            String tagDesc = PhpDocUtil.getTagValue(tag, generationForRenderedDoc);
            descBuilder.append(tagDesc);
            if (tags[tags.length - 1] == tag) continue;
            descBuilder.append('\n');
        }
    }

    @Override
    public String getProperties() {
        if (this.myDocComment == null) {
            return null;
        }
        return (String)StreamEx.of(PhpDocumentationProvider.PROPERTY_TAGS).flatMap(n -> StreamEx.of((Object[])this.myDocComment.getTagElementsByName(n))).map(propertyTag -> PhpNamedElementDocSource.getProperty(propertyTag, this.myIsGenerationForRenderedDoc)).collect(Collectors.joining("<br>"));
    }

    private static String getProperty(PhpDocTag tag, boolean isGenerationForRenderedDoc) {
        PhpDocProperty property;
        if (!(tag instanceof PhpDocPropertyTag)) {
            return "";
        }
        PhpDocPropertyTag propertyTag = (PhpDocPropertyTag)tag;
        StringBuilder buffer = new StringBuilder();
        String name = propertyTag.getName();
        if (!name.isEmpty()) {
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)QuickDocHighlightingHelper.wrapWithInlineCodeTag((String)name.substring(1)), (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
        }
        if ((property = propertyTag.getProperty()) != null) {
            buffer.append(" ");
            String propertyName = property.getName();
            QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)QuickDocHighlightingHelper.wrapWithInlineCodeTag((String)("$" + propertyName)), (TextAttributesKey)PhpHighlightingData.PARAMETER);
        }
        buffer.append(" ");
        PhpNamedElementDocSource.appendTypeFromDocTag(buffer, (PhpDocTag)propertyTag, isGenerationForRenderedDoc);
        PhpFunctionDocSource.appendDescription(buffer, (PhpDocTag)propertyTag);
        return buffer.toString();
    }

    @Override
    public String getReturnType() {
        return this.getReturnType(this.myElement);
    }

    protected String getReturnType(PhpNamedElement element) {
        StringBuilder buffer = new StringBuilder();
        PhpType type = element instanceof FunctionImpl ? ((FunctionImpl)element).getType(false) : element.getType();
        PhpNamedElementDocSource.appendType(buffer, type, element.getContext(), this.myIsGenerationForRenderedDoc);
        return buffer.toString();
    }

    public static void appendTypeFromDocTag(StringBuilder buffer, PhpDocTag tag, boolean isGenerationForRenderedDoc) {
        PhpDocParamTag paramTag;
        PhpType tagType = tag instanceof PhpDocParamTag && (paramTag = (PhpDocParamTag)tag).isVariadic() ? tag.getType().unpluralize() : tag.getType();
        StringBuilder builder2 = new StringBuilder();
        List<PhpDocType> types = PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance));
        if (PhpDocSignatureIsNotCompleteInspection.isExtendedBySpecialType(null, tag)) {
            for (PhpDocType type : types) {
                if (PhpNamedElementDocSource.isSingleType(type) && !PhpNamedElementDocSource.isSpecialTypeShouldNotResolve(type)) {
                    PhpNamedElementDocSource.appendType(builder2, type.getType(), type.getContext(), isGenerationForRenderedDoc, type.getText());
                } else {
                    PhpNamedElementDocSource.appendDocType(builder2, type, isGenerationForRenderedDoc);
                }
                builder2.append("|");
            }
            if (!builder2.isEmpty()) {
                builder2.setLength(builder2.length() - 1);
            }
        } else {
            PhpNamedElementDocSource.appendType(builder2, tagType, tag.getContext(), isGenerationForRenderedDoc);
        }
        QuickDocHighlightingHelper.appendWrappedWithInlineCodeTag((StringBuilder)buffer, (CharSequence)builder2);
    }

    private static boolean isSpecialTypeShouldNotResolve(PhpDocType type) {
        List<String> EXTENDED_STRINGS = List.of("class-string", "callable-string", "numeric-string", "lowercase-string", "non-empty-lowercase-string", "non-empty-string", "non-falsy-string", "truthy-string", "trait-string", "literal-string", "never-return", "never-returns", "no-return", "positive-int", "non-positive-int", "negative-int", "non-negative-int", "scalar", "numeric", "array-key", "empty", "closed-resource", "int-mask-of", "int-mask");
        return PhpDocTypeImpl.isNegationType(type.getText()) || PhpDocTypeImpl.isFloatArrayShapeType(type.getText()) || PhpDocTypeImpl.isAdvancedCallable(type) || PhpWorkaroundUtil.getGenericDocTypeName(type) != null || EXTENDED_STRINGS.contains(type.getText());
    }

    private static void appendDocType(StringBuilder buffer, PhpDocType type, boolean isGenerationForRenderedDoc) {
        PsiElement child = type.getFirstChild();
        while (child != null) {
            PhpDocType phpDocType;
            PhpDocType phpDocType2;
            if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) && !PhpType.isPrimitiveType((String)child.getText()) && PhpPsiUtil.isOfType(child.getNextSibling(), (IElementType)PhpDocElementTypes.phpDocAttributeList)) {
                String link = type.getGlobalType().getTypes().stream().dropWhile(l -> PhpDocUtil.unresolvedLink(l, (PsiElement)type)).findFirst().orElse(null);
                PhpNamedElementDocSource.tryToAppendLink(buffer, link, child.getText(), true, (PsiElement)type, true);
            } else if (child instanceof PhpDocType && !PhpNamedElementDocSource.isSingleType(phpDocType2 = (PhpDocType)child)) {
                PhpNamedElementDocSource.appendDocType(buffer, phpDocType2, isGenerationForRenderedDoc);
            } else if (child instanceof PhpDocType && !PhpNamedElementDocSource.isSpecialTypeShouldNotResolve(phpDocType = (PhpDocType)child)) {
                PhpNamedElementDocSource.appendType(buffer, phpDocType.getType(), type.getContext(), isGenerationForRenderedDoc, phpDocType.getText());
            } else {
                if (PhpPsiUtil.isOfType(child, (IElementType)PhpDocElementTypes.phpDocAttributeList)) {
                    child = child.getFirstChild();
                    continue;
                }
                if (child instanceof PhpDocVariable) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)child.getText(), (TextAttributesKey)PhpHighlightingData.DOC_VAR);
                } else if (!PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_LEADING_ASTERISK) && !(child instanceof PhpNamespaceReference)) {
                    QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)PhpNamedElementDocSource.prepareTypeText(child.getText()), (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
                }
            }
            child = child.getNextSibling();
        }
    }

    private static boolean isSingleType(PhpDocType type) {
        PsiElement attributeList = PhpPsiUtil.getChildOfType((PsiElement)type, (IElementType)PhpDocElementTypes.phpDocAttributeList);
        return attributeList == null && type.getChildren().length <= 1;
    }

    private static String prepareTypeText(String text) {
        return text.replace("<", "&lt;").replace(">", "&gt;").replaceAll("\n *", "<br>").replace(" ", "&nbsp;");
    }

    @Override
    public String getMethods() {
        PhpDocMethod[] methods;
        if (this.myDocComment == null) {
            return null;
        }
        @Nls StringBuilder builder2 = new StringBuilder();
        for (PhpDocMethod method : methods = this.myDocComment.getMethods()) {
            PhpType type = method.getType();
            if (!type.isEmpty()) {
                PhpNamedElementDocSource.appendType(builder2, method.getType(), method.getContext(), this.myIsGenerationForRenderedDoc);
                builder2.append(" ");
            }
            if (method.isStatic()) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)"static", (TextAttributesKey)PhpHighlightingData.KEYWORD);
                builder2.append(" ");
            }
            builder2.append(PhpDocUtil.extractDefinition((PhpNamedElement)method, this.myIsGenerationForRenderedDoc));
            Object description = PhpPsiUtil.getChildByCondition(method.getParent(), (Condition<? super PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpDocTokenTypes.DOC_METHOD_DESCRIPTION)));
            if (description != null) {
                builder2.append(" ");
                builder2.append(description.getText());
            }
            builder2.append("<br>");
        }
        return QuickDocHighlightingHelper.wrapWithInlineCodeTag((StringBuilder)builder2).toString();
    }

    public static void appendType(StringBuilder buffer, PhpType type, PsiElement context, boolean isGenerationForRenderedDoc) {
        PhpNamedElementDocSource.appendType(buffer, type, context, isGenerationForRenderedDoc, null);
    }

    private static void appendType(StringBuilder buffer, PhpType type, PsiElement context, boolean isGenerationForRenderedDoc, String text) {
        if (!type.isEmpty()) {
            boolean isGenericType = ContainerUtil.exists((Iterable)type.getTypes(), t -> PhpGenericsExtendedTypeProvider.KEY.signed((String)t));
            if (isGenericType) {
                if (text == null) {
                    return;
                }
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)PhpNamedElementDocSource.prepareTypeText(text), (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
            } else {
                type = DumbService.getInstance((Project)context.getProject()).isDumb() ? type : type.global(context.getProject());
                PhpNamedElementDocSource.appendTypes(buffer, type.getTypesSorted(), "|", isGenerationForRenderedDoc, context, text);
            }
        }
    }

    private static void appendTypes(StringBuilder buffer, Collection<@NlsSafe String> types, String delimiter, boolean isGenerationForRenderedDoc, PsiElement context, String text) {
        for (String s : types) {
            if (s.contains("&")) {
                PhpNamedElementDocSource.appendTypes(buffer, StringUtil.split((String)s, (String)"&"), "&", isGenerationForRenderedDoc, context, text);
                return;
            }
            if (StringUtil.startsWithChar((CharSequence)s, (char)'?')) continue;
            if (PhpType.isPrimitiveType((String)s) || PhpType.isResourceOrNumberType((String)s) || PhpType.isPluralPrimitiveType((String)s)) {
                TextAttributesKey attributesKey = isGenerationForRenderedDoc ? PhpHighlightingData.DOC_IDENTIFIER : PhpHighlightingData.PRIMITIVE_TYPE_HINT;
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buffer, (String)PhpType.toString((String)s), (TextAttributesKey)attributesKey);
                buffer.append(delimiter);
                continue;
            }
            if (text != null) {
                PhpNamedElementDocSource.tryToAppendLink(buffer, s, text, true, context, true);
            } else {
                PhpNamedElementDocSource.tryToAppendLink(buffer, s, true, context, true);
            }
            buffer.append(delimiter);
        }
        int bufferLength = buffer.length();
        if (bufferLength > 0 && buffer.charAt(bufferLength - 1) == delimiter.charAt(0)) {
            buffer.setLength(bufferLength - 1);
        }
    }

    @Override
    public String getDataProvider() {
        return PhpNamedElementDocSource.getSeeItemsInternal(this.myDocComment, "@dataProvider");
    }

    @Override
    public String getCovers() {
        return PhpNamedElementDocSource.getSeeItemsInternal(this.myDocComment, "@covers");
    }

    @Override
    public String getCoversDefaultClass() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] tags = this.myDocComment.getTagElementsByName("@coversDefaultClass");
        StringBuilder builder2 = new StringBuilder();
        for (PhpDocTag tag : tags) {
            builder2.append(PhpDocUtil.getTagInfo(tag, this.myIsGenerationForRenderedDoc));
            builder2.append("<br>");
        }
        if (tags.length != 0) {
            builder2.delete(builder2.length() - 4, builder2.length());
        }
        return builder2.toString();
    }

    @Override
    public String getDepends() {
        return PhpNamedElementDocSource.getSeeItemsInternal(this.myDocComment, "@depends");
    }

    public static String getSeeItemsInternal(PhpDocComment comment, String name) {
        if (comment == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        List seeTags = ContainerUtil.filter((Object[])comment.getTagElementsByName(name), seeTag -> !PhpDocTagImpl.isInline(seeTag));
        for (PhpDocTag seeTag2 : seeTags) {
            List<PsiElement> types = PhpPsiUtil.getChildren((PsiElement)seeTag2, (Condition<? super PsiElement>)((Condition)element -> PhpPsiUtil.isOfType(element, (IElementType)PhpDocElementTypes.phpDocRef)));
            if (!types.isEmpty()) {
                for (PsiElement child : types) {
                    PhpNamedElementDocSource.tryToAppendLink(buf, child.getText(), false, (PsiElement)comment, true);
                    buf.append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.append(" ").append(StringUtil.trimEnd((String)seeTag2.getTagValue(), (char)'}'));
            } else if (seeTag2.getReferences().length != 0) {
                PhpNamedElementDocSource.appendReference(buf, seeTag2);
            } else {
                PsiElement value = PhpPsiUtil.getChildOfType((PsiElement)seeTag2, (IElementType)PhpDocElementTypes.phpDocTagValue);
                if (value != null) {
                    PsiElement url = PhpPsiUtil.getChildOfType(value, PhpDocTokenTypes.DOC_URL);
                    if (url != null) {
                        String urlText = url.getText();
                        buf.append("<a href='").append(urlText).append("'>");
                        String valueText = value.getText().substring(urlText.length()).trim();
                        if (valueText.isEmpty()) {
                            valueText = url.getText();
                        }
                        buf.append(valueText).append("</a>");
                    } else {
                        buf.append(seeTag2.getTagValue());
                    }
                }
            }
            buf.append("<br>");
        }
        if (!seeTags.isEmpty()) {
            buf.delete(buf.length() - 4, buf.length());
        }
        return buf.toString();
    }

    private static String generateLink(String link, String text) {
        if (link != null && !link.trim().isEmpty()) {
            link = link.trim();
            return "<a href='" + PhpNamedElementDocSource.getLinkUrl(link) + "'>" + PhpLangUtil.toShortName(text) + "</a>";
        }
        return null;
    }

    public static void tryToAppendLink(StringBuilder buf, String link, String text, boolean quickDocSignature, PsiElement context, boolean appendUnresolvedLink) {
        boolean unresolvedLink;
        boolean bl = unresolvedLink = PhpDocUtil.unresolvedLink(link, context) && PhpDocUtil.tryResolveSuppressedInspection(link, context) == null;
        if (unresolvedLink && !appendUnresolvedLink) {
            return;
        }
        if (unresolvedLink) {
            if (quickDocSignature) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)text, (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
            } else {
                QuickDocHighlightingHelper.appendStyledLinkFragment((StringBuilder)buf, (String)text, (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
            }
        } else {
            PhpNamedElementDocSource.appendLink(buf, link, text, quickDocSignature);
        }
    }

    public static void tryToAppendLink(StringBuilder buf, String link, boolean quickDocSignature, PsiElement context, boolean appendUnresolvedLink) {
        PhpNamedElementDocSource.tryToAppendLink(buf, link, link, quickDocSignature, context, appendUnresolvedLink);
    }

    public static void appendLink(StringBuilder buf, String link, String text, boolean quickDocSignature) {
        PhpNamedElementDocSource.appendLink(buf, link, text, quickDocSignature, PhpHighlightingData.IDENTIFIER);
    }

    public static void appendLink(StringBuilder buf, String link, boolean quickDocSignature) {
        PhpNamedElementDocSource.appendLink(buf, link, link, quickDocSignature, PhpHighlightingData.IDENTIFIER);
    }

    private static void appendLink(StringBuilder buf, String link, String text, boolean quickDocSignature, TextAttributesKey textAttributesKey) {
        String generatedLink = PhpNamedElementDocSource.generateLink(link, text);
        if (generatedLink != null && !generatedLink.isEmpty()) {
            if (quickDocSignature) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)buf, (String)generatedLink, (TextAttributesKey)textAttributesKey);
            } else {
                QuickDocHighlightingHelper.appendStyledLinkFragment((StringBuilder)buf, (String)generatedLink, (TextAttributesKey)textAttributesKey);
            }
        }
    }

    public static void appendAttributeLink(StringBuilder buf, String link, boolean quickDocSignature) {
        PhpNamedElementDocSource.appendLink(buf, link, link, quickDocSignature, PhpHighlightingData.ATTRIBUTE);
    }

    private static String getLinkUrl(String link) {
        String linkPrefix = "";
        if (!link.startsWith("http://")) {
            linkPrefix = "psi_element://";
        }
        return linkPrefix + link.trim();
    }

    public static void appendReference(StringBuilder builder2, PhpDocTag tag) {
        List references = ContainerUtil.filter((Object[])tag.getReferences(), r -> r.resolve() instanceof Function);
        if (references.isEmpty()) {
            return;
        }
        PhpNamedElement element = (PhpNamedElement)ObjectUtils.tryCast((Object)((PsiReference)references.get(0)).resolve(), PhpNamedElement.class);
        if (element != null) {
            String fqn = element.getFQN().replace(".", "::");
            PhpNamedElementDocSource.appendLink(builder2, fqn, true);
        } else {
            builder2.append(((PsiReference)references.get(0)).getCanonicalText());
        }
    }

    @Override
    public String getGenerics() {
        if (this.myDocComment == null) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder();
        ((StreamEx)StreamEx.of(PhpDocumentationProvider.TEMPLATE_TAGS).flatMap(s -> Arrays.stream(this.myDocComment.getTagElementsByName(s))).filter(t -> t instanceof PhpDocTemplateTag)).forEach(t -> this.getGenericInfo(builder2, (PhpDocTemplateTag)t));
        if (builder2.length() > 4) {
            builder2.setLength(builder2.length() - 4);
        }
        return builder2.toString();
    }

    private void getGenericInfo(StringBuilder builder2, PhpDocTemplateTag tag) {
        String variantString;
        PhpDocTemplateParameter parameterElement = tag.getTemplateParameter();
        if (parameterElement == null) {
            return;
        }
        PhpDocType superTypeElement = tag.getSuperType();
        String string = tag.isCovariant() ? "covariant" : (variantString = tag.isContravariant() ? "contravariant" : "");
        if (!variantString.isEmpty()) {
            builder2.append(variantString);
            builder2.append(" ");
        }
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)parameterElement.getText(), (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
        if (superTypeElement != null) {
            builder2.append(" of ");
            PhpNamedElementDocSource.appendTypeFromDocTag(builder2, tag, this.myIsGenerationForRenderedDoc);
        }
        PhpFunctionDocSource.appendDescription(builder2, tag);
        builder2.append("<br>");
    }

    @Override
    public HtmlChunk.Element getContainerInfo() {
        String name;
        PhpNamedElement phpNamedElement = this.myElement;
        if (phpNamedElement instanceof PhpDocTemplateParameter) {
            PhpDocTemplateParameter parameter = (PhpDocTemplateParameter)phpNamedElement;
            PhpDocComment comment = parameter.getDocComment();
            PsiElement owner = comment == null ? null : comment.getOwner();
            PhpClass clazz = (PhpClass)ObjectUtils.tryCast((Object)owner, PhpClass.class);
            if (clazz == null) {
                return null;
            }
            return PhpNamedElementDocSource.getContainerInfo(clazz.getFQN(), PhpNamespaceDocSource.getIcon(clazz), (PsiElement)this.myElement);
        }
        PhpNamedElement phpNamedElement2 = this.myElement;
        if (phpNamedElement2 instanceof PhpNamespace) {
            PhpNamespace namespace = (PhpNamespace)phpNamedElement2;
            v0 = namespace.getParentNamespaceName();
        } else {
            v0 = name = this.myElement.getNamespaceName();
        }
        if (name.isEmpty() || name.equals("\\")) {
            return null;
        }
        return PhpNamedElementDocSource.getContainerInfo(name, "AllIcons.Nodes.Package", (PsiElement)this.myElement);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HtmlChunk.Element getContainerInfo(@NlsSafe String text, String icon, PsiElement context) {
        return PhpNamedElementDocSource.getLinkWithIcon(text, icon, "bottom", context);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HtmlChunk.Element getLinkWithIcon(@NlsSafe String text, String icon, String style, PsiElement context) {
        @NlsSafe StringBuilder link = new StringBuilder();
        PhpNamedElementDocSource.tryToAppendLink(link, text, StringUtil.trimEnd((String)text, (String)"\\"), false, context, false);
        if (link.isEmpty()) {
            return null;
        }
        return HtmlChunk.div().setClass(style).children(new HtmlChunk[]{HtmlChunk.tag((String)"icon").attr("src", icon), HtmlChunk.nbsp(), HtmlChunk.raw((String)QuickDocHighlightingHelper.wrapWithInlineCodeTag((StringBuilder)link).toString())});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/PhpNamedElementDocSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

