/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpGotoLabelDefinitionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpKeywordsCompletionContributor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpSquashRepetitiveUnderscoresWithSingleOneQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocRefImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameter;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.PhpDynamicFieldDeclarationInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpRemoveAttributeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveParametersQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassConstantType;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpClone;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.ForeachImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpCloneImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDumbAwareAnnotatorVisitor
extends PhpElementVisitor {
    private static final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final TokenSet COMPILE_TIME_CONSTANTS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.PARAMETER_DEFAULT_VALUE, PhpElementTypes.STATIC_STATEMENT, PhpElementTypes.CLASS_CONSTANTS, PhpElementTypes.CLASS_FIELDS});
    private static final TokenSet POSSIBLE_TYPE_HINT = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwARRAY, PhpTokenTypes.kwCALLABLE, PhpElementTypes.CLASS_REFERENCE, PhpDocElementTypes.phpDocType});
    private final AnnotationHolder holder;

    public PhpDumbAwareAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        if (PhpPsiUtil.isOfType((PsiElement)comment, PhpTokenTypes.LINE_COMMENT) && comment.getText().startsWith("#[")) {
            this.highlightInfo(comment.getNode(), PhpHighlightingData.COMMENT);
        }
    }

    public void visitPhpCallableFunction(PhpCallableFunction reference) {
        this.highlightFunctionCall((PhpReference)reference);
    }

    public void visitPhpClassConstantReference(ClassConstantReference reference) {
        ASTNode constantNameNode = reference.getNameNode();
        if (reference.isStatic() && !"class".equalsIgnoreCase(reference.getName())) {
            this.highlightInfo(constantNameNode, PhpHighlightingData.CONSTANT);
        }
    }

    public void visitPhpClone(PhpClone clone) {
        PhpCloneImpl cloneImpl;
        block6: {
            block5: {
                if (!(clone instanceof PhpCloneImpl)) break block5;
                cloneImpl = (PhpCloneImpl)clone;
                if (PhpLanguageFeature.CLONE_WITH_PROPERTIES.isSupported(clone.getProject())) break block6;
            }
            return;
        }
        ParameterList parameterList = cloneImpl.getParameterList();
        if (parameterList == null) {
            return;
        }
        if (parameterList.getParameters().length > 2) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameterList, PhpBundle.message("php.annotator.clone.expects.two.args", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpConstantReference(ConstantReference constant) {
        if (PhpLangUtil.isBuiltInConstant(constant)) {
            this.highlightInfo((PsiElement)constant, PhpHighlightingData.KEYWORD);
        } else {
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
        }
    }

    public void visitPhpConstant(Constant constant) {
        if (!(constant instanceof PhpDefineImpl)) {
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
        }
    }

    public void visitPhpParameter(Parameter parameter) {
        Method method = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Method.class);
        if (method instanceof PhpDocMethod) {
            PhpDumbAwareAnnotatorVisitor.getDeclaredTypeNodes(parameter).forEach(node -> this.highlightPhpDocType((PsiElement)node, false));
            this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.DOC_PARAMETER);
            return;
        }
        if (parameter.isPromotedField()) {
            for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!PhpAnnotatorVisitor.isReadonlyKeyword(parameter.getProject(), child.getNode())) continue;
                this.highlightInfo(child.getNode(), PhpHighlightingData.KEYWORD);
            }
            this.checkCallablePropertyTypeDeclaration(parameter.getTypeDeclaration(), PhpBundle.message("php.annotator.typed.property.callable.is.illegal", 0));
            if (parameter instanceof PhpPromotedFieldParameterImpl) {
                PhpPromotedFieldParameterImpl field = (PhpPromotedFieldParameterImpl)parameter;
                this.highlightPropertyHooks(field);
                PhpDumbAwareAnnotatorVisitor.checkPropertyHooks(this.holder, field);
            }
        }
    }

    public void visitPhpFieldTypeDeclaration(PhpFieldType fieldTypeDeclaration) {
        super.visitPhpFieldTypeDeclaration(fieldTypeDeclaration);
        this.checkCallablePropertyTypeDeclaration((PhpTypeDeclaration)fieldTypeDeclaration, PhpBundle.message("php.annotator.typed.property.callable.is.illegal", fieldTypeDeclaration instanceof PhpClassConstantType ? 1 : 0));
    }

    public void visitPhpClassConstantTypeDeclaration(PhpClassConstantType classConstantTypeDeclaration) {
        super.visitPhpClassConstantTypeDeclaration(classConstantTypeDeclaration);
        this.checkCallablePropertyTypeDeclaration((PhpTypeDeclaration)classConstantTypeDeclaration, PhpBundle.message("php.annotator.typed.class.constant.callable.is.illegal", new Object[0]));
    }

    private void checkCallablePropertyTypeDeclaration(@Nullable PhpTypeDeclaration fieldTypeDeclaration, @NotNull @Nls String message) {
        if (message == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (fieldTypeDeclaration == null) {
            return;
        }
        fieldTypeDeclaration.getClassReferences().stream().filter(r -> PhpLangUtil.equalsClassNames("callable", r.getText())).forEach(r -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)r, message, new CommonIntentionAction[0]));
    }

    public void visitPhpDocType(PhpDocType type) {
        PhpDocVariable var = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)type, PhpDocVariable.class);
        if (var != null) {
            this.highlightInfo(var.getNode(), PhpHighlightingData.DOC_VAR);
        }
        PsiElement declaredTypeNode = PhpDumbAwareAnnotatorVisitor.getDeclaredTypeNode((PsiElement)type);
        this.highlightPhpDocType(declaredTypeNode, PhpDocTypeImpl.isTemplateType(type));
    }

    public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
        Collection classReferences = typeDeclaration.getClassReferences();
        for (ClassReference reference : classReferences) {
            this.highlightPrimitiveTypeHint((PsiElement)reference);
        }
    }

    private void highlightPrimitiveTypeHint(@Nullable PsiElement element) {
        PsiElement declaredTypeNode = PhpDumbAwareAnnotatorVisitor.getDeclaredTypeNode(element);
        if (declaredTypeNode != null && PhpType.isPrimitiveType((String)declaredTypeNode.getText())) {
            this.highlightInfo(declaredTypeNode.getNode(), PhpHighlightingData.PRIMITIVE_TYPE_HINT);
        }
    }

    private static List<PsiElement> getDeclaredTypeNodes(@NotNull Parameter docMethodParameter) {
        if (docMethodParameter == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        return PhpPsiUtil.getChildren((PsiElement)docMethodParameter, (Condition<? super PsiElement>)((Condition)type -> PhpPsiUtil.isOfType(type, POSSIBLE_TYPE_HINT)));
    }

    private static PsiElement getDeclaredTypeNode(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (PhpPsiUtil.isOfType(element, POSSIBLE_TYPE_HINT)) {
            return element;
        }
        return PhpPsiUtil.getChildOfType(element, POSSIBLE_TYPE_HINT);
    }

    public void visitPhpGotoLabel(PhpGotoLabel label) {
        ASTNode nameNode = label.getNameNode();
        if (nameNode != null) {
            this.highlightInfo(nameNode, PhpHighlightingData.GOTO_LABEL);
        }
    }

    @Nullable
    public static TextRange getCastKeywordRange(@NotNull PsiElement operation) {
        int start;
        if (operation == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        String text = operation.getText();
        int end = text.length() - 1;
        for (start = 1; start < text.length() - 1 && Character.isWhitespace(text.charAt(start)); ++start) {
        }
        while (end > 1 && Character.isWhitespace(text.charAt(end - 1))) {
            --end;
        }
        if (start >= end) {
            return null;
        }
        return TextRange.create((int)start, (int)end);
    }

    private void highlightDocTagNamePart(PhpDocTag tag) {
        PsiElement nextSibling;
        PsiElement firstChild;
        if (tag instanceof PhpDocMethodTag && PhpPsiUtil.isOfType(firstChild = tag.getFirstChild(), PhpTokenTypes.opSILENCE) && PhpPsiUtil.isOfType(nextSibling = firstChild.getNextSibling(), PhpTokenTypes.IDENTIFIER) && nextSibling.textMatches((CharSequence)"method")) {
            this.highlightInfo(TextRange.create((int)firstChild.getTextRange().getStartOffset(), (int)nextSibling.getTextRange().getEndOffset()), PhpHighlightingData.DOC_TAG);
        }
    }

    private void highlightPhpDocType(@Nullable PsiElement declaredTypeNode, boolean isTemplateType) {
        if (declaredTypeNode == null) {
            return;
        }
        this.highlightInfo(declaredTypeNode.getNode(), isTemplateType ? PhpHighlightingData.DOC_TEMPLATE_PARAMETER : PhpHighlightingData.DOC_IDENTIFIER);
        PsiElement attributeList = PhpPsiUtil.getChildOfType(declaredTypeNode, (IElementType)PhpDocElementTypes.phpDocAttributeList);
        this.highlightAsterisks(attributeList);
        this.highlightAsterisks(declaredTypeNode);
        this.highlightLineComment(attributeList);
    }

    private void highlightAsterisks(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiElement child = element.getFirstChild();
        while ((child = PhpDumbAwareAnnotatorVisitor.getNextLeadingAsterisk(child)) != null) {
            this.highlightInfo(child.getNode(), PhpHighlightingData.DOC_COMMENT);
        }
    }

    private void highlightLineComment(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiElement child = element.getFirstChild();
        while ((child = PhpDumbAwareAnnotatorVisitor.getNextComment(child)) != null) {
            this.highlightInfo(child.getNode(), PhpHighlightingData.COMMENT);
        }
    }

    @Nullable
    private static PsiElement getNextComment(PsiElement child) {
        return PhpPsiUtil.getNextSiblingByCondition(child, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.ARRAY_SHAPE_LINE_COMMENT)));
    }

    @Nullable
    private static PsiElement getNextLeadingAsterisk(PsiElement child) {
        return PhpPsiUtil.getNextSiblingByCondition(child, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_LEADING_ASTERISK)));
    }

    private void highlightFieldNameNode(@NotNull Field field, @Nullable ASTNode nameNode) {
        if (field == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (nameNode == null) {
            return;
        }
        if (field.isConstant()) {
            this.highlightInfo(nameNode, PhpHighlightingData.CONSTANT);
        } else {
            this.highlightInfo(nameNode, field.getModifier().isStatic() ? PhpHighlightingData.STATIC_FIELD : PhpAnnotatorVisitor.getInstanceFieldHighlightingData(field));
        }
    }

    private void highlightPropertyHooks(Field field) {
        field.getPropertyHooksList().forEach(it -> {
            ASTNode kw = it.getNode().findChildByType(PhpTokenTypes.tsPROPERTY_HOOKS_KEYWORDS);
            if (kw != null) {
                this.highlightInfo(kw, PhpHighlightingData.KEYWORD);
            }
        });
    }

    private static void checkPropertyHooks(AnnotationHolder holder, Field field) {
        if (!PhpLanguageFeature.PROPERTY_HOOKS.isSupported(field.getProject())) {
            return;
        }
        PhpClass clazz = field.getContainingClass();
        if (clazz == null) {
            return;
        }
        if (!field.hasPropertyHooksContainer()) {
            return;
        }
        List hooksList = field.getPropertyHooksList();
        PhpDumbAwareAnnotatorVisitor.checkForDuplicatedHook(holder, hooksList);
        PhpDumbAwareAnnotatorVisitor.checkForIncompatibleAbstractnessOfThePropertyHook(holder, field, hooksList, clazz);
        PhpDumbAwareAnnotatorVisitor.checkGetHookParameterList(holder, hooksList);
        PhpDumbAwareAnnotatorVisitor.checkSetHookParameterList(holder, hooksList);
    }

    private static void checkSetHookParameterList(AnnotationHolder holder, List<PhpPropertyHook> hooksList) {
        ParameterList parameterList;
        PhpPropertyHook setHook = (PhpPropertyHook)ContainerUtil.find(hooksList, (Condition)PhpPropertyHook.IS_SET_HOOK);
        if (setHook != null && (parameterList = setHook.getParameterList()) != null) {
            PsiElement defaultValue;
            ASTNode bitAnd;
            ASTNode variadic;
            if (parameterList.getParameters().length != 1) {
                String message = PhpBundle.message("php.annotator.set.hook.must.accept.exactly.one.parameter", new Object[0]);
                if (parameterList.getParameters().length == 0) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, parameterList.getPrevSibling(), message, new CommonIntentionAction[]{new PhpRemoveParameterListQuickFix(setHook)});
                } else {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)parameterList, message, new CommonIntentionAction[]{new PhpLeaveOneSetHookParameterQuickFix(setHook)});
                }
                return;
            }
            Parameter singleParameter = (Parameter)ObjectUtils.tryCast((Object)parameterList.getParameters()[0], Parameter.class);
            if (singleParameter == null) {
                return;
            }
            if (singleParameter.isVariadic() && (variadic = singleParameter.getNode().findChildByType(PhpTokenTypes.opVARIADIC)) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, variadic.getPsi(), PhpBundle.message("php.annotator.parameter.of.set.hook.must.not.be.variadic", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(variadic.getPsi())});
            }
            if (singleParameter.isPassByRef() && (bitAnd = singleParameter.getNode().findChildByType(PhpTokenTypes.opBIT_AND)) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, bitAnd.getPsi(), PhpBundle.message("php.annotator.parameter.of.set.hook.must.not.be.pass.by.ref", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(bitAnd.getPsi())});
            }
            if ((defaultValue = singleParameter.getDefaultValue()) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)singleParameter, PhpBundle.message("php.annotator.parameter.of.set.hook.must.not.have.default.value", new Object[0]), new CommonIntentionAction[]{new PhpRemoveDefaultValueQuickFix((PsiElement)singleParameter)});
            }
        }
    }

    private static void checkGetHookParameterList(AnnotationHolder holder, List<PhpPropertyHook> hooksList) {
        ParameterList parameterList;
        PhpPropertyHook getHook = (PhpPropertyHook)ContainerUtil.find(hooksList, (Condition)PhpPropertyHook.IS_GET_HOOK);
        if (getHook != null && (parameterList = getHook.getParameterList()) != null) {
            String message = PhpBundle.message("php.annotator.get.hook.must.not.have.parameter.list", new Object[0]);
            if (parameterList.getParameters().length == 0) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, parameterList.getPrevSibling(), message, new CommonIntentionAction[]{new PhpRemoveParameterListQuickFix(getHook)});
            } else {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)parameterList, message, new CommonIntentionAction[]{new PhpRemoveParameterListQuickFix(getHook)});
            }
        }
    }

    private static void checkForIncompatibleAbstractnessOfThePropertyHook(AnnotationHolder holder, Field field, List<PhpPropertyHook> hooksList, PhpClass clazz) {
        hooksList.forEach(hook -> {
            if (field.isAbstract() && clazz.isInterface() && !hook.isAbstract()) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)hook, PhpBundle.message("php.annotator.abstract.property.hook.cannot.have.a.body", new Object[0]), new CommonIntentionAction[0]);
            }
            if (!field.isAbstract() && hook.isAbstract()) {
                PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)hook, PhpBundle.message("php.annotator.non.abstract.property.hook.must.have.a.body", new Object[0]), new CommonIntentionAction[0]);
            }
        });
    }

    private static void checkForDuplicatedHook(AnnotationHolder holder, List<PhpPropertyHook> hooksList) {
        hooksList.stream().filter(PhpPropertyHook.IS_SET_HOOK).skip(1L).forEach(it -> PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)it, PhpBundle.message("php.annotator.cannot.redeclare.property.hook.0", "set"), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)it)}));
        hooksList.stream().filter(PhpPropertyHook.IS_GET_HOOK).skip(1L).forEach(it -> PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)it, PhpBundle.message("php.annotator.cannot.redeclare.property.hook.0", "get"), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)it)}));
    }

    private void highlightFunctionCall(@NotNull PhpReference reference) {
        ASTNode nameNode;
        if (reference == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        if ((nameNode = reference.getNameNode()) != null) {
            if (PhpCompletionContributor.PHP_PREDEFINED_FUNCTIONS.contains(nameNode.getText())) {
                this.highlightInfo(nameNode, PhpHighlightingData.PREDEFINED_SYMBOL);
            } else {
                this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION_CALL);
            }
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        if (element instanceof LeafPsiElement) {
            PsiElement grandParent;
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER) && "match".equalsIgnoreCase(element.getText()) && PhpLanguageFeature.MATCH_EXPRESSION.isSupported(element.getProject()) && !PhpDumbAwareAnnotatorVisitor.isAllowedKeywordAsIdentifierContext(element)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("cannot.use.match.as.identifier", new Object[0]), new CommonIntentionAction[0]);
            }
            if (PhpAnnotatorVisitor.isReadonlyKeyword(element.getProject(), element.getNode()) && !PhpDumbAwareAnnotatorVisitor.isAllowedReadonlyKeywordAsIdentifierContext(element)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("cannot.use.readonly.as.identifier", new Object[0]), new CommonIntentionAction[0]);
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.PHP_CLOSING_TAG) && "__halt_compiler();".equals(element.getText()) && !((grandParent = element.getParent().getParent()) instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("halt.compiler.can.only.be.used.from.the.outermost.scope", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        super.visitPhpGroupStatement(groupStatement);
        PsiElement child = groupStatement.getFirstChild();
        if (PhpPsiUtil.isOfType(child, PhpElementTypes.EMPTY_INPUT)) {
            this.holder.newAnnotation(HighlightSeverity.WEAK_WARNING, PhpBundle.message("inspection.message.code.fragment.too.complex.to.parse.this.piece.code.will.be.treated.as.plain.text", new Object[0])).range(child).create();
        }
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        PsiElement parent;
        super.visitPhpNamespace(namespace);
        this.highlightInfo(namespace.getNameNode(), PhpHighlightingData.IDENTIFIER);
        this.checkControlFlow((PhpScopeHolder)namespace);
        PsiElement firstChild = namespace.getFirstChild();
        PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true);
        if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.kwNAMESPACE)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nextSibling, PhpBundle.message("namespace.cannot.start.with.namespace.due.to.conflict.with.ns.relative.names", new Object[0]), new CommonIntentionAction[0]);
        }
        if ("\\".equals(namespace.getFQN()) && !namespace.isBraced() && firstChild != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, PhpBundle.message("global.namespace.should.use.braced.syntax", new Object[0]), new CommonIntentionAction[0]);
        }
        if (!((parent = namespace.getParent()) instanceof GroupStatement && parent.getParent() instanceof PhpFile || firstChild == null)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, PhpBundle.message("namespace.declarations.cannot.be.nested", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        super.visitPhpAssignmentExpression(expr);
        this.checkIsVariableAssignable((PsiElement)expr.getVariable());
    }

    private void checkIsVariableAssignable(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE)) {
            this.checkIsVariableAssignable((PsiElement)((PhpPsiElement)element).getFirstPsiChild());
        } else if (element instanceof AssignmentExpression) {
            this.checkIsVariableAssignable((PsiElement)((AssignmentExpression)element).getVariable());
            this.checkIsVariableAssignable((PsiElement)((AssignmentExpression)element).getValue());
        } else if (element instanceof Variable && PhpLangUtil.equalsVariableNames("this", ((Variable)element).getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("this.reassignment.is.not.allowed", new Object[0]), new CommonIntentionAction[0]);
        } else if (PhpDumbAwareAnnotatorVisitor.isTemporaryExpression(element)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("cant.use.temporary.expression.in.write.context", new Object[0]), new CommonIntentionAction[0]);
        } else if (!PhpAnnotatorVisitor.isAssignable(element)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("expression.is.not.assignable", new Object[0]), new CommonIntentionAction[0]);
        } else if (element instanceof MemberReference && ((MemberReference)element).hasNullSafeDereference()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("can.t.use.nullsafe.operator.in.write.context", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpExpression(PhpExpression expression) {
        super.visitPhpExpression(expression);
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER)) {
            String text;
            PsiElement child;
            if (expression.getText().contains("__")) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("multiple.subsequent.underscores.in.a.numeric.literal.are.not.allowed", new Object[0]), new CommonIntentionAction[]{new PhpSquashRepetitiveUnderscoresWithSingleOneQuickFix(expression)});
            }
            if (PhpPsiUtil.isOfType(child = expression.getFirstChild(), PhpTokenTypes.OCTAL_INTEGER) && ((text = PhpPsiUtil.getLiteralText((PsiElement)expression)).indexOf(56) >= 0 || text.indexOf(57) >= 0)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("invalid.octal.literal.won.t.be.reported.by.php.but.will.work.incorrectly", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        boolean multiAssignmentVariable;
        super.visitPhpArrayCreationExpression(expression);
        MultiassignmentExpression parent = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)expression, false, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        boolean bl = multiAssignmentVariable = parent != null && PsiTreeUtil.isAncestor((PsiElement)parent.getFirstPsiChild(), (PsiElement)expression, (boolean)false);
        if (!multiAssignmentVariable) {
            boolean expectedDelimiter = false;
            for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opCOMMA)) {
                    if (!expectedDelimiter) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("cannot.use.empty.array.elements.in.arrays", new Object[0]), new CommonIntentionAction[0]);
                    }
                    expectedDelimiter = false;
                    continue;
                }
                if (!(child instanceof ArrayHashElement) && !PhpPsiUtil.isOfType(child, PhpElementTypes.ARRAY_VALUE) && !PhpPsiUtil.isOfType(child, PhpTokenTypes.opVARIADIC)) continue;
                expectedDelimiter = true;
            }
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        super.visitPhpArrayAccessExpression(expression);
        ArrayIndex index = expression.getIndex();
        if (index != expression.getValue() && (index == null || index.getTextLength() == 0)) {
            PsiElement parent = expression.getParent();
            if (parent instanceof ArrayAccessExpression || parent instanceof MultiassignmentExpression || parent instanceof ParameterList || parent instanceof FieldReference) {
                return;
            }
            AssignmentExpression assignmentExpression = (AssignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (assignmentExpression != null) {
                PsiElement parentOfParent;
                Collection<Object> variables;
                Collection<Object> collection = variables = assignmentExpression instanceof MultiassignmentExpression ? ((MultiassignmentExpression)assignmentExpression).getVariables() : Collections.singleton(assignmentExpression.getVariable());
                if (variables.contains(expression)) {
                    return;
                }
                if (assignmentExpression.getValue() == expression && (parentOfParent = parent.getParent()) instanceof AssignmentExpression && ((AssignmentExpression)parentOfParent).getVariable() == parent) {
                    return;
                }
                if (PhpWorkaroundUtil.isAssignByReference(assignmentExpression)) {
                    return;
                }
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("cannot.use.for.reading", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        super.visitPhpUnaryExpression(expr);
        ASTNode node = expr.getNode();
        PhpPsiElement value = expr.getValue();
        if (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == PhpElementTypes.CAST_EXPRESSION) {
                PsiElement operation = expr.getOperation();
                if (operation == null) {
                    return;
                }
                TextRange castKeywordRange = PhpDumbAwareAnnotatorVisitor.getCastKeywordRange(operation);
                if (castKeywordRange == null) {
                    return;
                }
                TextRange rangeToHighlight = castKeywordRange.shiftRight(operation.getTextRange().getStartOffset());
                this.highlightInfo(rangeToHighlight, PhpHighlightingData.PRIMITIVE_TYPE_HINT);
            }
            if (value != null && PhpPsiUtil.isOfType(expr.getOperation(), com.jetbrains.php.lang.parser.parsing.expressions.UnaryExpression.INC_DEC_OPERATORS)) {
                this.checkIsVariableAssignable((PsiElement)value);
            }
        }
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        PsiElement rightOperand;
        super.visitPhpBinaryExpression(expression);
        if (expression instanceof ConcatenationExpression && !(expression.getParent() instanceof ConcatenationExpression)) {
            this.highlightInfo((PsiElement)expression, PhpHighlightingData.PHP_CONCATENATION);
        }
        if (expression.getOperationType() == PhpTokenTypes.kwINSTANCEOF && (rightOperand = expression.getRightOperand()) != null) {
            if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.CLASS_REFERENCE)) {
                this.highlightInfo(rightOperand.getNode(), PhpHighlightingData.CLASS);
            }
            if (PhpDumbAwareAnnotatorVisitor.isFunction(rightOperand)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, rightOperand, PhpBundle.message("function.call.is.not.allowed.here", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)expression);
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        super.visitPhpMultiassignmentExpression(multiassignmentExpression);
        PhpPsiElement child = multiassignmentExpression.getFirstPsiChild();
        this.checkFullSyntaxArrayDestructing(child);
        List variables = multiassignmentExpression.getVariables();
        if (variables.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)(child instanceof ArrayCreationExpression ? child : multiassignmentExpression.getFirstChild()), PhpBundle.message("cannot.use.empty.list", new Object[0]), new CommonIntentionAction[0]);
        }
        for (PhpPsiElement expression : variables) {
            this.checkIsVariableAssignable((PsiElement)expression);
        }
        Collection<PhpPsiElement> keyedEntries = PhpAnnotatorVisitor.getKeyedEntries(variables);
        if (!keyedEntries.isEmpty()) {
            for (PhpPsiElement variable : variables) {
                if (keyedEntries.contains(variable)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("cannot.mix.keyed.and.unkeyed.array.entries.in.assignments", new Object[0]), new CommonIntentionAction[0]);
            }
            this.checkEmptyEntries(multiassignmentExpression, child);
        }
        PhpAnnotatorVisitor.checkSameArrayStyle(this.holder, (PhpPsiElement)(child instanceof ArrayCreationExpression ? child : multiassignmentExpression));
    }

    public void visitPhpVariable(Variable variable) {
        super.visitPhpVariable(variable);
        if (VariableImpl.isVariableVariable(variable)) {
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, PhpBundle.message("annotation.variable.variable", new Object[0])).textAttributes(PhpHighlightingData.VAR_VAR).create();
        } else {
            Function fun = PhpPsiUtil.getParentOfClass((PsiElement)variable, Function.class);
            if (fun != null) {
                for (Parameter parameter : fun.getParameters()) {
                    if (!PhpLangUtil.equalsVariableNames(parameter.getNameCS(), variable.getNameCS())) continue;
                    this.highlightInfo(variable.getNameNode(), PhpHighlightingData.PARAMETER);
                    break;
                }
            }
        }
        if (PhpLangUtil.equalsVariableNames("this", variable.getName())) {
            this.highlightInfo(variable.getNode(), PhpHighlightingData.THIS_VAR);
        }
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        super.visitPhpFunctionCall(reference);
        if (StringUtil.isEmpty((String)reference.getName())) {
            long childrenCount;
            PhpPsiElement name = reference.getFirstPsiChild();
            if (name instanceof ArrayCreationExpression && (childrenCount = ArrayCreationExpressionImpl.children((ArrayCreationExpression)name).stream().count()) != 2L) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)name, PhpBundle.message("array.callback.must.have.exactly.two.elements", new Object[0]), new CommonIntentionAction[0]);
            }
        } else {
            this.highlightFunctionCall((PhpReference)reference);
        }
    }

    public void visitPhpParameterList(ParameterList list) {
        ParameterListOwner owner;
        super.visitPhpParameterList(list);
        if (!(list.getParent() instanceof PhpAttribute || list.getParent() instanceof NewExpression && PhpAnnotatorVisitor.hasOnlyVariadicOperator((PhpPsiElement)list))) {
            PhpAnnotatorVisitor.reportIncompleteSpreadOperators((PsiElement)list, this.holder);
        }
        if ((owner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class)) == null) {
            return;
        }
        for (ParameterListImpl.PhpNamedArgumentPart range : ((ParameterListImpl)list).getNamedArgumentsParts()) {
            this.highlightInfo(range.getNameIdentifier().getNode(), PhpHighlightingData.NAMED_ARGUMENT);
            PsiElement colon = range.getColon();
            this.highlightInfo(colon.getNode(), PhpHighlightingData.NAMED_ARGUMENT);
            PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(colon, true);
            if (!PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.opVARIADIC)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nextSibling, PhpBundle.message("spread.operator.on.named.arguments.is.forbidden", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        PsiElement[] children;
        super.visitPhpIsset(issetExpression);
        for (PsiElement param : children = issetExpression.getChildren()) {
            if (PhpDumbAwareAnnotatorVisitor.allowedForIssetCheck(param)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, param, PhpBundle.message("isset.only.works.with.variables.and.arrays", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithNullCheckQuickFix(issetExpression)});
        }
    }

    public void visitPhpFieldReference(FieldReference reference) {
        PsiElement parent;
        super.visitPhpFieldReference(reference);
        ASTNode nameNode = reference.getNameNode();
        if (!(nameNode == null || (parent = nameNode.getPsi().getParent()) instanceof Variable && VariableImpl.isVariableVariable((Variable)parent) || FieldReferenceImpl.isClassNameLiteral((MemberReference)reference) || !reference.getReferenceType().isStatic())) {
            this.highlightInfo(nameNode, PhpHighlightingData.STATIC_FIELD);
        }
        this.checkCorrectNullsafeDereferencing((MemberReference)reference);
    }

    public void visitPhpMethodReference(MethodReference reference) {
        super.visitPhpMethodReference(reference);
        this.checkCorrectNullsafeDereferencing((MemberReference)reference);
        this.checkPropertyHookReferenceCall(reference);
    }

    private void checkPropertyHookReferenceCall(MethodReference reference) {
        PhpPropertyHook.PhpPropertyHookType callType;
        String methodName;
        FieldReference fieldReference = MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(reference.getClassReference());
        if (fieldReference == null) {
            return;
        }
        PhpPropertyHook hook = (PhpPropertyHook)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpPropertyHook.INSTANCEOF, (Condition<? super PsiElement>)Field.INSTANCEOF);
        if (hook == null) {
            return;
        }
        Field field = hook.getContainingField();
        if (field == null) {
            return;
        }
        String fieldNameFromCall = fieldReference.getName();
        if (fieldNameFromCall == null) {
            return;
        }
        String fieldName = field.getName();
        if (!fieldName.equalsIgnoreCase(fieldNameFromCall)) {
            PsiElement psiElementToRegisterProblem = PhpDumbAwareAnnotatorVisitor.getIdentifier((PhpReference)fieldReference);
            if (psiElementToRegisterProblem == null) {
                return;
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, psiElementToRegisterProblem, PhpBundle.message("php.annotator.must.not.call.0.in.different.property", fieldNameFromCall, fieldName), new CommonIntentionAction[0]);
        }
        if ((methodName = reference.getName()) == null) {
            return;
        }
        Object object = methodName.equalsIgnoreCase("get") ? PhpPropertyHook.PhpPropertyHookType.GET : (callType = methodName.equalsIgnoreCase("set") ? PhpPropertyHook.PhpPropertyHookType.SET : null);
        if (callType == null) {
            return;
        }
        PhpPropertyHook.PhpPropertyHookType hookType = hook.getHookType();
        if (hookType != callType) {
            PsiElement psiElementToRegisterProblem = PhpDumbAwareAnnotatorVisitor.getIdentifier((PhpReference)reference);
            if (psiElementToRegisterProblem == null) {
                return;
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, psiElementToRegisterProblem, PhpBundle.message("php.annotator.must.not.call.0.in.hook.1", callType.keyWord, hookType.keyWord), new CommonIntentionAction[0]);
        }
    }

    @Nullable
    private static PsiElement getIdentifier(PhpReference reference) {
        ASTNode nodeToRegisterProblem = reference.getNameNode();
        if (nodeToRegisterProblem == null) {
            return null;
        }
        return nodeToRegisterProblem.getPsi();
    }

    public void visitPhpFile(PhpFile file) {
        super.visitPhpFile(file);
        this.checkControlFlow((PhpScopeHolder)file);
        file.accept((PsiElementVisitor)new PhpDeclarationDuplicateCheckerVisitor());
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)file, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        this.checkNamespaceSyntax(groupStatement);
    }

    public void visitPhpClassReference(ClassReference classReference) {
        Object element;
        super.visitPhpClassReference(classReference);
        String referenceText = classReference.getText();
        if ("self".equalsIgnoreCase(referenceText) || "parent".equalsIgnoreCase(referenceText) || "static".equalsIgnoreCase(referenceText)) {
            this.highlightInfo(classReference.getNode(), PhpHighlightingData.KEYWORD);
        } else if (PhpTargetElementEvaluator.getElementByReference((PsiReference)classReference) != null) {
            this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.ALIAS_REFERENCE);
        } else {
            PsiElement parent = classReference.getParent();
            IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
            if (parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.FIELD_REFERENCE || parentType == PhpElementTypes.CLASS_CONSTANT_REFERENCE) {
                this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.CLASS);
            }
        }
        if ("static".equalsIgnoreCase(referenceText) && (element = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element1 -> PhpPsiUtil.isOfType(element1, COMPILE_TIME_CONSTANTS)), (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) != null && !(classReference.getParent() instanceof PhpClassConstantType)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, classReference.getNode(), PhpBundle.message("static.is.not.allowed.in.compile.time.constants", new Object[0]));
        }
        if (PhpTokenTypes.kwLIST.toString().equalsIgnoreCase(referenceText) && PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpDocComment.class) == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, classReference.getNode(), PhpBundle.message("list.is.not.allowed.as.class.reference", new Object[0]));
        }
    }

    public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
        super.visitPhpNamespaceReference(reference);
        PsiReference firstReference = (PsiReference)ArrayUtil.getFirstElement((Object[])reference.getReferences());
        if (firstReference != null && PhpTargetElementEvaluator.getElementByReference(firstReference) != null) {
            this.highlightInfo(reference.getFirstChild().getNode(), PhpHighlightingData.ALIAS_REFERENCE);
        }
    }

    public void visitPhpUseList(PhpUseList useList) {
        PsiElement grandParent;
        super.visitPhpUseList(useList);
        PsiElement parent = useList.getParent();
        PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof Function) && !(parent instanceof PhpClass) && !(parent instanceof GroupStatement) || parent instanceof GroupStatement && !(grandParent instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)useList, PhpBundle.message("the.use.keyword.must.be.declared.in.the.outermost.scope.of.a.file.the.global.scope.or.inside.namespace.declarations", new Object[0]), new CommonIntentionAction[0]);
        }
        if (parent instanceof Function && ((Function)parent).isClosure()) {
            HashSet<String> usedVariableNames = new HashSet<String>();
            for (Variable variable : PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF)) {
                if (!usedVariableNames.add(variable.getName())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("duplicate.variable.0", variable.getText()), new CommonIntentionAction[]{new PhpRemoveVariableIntention(variable)});
                }
                if (PhpAnnotatorVisitor.canBeUsedAsLexicalVariable(variable)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("cannot.use.0.as.lexical.variable", variable.getName()), new CommonIntentionAction[0]);
            }
        }
    }

    public void visitPhpUse(PhpUse expression) {
        super.visitPhpUse(expression);
        PhpReference reference = expression.getTargetReference();
        if (reference != null) {
            String alias;
            if (reference.getImmediateNamespaceName().startsWith("\\") && PhpPsiUtil.getParentByCondition((PsiElement)expression, PhpUseImpl.USE_BRACES_CONDITION, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("absolute.reference.is.not.allowed", new Object[0]), new CommonIntentionAction[0]);
            }
            if (PhpLangUtil.isPhpReservedClassName(alias = expression.getAliasName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNameNode(), PhpBundle.message("annotator.special.class.name", reference.getText(), alias));
            }
        }
    }

    public void visitPhpClass(PhpClass clazz) {
        super.visitPhpClass(clazz);
        ASTNode nameNode = clazz.getNameNode();
        String className = clazz.getName();
        boolean anInterface = clazz.isInterface();
        if (clazz.isReadonly()) {
            this.highlightInfo(FieldImpl.getReadonlyKeyword((PsiElement)clazz), PhpHighlightingData.KEYWORD);
        }
        this.highlightInfo(nameNode, anInterface ? PhpHighlightingData.INTERFACE : PhpHighlightingData.CLASS);
        if (PhpLangUtil.isPhpReservedClassName(className)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("annotator.reserved.class.name", className));
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)clazz, true, PhpClass.class) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("class.declarations.may.not.be.nested", new Object[0]));
        }
    }

    public void visitPhpFunction(Function function) {
        super.visitPhpFunction(function);
        this.checkControlFlow((PhpScopeHolder)function);
        ASTNode nameNode = function.getNameNode();
        if (!function.isClosure()) {
            PsiElement parent;
            this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
            PsiElement staticKeyword = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwSTATIC);
            if (staticKeyword != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, staticKeyword, PhpBundle.message("anonymous.function.expected", new Object[0]), new CommonIntentionAction[0]);
            }
            if ((parent = function.getParent()) instanceof PhpExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && nameNode != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("anonymous.function.expected", new Object[0]));
            }
        }
    }

    public void visitPhpMethod(Method method) {
        CharSequence name;
        this.checkControlFlow((PhpScopeHolder)method);
        if (method instanceof PhpPropertyHook) {
            return;
        }
        ASTNode nameNode = method.getNameNode();
        this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
        PhpClass clazz = method.getContainingClass();
        boolean hasBody = PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class) != null;
        boolean isAbstract = method.isAbstract();
        if ((!isAbstract && !hasBody || isAbstract && hasBody) && nameNode != null) {
            if (clazz != null && clazz.isInterface() && hasBody) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("interface.method.can.t.have.body", new Object[0]));
            } else {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("method.should.either.have.body.or.be.abstract", new Object[0]));
            }
        }
        PsiElement last = method.getLastChild();
        if (!method.isAbstract() && last instanceof LeafPsiElement && Objects.equals(last.getText(), ";")) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, last, PhpBundle.message("method.should.not.be.finished.with", new Object[0]), new CommonIntentionAction[0]);
        }
        if (PhpAnnotatorVisitor.isForbiddenEnumMethodName(name = method.getNameCS()) && clazz != null && clazz.isEnum() && nameNode != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode.getTextRange(), PhpBundle.message("enum.may.not.include.0", name), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)method, PhpBundle.message("quick.fix.delete", name))});
        }
        if (nameNode != null && PhpLangUtil.equalsMethodNames("__clone", method.getNameCS()) && method.getParameters().length != 0) {
            ParameterList parameters = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            assert (parameters != null);
            String className = clazz != null ? clazz.getName() : "";
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameters, PhpBundle.message("method.0.clone.cannot.accept.any.arguments", className), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpField(Field field) {
        super.visitPhpField(field);
        PhpClass aClass = field.getContainingClass();
        assert (aClass != null);
        ASTNode nameNode = field.getNameNode();
        this.highlightFieldNameNode(field, nameNode);
        if (field.isConstant()) {
            this.checkClassConstantNamedClass(nameNode);
        }
        if (field.isReadonly() && field.getTypeDeclaration() == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("readonly.property.must.have.type", new Object[0]));
        }
        if (field.isPropertyWithAsymmetricVisibility() && field.getTypeDeclaration() == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("php.annotator.property.with.asymmetric.visibility.must.have.type", new Object[0]));
        }
        if (field.isPropertyWithAsymmetricVisibility() && field.getModifier().isStatic()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("php.annotator.static.property.may.not.have.asymmetric.visibility", new Object[0]));
        }
        this.highlightPropertyHooks(field);
        PhpDumbAwareAnnotatorVisitor.checkPropertyHooks(this.holder, field);
    }

    public void visitPhpEnumCase(PhpEnumCase enumCase) {
        super.visitPhpEnumCase(enumCase);
        ASTNode nameNode = enumCase.getNameNode();
        this.highlightInfo(nameNode, PhpHighlightingData.CONSTANT);
        PhpClass containingClass = enumCase.getContainingClass();
        if (containingClass != null && !containingClass.isEnum()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)enumCase, PhpBundle.message("enum.case.should.be.located.only.inside.enum.classes", new Object[0]), new CommonIntentionAction[]{new PhpMakeClassEnumQuickFix(containingClass), new PhpDeleteElementQuickFix((PsiElement)enumCase)});
        }
        this.checkClassConstantNamedClass(nameNode);
    }

    public void visitPhpBreak(@NotNull PhpBreak breakStatement) {
        if (breakStatement == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        super.visitPhpBreak(breakStatement);
        PhpDumbAwareAnnotatorVisitor.checkBreakOrContinue(this.holder, (StatementWithArgument)breakStatement);
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        super.visitPhpContinue(continueStatement);
        PhpDumbAwareAnnotatorVisitor.checkBreakOrContinue(this.holder, (StatementWithArgument)continueStatement);
    }

    public void visitPhpYield(PhpYield element) {
        Function function;
        super.visitPhpYield(element);
        LeafPsiElement from = PhpYieldImpl.getFrom(element);
        if (from != null) {
            this.highlightInfo(from.getNode(), PhpHighlightingData.KEYWORD);
        }
        if ((function = PhpPsiUtil.getParentOfClass((PsiElement)element, Function.class)) == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("the.yield.expression.can.only.be.used.inside.a.function", new Object[0]), new CommonIntentionAction[0]);
        } else if (function.isReturningByReference() && from != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (ASTNode)from, PhpBundle.message("cannot.use.yield.from.inside.a.by.reference.generator", new Object[0]));
        }
    }

    public void visitPhpStatement(Statement statement) {
        super.visitPhpStatement(statement);
        if (statement instanceof Declare) {
            if (DeclareImpl.getStrictTypesDirective((Declare)((Declare)statement)) != null) {
                if (!PhpAnnotatorVisitor.allowedPlaceForStrictTypesDeclareStatement((PsiElement)statement)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.first.statement", new Object[0]), new CommonIntentionAction[0]);
                } else if (statement.getLastChild() instanceof GroupStatement) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.block.mode", new Object[0]), new CommonIntentionAction[0]);
                }
                PhpExpression value = PhpCodeInsightUtil.getStrictTypeDirectiveValue((Declare)statement);
                if (value != null && !"1".equals(value.getText()) && !"0".equals(value.getText())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, PhpBundle.message("strict.types.declaration.must.have.0.or.1.as.its.value", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithCorrectStrictTypeValueQuickFix((PsiElement)value, 0), new PhpReplaceWithCorrectStrictTypeValueQuickFix((PsiElement)value, 1)});
                }
            }
            this.checkSupportedDirectiveNames(statement);
        }
    }

    public void visitPhpForeach(ForeachStatement foreach) {
        super.visitPhpForeach(foreach);
        Variable key = foreach.getKey();
        this.checkIsVariableAssignable((PsiElement)key);
        this.checkIsVariableAssignable((PsiElement)((ForeachImpl)foreach).getValueExpression());
        PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)key, true);
        if (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.opBIT_AND)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("inspection.message.key.element.cannot.be.reference", new Object[0])).range(TextRange.create((int)prevSibling.getTextRange().getStartOffset(), (int)key.getTextRange().getEndOffset())).withFix((CommonIntentionAction)new PhpDeleteElementQuickFix(prevSibling, PhpBundle.message("remove.pass.by.ref.sign", new Object[0]))).create();
        }
        this.checkEmptyListInIteratedValue(foreach);
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        super.visitPhpUnset(unsetStatement);
        for (PhpPsiElement argument : unsetStatement.getArguments()) {
            if (argument instanceof FieldReference && ((FieldReference)argument).isStatic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("static.property.cannot.be.unset", new Object[0]), new CommonIntentionAction[0]);
                continue;
            }
            this.checkIsVariableAssignable((PsiElement)argument);
        }
    }

    public void visitPhpDocTag(PhpDocTag tag) {
        super.visitPhpDocTag(tag);
        this.highlightDocTagNamePart(tag);
        PhpDocRef[] refs = (PhpDocRef[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, PhpDocRef.class);
        if (refs != null) {
            for (PhpDocRef ref : refs) {
                if (PhpDocRefImpl.hasDocPathSymbols(ref)) continue;
                this.highlightInfo(ref.getNode(), PhpHighlightingData.DOC_IDENTIFIER);
            }
        }
        if (tag instanceof PhpDocMethodTag) {
            for (PsiElement docMethodType : (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)tag).filter(e -> PhpPsiUtil.isOfType(e, (IElementType)PhpDocElementTypes.phpDocMethodType))) {
                this.highlightPhpDocType(docMethodType, false);
            }
        }
        String name = tag.getName();
        PhpDocVariable var = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)tag, PhpDocVariable.class);
        if (var != null) {
            this.highlightInfo(var.getNode(), "@param".equalsIgnoreCase(name) ? PhpHighlightingData.DOC_PARAMETER : PhpHighlightingData.DOC_VAR);
        }
    }

    public void visitPhpElement(PhpPsiElement element) {
        PsiElement parent;
        if (element instanceof PhpDocTemplateParameter) {
            PhpDocTemplateParameter parameter = (PhpDocTemplateParameter)element;
            this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.DOC_TEMPLATE_PARAMETER);
            this.checkTemplateParameterShadowing(parameter);
        }
        if (element instanceof PhpDocMethod) {
            this.highlightInfo(((PhpDocMethod)element).getNameNode(), PhpHighlightingData.DOC_METHOD_IDENTIFIER);
        }
        if (element instanceof PhpDocProperty) {
            this.highlightInfo(((PhpDocProperty)element).getNameNode(), PhpHighlightingData.DOC_PROPERTY_IDENTIFIER);
        }
        if (!(element instanceof PhpNamespace) && !(element instanceof PhpDocComment) && (element.getPrevPsiSibling() instanceof PhpNamespace || !PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.DECLARE, PhpElementTypes.HTML) && element.getNextPsiSibling() instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("global.code.should.be.enclosed.in.global.namespace.declaration", new Object[0]), new CommonIntentionAction[0]);
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.HTML) && PhpPsiUtil.getPrevSiblingByCondition((PsiElement)element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.HTML))) == null && (parent = element.getParent()) instanceof GroupStatement && parent.getParent() instanceof PhpFile && !PhpAnnotatorVisitor.isShebang((PsiElement)element) && PhpPsiUtil.getNextSiblingByCondition((PsiElement)element, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("no.content.allowed.before.namespace.declaration", new Object[0]), new CommonIntentionAction[0]);
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.CLASS_REFERENCES_GROUP) && PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.CLASS_REFERENCES_GROUP)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("nested.type.groups.are.not.allowed", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    public void visitPhpClassFieldsList(PhpClassFieldsList classFieldsList) {
        super.visitPhpClassFieldsList(classFieldsList);
        Field field = (Field)ContainerUtil.getFirstItem((Collection)classFieldsList.getFields());
        if (field == null) {
            return;
        }
        PhpModifierList modifierList = classFieldsList.getModifierList();
        if (modifierList == null) {
            return;
        }
        ASTNode[] nodes = modifierList.getNode().getChildren(null);
        Project project = classFieldsList.getProject();
        for (ASTNode node : nodes) {
            if (!PhpAnnotatorVisitor.isReadonlyKeyword(project, node)) continue;
            this.highlightInfo(node, PhpHighlightingData.KEYWORD);
        }
        PhpAnnotatorVisitor.checkMemberModifiers((PhpClassMember)field, modifierList, this.holder);
        PhpClass containingClass = field.getContainingClass();
        if (!(classFieldsList instanceof PhpClassConstantsListImpl) && containingClass != null && containingClass.isEnum()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classFieldsList, PhpBundle.message("enums.may.not.include.properties", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)classFieldsList)});
        }
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        super.visitPhpMatchExpression(matchExpression);
        this.highlightInfo(matchExpression.getFirstChild().getNode(), PhpHighlightingData.KEYWORD);
        this.checkConditionToBodySeparator(matchExpression);
        this.checkDefaultArms(matchExpression);
    }

    public void visitPhpAttributesList(PhpAttributesList attributesList) {
        this.highlightInfo(attributesList.getFirstChild().getNode(), PhpHighlightingData.ATTRIBUTE);
        this.highlightInfo(attributesList.getLastChild().getNode(), PhpHighlightingData.ATTRIBUTE);
        PsiElement parent = attributesList.getParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CONSTANTS) && PhpPsiUtil.getChildren(parent, (Condition<? super PsiElement>)Constant.INSTANCEOF).size() > 1) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attributesList, PhpBundle.message("inspection.php.cannot.apply.to.multiple.constants", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)attributesList)});
        }
        Condition[] conditionArray = new Condition[3];
        conditionArray[0] = PsiWhiteSpace.class::isInstance;
        conditionArray[1] = PsiComment.class::isInstance;
        conditionArray[2] = PhpAttributesList.class::isInstance;
        PsiElement prevInvalidSibling = PhpPsiUtil.getPrevSibling((PsiElement)attributesList, conditionArray);
        if (prevInvalidSibling != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attributesList, PhpBundle.message("attribute.must.be.first.child.of.parent.element", new Object[0]), new CommonIntentionAction[]{new PhpMoveAttributeToStartOfElementQuickFix(attributesList)});
        }
    }

    public void visitPhpAttribute(PhpAttribute attribute) {
        PsiElement child;
        PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chLPAREN);
        PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chRPAREN);
        TextRange attributeTextRange = attribute.getTextRange();
        if (lParen != null && rParen != null) {
            TextRange rRange;
            PsiElement attributesList = attribute.getParent();
            TextRange lRange = TextRange.create((int)attributeTextRange.getStartOffset(), (int)lParen.getTextRange().getStartOffset());
            if (!(lRange.isEmpty() ? lRange.grown(1) : lRange).equals((Object)attributesList.getFirstChild().getNode().getTextRange())) {
                this.highlightInfo(lRange, PhpHighlightingData.ATTRIBUTE);
            }
            if (!((rRange = TextRange.create((int)rParen.getTextRange().getEndOffset(), (int)attributeTextRange.getEndOffset())).isEmpty() ? rRange.grown(1) : rRange).equals((Object)attributesList.getLastChild().getNode().getTextRange())) {
                this.highlightInfo(rRange, PhpHighlightingData.ATTRIBUTE);
            }
        } else {
            this.highlightInfo(attributeTextRange, PhpHighlightingData.ATTRIBUTE);
        }
        ParameterList list = attribute.getParameterList();
        PsiElement psiElement = child = list != null ? list.getFirstChild() : null;
        while (child != null) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opVARIADIC)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("cannot.use.unpacking.in.attribute.argument.list", new Object[0]), new CommonIntentionAction[0]);
            }
            child = child.getNextSibling();
        }
        if (PhpLangUtil.equalsClassNames("\\AllowDynamicProperties", attribute.getFQN())) {
            this.checkValidAllowDynamicPropertiesAttributeOwner(attribute);
        }
    }

    public void visitPhpCase(PhpCase phpCase) {
        List expressions = PhpPsiUtil.getChildren((PsiElement)phpCase, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
        if (expressions.size() <= 1) {
            return;
        }
        PsiElement prevComma = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)expressions.get(1), true);
        if (prevComma == null) {
            return;
        }
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)prevComma.getTextRange().getStartOffset(), (int)((PsiElement)ContainerUtil.getLastItem(expressions)).getTextRange().getEndOffset()), PhpBundle.message("invalid.syntax.for.multiple.case.expressions", new Object[0]), new CommonIntentionAction[]{PhpSplitIntoSeparateCasesQuickFix.INSTANCE});
    }

    private void checkValidAllowDynamicPropertiesAttributeOwner(PhpAttribute attribute) {
        PsiElement owner = attribute.getOwner();
        if (!(owner instanceof PhpClass)) {
            return;
        }
        PhpClass phpClass = (PhpClass)owner;
        if (phpClass.isTrait()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attribute, PhpBundle.message("cannot.apply.0.to.trait", PhpDynamicFieldDeclarationInspection.ALLOW_DYNAMIC_PROPERTIES_ATTRIBUTE_TEXT), new CommonIntentionAction[]{new PhpRemoveAttributeQuickFix(attribute)});
        } else if (phpClass.isInterface()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attribute, PhpBundle.message("cannot.apply.0.to.interface", PhpDynamicFieldDeclarationInspection.ALLOW_DYNAMIC_PROPERTIES_ATTRIBUTE_TEXT), new CommonIntentionAction[]{new PhpRemoveAttributeQuickFix(attribute)});
        } else if (phpClass.isReadonly()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attribute, PhpBundle.message("cannot.apply.0.to.readonly.class", PhpDynamicFieldDeclarationInspection.ALLOW_DYNAMIC_PROPERTIES_ATTRIBUTE_TEXT), new CommonIntentionAction[]{new PhpRemoveAttributeQuickFix(attribute)});
        }
    }

    private void checkConditionToBodySeparator(@NotNull PhpMatchExpression matchExpression) {
        if (matchExpression == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        for (PhpMatchArm arm : ((PhpMatchExpressionImpl)matchExpression).getAllMatchArms()) {
            SyntaxTraverser.psiApi().children((Object)arm).filter(e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOLON)).forEach(opColon -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, opColon, PhpBundle.message("invalid.condition.to.body.separator.should.be.used", new Object[0]), new CommonIntentionAction[]{new PhpReplaceWithOpHashFix((PsiElement)opColon)}));
        }
    }

    private void checkDefaultArms(@NotNull PhpMatchExpression matchExpression) {
        if (matchExpression == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        List<PhpDefaultMatchArm> defaultArms = PhpPsiUtil.getChildren((PsiElement)matchExpression, (Condition<? super PsiElement>)((Condition)PhpDefaultMatchArm.class::isInstance));
        for (PhpDefaultMatchArm defaultArm : defaultArms) {
            List defaultKeywords = ContainerUtil.map((Object[])defaultArm.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwDEFAULT})), ASTNode::getPsi);
            PsiElement firstDefaultKeyword = (PsiElement)ContainerUtil.getFirstItem((List)defaultKeywords);
            if (firstDefaultKeyword == null) continue;
            for (PsiElement condition : ContainerUtil.concat((List)defaultArm.getConditions(), (List)defaultKeywords)) {
                if (condition == firstDefaultKeyword) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, condition, PhpBundle.message("annotator.only.default.condition.allowed", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix(condition, PhpTokenTypes.opCOMMA)});
            }
            if (defaultArms.size() <= 1) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstDefaultKeyword, PhpBundle.message("annotator.duplicate.default.match.condition", new Object[0]), new CommonIntentionAction[]{new PhpDeleteElementQuickFix((PsiElement)defaultArm, PhpBundle.message("quickfix.remove.default.arm", new Object[0]), PhpTokenTypes.opCOMMA)});
        }
    }

    private void checkEmptyListInIteratedValue(ForeachStatement foreach) {
        Statement statement = foreach.getStatement();
        for (PsiElement element = PhpPsiUtil.getChildOfType((PsiElement)foreach, PhpTokenTypes.kwAS); element != null && element != statement; element = element.getNextSibling()) {
            PsiElement next;
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.chLBRACKET)) {
                next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true);
                if (!PhpPsiUtil.isOfType(next, PhpTokenTypes.chRBRACKET)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)element.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset()), PhpBundle.message("cannot.use.empty.list", new Object[0]), new CommonIntentionAction[0]);
                continue;
            }
            if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.kwLIST) || !PhpPsiUtil.isOfType(next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true), PhpTokenTypes.chLPAREN) || !PhpPsiUtil.isOfType(next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(next, true), PhpTokenTypes.chRPAREN)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)element.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset()), PhpBundle.message("cannot.use.empty.list", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private void checkSupportedDirectiveNames(Statement statement) {
        for (PsiElement directive : DeclareImpl.getDirectivesNames((Declare)((Declare)statement))) {
            String directiveName = directive.getText();
            if (PhpKeywordsCompletionContributor.ALL_DIRECTIVES.contains(StringUtil.toLowerCase((String)directiveName))) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, directive, PhpBundle.message("unsupported.declare.0", directiveName), (CommonIntentionAction[])PhpAnnotatorVisitor.PhpChangeToSupportDirectiveQuickFix.getFixes(directive));
        }
    }

    private static void checkBreakOrContinue(AnnotationHolder holder, StatementWithArgument breakOrContinue) {
        PsiElement argument = breakOrContinue.getArgument();
        Integer arg = argument == null ? Integer.valueOf(1) : PhpCodeInsightUtil.toInt(argument);
        Statement loopStatement = arg != null ? PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, arg) : PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, 1);
        if (loopStatement == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)breakOrContinue, PhpBundle.message("annotator.cannot.break.continue", arg != null ? arg : "any"), new CommonIntentionAction[0]);
        } else {
            Finally finallyStatement = PhpPsiUtil.getParentOfClass((PsiElement)breakOrContinue, true, Finally.class);
            PhpAnnotatorVisitor.checkJumpOutOfFinallyStatement(holder, finallyStatement, (PsiElement)breakOrContinue, (PsiElement)loopStatement);
        }
    }

    private void checkClassConstantNamedClass(@Nullable ASTNode nameNode) {
        if (nameNode != null && "class".equals(nameNode.getText())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("a.class.constant.must.not.be.called.class.it.is.reserved.for.class.name.fetching", new Object[0]));
        }
    }

    private void checkNamespaceSyntax(GroupStatement groupStatement) {
        if (groupStatement != null) {
            PsiElement[] children = groupStatement.getChildren();
            Boolean isBraced = null;
            for (PsiElement it : children) {
                if (!(it instanceof PhpNamespace)) continue;
                PhpNamespace namespace = (PhpNamespace)it;
                String text = PhpBundle.message("multiple.namespaces.in.a.file.should.use.same.preferably.braced.syntax", new Object[0]);
                if (isBraced == null) {
                    isBraced = namespace.isBraced();
                }
                if (isBraced.booleanValue() == namespace.isBraced()) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, namespace.getFirstChild(), text, new CommonIntentionAction[0]);
            }
        }
    }

    private void checkCorrectNullsafeDereferencing(MemberReference reference) {
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference.getClassReference(), true);
        if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.opCOALESCE)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, sibling, PhpBundle.message("incorrect.null.safe.operator", new Object[0]), new CommonIntentionAction[]{PhpReplaceWithQuestionQuickFix.INSTANCE});
        }
    }

    private void checkTemplateParameterShadowing(PhpDocTemplateParameter parameter) {
        PsiElement owner;
        PhpDocComment comment = PhpPsiUtil.getParentOfClass((PsiElement)parameter, PhpDocComment.class);
        PsiElement psiElement = owner = comment != null ? comment.getOwner() : null;
        if (owner instanceof Method) {
            String parameterName = parameter.getName();
            PhpClass aClass = ((Method)owner).getContainingClass();
            if (aClass == null) {
                return;
            }
            Collection<String> classTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates((PhpNamedElement)aClass);
            if (classTemplates.contains(parameterName)) {
                this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("method.template.parameter.shadows.class.template.parameter", parameterName)).range((PsiElement)parameter).create();
            }
        }
    }

    private static boolean allowedForIssetCheck(PsiElement param) {
        return param instanceof ArrayAccessExpression || param instanceof Variable || param instanceof FieldReference;
    }

    private void highlightInfo(@Nullable ASTNode node, TextAttributesKey textAttributeKey) {
        if (node == null) {
            return;
        }
        this.highlightInfo(node.getTextRange(), textAttributeKey);
    }

    private void highlightInfo(@NotNull TextRange range, TextAttributesKey textAttributeKey) {
        if (range == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        @NlsSafe String name = textAttributeKey.getExternalName();
        (isUnitTestMode ? this.holder.newAnnotation(HighlightSeverity.INFORMATION, name) : this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).textAttributes(textAttributeKey).create();
    }

    private void highlightInfo(@NotNull PsiElement element, TextAttributesKey textAttributeKey) {
        if (element == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        @NlsSafe String name = textAttributeKey.getExternalName();
        (isUnitTestMode ? this.holder.newAnnotation(HighlightSeverity.INFORMATION, name) : this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(element).textAttributes(textAttributeKey).create();
    }

    private void checkFullSyntaxArrayDestructing(PhpPsiElement array) {
        PhpPsiUtil.findChildrenNonStrict((PsiElement)array, ArrayCreationExpression.class).stream().sorted(Comparator.comparingInt(PsiElement::getTextOffset)).filter(Predicate.not(ArrayCreationExpression::isShortSyntax)).findFirst().ifPresent(c -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)c, PhpBundle.message("array.can.t.be.used.for.array.destructuring.assignment", new Object[0]), new CommonIntentionAction[0]));
    }

    private static boolean isFunction(@NotNull PsiElement operand) {
        PsiElement[] children;
        if (operand == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        for (PsiElement child : children = operand.getChildren()) {
            if (!PhpPsiUtil.isOfType(child, PhpElementTypes.PARAMETER_LIST)) continue;
            return true;
        }
        return false;
    }

    private void checkEmptyEntries(MultiassignmentExpression multiassignmentExpression, PhpPsiElement child) {
        List<PsiElement> commas = Arrays.stream((child instanceof ArrayCreationExpression ? child : multiassignmentExpression).getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOMMA}))).map(ASTNode::getPsi).filter(Objects::nonNull).toList();
        for (PsiElement comma : commas) {
            PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(comma, true);
            if (prev == null || prev instanceof PhpPsiElement) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)prev.getTextRange().getStartOffset(), (int)comma.getTextRange().getEndOffset()), PhpBundle.message("cannot.use.empty.array.entries.in.keyed.array.assignment", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static boolean isTemporaryExpression(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ParenthesizedExpression) {
            return PhpDumbAwareAnnotatorVisitor.isTemporaryExpression((PsiElement)((ParenthesizedExpression)element).getArgument());
        }
        if (element instanceof Variable) {
            return false;
        }
        if (element instanceof ClassReference) {
            return false;
        }
        if (element instanceof MemberReference) {
            PhpExpression reference = ((MemberReference)element).getClassReference();
            return !(reference instanceof FunctionReference) && PhpDumbAwareAnnotatorVisitor.isTemporaryExpression((PsiElement)reference);
        }
        if (element instanceof ArrayAccessExpression) {
            PhpPsiElement value = ((ArrayAccessExpression)element).getValue();
            return !(value instanceof FunctionReference) && PhpDumbAwareAnnotatorVisitor.isTemporaryExpression((PsiElement)value);
        }
        if (element instanceof ArrayCreationExpression && PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.ARRAY_VALUE)) {
            return false;
        }
        if (element instanceof PhpPsiElement && PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE)) {
            PhpPsiElement value = ((PhpPsiElement)element).getFirstPsiChild();
            return !(value instanceof ArrayCreationExpression) && PhpDumbAwareAnnotatorVisitor.isTemporaryExpression((PsiElement)value);
        }
        return true;
    }

    public void checkControlFlow(PhpScopeHolder scope) {
        PhpInstruction[] instructions = scope.getControlFlow().getInstructions();
        if (instructions == PhpControlFlowImpl.EMPTY) {
            PsiElement mark = scope.getFirstChild();
            if (mark instanceof GroupStatement) {
                mark = mark.getFirstChild();
            }
            this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("inspection.message.control.flow.too.big.to.analyze", new Object[0])).range(mark).create();
        } else {
            HashSet<String> labels = new HashSet<String>();
            HashSet<String> staticVars = new HashSet<String>();
            Project project = scope.getProject();
            for (PhpInstruction instruction : instructions) {
                Object object;
                if (instruction instanceof PhpStatementInstruction && (object = ((PhpStatementInstruction)instruction).getStatement()) instanceof PhpStaticStatement) {
                    PhpStaticStatement staticStatement = (PhpStaticStatement)object;
                    if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP830)) {
                        object = staticStatement.getDeclarations().iterator();
                        while (object.hasNext()) {
                            Variable staticVar;
                            String name;
                            AssignmentExpression declaration = (AssignmentExpression)object.next();
                            PhpPsiElement phpPsiElement = declaration.getVariable();
                            if (!(phpPsiElement instanceof Variable) || staticVars.add(name = (staticVar = (Variable)phpPsiElement).getName())) continue;
                            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)staticVar, PhpBundle.message("static.variable.with.same.name.already.defined.in.current.scope", name), new CommonIntentionAction[0]);
                        }
                    }
                }
                if (!(instruction instanceof PhpGotoLabelDefinitionInstruction)) continue;
                PhpGotoLabel label = ((PhpGotoLabelDefinitionInstruction)instruction).getLabel();
                String labelName = label.getName();
                if (labels.contains(labelName)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)label, PhpBundle.message("label.with.same.name.already.defined.in.current.scope", new Object[0]), new CommonIntentionAction[0]);
                    continue;
                }
                labels.add(labelName);
            }
        }
    }

    private static boolean isAllowedReadonlyKeywordAsIdentifierContext(@NotNull PsiElement readonlyIdentifier) {
        PsiElement nameIdentifier;
        PsiElement parent;
        if (readonlyIdentifier == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(13);
        }
        if ((parent = readonlyIdentifier.getParent()) instanceof PhpClass && readonlyIdentifier != (nameIdentifier = ((PhpClass)parent).getNameIdentifier())) {
            return true;
        }
        return PhpDumbAwareAnnotatorVisitor.isAllowedKeywordAsIdentifierContext(readonlyIdentifier) || parent instanceof PhpModifierList || parent instanceof Function || parent != null && parent.getParent() instanceof NewExpression && PhpLanguageFeature.ANONYMOUS_READONLY_CLASSES.isSupported(parent.getProject()) || parent instanceof FunctionReference;
    }

    private static boolean isAllowedKeywordAsIdentifierContext(@NotNull PsiElement matchIdentifier) {
        PsiElement parent;
        if (matchIdentifier == null) {
            PhpDumbAwareAnnotatorVisitor.$$$reportNull$$$0(14);
        }
        return (parent = matchIdentifier.getParent()) instanceof PhpClassMember || parent instanceof MemberReference || parent instanceof PhpNamespace || parent instanceof PhpNamespaceReference || parent instanceof ParameterList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docMethodParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readonlyIdentifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchIdentifier";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallablePropertyTypeDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclaredTypeNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCastKeywordRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightFieldNameNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightFunctionCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPhpBreak";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConditionToBodySeparator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDefaultArms";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedReadonlyKeywordAsIdentifierContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedKeywordAsIdentifierContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpRemoveParameterListQuickFix
    extends PsiUpdateModCommandAction<PhpPropertyHook> {
        protected PhpRemoveParameterListQuickFix(@NotNull PhpPropertyHook element) {
            if (element == null) {
                PhpRemoveParameterListQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpPropertyHook element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpRemoveParameterListQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveParameterListQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveParameterListQuickFix.$$$reportNull$$$0(3);
            }
            PhpRemoveParametersQuickFix.removePropertyHookParameter(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.quick.fix.remove.parameter.list", new Object[0]);
            if (string == null) {
                PhpRemoveParameterListQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveParameterListQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveParameterListQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpLeaveOneSetHookParameterQuickFix
    extends PsiUpdateModCommandAction<PhpPropertyHook> {
        protected PhpLeaveOneSetHookParameterQuickFix(@NotNull PhpPropertyHook element) {
            if (element == null) {
                PhpLeaveOneSetHookParameterQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpPropertyHook element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpLeaveOneSetHookParameterQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpLeaveOneSetHookParameterQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpLeaveOneSetHookParameterQuickFix.$$$reportNull$$$0(3);
            }
            Parameter[] parameters = element.getParameters();
            for (int i = 1; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                if (param == null) continue;
                PsiElement comma = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)param, true);
                if (PhpPsiUtil.isOfType(comma, PhpTokenTypes.opCOMMA)) {
                    comma.delete();
                }
                param.delete();
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.quick.fix.leave.one.hook.parameter.family.name", new Object[0]);
            if (string == null) {
                PhpLeaveOneSetHookParameterQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpLeaveOneSetHookParameterQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpLeaveOneSetHookParameterQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpRemoveDefaultValueQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpRemoveDefaultValueQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                PhpRemoveDefaultValueQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Parameter parameter;
            if (context == null) {
                PhpRemoveDefaultValueQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveDefaultValueQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveDefaultValueQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement defaultValue = null;
            if (element instanceof Field) {
                Field field = (Field)element;
                defaultValue = field.getDefaultValue();
            } else if (element instanceof Parameter && (defaultValue = (parameter = (Parameter)element).getDefaultValue()) != null) {
                defaultValue = defaultValue.getParent();
            }
            if (defaultValue != null) {
                PsiElement assign = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(defaultValue, true);
                if (PhpPsiUtil.isOfType(assign, PhpTokenTypes.opASGN)) {
                    assign.delete();
                }
                defaultValue.delete();
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.quick.fix.remove.default.value", new Object[0]);
            if (string == null) {
                PhpRemoveDefaultValueQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveDefaultValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveDefaultValueQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithNullCheckQuickFix
    extends PsiUpdateModCommandAction<PhpIsset> {
        private PhpReplaceWithNullCheckQuickFix(PhpIsset issetCheck) {
            super((PsiElement)issetCheck);
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PhpIsset element) {
            if (context == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(1);
            }
            String text = element.getVariables().length == 1 ? PhpBundle.message("intention.family.name.replace.with", element.getVariables()[0].getText() + " !== null") : this.getFamilyName();
            return Presentation.of((String)text);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpIsset startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(4);
            }
            Project project = context.project();
            PhpExpression[] variables = startElement.getVariables();
            int i = 0;
            ArrayList<String> toCheckInIsset = new ArrayList<String>();
            ArrayList<Object> finalArguments = new ArrayList<Object>();
            while (i < variables.length) {
                while (i < variables.length && PhpDumbAwareAnnotatorVisitor.allowedForIssetCheck((PsiElement)variables[i])) {
                    toCheckInIsset.add(variables[i++].getText());
                }
                if (!toCheckInIsset.isEmpty()) {
                    String issetText = "isset(" + StringUtil.join(toCheckInIsset, (String)",") + ")";
                    finalArguments.add(PhpPsiElementFactory.createPhpPsiFromText(project, PhpIsset.class, issetText));
                    toCheckInIsset.clear();
                }
                while (i < variables.length && !PhpDumbAwareAnnotatorVisitor.allowedForIssetCheck((PsiElement)variables[i])) {
                    finalArguments.add(PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, variables[i++].getText() + " !== null"));
                }
            }
            PsiElement toReplace = finalArguments.size() == 1 ? (PsiElement)finalArguments.get(0) : PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, StringUtil.join(finalArguments, PsiElement::getText, (String)"&&"));
            startElement.replace(toReplace);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.check", new Object[0]);
            if (string == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithNullCheckQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithNullCheckQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private class PhpDeclarationDuplicateCheckerVisitor
    extends PsiRecursiveElementWalkingVisitor {
        final Set<String> classes = new TreeSet<String>(String::compareToIgnoreCase);
        final Set<String> functions = new TreeSet<String>(String::compareToIgnoreCase);
        final MultiMap<String, String> constants = new MultiMap<String, String>(new TreeMap(String::compareToIgnoreCase)){

            @NotNull
            protected Collection<String> createCollection() {
                return new SmartHashSet();
            }
        };

        private PhpDeclarationDuplicateCheckerVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof PhpClass) {
                this.visitPhpClass((PhpClass)element);
            }
            if (element instanceof Function) {
                this.visitPhpFunction((Function)element);
            }
            if (element instanceof Constant) {
                this.visitPhpConstant((Constant)element);
            }
            if (element instanceof PhpUse) {
                this.visitPhpUse((PhpUse)element);
            }
            if (!(element instanceof PhpClass || element instanceof Function || element instanceof PhpDocComment || element instanceof Constant || element instanceof Statement && !(element instanceof GroupStatement) && !PhpPsiUtil.isOfType(element, PhpElementTypes.CONSTANTS))) {
                super.visitElement(element);
            }
        }

        public void visitPhpUse(PhpUse use) {
            if (!use.isTraitImport()) {
                String name = use.getName();
                String namespace = use.getNamespaceName();
                if (PhpUseImpl.isOfFunction(use)) {
                    this.checkUseDupe(use, namespace + name, this.functions);
                } else if (PhpUseImpl.isOfConst(use)) {
                    this.checkUseDupe(use, name, this.constants.getModifiable((Object)namespace));
                } else {
                    this.checkUseDupe(use, namespace + name, this.classes);
                }
            }
        }

        private void checkUseDupe(@NotNull PhpUse use, @NotNull String name, Collection<String> collection) {
            if (use == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(1);
            }
            if (name == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(2);
            }
            if (collection.contains(name)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpDumbAwareAnnotatorVisitor.this.holder, (PsiElement)use, PhpBundle.message("annotator.duplicate.use.statement", use.getName()), new CommonIntentionAction[0]);
            } else {
                collection.add(name);
            }
        }

        public void visitPhpClass(PhpClass clazz) {
            this.checkDupe((PhpNamedElement)clazz, this.classes);
        }

        public void visitPhpFunction(Function function) {
            if (!function.getAttributes("\\JetBrains\\PhpStorm\\Internal\\PhpStormStubsElementAvailable").isEmpty()) {
                return;
            }
            this.checkDupe((PhpNamedElement)function, this.functions);
        }

        public void visitPhpConstant(@NotNull Constant constant) {
            ASTNode nameNode;
            if (constant == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(3);
            }
            if ((nameNode = constant.getNameNode()) != null && this.constants.getModifiable((Object)constant.getNamespaceName()).contains(constant.getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpDumbAwareAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("another.definition.with.same.name.exists.in.this.file", new Object[0]));
            }
        }

        void checkDupe(PhpNamedElement e, Set<String> set) {
            if (PhpPsiUtil.getParentOfClass((PsiElement)e, Else.class) != null) {
                return;
            }
            if (PhpPsiUtil.getParentOfClass((PsiElement)e, ElseIf.class) != null) {
                return;
            }
            @NonNls String fqn = e.getFQN();
            ASTNode nameNode = e.getNameNode();
            if (nameNode != null && !set.add(fqn)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpDumbAwareAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("another.definition.with.same.name.exists.in.this.file", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "use";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpDeclarationDuplicateCheckerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkUseDupe";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPhpConstant";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpRemoveVariableIntention
    extends PsiUpdateModCommandAction<Variable> {
        protected PhpRemoveVariableIntention(@NotNull Variable variable) {
            if (variable == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(0);
            }
            super((PsiElement)variable);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Variable variable, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(1);
            }
            if (variable == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(3);
            }
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)variable, PhpTokenTypes.opCOMMA);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Variable variable) {
            if (context == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(4);
            }
            if (variable == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(5);
            }
            Presentation presentation = Presentation.of((String)PhpBundle.message("annotator.fix.remove", variable.getText()));
            if (presentation == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(6);
            }
            return presentation;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("remove.variable", new Object[0]);
            if (string == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveVariableIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpRemoveVariableIntention";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpMakeClassEnumQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        private PhpMakeClassEnumQuickFix(@NotNull PhpClass containingClass) {
            if (containingClass == null) {
                PhpMakeClassEnumQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)containingClass);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass startElement, @NotNull ModPsiUpdater updater) {
            ASTNode firstChild;
            if (context == null) {
                PhpMakeClassEnumQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpMakeClassEnumQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMakeClassEnumQuickFix.$$$reportNull$$$0(3);
            }
            if ((firstChild = PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)startElement)).getElementType() != PhpTokenTypes.kwENUM) {
                PsiElement kwEnum = PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpClass.class, "enum a{}").getFirstChild();
                firstChild.getPsi().replace(kwEnum);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.containing.class.enum", new Object[0]);
            if (string == null) {
                PhpMakeClassEnumQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpMakeClassEnumQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpMakeClassEnumQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplaceWithCorrectStrictTypeValueQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final int myValue;

        private PhpReplaceWithCorrectStrictTypeValueQuickFix(@NotNull PsiElement directiveValue, int value) {
            if (directiveValue == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(0);
            }
            super(directiveValue);
            this.myValue = value;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myValue);
            if (string == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpExpression value;
            if (context == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(4);
            }
            if ((value = PhpCodeInsightUtil.getStrictTypeDirectiveValue(PhpPsiElementFactory.createPhpPsiFromText(context.project(), Declare.class, "declare(strict_types=" + this.myValue + ")"))) == null) {
                return;
            }
            element.replace((PsiElement)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directiveValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithCorrectStrictTypeValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithCorrectStrictTypeValueQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpMoveAttributeToStartOfElementQuickFix
    extends PsiUpdateModCommandAction<PhpAttributesList> {
        private PhpMoveAttributeToStartOfElementQuickFix(PhpAttributesList attribute) {
            super((PsiElement)attribute);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpAttributesList startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement parent = startElement.getParent();
            parent.addBefore(startElement.copy(), parent.getFirstChild());
            startElement.delete();
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.move.attribute.to.start.element", new Object[0]);
            if (string == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpMoveAttributeToStartOfElementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpMoveAttributeToStartOfElementQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpSplitIntoSeparateCasesQuickFix
    extends PsiUpdateModCommandAction<PhpCase> {
        static final ModCommandAction INSTANCE = new PhpSplitIntoSeparateCasesQuickFix();

        PhpSplitIntoSeparateCasesQuickFix() {
            super(PhpCase.class);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.split.into.separate.case.statements", new Object[0]);
            if (string == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpCase phpCase, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(1);
            }
            if (phpCase == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(3);
            }
            List children = PhpPsiUtil.getChildren((PsiElement)phpCase, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            PhpCase anchor = phpCase;
            for (int i = children.size() - 2; i >= 0; --i) {
                PsiElement child = (PsiElement)children.get(i);
                PhpCodeEditUtil.removeStatementWithDelivery(child, PhpTokenTypes.opCOMMA);
                PhpCase emptyCase = PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpCase.class, String.format("switch(){case %s: }", child.getText()));
                anchor = anchor.getParent().addBefore((PsiElement)emptyCase, (PsiElement)anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpSplitIntoSeparateCasesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpCase";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpSplitIntoSeparateCasesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceWithQuestionQuickFix
    extends PsiUpdateModCommandAction<MemberReference> {
        static final ModCommandAction INSTANCE = new PhpReplaceWithQuestionQuickFix();

        PhpReplaceWithQuestionQuickFix() {
            super(MemberReference.class);
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("replace.with.quest", new Object[0]);
            if (string == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull MemberReference memberReference, @NotNull ModPsiUpdater updater) {
            PhpExpression classReference;
            PsiElement coalesce;
            if (context == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(1);
            }
            if (memberReference == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(3);
            }
            if (PhpPsiUtil.isOfType(coalesce = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)(classReference = memberReference.getClassReference()), true), PhpTokenTypes.opCOALESCE)) {
                coalesce.replace(PhpPsiElementFactory.createQuest(context.project()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithQuestionQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithQuestionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceWithOpHashFix
    extends PsiUpdateModCommandAction<PsiElement> {
        protected PhpReplaceWithOpHashFix(PsiElement quest) {
            super(quest);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(2);
            }
            element.replace(PhpPsiElementFactory.createFromText(context.project(), PhpTokenTypes.opHASH_ARRAY, "match(1) { true => 1 };"));
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.with.01", "'=>'");
            if (string == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithOpHashFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDumbAwareAnnotatorVisitor$PhpReplaceWithOpHashFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

