/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePrivateIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePrivateSetIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedSetIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePublicIntention;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.impl.PhpBaseMemberReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAdjustMemberAccessFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;
    private final PhpModifier.Access myAccess;
    private final PhpChangeVisibilityIntentionBase myDelegate;
    private final boolean myIsSetAccess;

    public PhpAdjustMemberAccessFix(@NotNull PhpBaseMemberReference reference, @NotNull PhpModifier.Access access) {
        if (reference == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(0);
        }
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)reference);
        this.myAccess = access;
        this.myName = StringUtil.notNullize((String)reference.getName());
        this.myDelegate = PhpAdjustMemberAccessFix.getDelegate(access, false);
        this.myIsSetAccess = false;
    }

    public PhpAdjustMemberAccessFix(@NotNull PhpClassMember member, @NotNull PhpModifier.Access access) {
        if (member == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(2);
        }
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)member);
        this.myAccess = access;
        this.myName = StringUtil.notNullize((String)member.getName());
        this.myDelegate = PhpAdjustMemberAccessFix.getDelegate(access, false);
        this.myIsSetAccess = false;
    }

    public PhpAdjustMemberAccessFix(@NotNull PhpClassMember member, @NotNull PhpModifier.Access access, boolean isSetAccess) {
        if (member == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(4);
        }
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(5);
        }
        super((PsiElement)member);
        this.myAccess = access;
        this.myName = StringUtil.notNullize((String)member.getName());
        this.myDelegate = PhpAdjustMemberAccessFix.getDelegate(access, isSetAccess);
        this.myIsSetAccess = isSetAccess;
    }

    public static PhpChangeVisibilityIntentionBase getDelegate(@NotNull PhpModifier.Access access) {
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(6);
        }
        return switch (access) {
            default -> throw new IncompatibleClassChangeError();
            case PhpModifier.Access.PUBLIC -> new PhpMakePublicIntention();
            case PhpModifier.Access.PROTECTED -> new PhpMakeProtectedIntention();
            case PhpModifier.Access.PRIVATE -> new PhpMakePrivateIntention();
        };
    }

    public static PhpChangeVisibilityIntentionBase getDelegate(@NotNull PhpModifier.Access access, boolean isSetAccess) {
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(7);
        }
        if (isSetAccess) {
            return switch (access) {
                default -> throw new IncompatibleClassChangeError();
                case PhpModifier.Access.PROTECTED -> new PhpMakeProtectedSetIntention();
                case PhpModifier.Access.PRIVATE -> new PhpMakePrivateSetIntention();
                case PhpModifier.Access.PUBLIC -> null;
            };
        }
        return PhpAdjustMemberAccessFix.getDelegate(access);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = PhpBundle.message("make.0.1", this.myName, this.myAccess.toString() + (this.myIsSetAccess ? "(set)" : ""));
        if (string == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("change.member.access", new Object[0]);
        if (string == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(10);
        }
        if (psiFile == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(12);
        }
        if (endElement == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            return;
        }
        PhpClassMember member = this.resolveClassMember();
        if (member == null) {
            return;
        }
        if (member instanceof Method) {
            this.myDelegate.changeAccess(project, editor, (Method)member);
        } else if (member instanceof PhpPromotedFieldParameterImpl) {
            this.myDelegate.changeAccess(project, (PhpPromotedFieldParameterImpl)member);
        } else {
            this.myDelegate.changeAccess((Field)member);
        }
    }

    @Nullable
    private PhpClassMember resolveClassMember() {
        PsiElement startElement = this.getStartElement();
        if (startElement instanceof PhpClassMember) {
            return (PhpClassMember)startElement;
        }
        PhpBaseMemberReference element = (PhpBaseMemberReference)startElement;
        if (element == null) {
            return null;
        }
        return (PhpClassMember)ObjectUtils.tryCast((Object)element.resolve(), PhpClassMember.class);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PhpClassMember member;
        if (project == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(16);
        }
        if ((member = this.resolveClassMember()) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpAdjustMemberAccessFix.$$$reportNull$$$0(17);
            }
            return intentionPreviewInfo;
        }
        String memberSuffix = member instanceof Method ? " function " + member.getName() : " $" + member.getName();
        String oldModifier = String.valueOf(member.getModifier()) + memberSuffix;
        String newModifier = String.valueOf(PhpModifier.instance((PhpModifier.Access)this.myAccess, (PhpModifier.Abstractness)member.getModifier().getAbstractness(), (PhpModifier.State)member.getModifier().getState())) + memberSuffix;
        return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, member.getContainingFile().getName(), oldModifier, newModifier);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAdjustMemberAccessFix";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAdjustMemberAccessFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 17 -> new IllegalStateException(string);
        };
    }
}

