/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import icons.PhpIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGeneratePhpDocBlocksAction
extends CodeInsightAction {
    private final LanguageCodeInsightActionHandler myHandler = new PhpGeneratePhpDocBlocksActionHandler();

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        LanguageCodeInsightActionHandler languageCodeInsightActionHandler = this.myHandler;
        if (languageCodeInsightActionHandler == null) {
            PhpGeneratePhpDocBlocksAction.$$$reportNull$$$0(0);
        }
        return languageCodeInsightActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PhpGeneratePhpDocBlocksAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpGeneratePhpDocBlocksAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            PhpGeneratePhpDocBlocksAction.$$$reportNull$$$0(3);
        }
        return this.myHandler.isValidFor(editor, psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGeneratePhpDocBlocksAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGeneratePhpDocBlocksAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    public static final class PhpGeneratePhpDocBlocksActionHandler
    implements LanguageCodeInsightActionHandler {
        public boolean isValidFor(Editor editor, PsiFile file) {
            return file instanceof PhpFile;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                PhpGeneratePhpDocBlocksActionHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                PhpGeneratePhpDocBlocksActionHandler.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                PhpGeneratePhpDocBlocksActionHandler.$$$reportNull$$$0(2);
            }
            PhpNodesCollector collector = new PhpNodesCollector();
            psiFile.accept((PsiElementVisitor)collector);
            if (collector.myCollectedNodes.isEmpty()) {
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    HintManager.getInstance().showErrorHint(editor, PhpBundle.message("no.elements.to.generate.phpdoc.for", new Object[0]));
                }
                return;
            }
            List<PhpDocElement> selectedNodes = PhpGeneratePhpDocBlocksActionHandler.chooseElements(project, collector.myCollectedNodes);
            List<RangeMarker> existingMarkers = PhpDocCommentGenerator.collectCaretMarkers(editor.getDocument(), psiFile.getTextRange());
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (selectedNodes != null) {
                    for (PhpDocElement node : selectedNodes) {
                        PhpGeneratePhpDocBlocksActionHandler.addDocCommentFor(project, node.getPsiElement(), editor.getDocument(), psiFile);
                    }
                    PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, psiFile.getTextRange(), existingMarkers);
                }
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void addDocCommentFor(Project project, PsiElement forElement, Document document, PsiFile file) {
            PsiElement beforeElement = PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(forElement);
            if (beforeElement == null) {
                return;
            }
            PhpDocComment docComment = PhpDocCommentGenerator.constructDocComment(project, forElement, true);
            if (docComment != null) {
                PsiElement docParent;
                PsiElement parent = beforeElement.getParent();
                int atOffset = beforeElement.getTextRange().getStartOffset() + 1;
                PsiElement addedDocComment = parent.addBefore((PsiElement)docComment, beforeElement);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                PsiElement atElement = file.findElementAt(atOffset);
                if (atElement != null && (docParent = PsiTreeUtil.findFirstParent((PsiElement)atElement, (boolean)true, element -> element instanceof PhpDocComment || element instanceof PhpFile)) instanceof PhpDocComment) {
                    CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(docParent.getParent().getNode(), docParent.getNode());
                }
            }
        }

        @Nullable
        public static PsiElement getBeforeElement(PsiElement element) {
            assert (element != null);
            PsiElement beforeElement = element;
            PsiElement parent = element.getParent();
            if (beforeElement instanceof Field || PhpPsiUtil.isOfType(beforeElement, new IElementType[]{PhpStubElementTypes.DEFINE, PhpStubElementTypes.CONST})) {
                beforeElement = parent;
            } else if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE)) {
                beforeElement = parent = parent.getParent();
                if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ASSIGNMENT_EXPRESSION)) {
                    if ((parent = parent.getParent()) instanceof Statement) {
                        return parent;
                    }
                    return null;
                }
            }
            return beforeElement;
        }

        private static List<PhpDocElement> chooseElements(Project project, List<PhpDocElement> nodes) {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return nodes;
            }
            MemberChooser chooser = new MemberChooser((ClassMember[])nodes.toArray(new PhpDocElement[0]), true, true, project);
            chooser.setTitle(PhpBundle.message("choose.elements.to.generate.phpdoc.for", new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            return chooser.getSelectedElements();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpGeneratePhpDocBlocksAction$PhpGeneratePhpDocBlocksActionHandler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpDocElement
    extends PsiElementMemberChooserObject
    implements ClassMember {
        PhpDocElement(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                PhpDocElement.$$$reportNull$$$0(0);
            }
            super(psiElement, PhpDocElement.getText(psiElement), PhpDocElement.getIcon(psiElement));
        }

        public MemberChooserObject getParentNodeDelegate() {
            PsiElement element = this.getPsiElement();
            PsiElement parent = element.getParent();
            if (PhpPsiUtil.isOfType(element, new IElementType[]{PhpStubElementTypes.DEFINE, PhpStubElementTypes.CONST}) && parent instanceof Statement) {
                parent = parent.getParent();
            }
            if (parent instanceof GroupStatement || element instanceof Field) {
                parent = parent.getParent();
            }
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE)) {
                while (parent != null) {
                    if (parent instanceof AssignmentExpression) {
                        parent = ((AssignmentExpression)parent).getVariable();
                        break;
                    }
                    if (parent instanceof PhpFile) break;
                    parent = parent.getParent();
                }
            }
            if (parent == null) {
                parent = element;
            }
            return new PhpDocElement(parent);
        }

        @NlsSafe
        private static String getText(PsiElement element) {
            PsiElement parent;
            if (element instanceof Function && PhpPsiUtil.isOfType(parent = element.getParent(), PhpElementTypes.CLOSURE)) {
                StringBuilder funcHeader = new StringBuilder();
                PsiElement child = element.getFirstChild();
                while (!PhpPsiUtil.isOfType(child, PhpElementTypes.ANY_GROUP_STATEMENT)) {
                    funcHeader.append(child.getText());
                    child = child.getNextSibling();
                }
                return funcHeader.toString().trim().replace("\n", "").replaceAll("\\s", "") + "{...}";
            }
            if (element instanceof PhpNamedElement) {
                return ((PhpNamedElement)element).getName();
            }
            if (element instanceof PhpFile) {
                return ((PhpFile)element).getName();
            }
            return element.getText();
        }

        private static Icon getIcon(PsiElement element) {
            if (element instanceof PhpNamedElement) {
                return ((PhpNamedElement)element).getIcon();
            }
            if (element instanceof PhpFile) {
                return PhpIcons.PhpIcon;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/php/lang/actions/generation/PhpGeneratePhpDocBlocksAction$PhpDocElement", "<init>"));
        }
    }

    private static final class PhpNodesCollector
    extends PhpElementVisitor {
        private final List<PhpDocElement> myCollectedNodes = new SmartList();

        private PhpNodesCollector() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpNodesCollector.$$$reportNull$$$0(0);
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        public void visitPhpFunction(Function function) {
            this.addElement((PhpNamedElement)function);
        }

        public void visitPhpClass(PhpClass clazz) {
            this.addElement((PhpNamedElement)clazz);
            super.visitPhpClass(clazz);
        }

        public void visitPhpMethod(Method method) {
            this.addElement((PhpNamedElement)method);
        }

        public void visitPhpConstant(Constant constant) {
            this.addElement((PhpNamedElement)constant);
        }

        public void visitPhpField(Field field) {
            this.addElement((PhpNamedElement)field);
        }

        private void addElement(PhpNamedElement element) {
            PsiElement beforeElement = PhpGeneratePhpDocBlocksActionHandler.getBeforeElement((PsiElement)element);
            if (beforeElement == null) {
                return;
            }
            PsiElement prev = beforeElement.getPrevSibling();
            if (prev instanceof PsiWhiteSpace) {
                prev = prev.getPrevSibling();
            }
            if (prev instanceof PhpDocComment) {
                return;
            }
            this.myCollectedNodes.add(new PhpDocElement((PsiElement)element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/actions/generation/PhpGeneratePhpDocBlocksAction$PhpNodesCollector", "visitElement"));
        }
    }
}

