/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.InheritorsCodeVisionProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.hints.PhpCodeVisionUsageCollector;
import com.jetbrains.php.hints.PhpReferencesCodeVisionProvider;
import com.jetbrains.php.lang.PhpLineMarkerProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInheritorsCodeVisionProvider
extends InheritorsCodeVisionProvider {
    static final String ID = "php.inheritors";

    public boolean acceptsFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(0);
        }
        return file instanceof PhpFile;
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(1);
        }
        return element instanceof PhpClass && !((PhpClass)element).isAnonymous() && !(element instanceof PhpClassAlias) && !((PhpClass)element).isEnum() || element instanceof PhpClassFieldsList && ((PhpClassFieldsList)element).getFields().size() == 1 || element instanceof PhpClassMember && !(element instanceof PhpEnumCase) && !(element instanceof Field) && !(element instanceof PhpDocPsiElement) && !(element instanceof RenameableFakePsiElement);
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        if (element == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(3);
        }
        int[] count = new int[1];
        int limit = AdvancedSettings.getInt((String)"php.code.vision.hierarchy.limit");
        String preview = PhpReferencesCodeVisionProvider.getHintForPreview(file, element, true);
        if (preview != null) {
            return new CodeVisionProviderBase.CodeVisionInfo(preview, null, true);
        }
        PsiElement psiElement = PhpReferencesCodeVisionProvider.adjustElement(element);
        if (psiElement instanceof PhpClassMember) {
            PhpClassMember member = (PhpClassMember)psiElement;
            PhpClass containingClass = member.getContainingClass();
            if (containingClass != null) {
                PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)member, (curMember, subClass, baseClass) -> {
                    count[0] = count[0] + 1;
                    return count[0] <= limit;
                });
                String itemText = PhpInheritorsCodeVisionProvider.getText(count[0], (PsiElement)member, containingClass, "code.vision.overrides.hint", limit);
                if (itemText == null) {
                    return null;
                }
                return new CodeVisionProviderBase.CodeVisionInfo(itemText, Integer.valueOf(count[0]), count[0] <= limit);
            }
        } else if (element instanceof PhpClass) {
            PhpClass clazz = (PhpClass)element;
            PhpIndex index = PhpIndex.getInstance((Project)element.getProject());
            if (clazz.isTrait()) {
                count[0] = index.getTraitUsages(clazz).size();
            } else {
                index.processAllSubclasses(clazz.getFQN(), __ -> {
                    count[0] = count[0] + 1;
                    return count[0] <= limit;
                });
            }
            String itemText = PhpInheritorsCodeVisionProvider.getText(count[0], (PsiElement)clazz, clazz, "code.vision.inheritors.hint", limit);
            if (itemText == null) {
                return null;
            }
            return new CodeVisionProviderBase.CodeVisionInfo(itemText, Integer.valueOf(count[0]), count[0] <= limit);
        }
        return null;
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        CodeVisionProviderBase.CodeVisionInfo info;
        if (element == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(5);
        }
        if ((info = this.getVisionInfo(element, file)) == null) {
            return null;
        }
        return info.getText();
    }

    @Nullable
    @Nls
    private static String getText(int count, PsiElement target, PhpClass containingClass, String classKey, int limit) {
        int choice;
        if (count <= 0) {
            return null;
        }
        int result = Math.min(count, limit);
        int n = choice = count > limit ? 1 : 0;
        if (target == containingClass && ((PhpClass)target).isTrait()) {
            return PhpBundle.message("code.vision.used.in.hint", result, choice);
        }
        return containingClass.isInterface() ? PhpBundle.message("code.vision.implementations.hint", result, choice) : PhpBundle.message(classKey, result, choice);
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element, @Nullable MouseEvent event) {
        if (editor == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(7);
        }
        if ((element = PhpReferencesCodeVisionProvider.adjustElement(element)) instanceof PhpClass) {
            new PhpLineMarkerProvider.PhpClassGutterIconNavigationHandler((PhpClass)element).navigate(event, element);
        } else {
            new PhpLineMarkerProvider.PhpMemberGutterIconNavigationHandler((PhpClassMember)element, PhpLineMarkerProvider::findChildrenMembers).navigate(event, element);
        }
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint) {
        if (element == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(8);
        }
        if (hint == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(9);
        }
        PhpCodeVisionUsageCollector.logInheritorsHintClicked(PhpReferencesCodeVisionProvider.adjustElement(element), hint);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        List<CodeVisionRelativeOrdering> list = Collections.emptyList();
        if (list == null) {
            PhpInheritorsCodeVisionProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/hints/PhpInheritorsCodeVisionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/hints/PhpInheritorsCodeVisionProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeOrderings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisionInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleClick";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logClickToFUS";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

