/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.hierarchy.method.PhpMethodHierarchyNodeDescriptor;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer<Method> myMethod;

    public PhpMethodHierarchyTreeStructure(Project project, Method method) {
        super(project, null);
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((PhpMethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, Method method) {
        PhpClass psiClass;
        int i;
        PhpClass suitableBaseClass = PhpMethodHierarchyTreeStructure.findSuitableBaseClass(method);
        PhpMethodHierarchyNodeDescriptor descriptor = null;
        ArrayList<PhpClass> superClasses = PhpMethodHierarchyTreeStructure.getDirectSuperClasses(suitableBaseClass);
        PhpClass containingClass = method.getContainingClass();
        if (!suitableBaseClass.equals(containingClass)) {
            superClasses.add(0, suitableBaseClass);
        }
        for (i = superClasses.size() - 1; i >= 0 && PhpHierarchyUtils.findBaseMethodInClass(method, psiClass = superClasses.get(i), false) == null; --i) {
            superClasses.remove(i);
        }
        for (i = superClasses.size() - 1; i >= 0; --i) {
            PhpClass superClass = superClasses.get(i);
            PhpMethodHierarchyNodeDescriptor newDescriptor = new PhpMethodHierarchyNodeDescriptor(project, descriptor, superClass, false, this);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        PhpMethodHierarchyNodeDescriptor newDescriptor = new PhpMethodHierarchyNodeDescriptor(project, descriptor, containingClass, true, this);
        if (descriptor != null) {
            descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static ArrayList<PhpClass> getDirectSuperClasses(PhpClass aClass) {
        if (!aClass.isValid()) {
            return new ArrayList<PhpClass>();
        }
        ArrayList<PhpClass> superClasses = new ArrayList<PhpClass>();
        while (true) {
            PhpClass aClass1 = aClass;
            PhpClass[] superTypes = aClass1.getSupers();
            PhpClass superType = null;
            for (PhpClass type : superTypes) {
                if (type == null || type.isInterface()) continue;
                superType = type;
                break;
            }
            if (superType == null) {
                for (PhpClass type : superTypes) {
                    if (type == null) continue;
                    superType = type;
                    break;
                }
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            aClass = superType;
        }
        return superClasses;
    }

    @Nullable
    private static PhpClass findSuitableBaseClass(Method method) {
        Collection superClasses;
        PhpClass containingClass = method.getContainingClass();
        if (containingClass != null && ((superClasses = containingClass.getSuperClasses()).isEmpty() || ContainerUtil.exists((Iterable)superClasses, superClass -> PhpHierarchyUtils.findBaseMethodInClass(method, superClass, true) == null))) {
            for (PhpClass anInterface : containingClass.getImplementedInterfaces()) {
                if (PhpHierarchyUtils.findBaseMethodInClass(method, anInterface, true) == null) continue;
                return anInterface;
            }
        }
        return containingClass;
    }

    @Nullable
    public final Method getBaseMethod() {
        return (Method)this.myMethod.getElement();
    }

    protected final Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            PhpMethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        PhpClass psiClass = ((PhpMethodHierarchyNodeDescriptor)descriptor).getPhpClass();
        Collection subclasses = PhpClassHierarchyUtils.getDirectSubclasses((PhpClass)psiClass);
        ArrayList<PhpMethodHierarchyNodeDescriptor> descriptors = new ArrayList<PhpMethodHierarchyNodeDescriptor>(subclasses.size());
        for (PhpClass aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            PhpMethodHierarchyNodeDescriptor d = new PhpMethodHierarchyNodeDescriptor(this.myProject, descriptor, aClass, false, this);
            descriptors.add(d);
        }
        Object[] objectArray = descriptors.toArray(HierarchyNodeDescriptor.EMPTY_ARRAY);
        if (objectArray == null) {
            PhpMethodHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private boolean shouldHideClass(PhpClass psiClass) {
        if (this.getMethod(psiClass, false) != null) {
            return false;
        }
        if (this.hasBaseClassMethod(psiClass) || psiClass.isAbstract()) {
            for (PhpClass subclass : PhpClassHierarchyUtils.getDirectSubclasses((PhpClass)psiClass)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasBaseClassMethod(PhpClass psiClass) {
        Method baseClassMethod = this.getMethod(psiClass, true);
        return baseClassMethod != null && !baseClassMethod.isAbstract();
    }

    @Nullable
    private Method getMethod(PhpClass aClass, boolean checkBases) {
        return PhpHierarchyUtils.findBaseMethodInClass(this.getBaseMethod(), aClass, checkBases);
    }

    private static boolean checkClassHasParentOfAnotherOne(PhpClass aClass, PhpClass parent, @Nullable Set<PhpClass> visited) {
        if (visited != null && visited.contains(aClass)) {
            return false;
        }
        for (PhpClass superClazz : aClass.getSupers()) {
            if (superClazz == null) continue;
            if (superClazz.isEquivalentTo((PsiElement)parent)) {
                return true;
            }
            if (visited == null) {
                visited = new HashSet<PhpClass>();
            }
            visited.add(aClass);
            if (!PhpMethodHierarchyTreeStructure.checkClassHasParentOfAnotherOne(superClazz, parent, visited)) continue;
            return true;
        }
        return false;
    }

    boolean isSuperClassForBaseClass(PhpClass aClass) {
        Method baseMethod = this.getBaseMethod();
        if (baseMethod == null) {
            return false;
        }
        PhpClass baseClass = baseMethod.getContainingClass();
        if (baseClass == null) {
            return false;
        }
        return PhpMethodHierarchyTreeStructure.checkClassHasParentOfAnotherOne(aClass, baseClass, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/hierarchy/method/PhpMethodHierarchyTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/hierarchy/method/PhpMethodHierarchyTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

