/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.connection.Message;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ZendDebugMessage
implements Message {
    protected static final String LIFETIME = "lifetime";
    protected static final String TYPE = "type";
    protected static final String BREAKPOINT_ID = "breakpoint_id";
    protected static final String CONDITION = "condition";
    protected static final String FILENAME = "filename";
    protected static final String LINENUMBER = "linenumber";
    protected static final String REQUEST_ID = "request_id";
    protected static final String STATUS = "status";
    protected static final String EXPR = "expr";
    protected static final String MESSAGE_ID = "message_id";
    protected static final String PROTOCOL_ID = "protocol_id";
    protected static final String URI = "uri";
    protected static final String QUERY = "query";
    protected static final String MODE = "mode";
    protected static final String TEXT = "text";
    protected static final String RESULT = "result";
    public static final String VARIABLE = "variable";
    public static final String CWD = "CWD";
    public static final String DEPTH = "depth";
    protected static final String STACK__DEPTH = "stack_depth";
    protected static final String PATH_LENGTH = "path_length";
    protected static final String PATH = "path";
    protected static final String VAR_NAME = "var_name";
    protected static final String VALUE = "value";
    protected static final String VARIABLE_CONTENT = "var_content";
    protected static final String PARAM_1 = "param1";
    protected static final String PARAM_2 = "param2";

    public abstract short getMessageId();

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("(");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        this.appendParameters(parameters);
        boolean isFirst = true;
        for (String parameterName : parameters.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder2.append(", ");
            }
            builder2.append(parameterName);
            builder2.append("=");
            builder2.append((String)parameters.get(parameterName));
        }
        builder2.append(")");
        return builder2.toString();
    }

    protected void appendParameters(Map<String, String> parameters) {
        ZendDebugMessage.appendParameters(parameters, MESSAGE_ID, this.getMessageId());
    }

    protected static void appendParameters(Map<String, String> parameters, @NotNull String key, @NotNull String value) {
        String[] valueLines;
        if (key == null) {
            ZendDebugMessage.$$$reportNull$$$0(0);
        }
        if (value == null) {
            ZendDebugMessage.$$$reportNull$$$0(1);
        }
        parameters.put(key, "\"" + ((valueLines = StringUtil.splitByLines((String)value)).length > 0 ? valueLines[0] : "") + "\"");
    }

    protected static void appendParameters(Map<String, String> parameters, @NotNull String key, String ... values) {
        if (key == null) {
            ZendDebugMessage.$$$reportNull$$$0(2);
        }
        if (values == null) {
            ZendDebugMessage.$$$reportNull$$$0(3);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder2.append(",");
            }
            builder2.append(value);
        }
        ZendDebugMessage.appendParameters(parameters, key, builder2.toString());
    }

    protected static void appendParameters(Map<String, String> parameters, @NotNull String key, int value) {
        if (key == null) {
            ZendDebugMessage.$$$reportNull$$$0(4);
        }
        parameters.put(key, String.valueOf(value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = VALUE;
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "values";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/debug/zend/messages/ZendDebugMessage";
        objectArray[2] = "appendParameters";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

