/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.connection;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.InputReader;
import com.jetbrains.php.debug.connection.OutputWriter;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnectionDetacher;
import com.jetbrains.php.debug.zend.handlers.EvalResponseHandler;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerBooleanEvalResponseHandler;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.EvalRequest;
import com.jetbrains.php.debug.zend.messages.GetCallTraceResponse;
import com.jetbrains.php.debug.zend.messages.GetCodeCoverageResponse;
import com.jetbrains.php.debug.zend.messages.GetProfilerInfoResponse;
import com.jetbrains.php.debug.zend.messages.GetScriptProfilerInfoResponse;
import com.jetbrains.php.debug.zend.messages.SessionStartNotification;
import com.jetbrains.php.debug.zend.messages.SetProtocolRequest;
import com.jetbrains.php.debug.zend.messages.SetProtocolResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugInputMessage;
import com.jetbrains.php.debug.zend.messages.ZendDebugOutputMessage;
import com.jetbrains.php.util.PhpUrlUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerConnection
extends PhpDebugConnection<ZendDebugInputMessage, ZendDebugOutputMessage> {
    private int myProtocolVersion;
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    private ProfilerData myProfilerData = null;
    @Nullable
    private CodeCoverageData myCodeCoverageData = null;

    public ZendDebuggerConnection(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(0);
        }
        return configuration;
    }

    @Nullable
    public ProfilerData getProfilerData() {
        return this.myProfilerData;
    }

    @Nullable
    public CodeCoverageData getCodeCoverageData() {
        return this.myCodeCoverageData;
    }

    public void setProfilerData(@Nullable ProfilerData profilerData) {
        this.myProfilerData = profilerData;
    }

    public void setCodeCoverageData(@Nullable CodeCoverageData codeCoverageData) {
        this.myCodeCoverageData = codeCoverageData;
    }

    @Override
    public void init() throws IOException {
        ZendDebugInputMessage message = (ZendDebugInputMessage)this.myInputReader.read();
        this.logMessage(message, "<-");
        if (!(message instanceof SessionStartNotification)) {
            throw new IOException("");
        }
        SessionStartNotification sessionStartNotification = (SessionStartNotification)message;
        String filename = sessionStartNotification.getFilename();
        String queryString = sessionStartNotification.getQuery();
        String modeString = sessionStartNotification.getMode();
        this.myProtocolVersion = sessionStartNotification.getProtocolId();
        this.myConfiguration = Configuration.parse(filename, queryString, modeString);
    }

    @Override
    @NotNull
    public String getSessionId() {
        String string = this.myConfiguration.getSessionId();
        if (string == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFilePath() {
        String string = this.myConfiguration.getFileName();
        if (string == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public Version getEngineVersion() {
        return new Version(this.myProtocolVersion, 0, 0);
    }

    @Override
    @NotNull
    public String getEngineName() {
        String string = ZendDebuggerExtension.INSTANCE.getName();
        if (string == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public String getPhpVersion() {
        return null;
    }

    @Override
    public void startDetach(@Nullable String reason) {
        this.startDetach(false);
    }

    @Override
    protected boolean isDebugSessionActive() {
        return true;
    }

    public void startDetach(boolean collectInfo) {
        ZendDebuggerConnectionDetacher detacher = new ZendDebuggerConnectionDetacher(this, collectInfo);
        detacher.init();
    }

    @Override
    @NotNull
    protected InputReader<ZendDebugInputMessage> createInputReader(InputStream in) {
        return new MyInputReader(in);
    }

    @Override
    @NotNull
    protected OutputWriter<ZendDebugOutputMessage> createOutputWriter(OutputStream out) {
        return new MyOutputWriter(out);
    }

    @Override
    public void evalBoolean(@NotNull String booleanExpression, @NotNull String encoding, final @NotNull PhpDebugProcess.BooleanEvaluateCallback callback) {
        if (booleanExpression == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(6);
        }
        this.send(new EvalRequest(booleanExpression), new ZendDebuggerBooleanEvalResponseHandler(){

            @Override
            public void onEval(boolean value) {
                callback.evaluated(value);
            }

            @Override
            public void onEvalError() {
                callback.errorOccurred();
            }
        });
    }

    @Override
    public void evalString(@NotNull String expression, @NotNull String encoding, final @NotNull PhpDebugProcess.StringEvaluateCallback callback) {
        if (expression == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(7);
        }
        if (encoding == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(9);
        }
        this.send(new EvalRequest(expression), new EvalResponseHandler(){

            @Override
            public void onEvalSuccess(@NotNull String result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.evaluated(result);
            }

            @Override
            public void onEvalError() {
                callback.errorOccurred();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$2", "onEvalSuccess"));
            }
        });
    }

    @Override
    protected void initialize(final @NotNull PhpDebugProcess.InitializeCallback callback, boolean isExternalConnection) {
        Configuration configuration;
        if (callback == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(10);
        }
        final int requiredProtocolVersion = (configuration = this.getConfiguration()).isStartProfiler() ? 2006040905 : 2006040705;
        this.send(new SetProtocolRequest(requiredProtocolVersion), new ZendDebuggerResponseHandler<SetProtocolResponse>(){

            @Override
            public void onSuccessResponse(@NotNull SetProtocolResponse message) {
                if (message == null) {
                    3.$$$reportNull$$$0(0);
                }
                callback.initialized(false);
            }

            @Override
            public void onErrorResponse(@NotNull SetProtocolResponse message) {
                if (message == null) {
                    3.$$$reportNull$$$0(1);
                }
                String protocolVersionString = String.valueOf(requiredProtocolVersion);
                callback.errorOccurred(PhpBundle.message("debug.zend.cannot.accept.incoming.connection", new Object[0]), PhpBundle.message("debug.zend.required.protocol.version.0.or.higher", protocolVersionString));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected void handleClassCastException(@NotNull ClassCastException e) {
        if (e == null) {
            ZendDebuggerConnection.$$$reportNull$$$0(11);
        }
        LOG.error("Can not handle debugger response due to wrong response type", (Throwable)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "booleanExpression";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEngineName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evalBoolean";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evalString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleClassCastException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static class ProfilerData {
        @NotNull
        private final GetProfilerInfoResponse myProfilerInfoResponse;
        private final GetScriptProfilerInfoResponse @NotNull [] myScriptProfilerInfoResponses;
        @NotNull
        private final GetCallTraceResponse myCallTraceResponses;

        public ProfilerData(@NotNull GetProfilerInfoResponse profilerInfoResponse, GetScriptProfilerInfoResponse @NotNull [] scriptProfilerInfoResponses, @NotNull GetCallTraceResponse callTraceResponses) {
            if (profilerInfoResponse == null) {
                ProfilerData.$$$reportNull$$$0(0);
            }
            if (callTraceResponses == null) {
                ProfilerData.$$$reportNull$$$0(1);
            }
            if (scriptProfilerInfoResponses == null) {
                ProfilerData.$$$reportNull$$$0(2);
            }
            this.myProfilerInfoResponse = profilerInfoResponse;
            this.myScriptProfilerInfoResponses = scriptProfilerInfoResponses;
            this.myCallTraceResponses = callTraceResponses;
        }

        @NotNull
        public GetProfilerInfoResponse getProfilerInfoResponse() {
            GetProfilerInfoResponse getProfilerInfoResponse = this.myProfilerInfoResponse;
            if (getProfilerInfoResponse == null) {
                ProfilerData.$$$reportNull$$$0(3);
            }
            return getProfilerInfoResponse;
        }

        public GetScriptProfilerInfoResponse @NotNull [] getScriptProfilerInfoResponses() {
            if (this.myScriptProfilerInfoResponses == null) {
                ProfilerData.$$$reportNull$$$0(4);
            }
            return this.myScriptProfilerInfoResponses;
        }

        @NotNull
        public GetCallTraceResponse getCallTraceResponses() {
            GetCallTraceResponse getCallTraceResponse = this.myCallTraceResponses;
            if (getCallTraceResponse == null) {
                ProfilerData.$$$reportNull$$$0(5);
            }
            return getCallTraceResponse;
        }

        public void serialize(DataOutputStream out) throws IOException {
            this.myProfilerInfoResponse.serialize(out);
            for (GetScriptProfilerInfoResponse it : this.myScriptProfilerInfoResponses) {
                it.serialize(out);
            }
            this.myCallTraceResponses.serialize(out);
        }

        public static ProfilerData deserialize(DataInputStream inputStream) throws IOException {
            GetProfilerInfoResponse profilerInfoResponse = new GetProfilerInfoResponse();
            profilerInfoResponse.deserialize(inputStream);
            int length = profilerInfoResponse.getScripts().length;
            GetScriptProfilerInfoResponse[] scriptProfilerInfoResponses = new GetScriptProfilerInfoResponse[length];
            for (int i = 0; i < length; ++i) {
                GetScriptProfilerInfoResponse scriptProfilerInfoResponse = new GetScriptProfilerInfoResponse();
                scriptProfilerInfoResponses[i] = (GetScriptProfilerInfoResponse)scriptProfilerInfoResponse.deserialize(inputStream);
            }
            GetCallTraceResponse callTraceResponse = new GetCallTraceResponse();
            callTraceResponse.deserialize(inputStream);
            return new ProfilerData(profilerInfoResponse, scriptProfilerInfoResponses, callTraceResponse);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerInfoResponse";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callTraceResponses";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptProfilerInfoResponses";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$ProfilerData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$ProfilerData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilerInfoResponse";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptProfilerInfoResponses";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallTraceResponses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class CodeCoverageData {
        @NotNull
        private final GetCodeCoverageResponse myCodeCoverageResponse;

        public CodeCoverageData(@NotNull GetCodeCoverageResponse codeCoverageResponse) {
            if (codeCoverageResponse == null) {
                CodeCoverageData.$$$reportNull$$$0(0);
            }
            this.myCodeCoverageResponse = codeCoverageResponse;
        }

        @NotNull
        public GetCodeCoverageResponse getCodeCoverageResponse() {
            GetCodeCoverageResponse getCodeCoverageResponse = this.myCodeCoverageResponse;
            if (getCodeCoverageResponse == null) {
                CodeCoverageData.$$$reportNull$$$0(1);
            }
            return getCodeCoverageResponse;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeCoverageResponse";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$CodeCoverageData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$CodeCoverageData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeCoverageResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class Configuration {
        @NotNull
        private String mySessionId;
        @NotNull
        private String myFileName;
        private boolean myStartProfiler;
        private boolean myDebugCoverage;

        @NotNull
        public String getSessionId() {
            String string = this.mySessionId;
            if (string == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isStartProfiler() {
            return this.myStartProfiler;
        }

        public boolean isDebugCoverage() {
            return this.myDebugCoverage;
        }

        @NotNull
        public static Configuration parse(@NotNull String fileName, @NotNull String queryString, @NotNull String modeString) {
            if (fileName == null) {
                Configuration.$$$reportNull$$$0(2);
            }
            if (queryString == null) {
                Configuration.$$$reportNull$$$0(3);
            }
            if (modeString == null) {
                Configuration.$$$reportNull$$$0(4);
            }
            Configuration conf = new Configuration();
            conf.myFileName = fileName;
            Map<String, String> queryParameters = PhpUrlUtil.parseParameters(queryString);
            String sessionId = queryParameters.get("debug_session_id");
            assert (sessionId != null);
            conf.mySessionId = sessionId;
            Map<String, String> modeParameters = PhpUrlUtil.parseParameters(modeString);
            conf.myStartProfiler = Configuration.isOptionEnabled(modeParameters, "start_profile");
            if (!conf.myStartProfiler) {
                conf.myStartProfiler = modeString.contains("start_profile");
            }
            conf.myDebugCoverage = Configuration.isOptionEnabled(queryParameters, "debug_coverage");
            Configuration configuration = conf;
            if (configuration == null) {
                Configuration.$$$reportNull$$$0(5);
            }
            return configuration;
        }

        private static boolean isOptionEnabled(@NotNull Map<String, String> parameters, @NotNull String parameterName) {
            String parameterValue;
            if (parameters == null) {
                Configuration.$$$reportNull$$$0(6);
            }
            if (parameterName == null) {
                Configuration.$$$reportNull$$$0(7);
            }
            return !StringUtil.isEmpty((String)(parameterValue = parameters.get(parameterName))) && "1".equals(parameterValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$Configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryString";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modeString";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSessionId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$Configuration";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isOptionEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyInputReader
    implements InputReader<ZendDebugInputMessage> {
        private final DataInputStream myDataInputStream;

        private MyInputReader(InputStream inputStream) {
            this.myDataInputStream = new DataInputStream(inputStream);
        }

        @Override
        @NotNull
        public ZendDebugInputMessage read() throws IOException {
            ZendDebugInputMessage message = ZendDebugUtil.readMessage(ZendDebugUtil.readPacket(this.myDataInputStream));
            if (message != null) {
                ZendDebugInputMessage zendDebugInputMessage = message;
                if (zendDebugInputMessage == null) {
                    MyInputReader.$$$reportNull$$$0(0);
                }
                return zendDebugInputMessage;
            }
            throw new IOException("Cannot read input message");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/zend/connection/ZendDebuggerConnection$MyInputReader", "read"));
        }
    }

    private static final class MyOutputWriter
    implements OutputWriter<ZendDebugOutputMessage> {
        private final DataOutputStream myDataOutputStream;

        private MyOutputWriter(OutputStream outputStream) {
            this.myDataOutputStream = new DataOutputStream(outputStream);
        }

        @Override
        public void write(ZendDebugOutputMessage output) throws IOException {
            ZendDebugUtil.writeMessage(this.myDataOutputStream, output);
        }
    }
}

