/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.cloud.connection;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.cloud.CloudConnectionRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.cloud.CloudConnectionResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.cloud.CloudInitRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.cloud.CloudStopRequest;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;

public class XdebugCloudInitializer {
    private final String myCloudId;
    private final String myCloudHost;
    private final int myCloudPort;
    private XdebugConnection.MyInputReader myInputReader;
    private XdebugConnection.MyOutputWriter myOutputWriter;
    private final AtomicInteger myRequestId;

    public XdebugCloudInitializer(@NotNull String cloudId, @NotNull String cloudHost, int cloudPort) {
        if (cloudId == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(0);
        }
        if (cloudHost == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(1);
        }
        this.myRequestId = new AtomicInteger(0);
        this.myCloudId = cloudId;
        this.myCloudHost = cloudHost;
        this.myCloudPort = cloudPort;
    }

    @NotNull
    private SSLSocket createSocket() throws IOException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket mySSLSocket = (SSLSocket)factory.createSocket(this.myCloudHost, this.myCloudPort);
        mySSLSocket.setNeedClientAuth(false);
        mySSLSocket.startHandshake();
        SSLSocket sSLSocket = mySSLSocket;
        if (sSLSocket == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(2);
        }
        return sSLSocket;
    }

    private synchronized SSLSocket connectToXdebugCloud() throws IOException {
        SSLSocket socket = this.createSocket();
        this.myInputReader = new XdebugConnection.MyInputReader(socket.getInputStream());
        this.myOutputWriter = new XdebugConnection.MyOutputWriter(socket.getOutputStream());
        return socket;
    }

    public void unregisterUserId() throws IOException {
        SSLSocket socket = this.connectToXdebugCloud();
        this.doSendRequestAsync(socket, new CloudStopRequest(this.myCloudId));
    }

    @NotNull
    public SSLSocket registerUserId() throws IOException {
        this.unregisterUserId();
        SSLSocket socket = this.connectToXdebugCloud();
        CloudConnectionResponse response = this.doSendRequestAsync(socket, new CloudInitRequest(this.myCloudId));
        if (!response.isSuccessful()) {
            throw new IOException(StringUtil.notNullize((String)response.getError(), (String)PhpBundle.message("xdebug.cloud.cannot.register.cloud.id", new Object[0])));
        }
        SSLSocket sSLSocket = socket;
        if (sSLSocket == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(3);
        }
        return sSLSocket;
    }

    private synchronized CloudConnectionResponse doSendRequestAsync(Socket socket, @NotNull CloudConnectionRequest request) throws IOException {
        if (request == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(4);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.doSendRequest(request));
        while (true) {
            try {
                ProgressManager.checkCanceled();
                return (CloudConnectionResponse)future.get(2L, TimeUnit.SECONDS);
            }
            catch (ProcessCanceledException e) {
                if (socket != null && !socket.isClosed()) {
                    socket.close();
                }
                throw e;
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
            catch (InterruptedException | TimeoutException exception) {
                continue;
            }
            break;
        }
    }

    private CloudConnectionResponse doSendRequest(@NotNull CloudConnectionRequest request) throws IOException {
        if (request == null) {
            XdebugCloudInitializer.$$$reportNull$$$0(5);
        }
        request.setRequestId(this.myRequestId.incrementAndGet());
        this.myOutputWriter.write(request);
        DbgpInputMessage response = this.myInputReader.read();
        if (!(response instanceof CloudConnectionResponse)) {
            throw new IOException(PhpBundle.message("xdebug.cloud.cannot.register.cloud.id.unexpected.response", new Object[0]));
        }
        return (CloudConnectionResponse)response;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloudHost";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudInitializer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/cloud/connection/XdebugCloudInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSocket";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerUserId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSendRequestAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSendRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

