/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XdebugUtil {
    public static final int DBGP_GLOBAL_CONTEXT_ID = 1;

    private XdebugUtil() {
    }

    public static boolean isInteger(@NotNull String value) {
        if (value == null) {
            XdebugUtil.$$$reportNull$$$0(0);
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isBeforeXdebug29(@Nullable String version) {
        Version versionObj = StringUtil.isNotEmpty((String)version) ? Version.parseVersion((String)version) : null;
        return versionObj != null && versionObj.lessThan(Integer.valueOf(2), Integer.valueOf(9));
    }

    public static boolean isAtLeastXdebug3(@Nullable String version) {
        Version versionObj = StringUtil.isNotEmpty((String)version) ? Version.parseVersion((String)version) : null;
        return versionObj != null && versionObj.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(0));
    }

    public static XDebugVersion getXDebugVersion(@NotNull Project project) {
        PhpInterpreter interpreter;
        if (project == null) {
            XdebugUtil.$$$reportNull$$$0(1);
        }
        if ((interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter()) == null) {
            return XDebugVersion.UNKNOWN;
        }
        return XdebugUtil.getXDebugVersion(interpreter, project);
    }

    public static XDebugVersion getXDebugVersion(@NotNull PhpInterpreter interpreter, @NotNull Project project) {
        PhpInterpretersPhpInfoCacheImpl infoCache;
        PhpInfo info;
        if (interpreter == null) {
            XdebugUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            XdebugUtil.$$$reportNull$$$0(3);
        }
        if ((info = (infoCache = PhpInterpretersPhpInfoCacheImpl.getInstance(project)).getPhpInfo(interpreter.getName())) == null) {
            info = infoCache.updateAnGet(project, interpreter.getName(), null);
        }
        if (info != null) {
            Optional<String> xdebugVersion = XdebugConfigurationOptionsManager.getXdebugVersion(info);
            if (xdebugVersion.isEmpty() || xdebugVersion.get().isEmpty()) {
                return XDebugVersion.UNKNOWN;
            }
            if (XdebugUtil.isAtLeastXdebug3(xdebugVersion.get())) {
                return XDebugVersion.VERSION3;
            }
            return XDebugVersion.VERSION2;
        }
        return XDebugVersion.UNKNOWN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/XdebugUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInteger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getXDebugVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum XDebugVersion {
        VERSION2("xdebug.remote_port", Arrays.asList("-dxdebug.remote_enable=false", "-dxdebug.default_enable=false", "-dxdebug.profiler_enable=0"), "2"),
        VERSION3("xdebug.client_port", Collections.singletonList("-dxdebug.mode=off"), "3"),
        UNKNOWN("xdebug.remote_port/xdebug.client_port", Collections.emptyList(), "UNKNOWN");

        private final String myPortSetting;
        private final List<String> myDisableSettings;
        @Nls
        private final String myVersionString;

        private XDebugVersion(@Nls String portSetting, List<String> disableSettings, String versionString) {
            this.myPortSetting = portSetting;
            this.myDisableSettings = disableSettings;
            this.myVersionString = versionString;
        }

        public String getPortSetting() {
            return this.myPortSetting;
        }

        public List<String> getDisableSettings() {
            return this.myDisableSettings;
        }

        @Nls
        public String toString() {
            return this.myVersionString;
        }
    }
}

