/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug;

import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.net.NetUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.debug.xdebug.cloud.XdebugCloudSettings;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudConnectionManager;
import com.jetbrains.php.debug.xdebug.cloud.connection.XdebugCloudServer;
import com.jetbrains.php.debug.xdebug.connection.XdebugCompositeServer;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.connection.XdebugServer;
import com.jetbrains.php.debug.xdebug.connection.XdebugServerConnectionManager;
import com.jetbrains.php.debug.xdebug.debugger.XdebugDriver;
import com.jetbrains.php.debug.xdebug.options.XdebugConfigurationOptionsManager;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.util.QueryString;
import com.jetbrains.php.util.connection.PhpConnectionInitCallback;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugExtension
implements PhpDebugExtension {
    public static final XdebugExtension INSTANCE = new XdebugExtension();
    public static final String NAME = "xdebug";
    private static final String PARAMETER_XDEBUG_SESSION_START = "XDEBUG_SESSION_START";
    private static final String ENV_XDEBUG_CONFIG = "XDEBUG_CONFIG";

    @Override
    @NotNull
    public String getId() {
        return NAME;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public List<PhpConfigurationOption> getDebugConfigurationsOptions(@NotNull Project project, @NotNull String remoteHost, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(0);
        }
        if (remoteHost == null) {
            XdebugExtension.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            XdebugExtension.$$$reportNull$$$0(2);
        }
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        List<PhpConfigurationOption> list = XdebugConfigurationOptionsManager.getConfigurationOptionsProvider(project, interpreter).enable().addXdebugRemoteMode("req").addXdebugRemotePort(state.getXDebugDebugPort()).addXdebugRemoteHost(remoteHost).createXdebugConfigurations();
        if (list == null) {
            XdebugExtension.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer<XdebugConnection> startDebugServer(@NotNull Project project, @Nullable PhpConnectionInitCallback callback) throws ExecutionException {
        XdebugCloudSettings.State xdebugCloud;
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(4);
        }
        if ((xdebugCloud = XdebugCloudSettings.getInstance(project).getState()).isEnabled()) {
            XdebugCloudServer xdebugCloudServer = XdebugCloudConnectionManager.getInstance().start(xdebugCloud.getCloudId(), xdebugCloud.getCloudHost(), xdebugCloud.getCloudPort(), callback != null ? callback : error -> {});
            if (xdebugCloudServer == null) {
                XdebugExtension.$$$reportNull$$$0(5);
            }
            return xdebugCloudServer;
        }
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        HashSet<Integer> debugPort = new HashSet<Integer>(state.getXDebugDebugPorts());
        if (debugPort.isEmpty()) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("PhpDebugConfigurable.xdebug.debug.port", new Object[0])));
        }
        if (debugPort.size() == 1) {
            PhpIncomingDebugConnectionServer<XdebugConnection> phpIncomingDebugConnectionServer = this.startDebugServer(project, (Integer)debugPort.iterator().next(), callback);
            if (phpIncomingDebugConnectionServer == null) {
                XdebugExtension.$$$reportNull$$$0(6);
            }
            return phpIncomingDebugConnectionServer;
        }
        ArrayList<PhpIncomingDebugConnectionServer<XdebugConnection>> servers = new ArrayList<PhpIncomingDebugConnectionServer<XdebugConnection>>();
        for (Integer port : debugPort) {
            servers.add(this.startDebugServer(project, port, callback));
        }
        return new XdebugCompositeServer(servers);
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer<XdebugConnection> startLocalDebugServer(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(7);
        }
        int debugPort = PhpProjectDebugConfiguration.getInstance(project).getState().getXDebugDebugPort();
        PhpIncomingDebugConnectionServer<XdebugConnection> phpIncomingDebugConnectionServer = this.startDebugServer(project, debugPort, null);
        if (phpIncomingDebugConnectionServer == null) {
            XdebugExtension.$$$reportNull$$$0(8);
        }
        return phpIncomingDebugConnectionServer;
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer<XdebugConnection> startDebugServer(@NotNull Project project, int port, @Nullable PhpConnectionInitCallback callback) throws ExecutionException {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(9);
        }
        XdebugServer server = (XdebugServer)XdebugServerConnectionManager.getInstance().start(port);
        if (callback != null) {
            callback.onInit(null);
        }
        XdebugServer xdebugServer = server;
        if (xdebugServer == null) {
            XdebugExtension.$$$reportNull$$$0(10);
        }
        return xdebugServer;
    }

    @Override
    @Nullable
    public PhpIncomingDebugConnectionServer startLocalDebugServer(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            XdebugExtension.$$$reportNull$$$0(12);
        }
        try {
            return this.startLocalDebugServer(project);
        }
        catch (ExecutionException ex) {
            int availableSocketPort;
            try {
                availableSocketPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException ioe) {
                XdebugExtension.notify(PhpBundle.message("debug.cannot.find.port", new Object[0]), PhpBundle.message("debug.check.firewall", new Object[0]), project, new AnAction[0]);
                return null;
            }
            PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
            ArrayList<Integer> ports = new ArrayList<Integer>(availableSocketPort);
            ports.addAll(state.getXDebugDebugPorts());
            ports.add(availableSocketPort);
            state.setXDebugDebugPorts(ports);
            final String portSetting = XdebugUtil.getXDebugVersion(interpreter, project).getPortSetting() + "=" + availableSocketPort;
            XdebugExtension.notify(PhpBundle.message("debug.cannot.start.listening.for.connections.from.0", INSTANCE.getName()), PhpBundle.message("debug.port.is.updated", PhpProjectDebugConfiguration.getInstance(project).getState().getXDebugDebugPort(), availableSocketPort, portSetting), project, new AnAction(PhpBundle.message("action.copy.to.clipboard.text", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(portSetting), null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/xdebug/XdebugExtension$1", "actionPerformed"));
                }
            });
            return null;
        }
    }

    private static void notify(@NotNull @Nls String title, @Nls @NotNull String text, @NotNull Project project, AnAction ... anActions) {
        if (title == null) {
            XdebugExtension.$$$reportNull$$$0(13);
        }
        if (text == null) {
            XdebugExtension.$$$reportNull$$$0(14);
        }
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(15);
        }
        Notification notification = new Notification("PhpDebugListener", title, text, NotificationType.WARNING);
        notification.addActions(List.of(anActions));
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @Override
    @NotNull
    public PhpDebugConnectionManager createDebugConnectionManager() {
        return new PhpDebugConnectionManager();
    }

    @Override
    @NotNull
    public PhpDebugDriver getDebugDriver() {
        XdebugDriver xdebugDriver = XdebugDriver.INSTANCE;
        if (xdebugDriver == null) {
            XdebugExtension.$$$reportNull$$$0(16);
        }
        return xdebugDriver;
    }

    @Override
    @NotNull
    public Map<String, String> getDebugEnv(@NotNull Project project, boolean breakAtTheFirstLine, @NotNull String sessionId) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(17);
        }
        if (sessionId == null) {
            XdebugExtension.$$$reportNull$$$0(18);
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put(ENV_XDEBUG_CONFIG, "idekey=" + sessionId);
        HashMap<String, String> hashMap = envs;
        if (hashMap == null) {
            XdebugExtension.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public QueryString getDebugQuery(@NotNull Project project, boolean breakAtFistLine, @NotNull String sessionId) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(20);
        }
        if (sessionId == null) {
            XdebugExtension.$$$reportNull$$$0(21);
        }
        QueryString queryString = new QueryString();
        queryString.addParameter(PARAMETER_XDEBUG_SESSION_START, sessionId);
        QueryString queryString2 = queryString;
        if (queryString2 == null) {
            XdebugExtension.$$$reportNull$$$0(22);
        }
        return queryString2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 10, 16, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHost";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/XdebugExtension";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/XdebugExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugConfigurationsOptions";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugServer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startLocalDebugServer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugDriver";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugEnv";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDebugConfigurationsOptions";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 19: 
            case 22: {
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startDebugServer";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startLocalDebugServer";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDebugEnv";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDebugQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 10, 16, 19, 22 -> new IllegalStateException(string);
        };
    }
}

