/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class ZendDebugConfiguration
extends PhpDebugConfiguration {
    private ExposeRemotely myRemoteMode;
    private String myHost;
    private String myDenyHosts;

    @NotNull
    public static ZendDebugConfiguration parseConfiguration(@NotNull Attributes attributes) {
        if (attributes == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(0);
        }
        ZendDebugConfiguration configuration = new ZendDebugConfiguration();
        configuration.myRemoteMode = ExposeRemotely.getInstance(attributes.getValue("enable"));
        configuration.myHost = attributes.getValue("host");
        configuration.myDenyHosts = attributes.getValue("deny_hosts");
        ZendDebugConfiguration zendDebugConfiguration = configuration;
        if (zendDebugConfiguration == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(1);
        }
        return zendDebugConfiguration;
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @NotNull String serverHost, @Nullable String remoteAddr, boolean docker, Project project) {
        String message;
        boolean isLocalServer;
        if (messages == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(2);
        }
        if (serverHost == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(3);
        }
        String name = PhpDebugUtil.getDebuggerNameById("php.debugger.ZendDebugger");
        messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.loaded.debugger.extension", name), null, new Runnable[0]));
        boolean bl = isLocalServer = ZendDebugConfiguration.isLocalhost(serverHost) || ZendDebugConfiguration.isLocalhost(remoteAddr);
        if (!isLocalServer && ZendDebugConfiguration.isLocalhost(this.myHost.trim())) {
            String description = PhpBundle.message("php.web.server.validation.zend.debugger.localhost.description", new Object[0]);
            messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.zend.debugger.localhost", new Object[0]), description, new Runnable[0]));
        } else if (StringUtil.isNotEmpty((String)this.myHost)) {
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.zend.debugger.host", this.myHost), null, new Runnable[0]));
        }
        if (StringUtil.isNotEmpty((String)this.myDenyHosts)) {
            message = PhpBundle.message("php.web.server.validation.zend.debugger.deny.host", this.myDenyHosts);
            messages.add(PhpInfoValidationMessage.error(message, PhpBundle.message("php.web.server.validation.zend.debugger.deny.host.description", new Object[0]), new Runnable[0]));
        }
        message = PhpBundle.message("php.web.server.validation.zend.expose.remotely", this.myRemoteMode.getPresentableName());
        messages.add(PhpInfoValidationMessage.message(this.myRemoteMode == ExposeRemotely.NEVER ? PhpInfoValidationMessage.MessageType.ERROR : PhpInfoValidationMessage.MessageType.INFO, message, ZendDebugConfiguration.getDescription(this.myRemoteMode), new Runnable[0]));
    }

    @NotNull
    @Nls
    private static String getDescription(@NotNull ExposeRemotely mode) {
        if (mode == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(4);
        }
        String string = PhpBundle.message(switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ExposeRemotely.ALLOWED_HOSTS -> "php.web.server.validation.zend.expose.remotely.allowed.hosts.description";
            case ExposeRemotely.ALWAYS -> "php.web.server.validation.zend.expose.remotely.always.description";
            case ExposeRemotely.NEVER -> "php.web.server.validation.zend.expose.remotely.never.description";
        }, new Object[0]);
        if (string == null) {
            ZendDebugConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/ZendDebugConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/ZendDebugConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseConfiguration";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    private static enum ExposeRemotely {
        ALWAYS("always", List.of("always", "1")),
        ALLOWED_HOSTS("allowed hosts only", List.of("allowed_hosts", "2")),
        NEVER("never", List.of());

        private final String myPresentableName;
        private final List<String> myKeys;

        private ExposeRemotely(String name, List<String> keys) {
            if (name == null) {
                ExposeRemotely.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                ExposeRemotely.$$$reportNull$$$0(1);
            }
            this.myPresentableName = name;
            this.myKeys = keys;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                ExposeRemotely.$$$reportNull$$$0(2);
            }
            return string;
        }

        public static ExposeRemotely getInstance(@Nullable String inputKey) {
            if (StringUtil.isNotEmpty((String)inputKey)) {
                for (ExposeRemotely option : ExposeRemotely.values()) {
                    for (String optionKey : option.myKeys) {
                        if (!optionKey.equalsIgnoreCase(inputKey)) continue;
                        return option;
                    }
                }
            }
            return NEVER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/ZendDebugConfiguration$ExposeRemotely";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/ZendDebugConfiguration$ExposeRemotely";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

