/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.factories.Xdebug2ConfigurationFactory;
import com.jetbrains.php.debug.validation.configuration.factories.Xdebug3ConfigurationFactory;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.Set;
import org.apache.http.conn.util.InetAddressUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class XdebugConfiguration
extends PhpDebugConfiguration {
    protected static final String XDEBUG_REMOTE_MODE_URL = "https://xdebug.org/docs/all_settings#remote_mode";
    protected static final String XDEBUG_REMOTE_CONNECT_BACK_URL = "https://xdebug.org/docs/all_settings#remote_connect_back";
    protected static final String DBGP = "dbgp";
    private static final int MIN_PORT = 1024;
    protected static final String CONFIGURING_XDEBUG_DOCKER = "https://www.jetbrains.com/help/phpstorm/configuring-xdebug.html#configuring-xdebug-docker";
    protected final String myVersion;
    protected final boolean myIsLoadedByZendExtension;
    protected final String myProtocol;
    protected final String myHost;
    protected final String myPort;
    protected final String myLog;
    protected final boolean myIsConnectBack;

    protected XdebugConfiguration(String version, boolean isLoadedByZendExtension, String protocol, String host, String port, String log, boolean isConnectBack) {
        this.myVersion = version;
        this.myIsLoadedByZendExtension = isLoadedByZendExtension;
        this.myProtocol = protocol;
        this.myHost = host;
        this.myPort = port;
        this.myLog = log;
        this.myIsConnectBack = isConnectBack;
    }

    @NotNull
    public static XdebugConfiguration parseConfiguration(@NotNull Project project, @NotNull Attributes attributes) {
        if (project == null) {
            XdebugConfiguration.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            XdebugConfiguration.$$$reportNull$$$0(1);
        }
        if (XdebugUtil.isAtLeastXdebug3(attributes.getValue("version"))) {
            XdebugConfiguration xdebugConfiguration = new Xdebug3ConfigurationFactory(project).parseConfiguration(attributes);
            if (xdebugConfiguration == null) {
                XdebugConfiguration.$$$reportNull$$$0(2);
            }
            return xdebugConfiguration;
        }
        XdebugConfiguration xdebugConfiguration = new Xdebug2ConfigurationFactory().parseConfiguration(attributes);
        if (xdebugConfiguration == null) {
            XdebugConfiguration.$$$reportNull$$$0(3);
        }
        return xdebugConfiguration;
    }

    protected abstract PhpInfoValidationMessage onWrongHostConfigurationAsLocalhost(@Nullable String var1);

    protected abstract PhpInfoValidationMessage onSuccessfulHostConfiguration();

    protected PhpInfoValidationMessage onBusyPortConfiguration(int availableSocket) {
        String message = PhpBundle.message("connection.port.is.busy", this.myPort);
        String description = PhpBundle.message("debug.port.is.updated.descr", this.myPort, availableSocket);
        return PhpInfoValidationMessage.error(message, description, new Runnable[0]);
    }

    protected PhpInfoValidationMessage onNoFreePortsConfiguration() {
        String message = PhpBundle.message("debug.cannot.find.port", new Object[0]);
        String description = PhpBundle.message("debug.check.firewall", new Object[0]);
        return PhpInfoValidationMessage.error(message, description, new Runnable[0]);
    }

    protected abstract PhpInfoValidationMessage onWrongPortConfiguration(String var1, int var2, Project var3);

    protected abstract PhpInfoValidationMessage onConnectBackEnabled();

    protected void validateHost(@NotNull List<PhpInfoValidationMessage> messages, @Nullable String serverHost, @Nullable String remoteAddr) {
        if (messages == null) {
            XdebugConfiguration.$$$reportNull$$$0(4);
        }
        Set<String> hosts = PhpProjectDebugConfiguration.detectIdeHostsSetSynchronously();
        if (!StringUtil.isEmpty((String)this.myHost) && InetAddressUtils.isIPv4Address((String)this.myHost) && !hosts.contains(this.myHost)) {
            messages.add(PhpInfoValidationMessage.recommendation(PhpBundle.message("xdebug.validation.ip.not.found", this.myHost), PhpBundle.message("xdebug.validation.ip.not.found.descr", StringUtil.join(hosts, (String)"\n")), new Runnable[0]));
        }
        if (serverHost == null) {
            messages.add(this.onSuccessfulHostConfiguration());
            return;
        }
        if (StringUtil.isNotEmpty((String)this.myHost)) {
            boolean isLocalServer;
            boolean bl = isLocalServer = XdebugConfiguration.isLocalhost(serverHost) || XdebugConfiguration.isLocalhost(remoteAddr);
            if (!isLocalServer && XdebugConfiguration.isLocalhost(this.myHost)) {
                messages.add(this.onWrongHostConfigurationAsLocalhost(remoteAddr));
            } else {
                messages.add(this.onSuccessfulHostConfiguration());
            }
        }
    }

    @Override
    public void validate(@NotNull List<PhpInfoValidationMessage> messages, @Nullable PhpProjectDebugConfiguration.State state, @Nullable String serverHost, @Nullable String remoteAddr, boolean docker, Project project) {
        block12: {
            if (messages == null) {
                XdebugConfiguration.$$$reportNull$$$0(5);
            }
            String name = PhpDebugUtil.getDebuggerNameById("php.debugger.XDebug") + (String)(this.myVersion == null ? "" : " " + this.myVersion);
            messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.loaded.debugger.extension", name), null, new Runnable[0]));
            if (!this.myIsLoadedByZendExtension) {
                String description = XdebugConfiguration.getDescription("php.web.server.validation.xdebug.zend.extension.load.description", null);
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.zend.extension.load", new Object[0]), description, new Runnable[0]));
            }
            if (docker) {
                this.validateDockerHost(messages);
            }
            this.validateHost(messages, serverHost, remoteAddr);
            try {
                int port = Integer.parseInt(this.myPort);
                if (state != null && !state.getXDebugDebugPorts().contains(port)) {
                    String portInIde = String.valueOf(state.getXDebugDebugPort());
                    messages.add(this.onWrongPortConfiguration(portInIde, port, project));
                    break block12;
                }
                if (XdebugConfiguration.isPortBusy(Integer.parseInt(this.myPort))) {
                    int availableSocketPort;
                    try {
                        availableSocketPort = NetUtils.findAvailableSocketPort();
                    }
                    catch (IOException ex) {
                        messages.add(this.onNoFreePortsConfiguration());
                        return;
                    }
                    messages.add(this.onBusyPortConfiguration(availableSocketPort));
                    break block12;
                }
                if (port < 1024) {
                    String description = PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo.description", new Object[0]);
                    messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.port.require.sudo", this.myPort), description, new Runnable[0]));
                } else {
                    messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.xdebug.port", this.myPort), null, new Runnable[0]));
                }
            }
            catch (Exception e) {
                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.xdebug.wrong.port.format", this.myPort), null, new Runnable[0]));
            }
        }
        if (this.myIsConnectBack) {
            messages.add(this.onConnectBackEnabled());
        }
    }

    private void validateDockerHost(@NotNull List<PhpInfoValidationMessage> messages) {
        if (messages == null) {
            XdebugConfiguration.$$$reportNull$$$0(6);
        }
        if (this.myHost.contains("docker") && !this.myHost.equals("host.docker.internal")) {
            messages.add(PhpInfoValidationMessage.recommendation(PhpBundle.message("docker.host.name.error", new Object[0]), PhpBundle.message("docker.host.name.error.descr", new Object[0]), CONFIGURING_XDEBUG_DOCKER, new Runnable[0]));
        }
    }

    private static boolean isPortBusy(int port) {
        boolean bl;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        Socket ignored = new Socket("localhost", port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return true;
            }
        }
        ignored.close();
        return bl;
    }

    @NotNull
    protected Runnable getChangePortAction(final int port, final Project project) {
        return new Runnable(){

            @Override
            public void run() {
                PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
                List<Integer> ports = state.getXDebugDebugPorts();
                ports.add(port);
                state.setXDebugDebugPorts(ports);
            }

            public String toString() {
                return PhpBundle.message("add.port.in.ide.settings", port);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/XdebugConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/XdebugConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseConfiguration";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateHost";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateDockerHost";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

