/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.validation.PhpWebServerEnvironmentConfiguration;
import com.jetbrains.php.debug.validation.PhpWebServerValidationException;
import com.jetbrains.php.debug.validation.configuration.PhpDebugConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PhpWebServerEnvironmentConfigurationV2
extends PhpWebServerEnvironmentConfiguration {
    private static final Logger LOG = Logger.getInstance(PhpWebServerEnvironmentConfiguration.class);

    public PhpWebServerEnvironmentConfigurationV2(@Nullable String configurationFile, @Nullable String additionalPhpIni, @Nullable String serverName, @Nullable String remoteAddr, @NotNull List<PhpDebugConfiguration> debugConfigurations, boolean ping, boolean docker, boolean phpstorm_response, String os) {
        if (debugConfigurations == null) {
            PhpWebServerEnvironmentConfigurationV2.$$$reportNull$$$0(0);
        }
        super(configurationFile, additionalPhpIni, serverName, remoteAddr, debugConfigurations, ping, docker, phpstorm_response, os);
    }

    @NotNull
    public static PhpWebServerEnvironmentConfiguration parse(@NotNull Project project, @NotNull BufferedReader reader) throws PhpWebServerValidationException {
        if (project == null) {
            PhpWebServerEnvironmentConfigurationV2.$$$reportNull$$$0(1);
        }
        if (reader == null) {
            PhpWebServerEnvironmentConfigurationV2.$$$reportNull$$$0(2);
        }
        SmartList debuggers = new SmartList();
        final Ref additionalPhpIni = new Ref(null);
        final Ref configurationFile = new Ref();
        Ref serverName = new Ref(null);
        Ref remoteAddr = new Ref(null);
        Ref ping = new Ref((Object)false);
        Ref phpstorm = new Ref((Object)false);
        Ref docker = new Ref((Object)false);
        Ref os = new Ref((Object)"");
        StringBuilder result = new StringBuilder();
        try {
            String line = reader.readLine();
            if (line == null || StringUtil.isEmpty((String)line)) {
                throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.script.result.is.empty", new Object[0]), null);
            }
            result.append(line);
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(new DefaultHandler((List)debuggers, project, serverName, remoteAddr, os, ping, phpstorm, docker){
                final /* synthetic */ List val$debuggers;
                final /* synthetic */ Project val$project;
                final /* synthetic */ Ref val$serverName;
                final /* synthetic */ Ref val$remoteAddr;
                final /* synthetic */ Ref val$os;
                final /* synthetic */ Ref val$ping;
                final /* synthetic */ Ref val$phpstorm;
                final /* synthetic */ Ref val$docker;
                {
                    this.val$debuggers = list;
                    this.val$project = project;
                    this.val$serverName = ref3;
                    this.val$remoteAddr = ref4;
                    this.val$os = ref5;
                    this.val$ping = ref6;
                    this.val$phpstorm = ref7;
                    this.val$docker = ref8;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("Loaded php.ini".equals(attributes.getValue("section_name"))) {
                        String path = attributes.getValue("path");
                        if (StringUtil.isNotEmpty((String)path) && configurationFile.isNull()) {
                            configurationFile.set((Object)path);
                        }
                    } else if ("Additional php.ini".equals(attributes.getValue("section_name"))) {
                        String files = attributes.getValue("files");
                        if (StringUtil.isNotEmpty((String)files)) {
                            additionalPhpIni.set((Object)files);
                        }
                    } else if ("Debugger".equals(attributes.getValue("section_name"))) {
                        this.val$debuggers.add(PhpDebugConfiguration.parse(this.val$project, attributes));
                    } else if ("Server".equals(attributes.getValue("section_name"))) {
                        this.val$serverName.set((Object)attributes.getValue("server_name"));
                        this.val$remoteAddr.set((Object)attributes.getValue("client_host"));
                        this.val$os.set((Object)attributes.getValue("server_OS"));
                    } else if ("Xdebug Connection".equals(attributes.getValue("section_name"))) {
                        this.val$ping.set((Object)"OK".equals(attributes.getValue("status")));
                        this.val$phpstorm.set((Object)"OK".equals(attributes.getValue("PhpStorm_status")));
                    } else if ("Docker".equals(attributes.getValue("section_name"))) {
                        this.val$docker.set((Object)"YES".equals(attributes.getValue("inside_docker")));
                    }
                }
            });
            xr.parse(new InputSource(new StringReader(result.toString().trim())));
        }
        catch (SAXException e) {
            LOG.warn(result.toString());
            LOG.warn((Throwable)e);
            String description = "The failure may be caused by path mappings misconfiguration or warnings during script execution.<br>If mappings are properly configured please report the <a href=\"https://youtrack.jetbrains.com/issues/WI#newissue=yes\">issue</a> with attached IDE log files (from 'Help|Show Log in Files').";
            throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.script.result.wrong.format", new Object[0]), "The failure may be caused by path mappings misconfiguration or warnings during script execution.<br>If mappings are properly configured please report the <a href=\"https://youtrack.jetbrains.com/issues/WI#newissue=yes\">issue</a> with attached IDE log files (from 'Help|Show Log in Files').");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String description = "The failure may be caused by request interruption.<br>Please check that the connection to the server is stable and try again.";
            throw new PhpWebServerValidationException(PhpBundle.message("php.web.server.validation.failed.to.fetch.script.result", new Object[0]), "The failure may be caused by request interruption.<br>Please check that the connection to the server is stable and try again.");
        }
        return new PhpWebServerEnvironmentConfiguration((String)configurationFile.get(), (String)additionalPhpIni.get(), (String)serverName.get(), (String)remoteAddr.get(), (List<PhpDebugConfiguration>)debuggers, (Boolean)ping.get(), (Boolean)docker.get(), (Boolean)phpstorm.get(), (String)os.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugConfigurations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerEnvironmentConfigurationV2";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

