/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.validation.PhpWebServerValidationDialog;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpValidateWebServerAction
extends AnAction {
    @NotNull
    private Supplier<? extends PhpServer> myServerProducer = () -> null;

    public PhpValidateWebServerAction() {
        this(() -> null);
    }

    public PhpValidateWebServerAction(@Nullable Supplier<? extends PhpServer> serverProducer) {
        super(PhpBundle.message("php.web.server.validation.action.text", new Object[0]));
        if (serverProducer != null) {
            this.myServerProducer = serverProducer;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) != null && !project.isDisposed()) {
            PhpServer server = this.myServerProducer.get();
            String url = server != null ? PhpValidateWebServerAction.getStartUrl(server) : null;
            PhpWebServerValidationDialog dialog = new PhpWebServerValidationDialog(project, url);
            dialog.show();
        }
    }

    public boolean isDumbAware() {
        return true;
    }

    @Nullable
    public static String getStartUrl(@NotNull PhpServer server) {
        String host;
        if (server == null) {
            PhpValidateWebServerAction.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(host = server.getHost()))) {
            return null;
        }
        String url = host + ":" + server.getPort();
        return StringUtil.startsWith((CharSequence)host, (CharSequence)"http") ? url : "http://" + url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpValidateWebServerAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpValidateWebServerAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

