/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpPathMappingsConverter;
import com.jetbrains.php.debug.ui.PhpProjectComboBox;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMappingsFromDeploymentDetectorForm {
    private static final Logger LOG = Logger.getInstance(PhpMappingsFromDeploymentDetectorForm.class);
    protected JPanel myMainPanel;
    protected WebServerCombo myWebServerCombo;
    private PhpProjectComboBox myProjectsComboBox;
    private JTextField myLocalFileField;
    private JPanel myPreviewPanel;
    private JPanel myMessagesPanel;
    private JLabel myProjectsLabel;
    private JLabel myDeploymentLabel;
    protected JPanel myConfigurationPanel;
    private final NullableConsumer<? super VirtualFile> mySelectedFileProcessor;
    protected VirtualFile mySelectedFile;
    private final WebServerConfig.RemotePath myPath;

    public PhpMappingsFromDeploymentDetectorForm(@NotNull String remoteFilePath, @NotNull List<Project> projects, @NotNull NullableConsumer<? super VirtualFile> selectedFileProcessor) {
        if (remoteFilePath == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(0);
        }
        if (projects == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(1);
        }
        if (selectedFileProcessor == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(2);
        }
        this.mySelectedFileProcessor = selectedFileProcessor;
        this.$$$setupUI$$$();
        this.myMessagesPanel.setLayout((LayoutManager)new VerticalFlowLayout(0));
        JBLabel label = this.createMessage();
        this.myMessagesPanel.add((Component)label);
        String title = PhpBundle.message("debug.server.import.configuration.preview.border.title", new Object[0]);
        this.myPreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
        this.myPath = new WebServerConfig.RemotePath(remoteFilePath);
        final Condition<WebServerConfig> filter = this.createWebServerFilter(this.myPath);
        Project selectedProject = projects.get(0);
        this.myProjectsLabel.setLabelFor((Component)((Object)this.myProjectsComboBox));
        this.myProjectsComboBox.setProjects(projects, selectedProject);
        if (projects.size() == 1) {
            this.myProjectsComboBox.setEnabled(false);
        }
        this.myProjectsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Project selectedItem = PhpMappingsFromDeploymentDetectorForm.this.myProjectsComboBox.getSelectedProject();
                    PhpMappingsFromDeploymentDetectorForm.this.updateWebServer(selectedItem, (Condition<WebServerConfig>)filter, PhpMappingsFromDeploymentDetectorForm.this.getRemoteFilePath());
                }
            }
        });
        this.myDeploymentLabel.setLabelFor((Component)this.myWebServerCombo);
        this.myWebServerCombo.setWebServerFilter(filter);
        this.myWebServerCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpMappingsFromDeploymentDetectorForm.this.updateLocalFile(PhpMappingsFromDeploymentDetectorForm.this.getRemoteFilePath());
            }
        });
        this.updateWebServer(selectedProject, filter, this.getRemoteFilePath());
    }

    @Nullable
    protected WebServerConfig.RemotePath getRemoteFilePath() {
        return this.myPath;
    }

    public void updateLocalFile(@Nullable WebServerConfig.RemotePath path) {
        this.mySelectedFile = this.deploymentServerWasChanged(path);
        this.mySelectedFileProcessor.consume((Object)this.mySelectedFile);
    }

    @NotNull
    protected JBLabel createMessage() {
        JBLabel label = new JBLabel();
        label.setText(PhpBundle.message("debug.server.import.from.deployment.deployment.configurations.message", new Object[0]));
        label.setIcon(UIUtil.getBalloonInformationIcon());
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(3);
        }
        return jBLabel;
    }

    @NotNull
    protected Condition<WebServerConfig> createWebServerFilter(@NotNull WebServerConfig.RemotePath path) {
        if (path == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(4);
        }
        Condition condition = config -> {
            Project selectedItem = this.myProjectsComboBox.getSelectedProject();
            return PhpPathMappingsConverter.findLocalFile(path, config, PublishConfig.getInstance((Project)selectedItem)) != null;
        };
        if (condition == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @Nullable
    public VirtualFile deploymentServerWasChanged(@Nullable WebServerConfig.RemotePath path) {
        if (path == null) {
            this.setLocalFilePath("");
            return null;
        }
        WebServerConfig server = this.myWebServerCombo.getSelectedServer();
        if (server == null) {
            this.setLocalFilePath("");
            return null;
        }
        Ref fileRef = new Ref();
        Project project = this.myProjectsComboBox.getSelectedProject();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            VirtualFile file = PhpPathMappingsConverter.findLocalFile(path, server, PublishConfig.getInstance((Project)project));
            fileRef.set((Object)file);
            this.myLocalFileField.setText(file == null ? "" : file.getPath());
        });
        return (VirtualFile)fileRef.get();
    }

    private void setLocalFilePath(@NotNull String path) {
        if (path == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(6);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> this.myLocalFileField.setText(path));
    }

    public void updateWebServer(@NotNull Project selectedItem, @NotNull Condition<WebServerConfig> filter, @Nullable WebServerConfig.RemotePath remotePath) {
        if (selectedItem == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(8);
        }
        this.myWebServerCombo.setProject(selectedItem);
        WebServerConfig selectedServer = this.findDeploymentServer(filter);
        this.myWebServerCombo.resetToServerOrGroup(selectedServer == null ? null : new ServerOrGroup().setServer(selectedServer));
        this.updateLocalFile(remotePath);
    }

    @Nullable
    public WebServerConfig findDeploymentServer(@NotNull Condition<WebServerConfig> filter) {
        if (filter == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(9);
        }
        for (WebServerConfig server : GroupedServersConfigManager.getInstance((Project)this.getSelectedProject()).getFlattenedServers()) {
            if (!filter.value((Object)server)) continue;
            return server;
        }
        return null;
    }

    public boolean isValid() {
        return this.myWebServerCombo.getSelectedServer() != null && this.getSelectedFile() != null;
    }

    @NotNull
    public Project getSelectedProject() {
        Project project = this.myProjectsComboBox.getSelectedProject();
        if (project == null) {
            PhpMappingsFromDeploymentDetectorForm.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return this.mySelectedFile;
    }

    @Nullable
    protected List<PathMappingSettings.PathMapping> getPathMappings() {
        WebServerConfig webConfig = this.myWebServerCombo.getSelectedServer();
        if (webConfig == null) {
            LOG.warn(PhpBundle.message("debug.server.can.not.detect.path.mappings.from.deployment", new Object[0]));
            return null;
        }
        return PhpPathMappingsConverter.getMappings(this.myProjectsComboBox.getSelectedProject(), webConfig, "");
    }

    private void createUIComponents() {
        this.myWebServerCombo = new WebServerCombo(false, -1, false, false);
        this.myWebServerCombo.setPreferredSize(new Dimension(200, this.myWebServerCombo.getPreferredSize().height));
        this.myProjectsComboBox = new PhpProjectComboBox();
    }

    public JPanel getComponent() {
        return this.myMainPanel;
    }

    protected void disposeUI() {
        Disposer.dispose((Disposable)this.myWebServerCombo);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConfigurationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProjectsLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpMappingsFromDeploymentDetectorForm.class).getString("debug.server.import.configuration.project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        this.myDeploymentLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpMappingsFromDeploymentDetectorForm.class).getString("debug.server.import.configuration.deployment"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel3.add((Component)jLabel, gridBagConstraints2);
        PhpProjectComboBox phpProjectComboBox = this.myProjectsComboBox;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        jPanel3.add((Component)((Object)phpProjectComboBox), gridBagConstraints3);
        WebServerCombo webServerCombo = this.myWebServerCombo;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagConstraints4.fill = 2;
        jPanel3.add((Component)webServerCombo, gridBagConstraints4);
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpMappingsFromDeploymentDetectorForm.class).getString("debug.server.import.configuration.local.file.path"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalFileField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMessagesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5), null, 0, 0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFileProcessor";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingsFromDeploymentDetectorForm";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingsFromDeploymentDetectorForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebServerFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWebServerFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLocalFilePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateWebServer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDeploymentServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 10 -> new IllegalStateException(string);
        };
    }
}

