/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpPathMappingsConfigurable;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PhpMappingAdvancedResolveDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 30;
    private static final int PATH_SUFFIX_LENGTH = 20;
    private JPanel myMainPanel;
    private JPanel myPathMappingsPanel;
    private JTextField myRemoteFilePathField;
    private JTextField myLocalFilePathField;
    private final PhpPathMappingsConfigurable myPathMappingsConfigurable;
    private final UserActivityWatcher myWatcher;
    private final String myRemoteFilePath;
    private final String myLocalFilePath;
    private final boolean myDetectLocal;

    public PhpMappingAdvancedResolveDialog(@NotNull Project project, @NotNull String remoteFilePath, @NotNull PhpServer server) {
        if (project == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(1);
        }
        if (server == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(2);
        }
        this(project, "", remoteFilePath, server, true);
    }

    public PhpMappingAdvancedResolveDialog(@NotNull Project project, @NotNull String localFilePath, @NotNull String remoteFilePath, @NotNull PhpServer server, boolean detectLocal) {
        if (project == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(3);
        }
        if (localFilePath == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(4);
        }
        if (remoteFilePath == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(5);
        }
        if (server == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(6);
        }
        super(project);
        this.myRemoteFilePath = remoteFilePath;
        this.myLocalFilePath = localFilePath;
        this.myDetectLocal = detectLocal;
        this.$$$setupUI$$$();
        if (detectLocal) {
            List<String> fileSuggestion = Collections.singletonList(remoteFilePath);
            List<String> folderSuggestions = PhpMappingAdvancedResolveDialog.generateParentPaths(remoteFilePath);
            this.myPathMappingsConfigurable = new PhpPathMappingsConfigurable(project, server, false, fileSuggestion, folderSuggestions);
        } else {
            this.myPathMappingsConfigurable = new PhpPathMappingsConfigurable(project, server);
        }
        JComponent pathMappingsComponent = this.myPathMappingsConfigurable.createComponent();
        this.myPathMappingsPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)pathMappingsComponent), "Center");
        this.myWatcher = new UserActivityWatcher();
        this.myWatcher.register((Component)pathMappingsComponent);
        UserActivityListener userActivityListener = new UserActivityListener(){

            public void stateChanged() {
                PhpMappingAdvancedResolveDialog.this.mappingsChanged();
            }
        };
        this.myWatcher.addUserActivityListener(userActivityListener, this.getDisposable());
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(PhpBundle.message("debug.resolve.mapping.problem", new Object[0]));
        this.myPathMappingsConfigurable.reset();
        this.myLocalFilePathField.setText(this.myLocalFilePath);
        this.myRemoteFilePathField.setText(this.myRemoteFilePath);
        this.mappingsChanged();
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected String getDimensionServiceKey() {
        return "PhpMappingAdvancedResolveDialog";
    }

    protected ValidationInfo doValidate() {
        PhpPathMapper pathMapper = this.myPathMappingsConfigurable.getPathMapper();
        if (this.myDetectLocal) {
            if (pathMapper.getLocalPath(this.myRemoteFilePath) == null) {
                String text = StringUtil.shortenTextWithEllipsis((String)this.myRemoteFilePath, (int)30, (int)20);
                return new ValidationInfo(PhpBundle.message("debug.process.cannot.find.path.mapping", text), (JComponent)this.myLocalFilePathField);
            }
            if (pathMapper.getLocalFile(this.myRemoteFilePath) == null) {
                String localPath = pathMapper.getLocalPath(this.myRemoteFilePath);
                assert (localPath != null);
                String text = StringUtil.shortenTextWithEllipsis((String)localPath, (int)30, (int)20);
                return new ValidationInfo(PhpBundle.message("debug.process.cannot.find.file.in.project", text), (JComponent)this.myLocalFilePathField);
            }
        } else if (pathMapper.getRemoteFilePath(this.myLocalFilePath) == null) {
            String text = StringUtil.shortenTextWithEllipsis((String)this.myLocalFilePath, (int)30, (int)20);
            return new ValidationInfo(PhpBundle.message("debug.process.cannot.find.remote.copy.local.file", text), (JComponent)this.myRemoteFilePathField);
        }
        return super.doValidate();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        this.myPathMappingsConfigurable.apply();
        super.doOKAction();
    }

    private void mappingsChanged() {
        PhpPathMapper pathMapper = this.myPathMappingsConfigurable.getPathMapper();
        if (this.myDetectLocal) {
            String localPath = pathMapper.getLocalPath(this.myRemoteFilePath);
            if (localPath == null) {
                this.myLocalFilePathField.setText("undefined");
            } else {
                this.myLocalFilePathField.setText(localPath);
            }
        } else {
            String remoteFilePath = pathMapper.getRemoteFilePath(this.myLocalFilePath);
            if (remoteFilePath == null) {
                this.myRemoteFilePathField.setText("undefined");
            } else {
                this.myRemoteFilePathField.setText(remoteFilePath);
            }
        }
    }

    @NotNull
    public static List<String> generateParentPaths(@NotNull String filePath) {
        if (filePath == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(7);
        }
        ArrayList<String> parentPaths = new ArrayList<String>();
        String[] path = PhpPathMapper.getPath(filePath);
        for (int i = path.length - 1; i > 0; --i) {
            parentPaths.add(PhpPathMapper.createFilePath(path, i));
        }
        ArrayList<String> arrayList = parentPaths;
        if (arrayList == null) {
            PhpMappingAdvancedResolveDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpMappingAdvancedResolveDialog.class).getString("debug.label.file.path.on.server"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPathMappingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myRemoteFilePathField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpMappingAdvancedResolveDialog.class).getString("debug.label.file.path.in.project"));
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalFilePathField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel2.add((Component)jTextField, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingAdvancedResolveDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingAdvancedResolveDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateParentPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateParentPaths";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

