/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhpDebugStateStatusBarWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "php.debug.status.widget";

    PhpDebugStateStatusBarWidgetFactory() {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = PhpBundle.message("php.debug.state.widget", new Object[0]);
        if (string == null) {
            PhpDebugStateStatusBarWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            PhpDebugStateStatusBarWidgetFactory.$$$reportNull$$$0(1);
        }
        return PlatformUtils.isPhpStorm();
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project) {
        if (project == null) {
            PhpDebugStateStatusBarWidgetFactory.$$$reportNull$$$0(2);
        }
        return new PhpDebugStateWidget(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugStateStatusBarWidgetFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugStateStatusBarWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class PhpDebugStateWidget
    implements StatusBarWidget.Multiframe,
    StatusBarWidget.IconPresentation {
        private Project myProject;

        private PhpDebugStateWidget(@NotNull Project project) {
            if (project == null) {
                PhpDebugStateWidget.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NonNls
        @NotNull
        public String ID() {
            return PhpDebugStateStatusBarWidgetFactory.ID;
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                PhpDebugStateWidget.$$$reportNull$$$0(1);
            }
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpDebugExternalConnectionsAccepter.StateChangedListener.TOPIC, () -> statusBar.updateWidget(PhpDebugStateStatusBarWidgetFactory.ID));
        }

        public StatusBarWidget copy() {
            return new PhpDebugStateWidget(this.myProject);
        }

        @Nullable
        public String getTooltipText() {
            return PhpDebugExternalConnectionsAccepter.getInstance(this.myProject).isStarted() ? PhpBundle.message("debug.stop.listen.debug.connections", new Object[0]) : PhpBundle.message("debug.start.listen.debug.connections", new Object[0]);
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return mouseEvent -> PhpDebugExternalConnectionsAccepter.getInstance(this.myProject).doSwitch();
        }

        @Nullable
        public Icon getIcon() {
            boolean started = PhpDebugExternalConnectionsAccepter.getInstance(this.myProject).isStarted();
            return started ? PhpIcons.LISTEN_DEBUG_ON : PhpIcons.LISTEN_DEBUG_OFF;
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this;
        }

        public void dispose() {
            this.myProject = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugStateStatusBarWidgetFactory$PhpDebugStateWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

