/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.DynamicBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.template.PhpTemplateLanguagePathMapper;
import com.jetbrains.php.debug.ui.PhpIncomingRemoteConnectionDialog;
import com.jetbrains.php.debug.ui.PhpMappingsFromDeploymentDetectorForm;
import com.jetbrains.php.debug.ui.PhpMappingsFromDeploymentImporterForm;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugMappingsChooserDialog
extends PhpIncomingRemoteConnectionDialog {
    private static final String HELP_ID = "php.debugging.incoming.connection";
    private final StructureTreeModel<MyTreeStructure> myModel;
    private JPanel myMainPanel;
    private JBRadioButton myDeploymentRadio;
    private JBRadioButton myManualRadio;
    private JPanel myManualConfigPanel;
    private SimpleTree myTree;
    private JPanel myDeploymentConfigPanel;
    private JPanel myConfigurationTypePanel;
    @Nullable
    private PhpMappingsFromDeploymentDetectorForm myDeploymentMappingsForm;
    private SimpleNode myLastSelectedNode;
    private ActionListener myChangeTypeListener;
    private final String myDebuggerId;

    public PhpDebugMappingsChooserDialog(@NotNull String clientName, @NotNull List<Project> allProjects, @NotNull List<Project> projectsWithPathMappings, @NotNull String remoteFilePath, @NotNull String serverName, int serverPort, @NotNull String debuggerId, @NotNull String requestUri, boolean withDeployment) {
        if (clientName == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(0);
        }
        if (allProjects == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(1);
        }
        if (projectsWithPathMappings == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(2);
        }
        if (remoteFilePath == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(3);
        }
        if (serverName == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(4);
        }
        if (debuggerId == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(5);
        }
        if (requestUri == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(6);
        }
        super(clientName, remoteFilePath, serverName, serverPort, requestUri);
        this.$$$setupUI$$$();
        assert (!allProjects.isEmpty());
        this.myDebuggerId = debuggerId;
        this.myMainPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("debug.server.select.file.mapping", new Object[0])));
        if (!withDeployment) {
            this.myManualRadio.setSelected(true);
            this.myDeploymentConfigPanel.setVisible(false);
            this.myConfigurationTypePanel.setVisible(false);
        } else {
            this.myDeploymentMappingsForm = this.createMappingsFromDeploymentForm(remoteFilePath, allProjects, projectsWithPathMappings);
            JBEmptyBorder emptyBorder = JBUI.Borders.empty((int)5, (int)5, (int)10, (int)10);
            CompoundBorder border = new CompoundBorder((Border)IdeBorderFactory.createRoundedBorder(), (Border)emptyBorder);
            this.myDeploymentConfigPanel.setBorder(border);
            this.myDeploymentConfigPanel.add((Component)this.myDeploymentMappingsForm.getComponent(), "Center");
        }
        Project[] projectsArray = allProjects.toArray(new Project[0]);
        this.myModel = new StructureTreeModel((AbstractTreeStructure)new MyTreeStructure(projectsArray), (Comparator)new WeightBasedComparator(true), this.getDisposable());
        this.myTree.setModel((TreeModel)new AsyncTreeModel(this.myModel, this.getDisposable()));
        this.init();
    }

    @NotNull
    private PhpMappingsFromDeploymentDetectorForm createMappingsFromDeploymentForm(@NotNull String remoteFilePath, @NotNull List<Project> allProjects, @NotNull List<Project> projectsWithPathMappings) {
        if (remoteFilePath == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(7);
        }
        if (allProjects == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(8);
        }
        if (projectsWithPathMappings == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(9);
        }
        NullableConsumer fileProcessor = file -> this.setOKActionEnabled(file != null);
        if (projectsWithPathMappings.isEmpty()) {
            this.myManualRadio.setSelected(true);
            return new PhpMappingsFromDeploymentImporterForm(remoteFilePath, allProjects, (NullableConsumer<VirtualFile>)fileProcessor);
        }
        this.myDeploymentRadio.setSelected(true);
        return new PhpMappingsFromDeploymentDetectorForm(remoteFilePath, projectsWithPathMappings, (NullableConsumer<? super VirtualFile>)fileProcessor);
    }

    @Override
    protected void init() {
        super.init();
        this.myTree.setMinSizeInRows(10);
        this.myTree.getSelectionModel().setSelectionMode(1);
        final Ref maxWeight = new Ref((Object)Integer.MIN_VALUE);
        ((TreeVisitor.Acceptor)this.myTree.getModel()).accept(new TreeVisitor(){

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path) {
                Object node;
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((node = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof MyFileNode) {
                    this.visit((MyFileNode)((Object)node));
                }
                TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                if (action == null) {
                    1.$$$reportNull$$$0(1);
                }
                return action;
            }

            public void visit(@NotNull MyFileNode node) {
                int weight;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((weight = node.getWeight()) > (Integer)maxWeight.get()) {
                    PhpDebugMappingsChooserDialog.this.myModel.select((Object)node, (JTree)PhpDebugMappingsChooserDialog.this.myTree, treePath -> {});
                    maxWeight.set((Object)weight);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.myChangeTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpDebugMappingsChooserDialog.this.radioSelected();
            }
        };
        this.myDeploymentRadio.addActionListener(this.myChangeTypeListener);
        this.myManualRadio.addActionListener(this.myChangeTypeListener);
        this.radioSelected();
    }

    protected void dispose() {
        super.dispose();
        if (this.myDeploymentMappingsForm != null) {
            this.myDeploymentMappingsForm.disposeUI();
        }
        this.myDeploymentRadio.removeActionListener(this.myChangeTypeListener);
        this.myManualRadio.removeActionListener(this.myChangeTypeListener);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void radioSelected() {
        this.myManualConfigPanel.setVisible(this.myManualRadio.isSelected());
        this.myDeploymentConfigPanel.setVisible(this.myDeploymentRadio.isSelected());
        this.setOKActionEnabled(!this.myDeploymentRadio.isSelected() || this.myDeploymentMappingsForm != null && this.myDeploymentMappingsForm.isValid());
    }

    @Override
    @NotNull
    public Project getSelectedProject() {
        if (this.myDeploymentRadio.isSelected() && this.myDeploymentMappingsForm != null) {
            Project project = this.myDeploymentMappingsForm.getSelectedProject();
            if (project == null) {
                PhpDebugMappingsChooserDialog.$$$reportNull$$$0(10);
            }
            return project;
        }
        assert (this.myLastSelectedNode != null);
        if (this.myLastSelectedNode instanceof MyProjectRootNode) {
            Project project = ((MyProjectRootNode)this.myLastSelectedNode).getNodeProject();
            if (project == null) {
                PhpDebugMappingsChooserDialog.$$$reportNull$$$0(11);
            }
            return project;
        }
        if (this.myLastSelectedNode instanceof MyFileNode) {
            Project project = ((MyFileNode)this.myLastSelectedNode).getFileProject();
            if (project == null) {
                PhpDebugMappingsChooserDialog.$$$reportNull$$$0(12);
            }
            return project;
        }
        assert (false);
        if (null == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    protected boolean isSelected() {
        return this.myDeploymentRadio.isSelected() && this.myDeploymentMappingsForm != null || this.myLastSelectedNode != null;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        if (this.myDeploymentRadio.isSelected() && this.myDeploymentMappingsForm != null) {
            return this.myDeploymentMappingsForm.getSelectedFile();
        }
        assert (this.myLastSelectedNode != null);
        if (this.myLastSelectedNode instanceof MyFileNode) {
            return ((MyFileNode)this.myLastSelectedNode).getFile();
        }
        return null;
    }

    @NotNull
    public PhpServer createServer(@NotNull Project project) {
        if (project == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(14);
        }
        List<PathMappingSettings.PathMapping> mappings = this.getPathMappings(project);
        PhpServer server = new PhpServer(this.myServerName, this.myServerName, this.myServerPort, this.myDebuggerId, false);
        if (mappings != null) {
            server.setUsePathMappings(true);
            server.setMappings(mappings);
        }
        PhpServer phpServer = server;
        if (phpServer == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(15);
        }
        return phpServer;
    }

    @Nullable
    protected List<PathMappingSettings.PathMapping> getPathMappings(@NotNull Project project) {
        String[] remoteCanonicalFilePath;
        if (project == null) {
            PhpDebugMappingsChooserDialog.$$$reportNull$$$0(16);
        }
        if (this.myDeploymentRadio.isSelected() && this.myDeploymentMappingsForm != null) {
            return this.myDeploymentMappingsForm.getPathMappings();
        }
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        String localFilePath = selectedFile.getPath();
        String[] localCanonicalFilePath = PhpPathMapper.getPath(localFilePath);
        if (PhpStringUtil.isEquals(localCanonicalFilePath, remoteCanonicalFilePath = PhpPathMapper.getPath(this.myRemoteFilePath), false)) {
            return null;
        }
        String localRoot = PathUtil.getParentPath((String)localFilePath);
        String remoteRoot = PathUtil.getParentPath((String)this.myRemoteFilePath);
        VirtualFile commonTemplatesAncestor = VfsUtil.getCommonAncestor(PhpTemplateLanguagePathMapper.getTemplatesMappingPaths(project));
        if (commonTemplatesAncestor != null && VfsUtilCore.isUnder((VirtualFile)commonTemplatesAncestor, Collections.singleton(project.getBaseDir()))) {
            while (!VfsUtilCore.isUnder((String)commonTemplatesAncestor.getPath(), Collections.singleton(localRoot))) {
                localRoot = PathUtil.getParentPath((String)localRoot);
                remoteRoot = PathUtil.getParentPath((String)remoteRoot);
            }
        }
        return Collections.singletonList(new PathMappingSettings.PathMapping(localRoot, remoteRoot));
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        SimpleTree simpleTree;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConfigurationTypePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugMappingsChooserDialog.class).getString("debug.server.import.from.deployment.radio"));
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myManualRadio = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugMappingsChooserDialog.class).getString("debug.server.manually.select.file.or.project"));
        jPanel3.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myManualConfigPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpDebugMappingsChooserDialog.class).getString("debug.server.manually.select.file.message"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(550, 300), null));
        this.myTree = simpleTree = new SimpleTree();
        simpleTree.setRootVisible(false);
        jBScrollPane.setViewportView((Component)simpleTree);
        this.myDeploymentConfigPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(550, 300), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientName";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProjects";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsWithPathMappings";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestUri";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMappingsFromDeploymentForm";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createServer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 15 -> new IllegalStateException(string);
        };
    }

    private final class MyTreeStructure
    extends SimpleTreeStructure {
        private final Project[] myProjects;
        private MyRootNode myRootNode;

        private MyTreeStructure(Project[] projects) {
            this.myProjects = projects;
        }

        @NotNull
        public Object getRootElement() {
            if (this.myRootNode == null) {
                this.myRootNode = new MyRootNode(this.myProjects);
            }
            MyRootNode myRootNode = this.myRootNode;
            if (myRootNode == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return myRootNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyTreeStructure", "getRootElement"));
        }
    }

    public final class MyProjectRootNode
    extends SimpleNode {
        private final Project myNodeProject;
        private SimpleNode[] myChildren;

        private MyProjectRootNode(SimpleNode parent, Project project) {
            super(parent);
            this.myNodeProject = project;
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                Collection candidates = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)PathUtil.getFileName((String)PhpDebugMappingsChooserDialog.this.myRemoteFilePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myNodeProject)));
                ArrayList<MyFileNode> children = new ArrayList<MyFileNode>();
                for (VirtualFile candidate : candidates) {
                    children.add(new MyFileNode(this, candidate));
                }
                this.myChildren = children.toArray(new MyFileNode[0]);
            }
            if (this.myChildren == null) {
                MyProjectRootNode.$$$reportNull$$$0(0);
            }
            return this.myChildren;
        }

        public Project getNodeProject() {
            return this.myNodeProject;
        }

        public Object @NotNull [] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myNodeProject};
            if (objectArray == null) {
                MyProjectRootNode.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyProjectRootNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setIcon(PhpIcons.PROJECT_ICON);
            presentation.setPresentableText(this.myNodeProject.getName());
        }

        public void handleSelection(SimpleTree tree) {
            PhpDebugMappingsChooserDialog.this.myLastSelectedNode = this;
            PhpDebugMappingsChooserDialog.this.turnOffAction.setEnabled(PhpDebugMappingsChooserDialog.this.turnOffAction.isEnabled());
            PhpDebugMappingsChooserDialog.this.myOKAction.setEnabled(PhpDebugMappingsChooserDialog.this.isSelected());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyProjectRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyProjectRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public final class MyFileNode
    extends SimpleNode {
        private final VirtualFile myFile;
        private final Project myFileProject;

        private MyFileNode(MyProjectRootNode parent, VirtualFile file) {
            super((SimpleNode)parent);
            this.myFileProject = parent.getNodeProject();
            this.myFile = file;
        }

        public SimpleNode @NotNull [] getChildren() {
            if (NO_CHILDREN == null) {
                MyFileNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyFileNode.$$$reportNull$$$0(1);
            }
            super.update(presentation);
            presentation.setIcon(icons.PhpIcons.PhpIcon);
            VirtualFile myProjectBaseDir = this.myFileProject.getBaseDir();
            assert (myProjectBaseDir != null);
            presentation.setPresentableText(this.myFile.getPresentableUrl());
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public Project getFileProject() {
            return this.myFileProject;
        }

        public int getWeight() {
            return super.getWeight() + PhpPathMapper.intersectFromEnd(PhpDebugMappingsChooserDialog.this.myRemoteFilePath, this.myFile.getPath(), false).length;
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            PhpDebugMappingsChooserDialog.this.doOKAction();
        }

        public void handleSelection(SimpleTree tree) {
            PhpDebugMappingsChooserDialog.this.myLastSelectedNode = this;
            PhpDebugMappingsChooserDialog.this.turnOffAction.setEnabled(PhpDebugMappingsChooserDialog.this.turnOffAction.isEnabled());
        }

        public Object @NotNull [] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myFile};
            if (objectArray == null) {
                MyFileNode.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyFileNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyFileNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEqualityObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class MyRootNode
    extends SimpleNode {
        private final MyProjectRootNode[] myChildren;

        private MyRootNode(Project[] projects) {
            ArrayList<MyProjectRootNode> children = new ArrayList<MyProjectRootNode>();
            for (Project project : projects) {
                children.add(new MyProjectRootNode(this, project));
            }
            this.myChildren = children.toArray(new MyProjectRootNode[0]);
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            return this.myChildren;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/debug/ui/PhpDebugMappingsChooserDialog$MyRootNode", "getChildren"));
        }
    }
}

