/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDetachReasonMessage;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugExternalConnectionHandler;
import com.jetbrains.php.debug.connection.PhpDebugSessionId;
import com.jetbrains.php.debug.connection.PhpListeningProjectsProvider;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.util.connection.ConnectionHandler;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionsSocket;
import com.jetbrains.php.util.connection.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public abstract class PhpDebugServer<C extends PhpDebugConnection>
extends ServerConnection
implements PhpListeningProjectsProvider,
PhpIncomingDebugConnectionServer<C> {
    private final Map<String, ConnectionHandler<C>> myIdHandlerMap;
    private final Map<String, Boolean> myIdPermanentMap;
    private final List<PhpDebugExternalConnectionsAccepter> myConnectionListeners;
    private final Random sessionNumberGenerator;
    protected final Object myLock;
    private volatile int myConnected;
    public static final int MAX_CONNECTED_COUNT = 50;

    protected PhpDebugServer(@NotNull PhpIncomingDebugConnectionsSocket socket, @NotNull Disposable parentDisposable) {
        if (socket == null) {
            PhpDebugServer.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            PhpDebugServer.$$$reportNull$$$0(1);
        }
        super(socket, parentDisposable);
        this.myIdHandlerMap = new HashMap<String, ConnectionHandler<C>>();
        this.myIdPermanentMap = new HashMap<String, Boolean>();
        this.myConnectionListeners = new ArrayList<PhpDebugExternalConnectionsAccepter>();
        this.sessionNumberGenerator = new Random();
        this.myLock = new Object();
        this.myConnected = 0;
    }

    @Override
    protected void handle(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            PhpDebugServer.$$$reportNull$$$0(2);
        }
        this.handle(socket.getInputStream(), socket.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handle(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            PhpDebugServer.$$$reportNull$$$0(3);
        }
        if (outputStream == null) {
            PhpDebugServer.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnected >= 50) {
                this.logEvent("too many connected connections");
                return;
            }
            ++this.myConnected;
        }
        PhpDebugConnection connection = null;
        try {
            ConnectionHandler<PhpDebugConnection> handler;
            connection = (PhpDebugConnection)this.createConnection(inputStream, outputStream);
            Disposer.register((Disposable)XDebuggerSettingsManager.getInstance(), connection);
            connection.init();
            String sessionId = connection.getSessionId();
            Object object2 = this.myLock;
            synchronized (object2) {
                handler = this.myIdHandlerMap.get(sessionId);
                if (handler != null) {
                    Boolean isPermanent = this.myIdPermanentMap.get(sessionId);
                    assert (isPermanent != null);
                    if (!isPermanent.booleanValue()) {
                        this.unregisterSessionHandler(sessionId);
                    }
                }
            }
            if (handler != null) {
                handler.handle(connection);
            } else {
                int size;
                Object object3 = this.myLock;
                synchronized (object3) {
                    size = this.myConnectionListeners.size();
                }
                if (size != 0) {
                    this.createExternalConnectionHandler(connection);
                } else {
                    connection.startDetach(PhpDetachReasonMessage.NoExternalConnectionListeners.INSTANCE.getMessage());
                }
            }
            connection.connect();
        }
        finally {
            Object object4 = this.myLock;
            synchronized (object4) {
                --this.myConnected;
            }
            if (connection != null) {
                Disposer.dispose((Disposable)connection);
            }
        }
    }

    @Override
    @NotNull
    public List<Project> getListeningProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        List<PhpDebugExternalConnectionsAccepter> connectionListeners = this.getConnectionListeners();
        for (PhpDebugExternalConnectionsAccepter connectionListener : connectionListeners) {
            if (!connectionListener.isStarted()) continue;
            projects.add(connectionListener.getProject());
        }
        ArrayList<Project> arrayList = projects;
        if (arrayList == null) {
            PhpDebugServer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<PhpDebugExternalConnectionsAccepter> getConnectionListeners() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<PhpDebugExternalConnectionsAccepter> arrayList = new ArrayList<PhpDebugExternalConnectionsAccepter>(this.myConnectionListeners);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        PhpDebugServer.$$$reportNull$$$0(6);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PhpDebugSessionId registerSessionHandler(boolean permanent, @NotNull ConnectionHandler<C> handler) throws ExecutionException {
        if (handler == null) {
            PhpDebugServer.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        String sessionIdStr = this.generateNewSessionId();
        this.registerSessionHandler(sessionIdStr, permanent, handler);
        PhpDebugSessionId phpDebugSessionId = new PhpDebugSessionId(sessionIdStr);
        // MONITOREXIT : object
        if (phpDebugSessionId != null) return phpDebugSessionId;
        PhpDebugServer.$$$reportNull$$$0(8);
        return phpDebugSessionId;
    }

    @Override
    public boolean isRegistered(@NotNull String sessionId) {
        if (sessionId == null) {
            PhpDebugServer.$$$reportNull$$$0(9);
        }
        return this.myIdHandlerMap.containsKey(sessionId);
    }

    @Override
    @NotNull
    public String generateNewSessionId() {
        int sessionId = this.generateSessionId();
        while (this.isRegistered(String.valueOf(sessionId))) {
            sessionId = this.generateSessionId();
        }
        String string = String.valueOf(sessionId);
        if (string == null) {
            PhpDebugServer.$$$reportNull$$$0(10);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSessionHandler(@NotNull String sessionId, boolean permanent, @NotNull ConnectionHandler<C> handler) throws ExecutionException {
        if (sessionId == null) {
            PhpDebugServer.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            PhpDebugServer.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getStatus()) {
                case STOPPED: {
                    throw new ExecutionException(PhpBundle.message("cannot.register.handler", new Object[0]));
                }
                case STARTED: {
                    if (this.myIdHandlerMap.containsKey(sessionId)) {
                        throw new ExecutionException(PhpBundle.message("handler.with.the.same.session.id.is.already.registered", new Object[0]));
                    }
                    this.myIdHandlerMap.put(sessionId, handler);
                    this.myIdPermanentMap.put(sessionId, permanent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSessionHandler(@NotNull String sessionId) {
        if (sessionId == null) {
            PhpDebugServer.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdPermanentMap.remove(sessionId);
            this.myIdHandlerMap.remove(sessionId);
            this.tryStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) throws ExecutionException {
        if (connectionsListener == null) {
            PhpDebugServer.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (this.getStatus()) {
                case STARTED: {
                    this.myConnectionListeners.add(connectionsListener);
                    break;
                }
                case STOPPED: {
                    throw new ExecutionException(PhpBundle.message("cannot.register.handler", new Object[0]));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterExternalConnectionListener(@NotNull PhpDebugExternalConnectionsAccepter connectionsListener) {
        boolean remove;
        if (connectionsListener == null) {
            PhpDebugServer.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            remove = this.myConnectionListeners.remove(connectionsListener);
            this.tryStop();
        }
        return remove;
    }

    private void tryStop() {
        if (this.myIdHandlerMap.isEmpty() && this.myConnectionListeners.isEmpty()) {
            this.stopListening();
        }
    }

    protected abstract C createConnection(@NotNull InputStream var1, @NotNull OutputStream var2);

    protected abstract PhpDebugExternalConnectionHandler<C> createExternalConnectionHandler(@NotNull C var1);

    private int generateSessionId() {
        return 10000 + this.sessionNumberGenerator.nextInt(10000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugServer";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionsListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugServer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeningProjects";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionListeners";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerSessionHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewSessionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerSessionHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSessionHandler";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExternalConnectionListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExternalConnectionListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

