/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpApplicationDebugConfiguration;
import com.jetbrains.php.debug.PhpDebugConfigurable;
import com.jetbrains.php.debug.PhpDebugUtil;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpDebugNotificationUtils {
    public static void notifyIfNecessary(final @NotNull Project project, @NotNull XLineBreakpoint originalBreakpoint) {
        if (project == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(0);
        }
        if (originalBreakpoint == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(1);
        }
        if (!PhpApplicationDebugConfiguration.getInstance().getState().isXdebugNotifyAboutResolvedBreakpoints()) {
            return;
        }
        String path = PathUtil.getFileName((String)originalBreakpoint.getFileUrl()) + ":" + (originalBreakpoint.getLine() + 1);
        boolean moveToResolveBreakpoints = PhpApplicationDebugConfiguration.getInstance().getState().isXdebugMoveToResolveBreakpoints();
        String message = PhpBundle.message("debug.breakpoint.was.resolved", path);
        Notification notification = PhpDebugUtil.getNotificationGroup().createNotification((String)(moveToResolveBreakpoints ? message + PhpBundle.message("debug.breakpoint.was.moved", new Object[0]) : message), NotificationType.INFORMATION).setListener((n, e) -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = e.getDescription();
                if ("disable".equals(description)) {
                    PhpDebugNotificationUtils.disableBreakpointResolve(project);
                } else if ("more".equals(description)) {
                    HelpManager.getInstance().invokeHelp("xdebug-breakpoint-resolved");
                } else if ("dontshow".equals(description)) {
                    PhpDebugNotificationUtils.disableNotifications(project);
                }
            }
        });
        if (moveToResolveBreakpoints) {
            notification.addAction((AnAction)new NotificationAction(PhpBundle.message("notification.content.disable.breakpoint.move.to.resolved.position", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PhpApplicationDebugConfiguration.getInstance().getState().setXdebugMoveToResolveBreakpoints(false);
                    PhpDebugNotificationUtils.notifyBreakpointSettingChanged(project, PhpBundle.message("debug.breakpoint.move.disabled", new Object[0]));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/debug/common/PhpDebugNotificationUtils$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification.notify(project);
    }

    private static void disableBreakpointResolve(@NotNull Project project) {
        if (project == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(2);
        }
        PhpApplicationDebugConfiguration.getInstance().getState().setXdebugResolveBreakpoints(false);
        PhpDebugNotificationUtils.notifyBreakpointSettingChanged(project, PhpBundle.message("debug.breakpoint.resolved.disabled", new Object[0]));
    }

    private static void notifyBreakpointSettingChanged(@NotNull Project project, @Nls String message) {
        if (project == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(3);
        }
        PhpDebugUtil.getNotificationGroup().createNotification(message, NotificationType.INFORMATION).setListener(PhpDebugNotificationUtils.newPhpDebugSettingListener(project)).notify(project);
    }

    private static void disableNotifications(@NotNull Project project) {
        if (project == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(4);
        }
        PhpApplicationDebugConfiguration.getInstance().getState().setXdebugNotifyAboutResolvedBreakpoints(false);
        PhpDebugNotificationUtils.notifyBreakpointSettingChanged(project, PhpBundle.message("debug.breakpoint.resolved.notify.disabled", new Object[0]));
    }

    @NotNull
    public static NotificationListener newPhpDebugSettingListener(final @NotNull Project project) {
        if (project == null) {
            PhpDebugNotificationUtils.$$$reportNull$$$0(5);
        }
        return new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "open".equals(e.getDescription())) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpDebugConfigurable.class);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/common/PhpDebugNotificationUtils$2";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBreakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebugNotificationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyIfNecessary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "disableBreakpointResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyBreakpointSettingChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "disableNotifications";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "newPhpDebugSettingListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

