/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugConfigInstruction;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.debug.validation.PhpValidateWebServerAction;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDebugConfigInstructionsPanel
extends JPanel {
    private static final Insets DEFAULT_INSETS = JBUI.insetsBottom((int)5);
    public static final String ZERO_CONFIGURATION_TUTORIAL = "php.debugging.zero_configuration";

    private PhpDebugConfigInstructionsPanel(@Nullable Supplier<PhpServer> serverProducer, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        PhpDebugConfigInstruction install = new PhpDebugConfigInstruction(parentDisposable);
        install.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.debugger.php.instruction", new Object[0]));
        install.addHelpLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.xdebug.php.instruction", new Object[0]), "php.debugging.xdebug.configure");
        install.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.instruction", new Object[0]));
        install.addHelpLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.zend.debugger.php.action", new Object[0]), "php.debugging.zend.configure");
        install.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.zend.debugger.php.instruction", new Object[0]));
        this.addInstruction(install);
        PhpDebugConfigInstruction validation = new PhpDebugConfigInstruction(parentDisposable);
        PhpValidateWebServerAction validateAction = new PhpValidateWebServerAction(serverProducer);
        validation.addAction(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.validate.action", new Object[0]), validateAction);
        validation.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.validate", new Object[0]));
        this.addInstruction(validation, (Insets)JBUI.insets((int)0, (int)10, (int)5, (int)0));
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createWebPageDebugInstructions(@NotNull Supplier<PhpServer> serverProducer, @NotNull Disposable parentDisposable) {
        if (serverProducer == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(2);
        }
        PhpDebugConfigInstructionsPanel instructions = new PhpDebugConfigInstructionsPanel(serverProducer, parentDisposable);
        instructions.addInstruction(new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.web.page.listen.for.connections", new Object[0]), parentDisposable));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(3);
        }
        return phpDebugConfigInstructionsPanel;
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createRemoteDebugInstructions(@NotNull Supplier<PhpServer> serverProduce, @NotNull Disposable parentDisposable) {
        if (serverProduce == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(5);
        }
        PhpDebugConfigInstruction startListening = new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.remote.debug.listen.for.connections", new Object[0]), parentDisposable);
        return PhpDebugConfigInstructionsPanel.createExternalPreConfig(startListening, serverProduce, parentDisposable);
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createZeroConfigurationInstructions(@NotNull Project project, Disposable parentDisposable) {
        if (project == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(6);
        }
        PhpDebugConfigInstruction startListening = new PhpDebugConfigInstruction(parentDisposable);
        startListening.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections", new Object[0]));
        startListening.addAction(new PhpStartListeningPresentation(project).getActionLink());
        PhpDebugConfigInstruction tutorial = new PhpDebugConfigInstruction(parentDisposable);
        tutorial.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.tutorial", new Object[0]));
        tutorial.addHelpLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.tutorial.action", new Object[0]), ZERO_CONFIGURATION_TUTORIAL);
        PhpDebugConfigInstructionsPanel instructions = PhpDebugConfigInstructionsPanel.createExternalPreConfig(startListening, null, parentDisposable);
        instructions.addInstruction(tutorial, (Insets)JBUI.insetsLeft((int)10));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(7);
        }
        return phpDebugConfigInstructionsPanel;
    }

    @NotNull
    private static PhpDebugConfigInstructionsPanel createExternalPreConfig(@NotNull PhpDebugConfigInstruction startListening, @Nullable Supplier<PhpServer> serverProduce, @NotNull Disposable parentDisposable) {
        if (startListening == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(9);
        }
        PhpDebugConfigInstructionsPanel instructions = new PhpDebugConfigInstructionsPanel(serverProduce, parentDisposable);
        PhpDebugConfigInstruction toolbar = new PhpDebugConfigInstruction(parentDisposable);
        toolbar.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.toolbar.instruction.label", new Object[0]));
        toolbar.addHelpLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.toolbar.instruction", new Object[0]), "php.debugging.browser_extensions");
        instructions.addInstruction(toolbar);
        instructions.addInstruction(startListening);
        instructions.addInstruction(new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.zero.configuration.start.session", new Object[0]), parentDisposable));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(10);
        }
        return phpDebugConfigInstructionsPanel;
    }

    private void addInstruction(@NotNull PhpDebugConfigInstruction instruction, @NotNull Insets insets) {
        if (instruction == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(11);
        }
        if (insets == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(12);
        }
        instruction.setBorder(IdeBorderFactory.createEmptyBorder((Insets)insets));
        this.add(instruction);
    }

    private void addInstruction(@NotNull PhpDebugConfigInstruction instruction) {
        if (instruction == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(13);
        }
        instruction.setBorder(IdeBorderFactory.createEmptyBorder((Insets)DEFAULT_INSETS));
        this.add(instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverProducer";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverProduce";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startListening";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebPageDebugInstructions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createZeroConfigurationInstructions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalPreConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWebPageDebugInstructions";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteDebugInstructions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createZeroConfigurationInstructions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExternalPreConfig";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10 -> new IllegalStateException(string);
        };
    }

    private static class PhpStartListeningPresentation {
        private final ActionLink myActionLink;

        PhpStartListeningPresentation(@NotNull Project project) {
            if (project == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(0);
            }
            this.myActionLink = new ActionLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections.action", new Object[0]), e -> {
                PhpDebugExternalConnectionsAccepter.getInstance(project).doSwitch();
                this.updatePresentation(project);
            });
            this.myActionLink.setBorder((Border)new EmptyBorder((Insets)JBUI.insets((int)0, (int)5, (int)3, (int)0)));
            this.updatePresentation(project);
        }

        @NotNull
        public ActionLink getActionLink() {
            ActionLink actionLink = this.myActionLink;
            if (actionLink == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(1);
            }
            return actionLink;
        }

        private void updatePresentation(@NotNull Project project) {
            if (project == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(2);
            }
            if (PhpDebugExternalConnectionsAccepter.getInstance(project).isStarted()) {
                this.myActionLink.setText(PhpBundle.message("PhpDebugConfigurable.zero.configuration.stop.listen.for.connections.action", new Object[0]));
                this.myActionLink.setIcon(PhpIcons.LISTEN_DEBUG_ON);
            } else {
                this.myActionLink.setIcon(PhpIcons.LISTEN_DEBUG_OFF);
                this.myActionLink.setText(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections.action", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel$PhpStartListeningPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel$PhpStartListeningPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

