/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoDialog;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.debug.PhpDebugErrorDetector;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpDebuggerError;
import com.jetbrains.php.debug.PhpDebuggerFixableError;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloader;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommonErrorDetector
extends PhpDebugErrorDetector {
    private final Project myProject;
    private final XDebugSession mySession;

    public PhpCommonErrorDetector(@NotNull Project project, @Nullable XDebugSession session) {
        if (project == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySession = session;
    }

    @Nullable
    public static PhpDebuggerError tryToDetect(@NotNull Project project, @Nullable String interpreterName, @Nullable XDebugSession session) {
        if (project == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(1);
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        return new PhpCommonErrorDetector(project, session).detectPotentialError(interpreter);
    }

    @Override
    @Nullable
    public PhpDebuggerError detectPotentialError(@Nullable PhpInterpreter interpreter) {
        if (interpreter == null) {
            return PhpDebuggerError.create(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter"), new Runnable[0]);
        }
        String name = interpreter.getName();
        PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(name);
        if (info == null) {
            String message = PhpBundle.message("validation.connection.was.not.established.no.debug", new Object[0]);
            String action = PhpBundle.message("validation.connection.was.not.established.update.info", new Object[0]);
            return this.suggestValidateDebuggerInstallation(message, action, interpreter, null);
        }
        String debugger = PhpCommonErrorDetector.getSelectedDebugger(interpreter, info);
        if (StringUtil.isEmpty((String)debugger)) {
            String message = PhpBundle.message("validation.connection.was.not.established.no.debug", new Object[0]);
            String action = PhpBundle.message("validation.connection.was.not.established.update.info", new Object[0]);
            if (!interpreter.isRemote()) {
                return this.suggestExtensionInstallation(message, action, interpreter, this.mySession);
            }
            return this.suggestValidateDebuggerInstallation(message, action, interpreter, null);
        }
        PhpDebuggerError error = PhpCommonErrorDetector.tryToFindCustomError(this.myProject, interpreter);
        if (error != null) {
            return error;
        }
        String message = PhpBundle.message("validation.connection.was.not.established.0", debugger);
        String action = PhpBundle.message("validation.connection.was.not.established.validate.installation", new Object[0]);
        return this.suggestValidateDebuggerInstallation(message, action, interpreter, info);
    }

    @Nullable
    private static PhpDebuggerError tryToFindCustomError(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        PhpRemoteInterpreterManager manager;
        if (project == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(2);
        }
        if (interpreter == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(3);
        }
        if (interpreter.isRemote() && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            PhpDebugErrorDetector detector = manager.newErrorDetector(project, interpreter.getPhpSdkAdditionalData());
            return detector != null ? detector.detectPotentialError(interpreter) : null;
        }
        return null;
    }

    @NotNull
    public PhpDebuggerError suggestValidateDebuggerInstallation(@NlsContexts.NotificationContent @NotNull String message, @NotNull @Nls String action, @NotNull PhpInterpreter interpreter, @Nullable PhpInfo info) {
        if (message == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(4);
        }
        if (action == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(6);
        }
        PhpDebuggerFixableError phpDebuggerFixableError = PhpDebuggerFixableError.create(message, action, () -> UIUtil.invokeLaterIfNeeded(() -> {
            Pair<PhpInfo, PhpNonPersistedInfo> newInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).updateAnGetWholeInfo(this.myProject, interpreter.getName(), null);
            if (newInfo == null) {
                String error = PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter");
                PhpDebuggerError.create(error, new Runnable[0]).show(this.myProject);
                return;
            }
            List<PhpDebuggerInfo> newDebuggers = ((PhpInfo)newInfo.getFirst()).getDebuggers();
            if (!newDebuggers.isEmpty() && !PhpCommonErrorDetector.containDebugger(newDebuggers, interpreter.getDebuggerId())) {
                interpreter.setDebuggerId(PhpDebugUtil.getDebuggerId(newDebuggers.get(0)));
            }
            String error = PhpCommonErrorDetector.validatePhpInfo(interpreter, (PhpInfo)newInfo.getFirst(), info);
            Runnable fix = () -> PhpInfoDialog.show(this.myProject, (PhpInfo)newInfo.getFirst(), (PhpNonPersistedInfo)newInfo.getSecond());
            PhpDebuggerFixableError.create(error, PhpBundle.message("PhpInterpreterConfigurable.show.phpinfo", new Object[0]), fix).show(this.myProject);
        }));
        if (phpDebuggerFixableError == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(7);
        }
        return phpDebuggerFixableError;
    }

    @NotNull
    public PhpDebuggerError suggestExtensionInstallation(@NlsContexts.NotificationContent @NotNull String message, @NotNull @Nls String action, @NotNull PhpInterpreter interpreter, @Nullable XDebugSession session) {
        if (message == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(8);
        }
        if (action == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(9);
        }
        if (interpreter == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(10);
        }
        PhpDebuggerFixableError phpDebuggerFixableError = PhpDebuggerFixableError.create(message, action, () -> UIUtil.invokeLaterIfNeeded(() -> {
            List<PhpConfigurationOption> options = PhpConfigurationOption.convert(interpreter.getConfigurationOptions());
            String debugger = interpreter.getDebuggerExtension();
            if (StringUtil.isNotEmpty((String)debugger)) {
                options.add(PhpConfigurationOption.createZendExtensionOption(debugger));
            }
            try {
                String newInfo = PhpInfoUtil.getWholeRawPhpInfo(this.myProject, interpreter.getPathToPhpExecutable(), interpreter.getPhpSdkAdditionalData(), options, null, false).getStdout();
                String error = PhpBundle.message("notification.content.xdebug.extension.not.installed", new Object[0]);
                PhpDebuggerFixableError.create(error, XdebugDownloader.getInstance(this.myProject, newInfo, session, interpreter.getHomePath()).getActions()).show(this.myProject);
            }
            catch (ExecutionException | InterruptedException throwable) {
                // empty catch block
            }
        }));
        if (phpDebuggerFixableError == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(11);
        }
        return phpDebuggerFixableError;
    }

    @Nullable
    private static String getSelectedDebugger(@NotNull PhpInterpreter interpreter, @NotNull PhpInfo info) {
        if (interpreter == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(12);
        }
        if (info == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(13);
        }
        List<PhpDebuggerInfo> configuredDebuggers = info.getDebuggers();
        String selected = interpreter.getDebuggerId();
        if (configuredDebuggers.isEmpty() || StringUtil.isEmpty((String)selected)) {
            return null;
        }
        return configuredDebuggers.size() == 1 ? configuredDebuggers.get(0).toString() : PhpDebugUtil.getDebuggerNameById(selected);
    }

    private static boolean containDebugger(@NotNull List<? extends PhpDebuggerInfo> newDebuggers, @Nullable String debuggerId) {
        if (newDebuggers == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmpty((String)debuggerId)) {
            for (PhpDebuggerInfo phpDebuggerInfo : newDebuggers) {
                if (!StringUtil.equals((CharSequence)PhpDebugUtil.getDebuggerId(phpDebuggerInfo), (CharSequence)debuggerId)) continue;
                return true;
            }
        }
        return false;
    }

    @NlsContexts.NotificationContent
    @NotNull
    public static String validatePhpInfo(@NotNull PhpInterpreter interpreter, @NotNull PhpInfo newInfo, @Nullable PhpInfo oldInfo) {
        if (interpreter == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(15);
        }
        if (newInfo == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(16);
        }
        if (newInfo.getDebuggers().isEmpty()) {
            String string = PhpBundle.message("validation.no.debug.extension.is.installed", new Object[0]);
            if (string == null) {
                PhpCommonErrorDetector.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (oldInfo == null || !oldInfo.getDebuggers().equals(newInfo.getDebuggers())) {
            String string = PhpBundle.message("validation.debug.extension.is.updated", new Object[0]);
            if (string == null) {
                PhpCommonErrorDetector.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (interpreter.isRemote()) {
            String newSsh;
            String debuggerId = interpreter.getDebuggerId();
            if (StringUtil.isNotEmpty((String)debuggerId) && StringUtil.equals((CharSequence)"Zend Debugger", (CharSequence)PhpDebugUtil.getDebuggerNameById(debuggerId))) {
                String string = PhpBundle.message("validation.ssh.remote.debug.support", "Zend Debugger");
                if (string == null) {
                    PhpCommonErrorDetector.$$$reportNull$$$0(19);
                }
                return string;
            }
            String oldSsh = oldInfo.getRemoteHost();
            if (!StringUtil.equals((CharSequence)oldSsh, (CharSequence)(newSsh = newInfo.getRemoteHost()))) {
                String string = PhpBundle.message("validation.debug.extension.is.updated", new Object[0]);
                if (string == null) {
                    PhpCommonErrorDetector.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        String debuggersList = StringUtil.join(newInfo.getDebuggers(), (String)", ");
        String string = PhpBundle.message("validation.0.extension.is.installed.check.configuration.options", debuggersList);
        if (string == null) {
            PhpCommonErrorDetector.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpCommonErrorDetector";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDebuggers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpCommonErrorDetector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestValidateDebuggerInstallation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestExtensionInstallation";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "validatePhpInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryToDetect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryToFindCustomError";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestValidateDebuggerInstallation";
                break;
            }
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestExtensionInstallation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDebugger";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containDebugger";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "validatePhpInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

