/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServerConfigurableForm;
import com.jetbrains.php.ui.PhpConfigurableItem;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpServerConfigurable
extends PhpConfigurableItem {
    private final PhpServerConfigurableForm myConfigurableForm;
    private final JBCheckBox mySharedCheckBox;
    private final Project myProject;
    private final PhpServer myServer;
    private final String myDeploymentServerId;
    private boolean myOldIsSelected;

    public PhpServerConfigurable(@NotNull Project project, @NotNull PhpServer server) {
        if (project == null) {
            PhpServerConfigurable.$$$reportNull$$$0(0);
        }
        if (server == null) {
            PhpServerConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myServer = server;
        this.myDeploymentServerId = this.myServer.getDeploymentServerId();
        this.myOldIsSelected = PhpProjectConfigurationFacade.getInstance(project).isSharedServer(server);
        this.myConfigurableForm = new PhpServerConfigurableForm(project, server, true);
        this.mySharedCheckBox = new JBCheckBox(PhpBundle.message("PhpServerConfigurable.shared", new Object[0]));
        this.mySharedCheckBox.setSelected(this.myOldIsSelected);
    }

    public JComponent createComponent() {
        return this.myConfigurableForm.createComponent();
    }

    @Override
    protected JComponent createTopRightComponent() {
        return this.mySharedCheckBox;
    }

    public boolean isModified() {
        if (this.mySharedCheckBox.isSelected() != this.myOldIsSelected) {
            return true;
        }
        if (this.myConfigurableForm.isModified()) {
            return true;
        }
        return !StringUtil.equals((CharSequence)this.myDeploymentServerId, (CharSequence)this.myServer.getDeploymentServerId());
    }

    public void apply() throws ConfigurationException {
        this.myOldIsSelected = this.mySharedCheckBox.isSelected();
        this.myConfigurableForm.apply();
        PhpProjectConfigurationFacade.getInstance(this.myProject).setSharedServer(this.myServer, this.mySharedCheckBox.isSelected());
    }

    public void reset() {
        this.myConfigurableForm.reset();
        this.mySharedCheckBox.setSelected(this.myOldIsSelected);
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("configurable.PhpServerConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "server";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/config/servers/PhpServerConfigurable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

