/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.DynamicBundle;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpPathMappings;
import com.jetbrains.php.config.servers.PhpProjectServersManager;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPathMappingsConfigurable
extends PerFileConfigurableBase<String> {
    private JPanel myMainPanel;
    private JCheckBox myUsePathMappingsCheckBox;
    private JPanel myPathMappingsTablePanel;
    private final PhpServer myServer;
    private final boolean mySuggestMirror;
    private final Collection<String> myFileSuggestions;
    private final Collection<String> myFolderSuggestions;

    public PhpPathMappingsConfigurable(@NotNull Project project, @NotNull PhpServer server) {
        if (project == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(0);
        }
        if (server == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(1);
        }
        this(project, server, true, Collections.emptySet(), Collections.emptySet());
    }

    public PhpPathMappingsConfigurable(@NotNull Project project, @NotNull PhpServer server, boolean suggestMirror, @NotNull Collection<String> fileSuggestions, @NotNull Collection<String> folderSuggestions) {
        if (project == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(2);
        }
        if (server == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(3);
        }
        if (fileSuggestions == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(4);
        }
        if (folderSuggestions == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(5);
        }
        super(project, (PerFileMappingsEx)new PhpPathMappings(server, project.getBasePath()));
        this.$$$setupUI$$$();
        Disposer.register((Disposable)PhpProjectServersManager.getInstance(project), (Disposable)((PerFileMappingsBase)this.myMappings));
        this.myServer = server;
        this.mySuggestMirror = suggestMirror;
        this.myFileSuggestions = fileSuggestions;
        this.myFolderSuggestions = folderSuggestions;
    }

    @Nullable
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(6);
        }
        if (key == MAPPING_TITLE) {
            return PhpBundle.message("debug.path.on.server", new Object[0]);
        }
        if (key == TARGET_TITLE) {
            return PhpBundle.message("column.name.file.directory", new Object[0]);
        }
        return null;
    }

    protected void renderValue(@Nullable Object target, @NlsContexts.Label @NotNull String remotePath, @NotNull ColoredTextContainer renderer) {
        if (remotePath == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(7);
        }
        if (renderer == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(8);
        }
        SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        renderer.append(remotePath, attributes);
    }

    @NotNull
    public JComponent createComponent() {
        this.myPathMappingsTablePanel.add(super.createComponent());
        this.myPathMappingsTablePanel.setVisible(this.myServer.isUsePathMappings());
        this.myUsePathMappingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpPathMappingsConfigurable.this.myPathMappingsTablePanel.setVisible(PhpPathMappingsConfigurable.this.myUsePathMappingsCheckBox.isSelected());
            }
        });
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this.isUsePathMappings() != this.myServer.isUsePathMappings();
    }

    public void apply() {
        try {
            super.apply();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.myServer.setUsePathMappings(this.isUsePathMappings());
        this.myServer.setMappings(this.getMappings());
        PhpProjectConfigurationFacade.getInstance(this.myProject).fireStateChanged();
    }

    public void reset() {
        this.myUsePathMappingsCheckBox.setSelected(this.myServer.isUsePathMappings());
        this.myPathMappingsTablePanel.setVisible(this.myUsePathMappingsCheckBox.isSelected());
        super.reset();
    }

    public boolean isUsePathMappings() {
        return this.myUsePathMappingsCheckBox.isSelected();
    }

    public List<PathMappingSettings.PathMapping> getMappings() {
        ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>();
        Map values = this.getNewMappings();
        for (Map.Entry entry : values.entrySet()) {
            String local = ((VirtualFile)entry.getKey()).getPath();
            String remotePath = (String)entry.getValue();
            if (remotePath.isEmpty()) continue;
            mappings.add(new PathMappingSettings.PathMapping(local, remotePath));
        }
        return mappings;
    }

    public PhpPathMapper getPathMapper() {
        return this.isUsePathMappings() ? new PhpRemotePathMapper(this.getMappings()) : new PhpRemotePathMapper();
    }

    public String getDisplayName() {
        return PhpBundle.message("configurable.name.php.servers", new Object[0]);
    }

    @NotNull
    protected TableCellEditor createMappingCellEditor() {
        return new MyCellEditor(this.myFileSuggestions, this.myFolderSuggestions, this.mySuggestMirror);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myUsePathMappingsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpPathMappingsConfigurable.class).getString("PhpPathMappingsConfigurable.use.path.mappings.label"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPathMappingsTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuggestions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderSuggestions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpPathMappingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpPathMappingsConfigurable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyCellEditor
    extends DefaultCellEditor {
        private final boolean mySuggestMirror;
        private final Collection<String> myFileSuggestions;
        private final Collection<String> myFolderSuggestions;

        private MyCellEditor(@NotNull Collection<String> fileSuggestions, @NotNull Collection<String> folderSuggestions, boolean suggestMirror) {
            if (fileSuggestions == null) {
                MyCellEditor.$$$reportNull$$$0(0);
            }
            if (folderSuggestions == null) {
                MyCellEditor.$$$reportNull$$$0(1);
            }
            super(new JComboBox());
            this.mySuggestMirror = suggestMirror;
            this.myFileSuggestions = fileSuggestions;
            this.myFolderSuggestions = folderSuggestions;
            JComboBox comboBox = this.getEditorComboBox();
            if (comboBox != null) {
                comboBox.setEditable(true);
                comboBox.setLightWeightPopupEnabled(true);
                comboBox.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, (Color)JBColor.GRAY));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox box;
            String initialValue;
            Component tableCellEditorComponent = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
            if (value instanceof String) {
                initialValue = (String)value;
                suggestions.add(initialValue);
            } else {
                initialValue = null;
            }
            suggestions.add("");
            Object valueAt = table.getValueAt(row, 0);
            if (valueAt instanceof VirtualFile) {
                String presentableUrl;
                VirtualFile file = (VirtualFile)valueAt;
                if (this.mySuggestMirror && !(presentableUrl = file.getPresentableUrl()).equals(initialValue)) {
                    suggestions.add(presentableUrl);
                }
                if (file.isDirectory()) {
                    suggestions.addAll(this.myFolderSuggestions);
                } else {
                    suggestions.addAll(this.myFileSuggestions);
                }
            }
            if ((box = (JComboBox)tableCellEditorComponent).getSelectedItem() instanceof String) {
                suggestions.add((String)box.getSelectedItem());
            }
            box.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(suggestions)));
            return tableCellEditorComponent;
        }

        @Override
        public boolean stopCellEditing() {
            Object item;
            JComboBox comboBox = this.getEditorComboBox();
            if (comboBox != null && (item = comboBox.getEditor().getItem()) != null) {
                comboBox.setSelectedItem(item);
            }
            return super.stopCellEditing();
        }

        @Nullable
        private JComboBox getEditorComboBox() {
            return this.editorComponent instanceof JComboBox ? (JComboBox)this.editorComponent : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileSuggestions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "folderSuggestions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/config/servers/PhpPathMappingsConfigurable$MyCellEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

