/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManagerKt;
import com.jetbrains.php.config.interpreters.remote.PhpUnknownRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import icons.PhpIcons;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSdkType
extends SdkType {
    private static final Logger LOG = Logger.getInstance(PhpSdkType.class);
    public static final Predicate<String> INTERPRETER_NAME_PREDICATE = Pattern.compile("php[0-9].[0-9]").asMatchPredicate();

    public static PhpSdkType getInstance() {
        return (PhpSdkType)SdkType.findInstance(PhpSdkType.class);
    }

    private PhpSdkType() {
        super(PhpSdkType.getPhpInterpreter());
    }

    @Nullable
    public String suggestHomePath() {
        return null;
    }

    public Icon getIcon() {
        return PhpIcons.LocalPHP_interpreter;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Set<PhpInterpreterPath> paths = PhpSdkType.findInstalledPhpBinaries();
        if (paths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpSdkType.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        for (PhpInterpreterPath path : paths) {
            suggestions.add(path.getFile().getPresentableUrl());
        }
        ArrayList<String> arrayList = suggestions;
        if (arrayList == null) {
            PhpSdkType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static Set<PhpInterpreterPath> findInstalledPhpBinaries() {
        TreeSet<PhpInterpreterPath> phpInterpreters = new TreeSet<PhpInterpreterPath>(Comparator.comparing(phpInterpreterPath -> phpInterpreterPath.file.getPath(), String.CASE_INSENSITIVE_ORDER));
        for (String path : StringUtil.split((String)System.getenv("PATH"), (String)File.pathSeparator)) {
            VirtualFile virtualFile;
            if (path.startsWith(PhpHerdInterpretersManager.getInstance().getHerdDirectory()) || (virtualFile = LocalFileSystem.getInstance().findFileByPath(path)) == null) continue;
            List phpInterpreterPaths = ContainerUtil.map((Collection)VfsUtil.getChildren((VirtualFile)virtualFile, file -> file.getName().equals(PhpProjectConfigurationFacade.PHP_EXECUTABLE) || INTERPRETER_NAME_PREDICATE.test(file.getName())), file -> new PhpInterpreterPath(file.getPath(), (VirtualFile)file));
            phpInterpreters.addAll(phpInterpreterPaths);
        }
        phpInterpreters.addAll(PhpHerdInterpretersManagerKt.findInstalledLaravelHerdBinaries());
        if (SystemInfo.isMac) {
            String[] cellarDirectories;
            for (String cellarDirectory : cellarDirectories = new String[]{"/usr/local/Cellar", "/opt/homebrew/Cellar"}) {
                VirtualFile[] apps;
                VirtualFile cellar = LocalFileSystem.getInstance().findFileByPath(cellarDirectory);
                if (cellar == null || !cellar.isDirectory() || (apps = cellar.getChildren()) == null) continue;
                Arrays.stream(apps).filter(app -> app.getName().startsWith("php")).filter(VirtualFile::isDirectory).map(VirtualFile::getChildren).filter(Objects::nonNull).flatMap(Arrays::stream).filter(VirtualFile::isDirectory).map(version -> version.findChild("bin")).filter(Objects::nonNull).filter(VirtualFile::isDirectory).map(version -> version.findChild(PhpProjectConfigurationFacade.PHP_EXECUTABLE)).filter(Objects::nonNull).map(file -> new PhpInterpreterPath(file.getPath(), (VirtualFile)file)).collect(Collectors.toCollection(() -> phpInterpreters));
            }
        }
        TreeSet<PhpInterpreterPath> treeSet = phpInterpreters;
        if (treeSet == null) {
            PhpSdkType.$$$reportNull$$$0(2);
        }
        return treeSet;
    }

    public boolean isValidSdkHome(@NotNull String path) {
        if (path == null) {
            PhpSdkType.$$$reportNull$$$0(3);
        }
        return PhpSdkType.getPhpBinary(path) != null;
    }

    @Nullable
    public static VirtualFile getPhpBinary(@Nullable String phpHome) {
        try {
            return PhpCommandSettingsBuilder.findPhpBinary(phpHome);
        }
        catch (ExecutionException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        if (sdkHome == null) {
            PhpSdkType.$$$reportNull$$$0(4);
        }
        return currentSdkName != null ? currentSdkName : "php";
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PhpSdkType.$$$reportNull$$$0(5);
        }
        if (parentComponent == null) {
            PhpSdkType.$$$reportNull$$$0(6);
        }
        if (sdkCreatedCallback == null) {
            PhpSdkType.$$$reportNull$$$0(7);
        }
        Messages.showWarningDialog((Component)parentComponent, (String)PhpBundle.message("PhpInterpreter.configuration.in.project.settings.message", new Object[0]), (String)PhpBundle.message("PhpInterpreter.configuration.in.project.settings.title", new Object[0]));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PhpSdkType.$$$reportNull$$$0(8);
        }
        if (sdkModificator == null) {
            PhpSdkType.$$$reportNull$$$0(9);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PhpSdkType.$$$reportNull$$$0(10);
        }
        if (additional == null) {
            PhpSdkType.$$$reportNull$$$0(11);
        }
        if (additionalData instanceof PhpSdkAdditionalData) {
            ((PhpSdkAdditionalData)additionalData).save(additional);
        }
    }

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        if (currentSdk == null) {
            PhpSdkType.$$$reportNull$$$0(12);
        }
        if (additional == null) {
            PhpSdkType.$$$reportNull$$$0(13);
        }
        return this.loadPhpAdditionalData(currentSdk, additional, null);
    }

    @NotNull
    public PhpSdkAdditionalData loadPhpAdditionalData(@NotNull Sdk interpreter, @NotNull Element additional, @Nullable Project project) {
        if (interpreter == null) {
            PhpSdkType.$$$reportNull$$$0(14);
        }
        if (additional == null) {
            PhpSdkType.$$$reportNull$$$0(15);
        }
        if (PhpSdkType.isRemoteInterpreterPath(interpreter.getHomePath())) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager != null) {
                PhpSdkAdditionalData phpSdkAdditionalData = manager.loadRemote(project, additional, interpreter);
                if (phpSdkAdditionalData == null) {
                    PhpSdkType.$$$reportNull$$$0(16);
                }
                return phpSdkAdditionalData;
            }
            PhpSdkAdditionalData phpSdkAdditionalData = PhpUnknownRemoteSdkAdditionalData.loadRemote(additional);
            if (phpSdkAdditionalData == null) {
                PhpSdkType.$$$reportNull$$$0(17);
            }
            return phpSdkAdditionalData;
        }
        PhpSdkAdditionalData phpSdkAdditionalData = PhpSdkAdditionalData.load(additional);
        if (phpSdkAdditionalData == null) {
            PhpSdkType.$$$reportNull$$$0(18);
        }
        return phpSdkAdditionalData;
    }

    private static boolean isRemoteInterpreterPath(@Nullable String path) {
        if (RemoteSdkProperties.isRemoteSdk((String)path)) {
            return true;
        }
        if (StringUtil.isNotEmpty((String)path) && URLUtil.containsScheme((String)path)) {
            String protocol = VirtualFileManager.extractProtocol((String)path);
            return !"file".equals(protocol);
        }
        return false;
    }

    @NotNull
    public String getPresentableName() {
        String string = PhpSdkType.getPhpInterpreter();
        if (string == null) {
            PhpSdkType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nls
    private static String getPhpInterpreter() {
        return PhpBundle.message("PhpInterpreter.php.sdk.type", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpSdkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstalledPhpBinaries";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpSdkType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPhpAdditionalData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadPhpAdditionalData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpInterpreterPath {
        private final String name;
        private final VirtualFile file;

        public PhpInterpreterPath(@NotNull String name, @NotNull VirtualFile file) {
            if (name == null) {
                PhpInterpreterPath.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpInterpreterPath.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.file = file;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                PhpInterpreterPath.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                PhpInterpreterPath.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        @NotNull
        public PhpInterpreter createPhpInterpreter(@Nullable Project project) {
            PhpInterpreter phpInterpreter = new PhpInterpreter(true);
            PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
            phpInterpreter.setName(PhpNamedCloneableItemsListEditor.suggestUniqueName(this.name, manager::findInterpreter));
            phpInterpreter.setHomePath(this.file.getPresentableUrl());
            PhpInterpreter phpInterpreter2 = phpInterpreter;
            if (phpInterpreter2 == null) {
                PhpInterpreterPath.$$$reportNull$$$0(4);
            }
            return phpInterpreter2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpSdkType$PhpInterpreterPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpSdkType$PhpInterpreterPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPhpInterpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

