/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersBaseManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersStateListener;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpretersManagerImpl
implements PhpInterpretersManager {
    private static final Logger LOG = Logger.getInstance(PhpInterpretersManagerImpl.class);
    private final PhpApplicationInterpretersManager myApplicationManager = PhpApplicationInterpretersManager.getInstance();
    private final PhpProjectInterpretersManager myProjectManager;

    public static PhpInterpretersManagerImpl getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpInterpretersManagerImpl)targetProject.getService(PhpInterpretersManagerImpl.class);
    }

    public PhpInterpretersManagerImpl(@Nullable Project project) {
        if (project != null && !project.isDefault()) {
            this.myProjectManager = PhpProjectInterpretersManager.getInstance(project);
            this.addListener(project, p -> this.resolvePossibleCollisions(p));
            this.registerInterpreterStateListeners(project);
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        if (manager != null) {
            manager.subscribeOnSshConfigsChanged(project);
        }
        this.subscribeForPluginUnloading();
    }

    private void subscribeForPluginUnloading() {
        Project disposable = this.myProjectManager != null ? this.myProjectManager.myProject : null;
        CredentialsType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<CredentialsType<?>>(){

            public void extensionAdded(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CredentialsManager.recogniseCredentialType(PhpInterpretersManagerImpl.this.getAllInterpretersStream(), extension);
            }

            public void extensionRemoved(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                CredentialsManager.forgetCredentialType(PhpInterpretersManagerImpl.this.getAllInterpretersStream(), extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)disposable);
        CredentialsLanguageContribution.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CredentialsLanguageContribution>(){

            public void extensionAdded(@NotNull CredentialsLanguageContribution extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                CredentialsManager.recogniseCredentialType(PhpInterpretersManagerImpl.this.getAllInterpretersStream(), (CredentialsType)extension.getType());
            }

            public void extensionRemoved(@NotNull CredentialsLanguageContribution extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                CredentialsManager.forgetCredentialType(PhpInterpretersManagerImpl.this.getAllInterpretersStream(), (CredentialsType)extension.getType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)disposable);
    }

    private Stream<? extends SdkAdditionalData> getAllInterpretersStream() {
        Stream interpreterStream = this.myApplicationManager.getInterpreters().stream();
        if (this.myProjectManager != null) {
            interpreterStream = Stream.concat(interpreterStream, this.myProjectManager.getInterpreters().stream());
        }
        return interpreterStream.map(interpreter -> interpreter.getPhpSdkAdditionalData());
    }

    private void registerInterpreterStateListeners(final @NotNull Project project) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(0);
        }
        for (PhpInterpretersStateListener listener : (PhpInterpretersStateListener[])PhpInterpretersStateListener.EP_NAME.getExtensions()) {
            this.addListener(project, listener);
        }
        PhpInterpretersStateListener.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PhpInterpretersStateListener>(){

            public void extensionAdded(@NotNull PhpInterpretersStateListener extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                PhpInterpretersManagerImpl.this.addListener(project, extension);
            }

            public void extensionRemoved(@NotNull PhpInterpretersStateListener extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                PhpInterpretersManagerImpl.this.removeListener(project, extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)PhpProjectInterpretersManager.getInstance(project));
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.myProjectManager == null) {
            return;
        }
        String selected = PhpProjectConfigurationFacade.getInstance(project).getProjectConfiguration().getInterpreterName();
        List<PhpInterpreter> interpreters = this.getInterpreters();
        HashSet<String> appInterpretersNames = new HashSet<String>();
        HashSet<String> appInterpretersIds = new HashSet<String>();
        HashSet<String> projectInterpretersNames = new HashSet<String>();
        for (PhpInterpreter interpreter : interpreters) {
            if (!interpreter.isProjectLevel()) {
                appInterpretersIds.add(interpreter.getId());
                appInterpretersNames.add(interpreter.getName());
                continue;
            }
            projectInterpretersNames.add(interpreter.getName());
        }
        Condition isOccupied = name -> appInterpretersNames.contains(name) || projectInterpretersNames.contains(name);
        HashSet<String> previousProjectInterpretersIds = new HashSet<String>();
        HashMap<String, String> oldToNewId = new HashMap<String, String>();
        HashMap<@NlsSafe String, @NlsSafe String> oldToNewName = new HashMap<String, String>();
        for (PhpInterpreter interpreter : interpreters) {
            String oldName = interpreter.getName();
            if (interpreter.isProjectLevel() && (appInterpretersNames.contains(oldName) || appInterpretersIds.contains(interpreter.getId()))) {
                PhpInterpreter oldInterpreter = interpreter.clone();
                if (appInterpretersNames.contains(oldName)) {
                    interpreter.setName(PhpNameUtil.unique(oldName + " (project level)", " (", ")", (Condition<? super String>)isOccupied));
                    if (StringUtil.isNotEmpty((String)selected) && oldName.equals(selected)) {
                        PhpProjectConfigurationFacade.getInstance(project).updateSelectedInterpreterName(oldName, interpreter.getName());
                    }
                }
                while (appInterpretersIds.contains(interpreter.getId()) || previousProjectInterpretersIds.contains(interpreter.getId())) {
                    interpreter.setId(PhpInterpreter.getNextId());
                }
                oldToNewName.put(oldName, interpreter.getName());
                if (!StringUtil.equals((CharSequence)oldInterpreter.getId(), (CharSequence)interpreter.getId())) {
                    oldToNewId.put(oldInterpreter.getId(), interpreter.getId());
                }
                projectInterpretersNames.add(oldName);
            }
            previousProjectInterpretersIds.add(interpreter.getId());
        }
        if (!oldToNewName.isEmpty()) {
            this.setInterpreters(interpreters);
            PhpInterpretersPhpInfoCacheImpl.getInstance(project).resolveConflicts(oldToNewName);
            if (!oldToNewId.isEmpty()) {
                ((PhpInterpreterConflictResolveListener)project.getMessageBus().syncPublisher(PhpInterpreterConflictResolveListener.TOPIC)).resolveInterpreterConflict(oldToNewId);
            }
            PhpInterpretersManagerImpl.showWarning(project, oldToNewName);
        }
    }

    private static void showWarning(@NotNull Project project, @NotNull Map<@NlsSafe String, @NlsSafe String> oldToNewName) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(2);
        }
        if (oldToNewName == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(3);
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.append(PhpBundle.message("PhpInterpreter.php.interpreter.name.conflict", new Object[0]));
        for (Map.Entry<String, String> entry : oldToNewName.entrySet()) {
            htmlBuilder.br().append((HtmlChunk)HtmlChunk.text((String)entry.getKey()).bold());
            htmlBuilder.append(" -> ");
            htmlBuilder.append((HtmlChunk)HtmlChunk.text((String)entry.getValue()).bold());
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("PHP Interpreters");
        notificationGroup.createNotification(PhpBundle.message("PhpInterpreter.php.interpreter.name.conflict.title", new Object[0]), htmlBuilder.toString(), NotificationType.WARNING).notify(project);
    }

    @Override
    @NotNull
    public List<PhpInterpreter> getInterpreters() {
        ArrayList<PhpInterpreter> result = new ArrayList<PhpInterpreter>(this.myApplicationManager.getInterpreters());
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getInterpreters());
        }
        ArrayList<PhpInterpreter> arrayList = result;
        if (arrayList == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    public void setInterpreters(@NotNull List<PhpInterpreter> interpreters) {
        if (interpreters == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setInterpreters(interpreters);
            return;
        }
        ArrayList<PhpInterpreter> applicationLevel = new ArrayList<PhpInterpreter>();
        ArrayList<PhpInterpreter> projectLevel = new ArrayList<PhpInterpreter>();
        for (PhpInterpreter interpreter : interpreters) {
            if (interpreter.isProjectLevel()) {
                projectLevel.add(interpreter);
                continue;
            }
            applicationLevel.add(interpreter);
        }
        this.myProjectManager.setInterpreters(projectLevel);
        this.myApplicationManager.setInterpreters(applicationLevel);
        this.myProjectManager.onInterpretersUpdate(this.myProjectManager.getProject());
    }

    @Override
    public void addInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(6);
        }
        if (interpreter.isProjectLevel()) {
            if (this.myProjectManager != null) {
                this.myProjectManager.addInterpreter(interpreter);
            }
        } else {
            this.myApplicationManager.addInterpreter(interpreter);
        }
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreter(@Nullable String interpreterName) {
        PhpInterpreter interpreter = this.myApplicationManager.findInterpreter(interpreterName);
        if (interpreter == null && this.myProjectManager != null) {
            interpreter = this.myProjectManager.findInterpreter(interpreterName);
        }
        return interpreter;
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreterById(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.myApplicationManager.findInterpreterById(interpreterId);
        if (interpreter == null && this.myProjectManager != null) {
            interpreter = this.myProjectManager.findInterpreterById(interpreterId);
        }
        return interpreter;
    }

    @Override
    @Nullable
    public PhpSdkAdditionalData findInterpreterDataById(@Nullable String interpreterId) {
        PhpSdkAdditionalData data = this.myApplicationManager.findInterpreterDataById(interpreterId);
        if (data == null && this.myProjectManager != null) {
            data = this.myProjectManager.findInterpreterDataById(interpreterId);
        }
        return data;
    }

    @Override
    @Nullable
    @NlsSafe
    public String findInterpreterId(@Nullable String interpreterName) {
        String interpreterId = this.myApplicationManager.findInterpreterId(interpreterName);
        if (interpreterId == null && this.myProjectManager != null) {
            interpreterId = this.myProjectManager.findInterpreterId(interpreterName);
        }
        return interpreterId;
    }

    @Override
    @Nullable
    @NlsSafe
    public String findInterpreterName(@Nullable String interpreterId) {
        String interpreterName = this.myApplicationManager.findInterpreterName(interpreterId);
        if (interpreterName == null && this.myProjectManager != null) {
            interpreterName = this.myProjectManager.findInterpreterName(interpreterId);
        }
        return interpreterName;
    }

    @Override
    public void addListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(7);
        }
        if (listener == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(8);
        }
        this.myApplicationManager.addListener(project, listener);
        if (this.myProjectManager != null) {
            this.myProjectManager.addListener(project, listener);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Added PHP interpreter listener: " + listener.getClass().getSimpleName());
        }
    }

    @Override
    public void removeListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(9);
        }
        if (listener == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(10);
        }
        this.myApplicationManager.removeListener(project, listener);
        if (this.myProjectManager != null) {
            this.myProjectManager.removeListener(project, listener);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removed PHP interpreter listener: " + listener.getClass().getSimpleName());
        }
    }

    public boolean isProjectLevel(@Nullable String interpreterId) {
        return this.myProjectManager != null && this.myProjectManager.findInterpreterById(interpreterId) != null;
    }

    @NotNull
    public String getUniqueName(@NotNull String newName) {
        if (newName == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(11);
        }
        HashSet<String> interpreterNames = new HashSet<String>();
        for (PhpInterpreter interpreter : this.getInterpreters()) {
            interpreterNames.add(interpreter.getName());
        }
        if (!interpreterNames.contains(newName)) {
            String string = newName;
            if (string == null) {
                PhpInterpretersManagerImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        Object name = newName;
        int counter = 1;
        while (interpreterNames.contains(name)) {
            name = newName + " (" + counter++ + ")";
        }
        String string = name;
        if (string == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewName";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerInterpreterStateListeners";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInterpreter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13 -> new IllegalStateException(string);
        };
    }

    @State(name="PhpInterpreters", storages={@Storage(value="php.xml", roamingType=RoamingType.DISABLED, deprecated=true), @Storage(value="php-tools.xml", roamingType=RoamingType.DISABLED)})
    public static class PhpApplicationInterpretersManager
    extends PhpInterpretersBaseManager {
        public static PhpApplicationInterpretersManager getInstance() {
            return (PhpApplicationInterpretersManager)ApplicationManager.getApplication().getService(PhpApplicationInterpretersManager.class);
        }

        @Override
        @Nullable
        protected Project getProject() {
            return null;
        }
    }

    @State(name="PhpInterpreters", storages={@Storage(value="php.xml")})
    public static class PhpProjectInterpretersManager
    extends PhpInterpretersBaseManager {
        @NotNull
        private final Project myProject;

        public static PhpProjectInterpretersManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpProjectInterpretersManager.$$$reportNull$$$0(0);
            }
            return (PhpProjectInterpretersManager)project.getService(PhpProjectInterpretersManager.class);
        }

        public PhpProjectInterpretersManager(@NotNull Project project) {
            if (project == null) {
                PhpProjectInterpretersManager.$$$reportNull$$$0(1);
            }
            this.myProject = project;
        }

        @Override
        @NotNull
        protected Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                PhpProjectInterpretersManager.$$$reportNull$$$0(2);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$PhpProjectInterpretersManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$PhpProjectInterpretersManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface PhpInterpreterConflictResolveListener {
        public static final Topic<PhpInterpreterConflictResolveListener> TOPIC = Topic.create((String)"resolveInterpreterConflict", PhpInterpreterConflictResolveListener.class);

        public void resolveInterpreterConflict(@NotNull Map<String, String> var1);
    }
}

