/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.composer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.composer.LanguageLevelComposerParser;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelComposerSettingConfig
implements ComposerSettingSyncConfigClient<String> {
    @NonNls
    private static final List<String> TAGS = new SmartList((Object[])new String[]{"require", "config"});

    @Override
    @Nullable
    public String parse(@NotNull Project project, @NotNull Map<String, JsonElement> elements, @NotNull VirtualFile config) {
        if (project == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(1);
        }
        if (config == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(2);
        }
        if (elements.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, JsonElement> entry : elements.entrySet()) {
            String phpVersion;
            JsonElement element = entry.getValue();
            if (element == null || !element.isJsonObject() || (phpVersion = LanguageLevelComposerSettingConfig.extractPhpVersionFromJsonObject(element.getAsJsonObject())) == null) continue;
            return phpVersion;
        }
        return null;
    }

    @Override
    public void updateSetting(@NotNull Project project, @Nullable String setting, @NotNull Runnable onSuccess) {
        PhpLanguageLevel requiredLevel;
        PhpProjectConfigurationFacade facade;
        PhpLanguageLevel currentLevel;
        if (project == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(3);
        }
        if (onSuccess == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(4);
        }
        if ((currentLevel = (facade = PhpProjectConfigurationFacade.getInstance(project)).getLanguageLevel()) != (requiredLevel = LanguageLevelComposerParser.getMinRequiredLanguageLevel(setting, project))) {
            ApplicationManager.getApplication().invokeLater(() -> {
                facade.setLanguageLevel(requiredLevel);
                onSuccess.run();
            });
        }
    }

    @Override
    @NotNull
    public String getSettingTitle() {
        String string = PhpBundle.message(PlatformUtils.isPhpStorm() ? "actions.detect.language.level.loaded.from.composer.title" : "actions.detect.language.level.loaded.from.composer.idea.title", new Object[0]);
        if (string == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings showSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.PHP;
        if (settings == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(6);
        }
        return settings;
    }

    @Override
    public boolean isDefaultSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        if (project == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(7);
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        return PhpLanguageLevel.current((Project)project) == PhpLanguageLevel.current((Project)defaultProject);
    }

    @Override
    @NotNull
    public List<String> getPath() {
        List<String> list = TAGS;
        if (list == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static String extractPhpVersionFromJsonObject(@NotNull JsonObject object) {
        String phpVersion;
        if (object == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(9);
        }
        if ((phpVersion = LanguageLevelComposerSettingConfig.getPhpVersion(object)) != null) {
            return phpVersion;
        }
        JsonObject platformObject = LanguageLevelComposerSettingConfig.getPlatformObject(object);
        if (platformObject != null) {
            return LanguageLevelComposerSettingConfig.getPhpVersion(platformObject);
        }
        return null;
    }

    @Nullable
    private static JsonObject getPlatformObject(@NotNull JsonObject configObject) {
        JsonElement platformElement;
        if (configObject == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(10);
        }
        if ((platformElement = configObject.get("platform")) != null && platformElement.isJsonObject()) {
            return platformElement.getAsJsonObject();
        }
        return null;
    }

    @Nullable
    private static String getPhpVersion(@NotNull JsonObject object) {
        JsonElement php;
        if (object == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(11);
        }
        if ((php = object.get("php")) == null) {
            php = object.get("PHP");
        }
        if (php != null && php.isJsonPrimitive()) {
            return php.getAsString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/composer/LanguageLevelComposerSettingConfig";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/composer/LanguageLevelComposerSettingConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingTitle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "showSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSetting";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractPhpVersionFromJsonObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPhpVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

