/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.composer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelComposerParser {
    private static final String BEFORE_CHARS = "-,><=|!";
    private static final String AFTER_CHARS = "-,=|";

    public static PhpLanguageLevel getMinRequiredLanguageLevel(@Nullable String version, PhpLanguageLevel defaultLanguageLevel) {
        if (StringUtil.isEmpty((String)version)) {
            return defaultLanguageLevel;
        }
        if (StringUtil.contains((CharSequence)(version = LanguageLevelComposerParser.filterUnnecessarySpaces(version)), (CharSequence)"|")) {
            List list = StringUtil.split((String)version, (String)"|");
            return list.stream().map(i -> LanguageLevelComposerParser.getMinRequiredLanguageLevel(i, defaultLanguageLevel)).min(Enum::compareTo).orElse(defaultLanguageLevel);
        }
        if (StringUtil.contains((CharSequence)version, (CharSequence)",")) {
            return LanguageLevelComposerParser.handleLogicalAnd(version, ",", defaultLanguageLevel);
        }
        if (StringUtil.containsWhitespaces((CharSequence)version)) {
            return LanguageLevelComposerParser.handleLogicalAnd(version, " ", defaultLanguageLevel);
        }
        ParsedComposerLanguageLevel parsedLevel = LanguageLevelComposerParser.parseSingleLanguageLevelInner(version);
        return parsedLevel != null ? parsedLevel.myLevel : defaultLanguageLevel;
    }

    @NotNull
    public static PhpLanguageLevel getMinRequiredLanguageLevel(@Nullable String version, @NotNull Project project) {
        if (project == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(0);
        }
        PhpLanguageLevel phpLanguageLevel = LanguageLevelComposerParser.getMinRequiredLanguageLevel(version, PhpLanguageLevel.current((Project)project));
        if (phpLanguageLevel == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(1);
        }
        return phpLanguageLevel;
    }

    private static boolean isSingleVersionSpecified(@NotNull String version) {
        if (version == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(2);
        }
        return !StringUtil.contains((CharSequence)version, (CharSequence)"|") && !StringUtil.contains((CharSequence)version, (CharSequence)",") && !StringUtil.containsWhitespaces((CharSequence)version);
    }

    public static ParsedComposerLanguageLevel parseSingleLanguageLevel(@Nullable String version) {
        return version != null ? LanguageLevelComposerParser.parseSingleLanguageLevelInner(LanguageLevelComposerParser.filterUnnecessarySpaces(version)) : null;
    }

    @Nullable
    private static ParsedComposerLanguageLevel parseSingleLanguageLevelInner(@Nullable String version) {
        PhpLanguageLevel minimalRequired;
        PhpLanguageLevel notLanguageLevel;
        if (version == null || !LanguageLevelComposerParser.isSingleVersionSpecified((String)version)) {
            return null;
        }
        boolean concreteVersionSpecified = !((String)(version = StringUtil.strip((String)version, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER))).contains("*");
        boolean nonStrict = true;
        String prefix = "";
        if (StringUtil.startsWithChar((CharSequence)version, (char)'<')) {
            prefix = "<";
            return new ParsedComposerLanguageLevel(PhpLanguageLevel.PHP530, false, true, prefix);
        }
        if (StringUtil.startsWith((CharSequence)version, (CharSequence)">=")) {
            prefix = ">=";
            version = ((String)version).substring(2);
        } else if (StringUtil.contains((CharSequence)version, (CharSequence)"-")) {
            version = (String)StringUtil.split((String)version, (String)"-").get(0);
            concreteVersionSpecified = false;
        } else if (StringUtil.contains((CharSequence)version, (CharSequence)"*")) {
            List split = StringUtil.split((String)version, (String)"*");
            if (!split.isEmpty()) {
                version = StringUtil.trimEnd((String)((String)split.get(0)), (String)".");
            }
        } else if (StringUtil.startsWithChar((CharSequence)version, (char)'~') || StringUtil.startsWithChar((CharSequence)version, (char)'^')) {
            prefix = String.valueOf(((String)version).charAt(0));
            version = ((String)version).substring(1);
        } else if (StringUtil.startsWithChar((CharSequence)version, (char)'>')) {
            prefix = String.valueOf(((String)version).charAt(0));
            version = ((String)version).substring(1);
            nonStrict = false;
        }
        if (!((String)version).contains(".")) {
            version = (String)version + ".0";
        }
        if (StringUtil.startsWith((CharSequence)version, (CharSequence)"!=") && (notLanguageLevel = PhpLanguageLevel.parse((String)(version = ((String)version).substring(2)))) != null && (minimalRequired = (PhpLanguageLevel)ContainerUtil.find((Object[])PhpLanguageLevel.values(), level -> level.compareTo((Enum)notLanguageLevel) != 0)) != null) {
            return new ParsedComposerLanguageLevel(minimalRequired, false, false, prefix);
        }
        PhpLanguageLevel requiredLevel = PhpLanguageLevel.parse((String)version);
        if (requiredLevel != null) {
            for (PhpLanguageLevel level2 : PhpLanguageLevel.values()) {
                boolean minimalRequired2;
                boolean bl = nonStrict ? level2.compareTo((Enum)requiredLevel) >= 0 : (minimalRequired2 = level2.compareTo((Enum)requiredLevel) > 0);
                if (!minimalRequired2) continue;
                return new ParsedComposerLanguageLevel(level2, nonStrict, concreteVersionSpecified, prefix);
            }
        }
        return null;
    }

    @NotNull
    public static String filterUnnecessarySpaces(@NotNull String version) {
        if (version == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(3);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char charAt = version.charAt(i);
            if (StringUtil.isWhiteSpace((char)charAt) && !LanguageLevelComposerParser.logicalAndSpace(version, i)) continue;
            result.append(charAt);
        }
        String string = result.toString();
        if (string == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean logicalAndSpace(@NotNull String version, int index) {
        if (version == null) {
            LanguageLevelComposerParser.$$$reportNull$$$0(5);
        }
        return !(index > 0 && StringUtil.containsChar((String)BEFORE_CHARS, (char)version.charAt(index - 1)) || index < version.length() - 1 && StringUtil.containsChar((String)AFTER_CHARS, (char)version.charAt(index + 1)));
    }

    private static PhpLanguageLevel handleLogicalAnd(String version, String separator, PhpLanguageLevel defaultLanguageLevel) {
        return StringUtil.split((String)version, (String)separator).stream().map(i -> LanguageLevelComposerParser.getMinRequiredLanguageLevel(i, defaultLanguageLevel)).max(Enum::compareTo).orElse(defaultLanguageLevel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/composer/LanguageLevelComposerParser";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/composer/LanguageLevelComposerParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinRequiredLanguageLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnnecessarySpaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMinRequiredLanguageLevel";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSingleVersionSpecified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterUnnecessarySpaces";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logicalAndSpace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }

    public static class ParsedComposerLanguageLevel {
        private final PhpLanguageLevel myLevel;
        private final boolean myInclusiveHigher;
        private final boolean myConcreteVersionSpecified;
        private final String myPrefix;

        public ParsedComposerLanguageLevel(PhpLanguageLevel string, boolean inclusiveHigher, boolean concreteVersionSpecified, String prefix) {
            this.myLevel = string;
            this.myInclusiveHigher = inclusiveHigher;
            this.myConcreteVersionSpecified = concreteVersionSpecified;
            this.myPrefix = prefix;
        }

        public PhpLanguageLevel getLevel() {
            return this.myLevel;
        }

        public boolean isInclusiveHigher() {
            return this.myInclusiveHigher;
        }

        public boolean isConcreteVersionSpecified() {
            return this.myConcreteVersionSpecified;
        }

        public String getPrefix() {
            return this.myPrefix;
        }
    }
}

