/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.ide.util.EditorHelper;
import com.intellij.json.psi.JsonProperty;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSynchronizationInitListener;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectSharedConfiguration;
import com.jetbrains.php.lang.inspections.PhpSwitchComposerLanguageLevelQuickFix;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class PhpLanguageLevelStatusBarWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "php.language.level.widget";

    PhpLanguageLevelStatusBarWidgetFactory() {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = PhpBundle.message(ID, new Object[0]);
        if (string == null) {
            PhpLanguageLevelStatusBarWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            PhpLanguageLevelStatusBarWidgetFactory.$$$reportNull$$$0(1);
        }
        return PlatformUtils.isPhpStorm();
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
        if (project == null) {
            PhpLanguageLevelStatusBarWidgetFactory.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PhpLanguageLevelStatusBarWidgetFactory.$$$reportNull$$$0(3);
        }
        return new PhpLanguageLevelWidget(project, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class PhpLanguageLevelWidget
    extends EditorBasedStatusBarPopup {
        private boolean myIsComposerRequiresPhp;

        private PhpLanguageLevelWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
            if (project == null) {
                PhpLanguageLevelWidget.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                PhpLanguageLevelWidget.$$$reportNull$$$0(1);
            }
            super(project, false, scope);
            this.myIsComposerRequiresPhp = ComposerDataService.getInstance(this.getProject()).composerConfigRequiresPhp();
        }

        @NonNls
        @NotNull
        public String ID() {
            return PhpLanguageLevelStatusBarWidgetFactory.ID;
        }

        @NotNull
        protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
            PhpLanguageLevel current = PhpLanguageLevel.current((Project)this.getProject());
            @NlsSafe String text = "PHP: " + current.getPresentableName();
            return new EditorBasedStatusBarPopup.WidgetState(this.isComposerSync() ? PhpBundle.message("tooltip.configured.php.language.level.widget.composer", new Object[0]) : PhpBundle.message("tooltip.configured.php.language.level.widget", new Object[0]), text, true);
        }

        private boolean isComposerSync() {
            return this.myIsComposerRequiresPhp && ComposerDataService.getInstance(this.getProject()).getSynchronizationState().equals((Object)ComposerDataService.SynchronizationState.SYNCHRONIZE);
        }

        protected void registerCustomListeners(MessageBusConnection connection) {
            connection.subscribe(PhpProjectSharedConfiguration.StateChangedListener.LANGUAGE_LEVEL_CHANGED_TOPIC, () -> ((PhpLanguageLevelWidget)this).update());
            ComposerDataService composerDataService = ComposerDataService.getInstance(this.getProject());
            ComposerSynchronizationInitListener composerSyncListener = newSyncState -> this.update();
            composerDataService.addSynchronizationInitListener(composerSyncListener);
            ComposerConfigListener composerPathListener = new ComposerConfigListener(){

                @Override
                public void configContentChanged(boolean composerRequiresPhp) {
                    myIsComposerRequiresPhp = composerRequiresPhp;
                    this.update();
                }

                @Override
                public void configPathChanged(@Nullable String oldPath, @Nullable String newPath, boolean isWellConfigured) {
                    if (!isWellConfigured) {
                        myIsComposerRequiresPhp = false;
                    }
                    this.update();
                }
            };
            composerDataService.addConfigListener(composerPathListener);
            Disposer.register((Disposable)this, () -> {
                composerDataService.removeSynchronizationInitListener(composerSyncListener);
                composerDataService.removeConfigListener(composerPathListener);
            });
        }

        @NotNull
        protected ListPopup createPopup(@NotNull DataContext context) {
            if (context == null) {
                PhpLanguageLevelWidget.$$$reportNull$$$0(2);
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)(this.isComposerSync() ? new PhpComposerSyncPopup(this.getProject()) : new PhpLanguageLevelListPopupStep(this.getProject(), PhpLanguageLevel.current((Project)this.getProject()))));
            if (listPopup == null) {
                PhpLanguageLevelWidget.$$$reportNull$$$0(3);
            }
            return listPopup;
        }

        @NotNull
        protected StatusBarWidget createInstance(@NotNull Project project) {
            if (project == null) {
                PhpLanguageLevelWidget.$$$reportNull$$$0(4);
            }
            return new PhpLanguageLevelWidget(project, this.getScope());
        }

        protected void updateForDocument(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") Document document) {
        }

        protected void updateForFile(@Nullable(value="null means update anyway") @Nullable(value="null means update anyway") VirtualFile file) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopup";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createInstance";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static final class PhpComposerSyncPopup
        extends BaseListPopupStep<String> {
            private static final @NlsContexts.Command String DISABLE_SYNCHRONISATION_WITH_COMPOSER = PhpBundle.message("command.name.disable.synchronisation.with.composer", new Object[0]);
            @Nls
            private static final String NAVIGATE_TO_COMPOSER = PhpBundle.message("navigate.to.composer.json", new Object[0]);
            private final Project myProject;

            private PhpComposerSyncPopup(@NotNull Project project) {
                if (project == null) {
                    PhpComposerSyncPopup.$$$reportNull$$$0(0);
                }
                super(PhpBundle.message("tooltip.configured.php.language.level.widget.composer", new Object[0]), (Object[])new String[]{DISABLE_SYNCHRONISATION_WITH_COMPOSER, NAVIGATE_TO_COMPOSER});
                this.myProject = project;
            }

            @Nullable
            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                if (selectedValue.equals(DISABLE_SYNCHRONISATION_WITH_COMPOSER)) {
                    return this.doFinalStep(() -> {
                        ComposerDataService.getInstance(this.myProject).setSynchronizationState(ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE);
                        NotificationGroupManager.getInstance().getNotificationGroup("Language level synchronisation with Composer").createNotification(PhpBundle.message("notification.content.language.level.synchronisation.with.composer.was.disabled", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(PhpBundle.message("composer.revert.action.name", new Object[0])){

                            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (notification == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                ComposerDataService.getInstance(myProject).setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
                                notification.expire();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpComposerSyncPopup$1";
                                objectArray[2] = "actionPerformed";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }).notify(this.myProject);
                    });
                }
                if (selectedValue.equals(NAVIGATE_TO_COMPOSER)) {
                    return this.doFinalStep(() -> {
                        JsonProperty property = PhpSwitchComposerLanguageLevelQuickFix.getComposerPhpLevelProperty(this.myProject);
                        if (property != null) {
                            EditorHelper.openInEditor((PsiElement)property);
                        }
                    });
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpComposerSyncPopup", "<init>"));
            }
        }

        private static class PhpLanguageLevelListPopupStep
        implements ListPopupStep<PhpLanguageLevel> {
            private final Project myProject;
            private final PhpLanguageLevel myCurrent;

            private PhpLanguageLevelListPopupStep(@NotNull Project project, @NotNull PhpLanguageLevel current) {
                if (project == null) {
                    PhpLanguageLevelListPopupStep.$$$reportNull$$$0(0);
                }
                if (current == null) {
                    PhpLanguageLevelListPopupStep.$$$reportNull$$$0(1);
                }
                this.myProject = project;
                this.myCurrent = current;
            }

            public @Unmodifiable @NotNull List<PhpLanguageLevel> getValues() {
                List<PhpLanguageLevel> levels = this.getAllLevels();
                int firstUnapplicableIndex = ContainerUtil.indexOf(levels, this::isInapplicable);
                List<PhpLanguageLevel> list = levels.subList(0, firstUnapplicableIndex + 1);
                if (list == null) {
                    PhpLanguageLevelListPopupStep.$$$reportNull$$$0(2);
                }
                return list;
            }

            @NotNull
            protected List<PhpLanguageLevel> getAllLevels() {
                List list = ContainerUtil.reverse(Arrays.asList(PhpLanguageLevel.values()));
                if (list == null) {
                    PhpLanguageLevelListPopupStep.$$$reportNull$$$0(3);
                }
                return list;
            }

            public boolean isSelectable(PhpLanguageLevel value) {
                return this.isInapplicable(value) || value != this.myCurrent;
            }

            @Nullable
            public Icon getIconFor(PhpLanguageLevel aValue) {
                return null;
            }

            @NotNull
            public String getTextFor(PhpLanguageLevel value) {
                String string = this.isInapplicable(value) ? PhpBundle.message("older", new Object[0]) : value.getPresentableName();
                if (string == null) {
                    PhpLanguageLevelListPopupStep.$$$reportNull$$$0(4);
                }
                return string;
            }

            protected boolean isInapplicable(PhpLanguageLevel value) {
                return value.compareTo((Enum)PhpLanguageLevel.DEFAULT) < 0;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PhpLanguageLevel value) {
                return null;
            }

            public int getDefaultOptionIndex() {
                List<PhpLanguageLevel> values = this.getValues();
                return this.isInapplicable(this.myCurrent) ? values.size() - 1 : values.indexOf(this.myCurrent);
            }

            @Nullable
            public String getTitle() {
                return PhpBundle.message("change.php.language.level", new Object[0]);
            }

            @Nullable
            public PopupStep<?> onChosen(PhpLanguageLevel selectedValue, boolean finalChoice) {
                if (this.isInapplicable(selectedValue)) {
                    return new PhpOldLevelsPopupStep(this.myProject, this.myCurrent);
                }
                PhpProjectConfigurationFacade.getInstance(this.myProject).setLanguageLevel(selectedValue);
                return FINAL_CHOICE;
            }

            public boolean isFinal(PhpLanguageLevel value) {
                return !this.isInapplicable(value);
            }

            public boolean hasSubstep(PhpLanguageLevel selectedValue) {
                return this.isInapplicable(selectedValue);
            }

            public void canceled() {
            }

            public boolean isMnemonicsNavigationEnabled() {
                return false;
            }

            @Nullable
            public MnemonicNavigationFilter<PhpLanguageLevel> getMnemonicNavigationFilter() {
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @Nullable
            public SpeedSearchFilter<PhpLanguageLevel> getSpeedSearchFilter() {
                return null;
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            @Nullable
            public Runnable getFinalRunnable() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpLanguageLevelListPopupStep";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpLanguageLevelListPopupStep";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValues";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllLevels";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        }

        private static final class PhpOldLevelsPopupStep
        extends PhpLanguageLevelListPopupStep {
            private PhpOldLevelsPopupStep(@NotNull Project project, @NotNull PhpLanguageLevel current) {
                if (project == null) {
                    PhpOldLevelsPopupStep.$$$reportNull$$$0(0);
                }
                if (current == null) {
                    PhpOldLevelsPopupStep.$$$reportNull$$$0(1);
                }
                super(project, current);
            }

            @Override
            protected boolean isInapplicable(PhpLanguageLevel value) {
                return false;
            }

            @Override
            public @Unmodifiable @NotNull List<PhpLanguageLevel> getValues() {
                List list = ContainerUtil.filter(super.getAllLevels(), x$0 -> super.isInapplicable((PhpLanguageLevel)x$0));
                if (list == null) {
                    PhpOldLevelsPopupStep.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "current";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpOldLevelsPopupStep";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/config/PhpLanguageLevelStatusBarWidgetFactory$PhpLanguageLevelWidget$PhpOldLevelsPopupStep";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValues";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

