/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.config.PhpComposerFilesViewCollector;
import com.jetbrains.php.config.PhpComposerFilesViewKt;
import com.jetbrains.php.util.ConfigurableForm;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001d\u0010\u001b\u001a\u00020\u00142\u000b\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/php/config/PhpComposerFilesView;", "Lcom/jetbrains/php/util/ConfigurableForm;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "tableView", "Lcom/intellij/ui/table/TableView;", "toolbarDecorator", "Lcom/intellij/ui/ToolbarDecorator;", "Lorg/jetbrains/annotations/NotNull;", "component", "Ljavax/swing/JPanel;", "getComponent", "Ljavax/swing/JComponent;", "reset", "", "apply", "isModified", "", "getComposerConfigs", "", "chooseComposerFile", "showErrorBalloon", "message", "", "Lorg/jetbrains/annotations/Nls;", "ComposerColumnInfo", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpComposerFilesView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpComposerFilesView.kt\ncom/jetbrains/php/config/PhpComposerFilesView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1056#2:148\n*S KotlinDebug\n*F\n+ 1 PhpComposerFilesView.kt\ncom/jetbrains/php/config/PhpComposerFilesView\n*L\n71#1:148\n*E\n"})
public final class PhpComposerFilesView
implements ConfigurableForm {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable parentDisposable;
    @Nullable
    private final VirtualFile projectDir;
    @NotNull
    private final TableView<VirtualFile> tableView;
    @NotNull
    private final ToolbarDecorator toolbarDecorator;
    @NotNull
    private final JPanel component;

    /*
     * WARNING - void declaration
     */
    public PhpComposerFilesView(@NotNull Project project, @NotNull Disposable parentDisposable) {
        void it;
        void it2;
        TableView tableView;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.parentDisposable = parentDisposable;
        this.projectDir = ProjectUtil.guessProjectDir((Project)this.project);
        TableView tableView2 = tableView = new TableView();
        PhpComposerFilesView phpComposerFilesView = this;
        boolean $i$a$-also-PhpComposerFilesView$tableView$22 = false;
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ComposerColumnInfo(this.projectDir)};
        it2.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
        it2.setShowGrid(false);
        phpComposerFilesView.tableView = tableView;
        TableView $i$a$-also-PhpComposerFilesView$tableView$22 = tableView2 = ToolbarDecorator.createDecorator(this.tableView, null);
        phpComposerFilesView = this;
        boolean bl = false;
        it.setAddAction(arg_0 -> PhpComposerFilesView.toolbarDecorator$lambda$5$lambda$1(this, arg_0));
        it.disableUpDownActions();
        it.setEditAction(arg_0 -> PhpComposerFilesView.toolbarDecorator$lambda$5$lambda$2(this, arg_0));
        it.setRemoveAction(arg_0 -> PhpComposerFilesView.toolbarDecorator$lambda$5$lambda$3(this, arg_0));
        it.setEditActionUpdater(arg_0 -> PhpComposerFilesView.toolbarDecorator$lambda$5$lambda$4(this, arg_0));
        TableView tableView3 = tableView2;
        Intrinsics.checkNotNullExpressionValue((Object)tableView3, (String)"also(...)");
        phpComposerFilesView.toolbarDecorator = tableView3;
        JPanel jPanel = this.toolbarDecorator.createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        this.component = jPanel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void reset() {
        VirtualFile projectDir1 = ProjectUtil.guessProjectDir((Project)this.project);
        ComposerConfigManager configManager = ComposerConfigManager.Companion.getInstance(this.project);
        VirtualFile mainConfig = configManager.getMainConfig();
        Iterable $this$sortedBy$iv = configManager.getSubProjectConfigs();
        boolean $i$f$sortedBy = false;
        List subProjectConfigs = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(projectDir1){
            final /* synthetic */ VirtualFile $projectDir1$inlined;
            {
                this.$projectDir1$inlined = virtualFile;
            }

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)PhpComposerFilesViewKt.access$getRelativePath(it, this.$projectDir1$inlined));
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)PhpComposerFilesViewKt.access$getRelativePath(it, this.$projectDir1$inlined))));
            }
        });
        List items = new ArrayList();
        if (mainConfig != null) {
            items.add(mainConfig);
        }
        items.addAll(subProjectConfigs);
        this.tableView.getListTableModel().setItems(items);
    }

    @Override
    public void apply() {
        List<VirtualFile> allConfigs = this.getComposerConfigs();
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull(allConfigs);
        String mainConfigPath = virtualFile != null ? virtualFile.getPath() : null;
        ComposerDataService composerDataService = ComposerDataService.getInstance(this.project);
        composerDataService.setConfigPathAndLibraryUpdateStatus(mainConfigPath, composerDataService.isUpdateLibrary());
        List subProjectConfigs = CollectionsKt.drop((Iterable)allConfigs, (int)1);
        ComposerConfigManager.Companion.getInstance(this.project).setSubProjectConfigs(subProjectConfigs);
    }

    @Override
    public boolean isModified() {
        List<VirtualFile> configuredConfigs = ComposerConfigManager.Companion.getInstance(this.project).getAllConfigs();
        Set currentConfigs = CollectionsKt.toSet((Iterable)this.getComposerConfigs());
        return configuredConfigs.size() != currentConfigs.size() || !currentConfigs.containsAll((Collection)configuredConfigs);
    }

    private final List<VirtualFile> getComposerConfigs() {
        List list = this.tableView.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return list;
    }

    private final VirtualFile chooseComposerFile(VirtualFile projectDir) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"json");
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Component)((Component)this.tableView), (Project)this.project, (VirtualFile)projectDir);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile chosenFile = virtualFile;
        if (this.getComposerConfigs().contains(chosenFile)) {
            String string = PhpBundle.message("php.project.configurable.composer.duplicate.configurations", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showErrorBalloon(string, this.getComponent());
            return null;
        }
        return chosenFile;
    }

    private final void showErrorBalloon(String message, JComponent component) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setDisposable(this.parentDisposable).setFadeoutTime(5000L).createBalloon().show(new RelativePoint((Component)component, new Point(0, 0)), Balloon.Position.below);
    }

    private static final void toolbarDecorator$lambda$5$lambda$1(PhpComposerFilesView this$0, AnActionButton it) {
        PhpComposerFilesViewCollector.INSTANCE.logAddEvent();
        VirtualFile chosenComposerFile = this$0.chooseComposerFile(this$0.projectDir);
        if (chosenComposerFile != null) {
            this$0.tableView.getListTableModel().addRow((Object)chosenComposerFile);
        }
    }

    private static final void toolbarDecorator$lambda$5$lambda$2(PhpComposerFilesView this$0, AnActionButton it) {
        PhpComposerFilesViewCollector.INSTANCE.logEditEvent();
        VirtualFile chosenComposerFile = this$0.chooseComposerFile(this$0.projectDir);
        if (chosenComposerFile != null) {
            this$0.tableView.getListTableModel().removeRow(0);
            this$0.tableView.getListTableModel().insertRow(0, (Object)chosenComposerFile);
        }
    }

    private static final void toolbarDecorator$lambda$5$lambda$3(PhpComposerFilesView this$0, AnActionButton it) {
        PhpComposerFilesViewCollector.INSTANCE.logRemoveEvent();
        TableUtil.removeSelectedItems((JTable)((JTable)this$0.tableView));
    }

    private static final boolean toolbarDecorator$lambda$5$lambda$4(PhpComposerFilesView this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.tableView.getSelectedRow() == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/config/PhpComposerFilesView$ComposerColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "projectDir", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "myRenderer", "Ljavax/swing/table/TableCellRenderer;", "valueOf", "item", "getRenderer", "ref", "intellij.php.impl"})
    public static final class ComposerColumnInfo
    extends ColumnInfo<VirtualFile, String> {
        @Nullable
        private final VirtualFile projectDir;
        @NotNull
        private final TableCellRenderer myRenderer;

        public ComposerColumnInfo(@Nullable VirtualFile projectDir) {
            super("");
            this.projectDir = projectDir;
            this.myRenderer = (TableCellRenderer)new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (value instanceof String) {
                        this.append((String)value);
                        if (row == 0) {
                            this.append(" " + PhpBundle.message("php.project.configurable.composer.main", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                    }
                }
            };
        }

        @NotNull
        public String valueOf(@Nullable VirtualFile item) {
            return PhpComposerFilesViewKt.access$getRelativePath(item, this.projectDir);
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable VirtualFile ref) {
            return this.myRenderer;
        }
    }
}

