/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.statistics;

import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.config.composer.LanguageLevelComposerParser;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerPackageVersionParser {
    private static final String ANY_VERSION = "*";
    private static final String ANY_REPORTED = "any";
    private static final String MASTER_VERSION = "dev-master";
    private static final String MASTER_REPORTED = "master";
    private static final String BRANCH_VERSION = "dev-";
    private static final String BRANCH_REPORTED = "branch";

    @NotNull
    public static List<ComposerPackageVersion> parseAllVersions(@Nullable String version) {
        if (StringUtil.isEmptyOrSpaces((String)version)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ComposerPackageVersionParser.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (StringUtil.contains((CharSequence)(version = LanguageLevelComposerParser.filterUnnecessarySpaces(version)), (CharSequence)"|")) {
            List orVersions = StringUtil.split((String)version, (String)"|");
            List list = ContainerUtil.mapNotNull((Collection)orVersions, v -> ComposerPackageVersionParser.parseVersion(v));
            if (list == null) {
                ComposerPackageVersionParser.$$$reportNull$$$0(1);
            }
            return list;
        }
        ComposerPackageVersion parsed = ComposerPackageVersionParser.parseVersion(version);
        List list = parsed != null ? new SmartList((Object)parsed) : ContainerUtil.emptyList();
        if (list == null) {
            ComposerPackageVersionParser.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public static ComposerPackageVersion parseVersion(@Nullable String version) {
        if (StringUtil.isEmptyOrSpaces((String)version) || StringUtil.contains((CharSequence)version, (CharSequence)"|")) {
            return null;
        }
        if (StringUtil.contains((CharSequence)version, (CharSequence)",")) {
            List andVersions = StringUtil.split((String)version, (String)",");
            return ComposerPackageVersionParser.findMax(ContainerUtil.mapNotNull((Collection)andVersions, v -> ComposerPackageVersionParser.parseVersion(v)));
        }
        if (StringUtil.containsWhitespaces((CharSequence)version)) {
            List andVersions = StringUtil.split((String)version, (String)" ");
            return ComposerPackageVersionParser.findMax(ContainerUtil.mapNotNull((Collection)andVersions, v -> ComposerPackageVersionParser.parseVersion(v)));
        }
        if (StringUtil.startsWithChar((CharSequence)version, (char)'<')) {
            return null;
        }
        if (StringUtil.startsWith((CharSequence)version, (CharSequence)">=")) {
            return ComposerPackageVersionParser.parseSimpleVersion(version.substring(2), ComposerPackageVersion.PackageVersionConstraint.GREATER);
        }
        if (StringUtil.startsWithChar((CharSequence)version, (char)'>')) {
            return ComposerPackageVersionParser.parseSimpleVersion(version.substring(1), ComposerPackageVersion.PackageVersionConstraint.STRICT_GREATER);
        }
        if (StringUtil.startsWithChar((CharSequence)version, (char)'~')) {
            return ComposerPackageVersionParser.parseSimpleVersion(version.substring(1), ComposerPackageVersion.PackageVersionConstraint.NEXT_SIGNIFICANT);
        }
        if (StringUtil.startsWithChar((CharSequence)version, (char)'^')) {
            return ComposerPackageVersionParser.parseSimpleVersion(version.substring(1), ComposerPackageVersion.PackageVersionConstraint.NEXT_SIGNIFICANT_MINOR);
        }
        if (StringUtil.contains((CharSequence)version, (CharSequence)"-")) {
            if (MASTER_VERSION.equals(version) || version.startsWith(BRANCH_VERSION)) {
                return ComposerPackageVersionParser.parseSimpleVersion(version, ComposerPackageVersion.PackageVersionConstraint.EQUAL);
            }
            List split = StringUtil.split((String)version, (String)"-");
            if (split.size() == 2) {
                ComposerPackageVersion toVersion = ComposerPackageVersionParser.parseSimpleVersion((String)split.get(1), ComposerPackageVersion.PackageVersionConstraint.EQUAL);
                return ComposerPackageVersionParser.parseSimpleVersion((String)split.get(0), toVersion != null ? ComposerPackageVersion.PackageVersionConstraint.INTERVAL : ComposerPackageVersion.PackageVersionConstraint.EQUAL);
            }
        }
        return ComposerPackageVersionParser.parseSimpleVersion(version, ComposerPackageVersion.PackageVersionConstraint.EQUAL);
    }

    @Nullable
    public static ComposerPackageVersion parseSimpleVersion(@NotNull String version, @NotNull ComposerPackageVersion.PackageVersionConstraint constraint) {
        Version parsed;
        if (version == null) {
            ComposerPackageVersionParser.$$$reportNull$$$0(3);
        }
        if (constraint == null) {
            ComposerPackageVersionParser.$$$reportNull$$$0(4);
        }
        version = StringUtil.toLowerCase((String)version);
        if (ANY_VERSION.equals(version = StringUtil.trimStart((String)version, (String)"v"))) {
            return new ComposerPackageVersion(ANY_REPORTED, constraint);
        }
        if (MASTER_VERSION.equals(version)) {
            return new ComposerPackageVersion(MASTER_REPORTED, constraint);
        }
        if (version.startsWith(BRANCH_VERSION)) {
            return new ComposerPackageVersion(BRANCH_REPORTED, constraint);
        }
        int i = version.indexOf(ANY_VERSION);
        if (i > 0) {
            version = version.substring(0, i);
        }
        if ((parsed = Version.parseVersion((String)version)) == null) {
            return null;
        }
        return new ComposerPackageVersion(parsed.major + "." + parsed.minor + "." + parsed.bugfix, constraint);
    }

    @Nullable
    private static ComposerPackageVersion findMax(@NotNull List<ComposerPackageVersion> versions) {
        if (versions == null) {
            ComposerPackageVersionParser.$$$reportNull$$$0(5);
        }
        if (versions.size() < 2) {
            return (ComposerPackageVersion)ContainerUtil.getFirstItem(versions);
        }
        ComposerPackageVersion max = versions.get(0);
        for (int i = 1; i < versions.size(); ++i) {
            ComposerPackageVersion next = versions.get(i);
            if (!next.isGreaterThan(max)) continue;
            max = next;
        }
        return max;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/statistics/ComposerPackageVersionParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAllVersions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/statistics/ComposerPackageVersionParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseSimpleVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMax";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

